"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3ApiSchema = exports.InlineApiSchema = exports.ApiSchema = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
const fs = require("fs");
/**
 * Bedrock Agents Action Group API Schema definition.
 */
class ApiSchema {
    /**
     * Inline code for API Schema
     * @return `InlineApiSchema` with inline schema
     * @param schema The actual Open API schema
     */
    static fromInline(schema) {
        return new InlineApiSchema(schema);
    }
    /**
     * Loads the API Schema from a local disk path.
     * @return `InlineApiSchema` with the contents of `path`
     * @param path Path to the Open API schema file in yaml or JSON
     */
    static fromAsset(path) {
        return new InlineApiSchema(fs.readFileSync(path, 'utf8'));
    }
    /**
     * API Schema as an S3 object.
     * @return `S3ApiSchema` with the S3 bucket and key.
     * @param bucket The S3 bucket
     * @param key The object key
     */
    static fromBucket(bucket, key) {
        return new S3ApiSchema(bucket, key);
    }
}
exports.ApiSchema = ApiSchema;
_a = JSII_RTTI_SYMBOL_1;
ApiSchema[_a] = { fqn: "@cdklabs/generative-ai-cdk-constructs.bedrock.ApiSchema", version: "0.1.198" };
/**
 * API Schema from a string value.
 */
class InlineApiSchema extends ApiSchema {
    constructor(schema) {
        super();
        this.schema = schema;
    }
    bind(_scope) {
        return {
            payload: this.schema,
        };
    }
}
exports.InlineApiSchema = InlineApiSchema;
_b = JSII_RTTI_SYMBOL_1;
InlineApiSchema[_b] = { fqn: "@cdklabs/generative-ai-cdk-constructs.bedrock.InlineApiSchema", version: "0.1.198" };
/**
 * API Schema in an S3 object.
 */
class S3ApiSchema extends ApiSchema {
    constructor(bucket, key) {
        super();
        this.bucket = bucket;
        this.key = key;
    }
    bind(_scope) {
        return {
            s3: {
                s3BucketName: this.bucket.bucketName,
                s3ObjectKey: this.key,
            },
        };
    }
}
exports.S3ApiSchema = S3ApiSchema;
_c = JSII_RTTI_SYMBOL_1;
S3ApiSchema[_c] = { fqn: "@cdklabs/generative-ai-cdk-constructs.bedrock.S3ApiSchema", version: "0.1.198" };
//# sourceMappingURL=data:application/json;base64,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