"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AgentAlias = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class AgentAlias extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const alias = new aws_cdk_lib_1.aws_bedrock.CfnAgentAlias(this, 'MyCfnAgentAlias', {
            agentAliasName: props.aliasName ?? 'latest',
            agentId: props.agentId,
            tags: props.tags,
            description: props.description,
        });
        if (props.agentVersion) {
            alias.routingConfiguration = [{
                    agentVersion: props.agentVersion,
                }];
        }
        this.aliasId = alias.attrAgentAliasId;
        this.aliasArn = alias.attrAgentAliasArn;
        this.aliasName = props.aliasName ?? 'latest';
    }
}
exports.AgentAlias = AgentAlias;
_a = JSII_RTTI_SYMBOL_1;
AgentAlias[_a] = { fqn: "@cdklabs/generative-ai-cdk-constructs.bedrock.AgentAlias", version: "0.1.198" };
//# sourceMappingURL=data:application/json;base64,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