"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AgentActionGroup = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const constructs_1 = require("constructs");
const utils_1 = require("../../common/helpers/utils");
class AgentActionGroup extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        validateAgentActionGroupProps(props);
        const apiSchema = props.apiSchema?.bind(this);
        validateApiSchema(apiSchema);
        const skipResourceInUseCheckOnDelete = props.skipResourceInUseCheckOnDelete ?? false;
        const actionGroupName = props.actionGroupName ?? (0, utils_1.generatePhysicalNameV2)(this, 'action-group', { maxLength: 100, separator: '-' });
        let actionGroupExecutorProperty;
        if (props.actionGroupExecutor) {
            actionGroupExecutorProperty = {
                lambda: props.actionGroupExecutor.lambda?.functionArn,
                customControl: props.actionGroupExecutor.customControl,
            };
            this.actionGroupExecutor = props.actionGroupExecutor;
        }
        ;
        const agentActionGroupProperty = {
            actionGroupName: actionGroupName,
            actionGroupExecutor: actionGroupExecutorProperty,
            actionGroupState: props.actionGroupState,
            apiSchema: apiSchema,
            description: props.description,
            parentActionGroupSignature: props.parentActionGroupSignature,
            functionSchema: props.functionSchema,
            skipResourceInUseCheckOnDelete: skipResourceInUseCheckOnDelete,
        };
        this.actionGroupProperty = agentActionGroupProperty;
        this.actionGroupName = agentActionGroupProperty.actionGroupName;
        this.apiSchema = apiSchema;
        this.description = props.description;
        this.parentActionGroupSignature = props.parentActionGroupSignature;
        this.actionGroupState = props.actionGroupState;
        this.skipResourceInUseCheckOnDelete = skipResourceInUseCheckOnDelete;
        this.functionSchema = props.functionSchema;
    }
}
exports.AgentActionGroup = AgentActionGroup;
_a = JSII_RTTI_SYMBOL_1;
AgentActionGroup[_a] = { fqn: "@cdklabs/generative-ai-cdk-constructs.bedrock.AgentActionGroup", version: "0.1.198" };
function validateAgentActionGroupProps(props) {
    if (props.parentActionGroupSignature && props.description) {
        throw new Error('Cannot specify both description and parentActionSignature');
    }
}
function validateApiSchema(apiSchema) {
    // mutually exclusive
    if (apiSchema?.payload && apiSchema?.s3) {
        throw new Error('Cannot specify both apiSchema.payload and apiSchema.s3');
    }
}
//# sourceMappingURL=data:application/json;base64,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