# Contributing to FreeType Docwriter

:+1::tada: First off, thanks for taking the time to contribute! :tada::+1:

The following is a set of guidelines for contributing to Docwriter. These are mostly guidelines, not rules. Use your best judgment, and feel free to propose changes to this document in a pull request.

## Did you find an issue?

1. **Ensure the issue was not already reported** by searching on GitHub under [Issues](https://github.com/freetype/docwriter/issues).
2. If you're unable to find an open issue addressing the problem, open a new one. Be sure to include a title and clear description, as much relevant information as possible, and a code sample or an executable test case demonstrating the expected behavior that is not occurring.

Issues to submit include:

- Bugs and errors in functionality
- Spelling, grammar, formatting
- Features, enhancements and improvement suggestions and requests


## How to submit changes

1. **Notify others by commenting on the issue.** By commenting on the issue, you will initiate a discussion around possible solutions and also communicate to other contributors that you started working on it. This will avoid having multiple people  work on the same thing.
2. **Fork this repository and submit a pull request.** A tutorial for forking, branching, and submitting a pull request can be found [here](https://www.digitalocean.com/community/tutorials/how-to-create-a-pull-request-on-github).

## Further Reading

https://opensource.guide/how-to-contribute/
