# opa-python-client

<p align="center"><img src="logo-build.png" class="center" alt="build-logo" width="30%"/></p>

## Abstract
[build.security](https://docs.build.security/) provides simple development and management for your organization's authorization policy.
*opa-python-client* is a Python 3 package that performs authorization requests against build.security PDPs (Policy Decision Point)/[OPA](https://www.openpolicyagent.org/).

## Data Flow
<p align="center"> <img src="data-flow.png" alt="drawing" width="60%"/></p>

## Usage
Before you start we recommend completing the onboarding tutorial.

---
**Important note**

To simplify the setup process, the following example uses a local [build.security PDP instance](https://docs.build.security/policy-decision-points-pdp/pdp-deployments/standalone-docker-1).
If you are already familiar with how to run your PDP, You can also run a PDP on your environment (Dev/Prod, etc).

In that case, don't forget to change the **hostname** and **port** in your code.

---
### Simple usage

Initialize the client, initialize some input for the PDP, and make a request:

```
from from opaclient import PolicyDecisionPointClient, PolicyDecisionPointInput, AuthzException

client = PolicyDecisionPointClient(hostname='http://some.host', port=8181,
             policy_path='mypolicy', read_timeout_milliseconds=100, connection_timeout_milliseconds=100,
             retry_max_attempts=5, retry_backoff_milliseconds=1000)

input = PolicyDecisionPointInput(schema='http', method='POST', more_authz_context=some_value,
             even_more_authz_context=some_other_value=some_other_value)

try:
    authz = client.authorize(input)
except AuthzException as e:
    raise

if authz:
    print('The request has been authorized!')
```
   
 ### Mandatory configuration to initialize the client 

 1. `hostname` - The hostname of the Policy Decision Point (PDP)
 2. `port` - The port at which the PDP service is serving authz decisions
 3. `policy_path` - Full path to the policy (including the rule) that decides whether requests should be authorized
 
 [How to get your pdp's hostname and port?](https://docs.build.security/policy-decision-points-pdp#pdp-instances-section)

  ### Optional configuration
 1. `retry_max_attempts` - the maximum number of retry attempts in case a failure occurs. **Default is 2**.
 2. `read_timeout_milliseconds` - Read timeout for requests in milliseconds. **Default is 5000**
 3. `connection_timeout_milliseconds` - Connection timeout in milliseconds. **Default is 5000**
 4. `retry_backoff_milliseconds` - The number of milliseconds to wait between two consecutive retry attempts. **Default is 250**

