"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3LogsExtension = exports.Function = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
const cdk = require("@aws-cdk/core");
/**
 * @stability stable
 */
class Function extends lambda.Function {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        super(scope, id, props);
    }
    /**
     * @stability stable
     */
    addExtension(extension) {
        this.addLayers(extension);
    }
}
exports.Function = Function;
_a = JSII_RTTI_SYMBOL_1;
Function[_a] = { fqn: "cdk-lambda-extensions.Function", version: "0.1.63" };
/**
 * @stability stable
 */
class S3LogsExtension extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id) {
        super(scope, id);
        this.extension = new lambda.LayerVersion(scope, `${id}LayerVersion`, {
            code: lambda.Code.fromAsset(path.join(__dirname, '../aws-lambda-extensions/s3-logs-extension-demo/extensionssrc')),
            compatibleRuntimes: [lambda.Runtime.PYTHON_3_8],
        });
    }
}
exports.S3LogsExtension = S3LogsExtension;
_b = JSII_RTTI_SYMBOL_1;
S3LogsExtension[_b] = { fqn: "cdk-lambda-extensions.S3LogsExtension", version: "0.1.63" };
//# sourceMappingURL=data:application/json;base64,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