
# Introduction

EMMO is a multidisciplinary effort to develop a standard
representational framework (the ontology) based on current materials
modelling knowledge, including physical sciences, analytical
philosophy and information and communication technologies.
This multidisciplinarity is illustrated by the figure on the title page.
It provides the connection between the physical world, materials
characterisation world and materials modelling world.

![EMMO provides the connection between the physical world, materials
characterisation world and materials modelling world.](figs/emmo-three_worlds.png){ width=620px }

EMMO is based on and is consistent with the [Review of Materials
Modelling][RoMM], [CEN Workshop Agreement][CWA] and [MODA
template][MODA].  However, while these efforts are written for humans,
EMMO is defined using the [Web Ontology Language (OWL)][OWL], which is
machine readable and allows for machine reasoning.  In terms of
semantic representation, EMMO brings everything to a much higher level
than these foundations.

As illustrated in the figure below, EMMO covers all aspects of
materials modelling and characterisation, including:

  - the **material** itself, which must be described in a rigorous way
  - the **observation process** involving an observer that percieves the
    real world (characterisation)
  - the **properties** that are measured or modelled
  - the **physics laws** that describe the material behaviour
  - the **physical models** that approximate the physics laws
  - the **solver** including the numerical discretisation method that
    leads to a solvable mathematical representation under certain
    simplifying assumptions
  - the **numerical solver** that performs the calculations
  - the **post processing** of experimental or simulated data

![The aspects of materials modelling and characterisation covered by EMMO.](figs/emmo-scope.png){ width=360px }


EMMO is released under the [Creative Commons license][CC] and is
available at [emmo.info/][EMMO].  The OWL2-DL sources are available in
RDF/XML format.



## What is an ontology
In short, an ontology is a specification of a conceptualization.  The
word *ontology* has a long history in philosophy, in which it refers
to the subject of existence.  The so-called [ontological
argument][ontological_argument] for the existence of God was proposed
by Anselm of Canterbury in 1078. He defined God as *"that than which
nothing greater can be thought"*, and argued that *"if the greatest
possible being exists in the mind, it must also exist in reality. If
it only exists in the mind, then an even greater being must be
possible -- one which exists both in the mind and in reality"*. Even
though this example has little to do with todays use of ontologies
in e.g. computer science, it illustrates the basic idea;  the ontology
defines some basic premises (concepts and relations between them) from
which it is possible reason to gain new knowledge.

For a more elaborated and modern definition of the ontology we refer
the reader to the one provided by [Tom Gruber (2009)][Gruber2009].
Another useful introduction to ontologies is the paper [Ontology
Development 101: A Guide to Creating Your First Ontology][Ontology101]
by Noy and McGuinness (2001), which is based on the [Protege][Protege]
sortware, with which EMMO has been developed.

A taxonomy is a hierarchical representation of classes and subclasses
connected via `is_a` relations.  Hence, it is a subset of the ontology
excluding all but the `is_a` relations.  The main use of taxonomies is
for the organisation of classifications.  The figure shows a simple
example of a taxonomy illustrating a categorisation of four classes
into a hierarchy of more higher of levels of generality.

![Example of a taxonomy.](figs/animal.png){ width=300px }

In EMMO, the taxonomy is a rooted directed acyclic graph (DAG).  This
is important since many classification methods relies on this
property, see e.g. [Valentini (2014)][Valentini2014] and [Robison et
al (2015)][Robison2015].  Note, that EMMO is a DAG does not prevent
some classes from having more than one parent.  A `Variable` is for
instance both a `Mathematical` and a `Symbol`.  See
[appendix][Appendix] for the full EMMO taxonomy.


## Primitive elements in EMMO

![The primitive building blocks of EMMO.](figs/emmo-primitives.png){ width=620px }

### Individuals
Individuals are the basic, "ground level" components of EMMO.  They
may include concrete objects such as cars, flowers, stars, persons and
molecules, as well as abstract individuals such as a measured height,
a specific equation and software programs.

Individuals possess attributes in form of axioms that are defined by
the user (interpreter) upon declaration.


### Classes
Classes represent concepts.  They are the building blocks that we use
to create an ontology as a representation of knowledge.  We distinguish
between *defined* and *non-defined* classes.

Defined classes are defined by the requirements for being a member
of the class.  In the graphical representations of EMMO, defined
classes are orange.  For instance, in the graph of the top-level
entity branch below, The root `EMMO` and a defined class (defined to be
the disjoint union of `Item` and `Collection`).

Non-defined classes are defined as an abstract group of objects,
whose members are defined as belonging to the class.  They are yellow
in the graphical representations.

![Example of the top-level branch of EMMO showing some classes and relationships between them.](genfigs/EMMOT.pdf){ width=668px }



### Axioms
Axioms are propositions in a logical framework that define the
relations between the individuals and classes.  They are used to
categorise individuals in classes and to define the *defined* classes.

The simplest form of a class axiom is a class description that just
states the existence of the class and gives it an unique identifier.
In order to provide more knowledge about the class, class axioms
typically contain additional components that state necessary
and/or sufficient characteristics of the class. OWL contains three
language constructs for combining class descriptions into class
axioms:

* _Subclass_ (`rdfs:subClassOf`) allows one to say that the class
  extension of a class description is a subset of the class extension
  of another class description.

* _Equivalence_ (`owl:equivalentClass`) allows one to say that a class
  description has exactly the same class extension (i.e. the
  individuals associated with the class) as another class description.

* _Distjointness_ (`owl:disjointWith`) allows one to say that the class
  extension of a class description has no members in common with the
  class extension of another class description.

See the section about [Description logic](#description-logic) for more
information about these language constructs.  Axioms are also used to
define relations between relations. These are further detailed in the
chapter on [Relations](#emmo-relations).




## Theoretical foundations
EMMO build upon several theoretical frameworks.

### Semiotics
Semiotics is the study of meaning-making.  It is the dicipline
of formulating something that possibly can exist in a defined
space and time in the real world.



### Mereotopology
Mereotopology is the combination of __mereology__ (science of
parthood) and __topology__ (mathematical study of the geometrical
properties and conservation through deformations).  It is introdused
via the [`Item`](#item) class and based on the
[`mereotopological`](#mereotopological) relations.  Items in EMMO are
always topologically connected in space and time.
EMMO makes a strong distinction between membership and parthood
relations.  In contrast to collections, items can only have parts that
are themselves items.  For further information, see [Casati and Varzi
"Parts and Places" (1999)][Casati1999].


### Physics
EMMO is strongly based on physics, with the aim of being able to
describe all aspects and all domains of physics, from quantum
mechanics to continuum, engeneering, chemistry, etc.  EMMO is
compatible with both the De Broglie - Bohm and the Copenhagen
interpretation of quantum mecanics (see [`Physical`](#physical) for
more comments).

EMMO defines a physics-based parthood hierachy under `Physical` by
introducing the following concepts (illustrated in the figure below):

  * [`Elementary`](#elementary) is the fundamental, non-divisible
    constituent of entities.  In EMMO, elementaries are based on the
    standard model of physics.

  * [`State`](#state) is a `Physical` whose parts does not change
    during its life time (at the chosen level of granularity).  This is
    consistent with a state within e.g. thermodynamics.

  * [`Existent`](#existent) is a succession of states.

![Parthood hierachy under `Physical`.](figs/physical.png){ width=600px }


### Metrology
Metrology is the science of measurements.  It introduces units and
links them to properties.  The description of metrology in EMMO
is based on the standards of
[International System of Quantities (ISQ)](https://en.wikipedia.org/wiki/International_System_of_Quantities)
and
[International System of Units (SI)](https://en.wikipedia.org/wiki/International_System_of_Units).


### Description logic
[Description logic (DL)][DL] is a formal knowledge representation language
in which the *axioms* are expressed.  It is less expressive than
[first-order logic (FOL)][FOL], but commonly used for providing the
logical formalism for ontologies and semantic web.  EMMO is expressed
in the [Web Ontology Language (OWL)][OWL], which in turn is based
on DL.  This brings along features like reasoning.

Since it is essential to have a basic notion of OWL and DL, we
include here a very brief overview.  For a proper introduction to OWL
and DL, we refer the reader to sources like [Grau et.al. (2008)][Grau2008],
[OWL2 Primer][OWL2_Primer] and [OWL Reference][OWL_Reference].

OWL distinguishes between six types of class descriptions:

  1. a class identifier (a IRI reference)
  2. an exhaustive enumeration of individuals that together form the instances
     of a class (`owl:oneOf`)
  3. a property restriction (`owl:someValuesFrom`, `owl:allValuesFrom`,
     `owl:hasValue`, `owl:cardinality`, `owl:minCardinality`,
     `owl:maxCardinality`)
  4. the intersection of two or more class descriptions (`owl:intersectionOf`)
  5. the union of two or more class descriptions (`owl:unionOf`)
  6. the complement of a class description (`owl:complementOf`)

Except for the first, all of these refer to *defined classes*.  The
table below shows the notation in OWL, DL and the [Manchester OWL
syntax][Manchester_OWL], all commonly used for the definitions.  The
Manchester syntax is used by [Protege][Protege] and is designed to not
use DL symbols and to be easy and quick to read and write.  Several
other syntaxes exist for DL.  An interesting example is the pure
Python syntax proposed by [Lamy (2017)][Lamy2017], which is used in
the open source [Owlready2][Owlready2] Python package.  The [Python API
for EMMO][EMMO-python] is also based on Owlready2.


----------------------------------------------------------------------------------------------------------------------------------
DL                 Manchester         [Python + Owlready2        Read                  Meaning
                                      ][Owlready2]
---------------    -----------------  -------------------        -------------------   --------------------
**Constants**

$\top$                                Thing                      top                   A special class with every individual as an instance

$\bot$                                Nothing                    bottom                The empty class

**Axioms**

$A\doteq B$                                                      A is defined to be    Class *definition*
                                                                 equal to B

$A\sqsubseteq B$   A subclass_of B    class A(B): ...            all A are B           Class *inclusion*

                                      issubclass(A, B)                                 Test for *inclusion*

$A\equiv B$        A equivalent_to B  A.equivalent_to.append(B)  A is equivalent to B  Class *equivalence*

                                      B in A.equivalent_to                             Test for equivalence

$a:A$              a is_a A           a = A()                    a is a A              Class *assertion* (*instantiation*)

                                      isinstance(a, A)                                 Test for instance of

$(a,b):R$          a object property  a.R.append(b)              a is R-related to b   Property *assertion*
                   assertion b

$(a,n):R$          a data property    a.R.append(n)              a is R-related to n   Data *assertion*
                   assertion n

**Constructions**

$A\sqcap B$        A and B            A & B                      A and B               Class *intersection* (*conjunction*)

$A\sqcup B$        A or B             A | B                      A or B                Class *union* (*disjunction*)

$\lnot A$          not A              Not(A)                     not A                 Class *complement* (*negation*)

$\{a, b, ...\}$    {a, b, ...}        OneOf([a, b, ...])         one of a, b, ...      Class *enumeration*

$S\equiv R^-$      S inverse_of R     Inverse(R)                 S is inverse of R     Property *inverse*

                                      S.inverse == R                                   Test for *inverse*

$\forall R.A$      R only A           R.only(A)                  all A with R          [*Universal restriction*][universal_restriction]

$\exists R.A$      R some A           R.some(A)                  some A with R         [*Existential restriction*][existential_restriction]

$=n R.A$           R exactly n A      R.exactly(n, A)                                  *Cardinality restriction*

$\leq n R.A$       R min n A          R.min(n, A)                                      *Minimum cardinality restriction*

$\geq n R.A$       R max n A          R.max(n, A)                                      *Minimum cardinality restriction*

$\exists R\{a\}$   R value a          R.value(a)                                       *Value restriction*

**Decompositions**

$A\sqcup B         A disjoint with B  AllDisjoint([A, B])        A disjoint with B     Disjoint
\sqsubseteq\bot$

                                      B in A.disjoints()                               Test for disjointness

$\exists R.\top    R domain A         R.domain = [A]                                   Classes that the restriction applies to
\sqsubseteq A$

$\top\sqsubseteq   R range B          R.range = [B]                                    All classes that can be the value of the restriction
\forall R.B$

----------------------------------------------------------------------------------------------------------------------------------

Table: Notation for DL and Protege. _A_ and _B_ are classes, _R_ is an active
relation, _S_ is an passive relation, _a_ and _b_ are individuals and _n_ is a
literal.  Inspired by the [Great table of Description Logics][Great_table_of_DL].

#### Examples
Here are some examples of different class descriptions using both
the DL and Manchester notation.

##### Equivalence (`owl:equivalentTo`)
Equivalence ($\equiv$) defines necessary and sufficient conditions.

Parent is equivalent to mother or father

  **DL:** `parent` $\equiv$ `mother` $\lor$ `father`

  **Manchester:** `parent equivalent_to mother or father`

##### Inclusion (`rdf:subclassOf`)
Inclusion ($\sqsubseteq$) defines necessary conditions.

An employee is a person.

  **DL:** `employee` $\sqsubseteq$ `person`

  **Manchester:** `employee is_a person`

##### Enumeration (`owl:oneOf`)
The color of a wine is either white, rose or red:

  **DL:** `wine_color` $\equiv$ {`white`, `rose`, `red`}

  **Manchester:** `wine_color equivalent_to {white, rose, red}`

##### Existential restriction (`owl:someValuesFrom`)
A mother is a woman that has a child (some person):

  **DL:** `mother` $\equiv$ `woman` $\sqcap$ $\exists$`has_child`.`person`

  **Manchester:** `mother equivalent_to woman and has_child some person`

##### Universal restriction (`owl:allValuesFrom`)
All parents that only have daughters:

  **DL:** `parents_with_only_daughters` $\equiv$ `person` $\sqcap$ $\forall$`has_child`.`woman`

  **Manchester:** `parents_with_only_daughters equivalent_to person and has_child only woman`

##### Value restriction (`owl:hasValue`)
The owl:hasValue restriction allows to define classes based on the
existence of particular property values. There must be at least one
matching property value.

All children of Mary:

  **DL:** `Marys_children` $\equiv$ `person` $\sqcap$ $\exists$`has_parent`.{`Mary`}

  **Manchester:** `Marys_children equivalent_to person and has_parent value Mary`

##### Property cardinality (`owl:cardinality`)
The owl:cardinality restrictions ($\geq$, $\leq$ or $\equiv$) allow to
define classes based on the maximum (owl:maxCardinality), minimum
(owl:minCardinality) or exact (owl:cardinality) number of occurences.

A person with one parent:

  **DL:** `half_orphant` $\equiv$ `person` and =1`has_parent`.`person`

  **Manchester:** `half_orphant equivalent_to person and has_parent exactly 1 person`

##### Intersection (`owl:intersectionOf`)
Individuals of the intersection ($\sqcap$) of two classes, are
simultaneously instances of both classes.

A man is a person that is male:

  **DL:** `man` $\equiv$ `person` $\sqcap$ `male`

  **Manchester:** `man equivalent_to person and male`

##### Union (`owl:unionOf`)
Individuals of the union ($\sqcup$) of two classes, are either instances
of one or both classes.

A person is a man or woman:

  **DL:** `person` $\equiv$ `man` $\sqcup$ `woman`

  **Manchester:** `person equivalent_to man or woman`

##### Complement (`owl:complementOf`)
Individuals of the complement ($\lnot$) of a class, are all
individuals that are not member of the class.

Not a man:

  **DL:** `female` $\equiv$ $\lnot$ `male`

  **Manchester:** `female equivalent_to not male`



## The structure of EMMO

The EMMO ontology is structured in shells, expressed by specific ontology fragments, that extends from fundamental concepts to the application domains, following the dependency flow.


### Top Level
The [EMMO top level](top.owl) is the group of fundamental axioms that constitute the philosophical foundation of the EMMO.  Adopting a physicalistic/nominalistic perspective, the EMMO defines real world objects as 4D objects that are always extended in space and time (i.e. real world objects cannot be spaceless nor timeless).  For this reason abstract objects, i.e. objects that does not extend in space and time, are forbidden in the EMMO.

EMMO is strongly based on the analytical philosophy dicipline semiotic.
The role of abstract objects are in EMMO fulfilled by semiotic objects, i.e. real world objects (e.g. symbol or sign) that stand for other real world objects that are to be interpreted by an agent. These symbols appear in actions (semiotic processes) meant to communicate meaning by establishing relationships between symbols (signs).

Another important building block of from analytical philosophy is atomistic mereology applied to 4D objects.  The EMMO calls it 'quantum mereology', since the there is a epistemological limit to how fine we can resolve space and time due to the uncertanity principles.

The [mereotopology](top/mereotopology.owl) module introduces the fundamental mereotopological concepts and their relations with the real world objects that they represent.  The EMMO uses mereotopology as the ground for all the subsequent ontology modules.  The concept of topological connection is used to define the first distinction between ontology entities namely the *Item* and *Collection* classes.  Items are causally self-connected objects, while collections are causally disconnected.  Quantum mereology is represented by the *Quantum* class. This module introduces also the fundamental mereotopological relations used to distinguish between space and time dimensions.

The [physical](top/physical.owl) module, defines the *Physical* objects and the concept of *Void* that plays a fundamental role in the description of multiscale objects and quantum systems. It also define the *Elementary* class, that restricts mereological atomism in space.

![The EMMO top level.](figs/top.png)

In EMMO, the only univocally defined real world object is the *Item* individual called **Universe** that stands for the universe. Every other real world object is a composition of elementaries up to the most comprehensive object; the **Universe**. Intermediate objects are not univocally defined, but their definition is provided according to some specific philosophical perspectives.  This is an expression of reductionism (i.e. objects are made of sub-objects) and epistemological pluralism (i.e. objects are always defined according to the perspective of an interpreter, or a class of interpreters).

The *Perspective* class collects the different ways to represent the objects that populate the conceptual region between the elementary and universe levels.


### Middle Level
The middle level ontologies act as roots for extending the EMMO towards specific application domains.

![The EMMO perspectives.](figs/Perspectives.png)

The *Reductionistic* perspective class uses the fundamental non-transitive parthood relation, called direct parthood, to provide a powerful granularity description of multiscale real world objects. The EMMO can in principle represents the **Universe** with direct parthood relations as a direct rooted tree up to its elementary constituents.

The *Phenomenic* perspective class introduces the concept of real world objects that express of a recognisable pattern in space or time that impress the user. Under this class the EMMO categorises e.g. formal languages, pictures, geometry, mathematics and sounds. Phenomenic objects can be used in a semiotic process as signs.

The *Physicalistic* perspective class introduces the concept of real world objects that have a meaning for the under applied physics perspective.

The *Holistic* perspective class introduces the concept of real world objects that unfold in time in a way that has a meaning for the EMMO user, through the definition of the classes *Process* and *Participant*.
The [semiotics](top/semiotics.owl) module introduces the concepts of
semiotics and the *Semiosis* process that has a *Sign*, an *Object*
and an *Interpreter* as participants.  This forms the basis in EMMO to
represent e.g. models, formal languages, theories, information and
properties.

![The semiotic level, showing both the taxonomy (open black arrows) and
other relations as listed in the caption. The inverted arrows corresponds to inverse relations.](figs/Semiotic.png)

### EMMO relations
All EMMO relations are subrelations of the relations found in the two roots: *mereotopological* and *semiotical*. The relation hierarchy extends more vertically (i.e. more subrelations) than horizontally (i.e. less sibling relations), facilitating the categorisation and inferencing of individuals.
See also the chapter [EMMO Relations](#emmo-relations).

Imposing all relations to fall under mereotopology or semiotics is how the EMMO force the developers to respect its perspectives. Two entities are related only by contact or parthood (mereotopology) or by standing one for another (semiosis): no other types of relation are possible within the EMMO.

A unique feature in EMMO, is the introduction of _direct parthood_.
As illustrated in the figure below, it is a mereological relation
that lacks transitivity.  This makes it possible to entities made of
parts at different levels of granularity and to go between granularity
levels in a well-defined manner.  This is paramount for cross
scale interoperability.  Every material in EMMO is placed on a
granularity level and the ontology gives information about the direct
upper and direct lower level classes using the non-transitive direct
parthood relations.

![Direct parthood.](figs/emmo-direct_part.png){ width=220px }



### Annotations
All entities and relations in EMMO have some attributes, called
*annotations*.  In some cases, only the required *International
Resource Identifier* (IRI) and *relations* are provided.  However,
descriptive annotations, like *elucidation* and *comment*, are planned
to be added for all classes and relations.  Possible annotations are:

* __Elucidation__ is a human readable explanation and clearification
  of the documented class or relation.
* __Example__ clearifies the elucidation through an example.  A class may
  have several examples, each addressing different aspects.
* __Comment__ is a clearifying note complementing the definition and
  elucidation.  A class may have several comments, each clearifying
  different aspects.
* __IRI__ stands for *international resource identifier*.  It is an
  identifier that uniquely identifies the class or relation.  IRIs are
  similar to URIs, but are not restricted to the ASCII character set.
  In EMMO, the IRIs are now valid URLs pointing to the stable version of
  EMMO.
* __Relations__ is a list of relations applying to the current class
  or relation.  The relations for relations are special and will be
  elaborated on in the introduction to chapter [Relations].  Some of
  the listed relations are defined in the OWL sources, while other are
  inferred by the reasoner.  The relations are expressed using the Manchester
  OWL syntax introduced in section [Description logic](#description-logic).







[CC]: http://emmo.info/blob/v1.0.0/LICENSE.md
[EMMO]: https://github.com/emmo-repo/EMMO/
[RoMM]: https://publications.europa.eu/en/publication-detail/-/publication/ec1455c3-d7ca-11e6-ad7c-01aa75ed71a1
[CWA]: https://www.cen.eu/news/workshops/Pages/WS_2016-013.aspx
[MODA]: https://emmc.info/moda-workflow-templates/
[ontological_argument]: https://en.wikipedia.org/wiki/Ontological_argument
[Valentini2014]: https://arxiv.org/abs/1406.4472
[Robison2015]: https://www.google.no/url?sa=t&rct=j&q=&esrc=s&source=web&cd=2&ved=0ahUKEwi_2vv-8tXbAhUFiiwKHVRdD4EQFgg1MAE&url=https%3A%2F%2Fwww.springer.com%2Fcda%2Fcontent%2Fdocument%2Fcda_downloaddocument%2F9783319202471-c2.pdf%3FSGWID%3D0-0-45-1510685-p177420182&usg=AOvVaw39c3v4a5PfVMEYDulWpF3w
[Gruber2009]: http://tomgruber.org/writing/ontology-definition-2007.htm
[Ontology101]: http://www.ksl.stanford.edu/people/dlm/papers/ontology-tutorial-noy-mcguinness-abstract.html
[DL]: https://en.wikipedia.org/wiki/Description_logic
[OWL]: https://en.wikipedia.org/wiki/Web_Ontology_Language
[FOL]: https://en.wikipedia.org/wiki/First-order_logic
[Casati1999]: https://mitpress.mit.edu/books/parts-and-places
[Grau2008]: http://www.cs.ox.ac.uk/boris.motik/pubs/ghmppss08next-steps.pdf
[OWL2_Primer]: https://www.w3.org/TR/owl2-primer/
[OWL_Reference]: https://www.w3.org/TR/owl-ref/
[Manchester_OWL]: http://ceur-ws.org/Vol-216/submission_9.pdf
[Owlready2]: https://pythonhosted.org/Owlready2/
[Lamy2017]: http://www.lesfleursdunormal.fr/_downloads/article_owlready_aim_2017.pdf
[EMMO-python]: https://github.com/emmo-repo/EMMO-python
[Great_table_of_DL]: http://www.lesfleursdunormal.fr/static/_downloads/great_ontology_table.pdf
[universal_restriction]: https://en.wikipedia.org/wiki/Universal_quantifier
[existential_restriction]: https://en.wikipedia.org/wiki/Universal_quantifier
[Protege]: https://protege.stanford.edu/
[UML]: http://www.uml.org/




# EMMO Relations

In the language of OWL, relations are called *properties*.  However,
since relations describe relations between classes and individuals and
since [properties](#Properties) has an other meaning in EMMO, we only call
them *relations*.

[Resource Description Framework (RDF)][RDF] is a W3C standard that is
widely used for describing informations on the web and is one of the
standards that OWL builds on.  RDF expresses information in form of
*subject-predicate-object* triplets.  The subject and object are
resources (aka items to describe) and the predicate expresses a
relationship between the subject and the object.

In OWL are the subject and object classes or individuals (or data)
while the predicate is a relation.  An example of an relationship is
the statement *dog is_a animal*.  Here `dog` is the subject, `is_a`
the predicate and `animal` the object.


OWL distingues between *object properties*, that link classes or
individuals to classes or individuals, and *data properties* that link
individuals to data values.  Since EMMO only deals with classes, we
will only be discussing object properties.  However,
in actual simulation or characterisation applications build on EMMO,
datatype propertyes will be important.

The characteristics of the different properties are described by
the following *property axioms*:

- `rdf:subPropertyOf` is used to define that a property is a
  subproperty of some other property.  For instance, in the figure
  below showing the relation branch, we see that `active_relation` is
  a subproperty or `relation`.
  The `rdf:subPropertyOf` axioms forms a taxonomy-like tree for relations.

- `owl:equivalentProperty` states that two properties have the same
  property extension.

- `owl:inverseOf` axioms relate active relations to their corresponding
  passive relations, and vice versa. The root relation `relation` is its
  own inverse.

- `owl:FunctionalProperty` is a property that can have only one
  (unique) value y for each instance x, i.e. there cannot be two
  distinct values y1 and y2 such that the pairs (x,y1) and (x,y2) are
  both instances of this property. Both object properties and datatype
  properties can be declared as "functional".

- `owl:InverseFunctionalProperty`

- `owl:TransitiveProperty` states that if a pair (x,y) is an instance
  of P, and the pair (y,z) is instance of P, then we can infer that
  the pair (x,z) is also an instance of P.

- `owl:SymmetricProperty` states that if the pair (x,y) is an instance of P,
  then the pair (y,x) is also an instance of P.
  A popular example of a symmetric property is the `siblingOf` relation.

- `rdfs:domain` specifies which classes the property applies to. Or
  said differently, the valid values of the *subject* in a
  *subject-predicate-object* triplet.

- `rdfs:range` specifies the property extension, i.e. the valid values
  of the *object* in a *subject-predicate-object* triplet.





## Root of EMMO relations
![Top-level of the EMMO relation hierarchy.](genfigs/EMMORelationT.pdf){ width=400px }


### EMMORelation
**IRI:** [http://emmo.info/emmo/top/mereotopology#EMMO_ec2472ae_cf4a_46a5_8555_1556f5a6c3c5](http://emmo.info/emmo/top/mereotopology#emmo_ec2472ae_cf4a_46a5_8555_1556f5a6c3c5)

**Elucidation:** The superclass of all relations used by the EMMO.

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a owl:SymmetricProperty
  - is_a owl:TransitiveProperty
  - is_a owl:topObjectProperty
  - inverse_of [EMMORelation](#emmorelation)
  - domain [EMMO](#emmo)
  - range [EMMO](#emmo)






## Mereotopological branch
![Mereotopological branch.](genfigs/mereotopologicalT.pdf){ width=374px }


### mereotopological
**IRI:** [http://emmo.info/emmo/top/mereotopology#EMMO_03212fd7_abfd_4828_9c8e_62c293052d4b](http://emmo.info/emmo/top/mereotopology#emmo_03212fd7_abfd_4828_9c8e_62c293052d4b)

**Elucidation:** The superclass of all EMMO mereotopological relations.

**Comment:** Mereotopology merges mereological and topological concepts and provides relations between wholes, parts, boundaries, etc.

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a owl:SymmetricProperty
  - is_a owl:TransitiveProperty
  - is_a [EMMORelation](#emmorelation)
  - Inverse(mereotopology.EMMORelation)
  - inverse_of [mereotopological](#mereotopological)






### disconnected
**IRI:** [http://emmo.info/emmo/top/mereotopology#EMMO_517dfaf9_4970_41ac_81ee_d031627d2c7c](http://emmo.info/emmo/top/mereotopology#emmo_517dfaf9_4970_41ac_81ee_d031627d2c7c)

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a owl:SymmetricProperty
  - is_a [mereotopological](#mereotopological)
  - Inverse(mereotopology.mereotopological)
  - inverse_of [disconnected](#disconnected)








## Connected branch
![Connected branch.](genfigs/connectedT.pdf){ width=389px }


### connected
**IRI:** [http://emmo.info/emmo/top/mereotopology#EMMO_6703954e_34c4_4a15_a9e7_f313760ae1a8](http://emmo.info/emmo/top/mereotopology#emmo_6703954e_34c4_4a15_a9e7_f313760ae1a8)

**Comment:** Causality is a topological property between connected items.

**Comment:** Items being connected means that there is a topological contact or "interaction" between them.

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a owl:SymmetricProperty
  - is_a [mereotopological](#mereotopological)
  - Inverse(mereotopology.mereotopological)
  - inverse_of [connected](#connected)






### hasOverlapWith
**IRI:** [http://emmo.info/emmo/top/mereotopology#EMMO_d893d373_b579_4867_841e_1c2b31a8d2c6](http://emmo.info/emmo/top/mereotopology#emmo_d893d373_b579_4867_841e_1c2b31a8d2c6)

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a owl:SymmetricProperty
  - is_a [connected](#connected)
  - Inverse(mereotopology.connected)
  - inverse_of [hasOverlapWith](#hasoverlapwith)






### encloses
**IRI:** [http://emmo.info/emmo/top/mereotopology#EMMO_8c898653_1118_4682_9bbf_6cc334d16a99](http://emmo.info/emmo/top/mereotopology#emmo_8c898653_1118_4682_9bbf_6cc334d16a99)

**Comment:** Enclosure is reflexive and transitive.

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a owl:TransitiveProperty
  - is_a [connected](#connected)
  - Inverse(mereotopology.connected)






### overcrosses
**IRI:** [http://emmo.info/emmo/top/mereotopology#EMMO_9cb984ca_48ad_4864_b09e_50d3fff19420](http://emmo.info/emmo/top/mereotopology#emmo_9cb984ca_48ad_4864_b09e_50d3fff19420)

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a owl:SymmetricProperty
  - is_a [hasOverlapWith](#hasoverlapwith)
  - Inverse(mereotopology.hasOverlapWith)
  - inverse_of [overcrosses](#overcrosses)






### hasContactWith
**IRI:** [http://emmo.info/emmo/top/mereotopology#EMMO_4d6504f1_c470_4ce9_b941_bbbebc9ab05d](http://emmo.info/emmo/top/mereotopology#emmo_4d6504f1_c470_4ce9_b941_bbbebc9ab05d)

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a owl:SymmetricProperty
  - is_a [connected](#connected)
  - Inverse(mereotopology.connected)
  - inverse_of [hasContactWith](#hascontactwith)







## Has Part branch
![Has Part branch.](genfigs/hasPartT.pdf){ width=668px }


### hasTemporalPart
**IRI:** [http://emmo.info/emmo/top/physical#EMMO_7afbed84_7593_4a23_bd88_9d9c6b04e8f6](http://emmo.info/emmo/top/physical#emmo_7afbed84_7593_4a23_bd88_9d9c6b04e8f6)

**Elucidation:** A relation that isolate a proper part that covers the total spatial extension of a whole within a time interval.

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a owl:TransitiveProperty
  - is_a [hasProperPart](#hasproperpart)
  - domain [Item](#item)
  - range [Item](#item)






### hasProperPart
**IRI:** [http://emmo.info/emmo/top/mereotopology#EMMO_9380ab64_0363_4804_b13f_3a8a94119a76](http://emmo.info/emmo/top/mereotopology#emmo_9380ab64_0363_4804_b13f_3a8a94119a76)

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a owl:TransitiveProperty
  - is_a [hasPart](#haspart)






### hasSpatioTemporalDirectPart
**IRI:** [http://emmo.info/emmo/middle/reductionistic#EMMO_663859e5_add3_4c9e_96fb_c99399de278d](http://emmo.info/emmo/middle/reductionistic#emmo_663859e5_add3_4c9e_96fb_c99399de278d)

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a owl:InverseFunctionalProperty
  - is_a owl:AsymmetricProperty
  - is_a owl:IrreflexiveProperty
  - is_a [hasSpatioTemporalPart](#hasspatiotemporalpart)






### hasTemporalDirectPart
**IRI:** [http://emmo.info/emmo/middle/reductionistic#EMMO_65a2c5b8_e4d8_4a51_b2f8_e55effc0547d](http://emmo.info/emmo/middle/reductionistic#emmo_65a2c5b8_e4d8_4a51_b2f8_e55effc0547d)

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a owl:InverseFunctionalProperty
  - is_a owl:AsymmetricProperty
  - is_a owl:IrreflexiveProperty
  - is_a [hasTemporalPart](#hastemporalpart)
  - domain [Existent](#existent)
  - range [State](#state)






### hasSpatioTemporalPart
**IRI:** [http://emmo.info/emmo/top/physical#EMMO_6e046dd0_9634_4013_b2b1_9cc468087c83](http://emmo.info/emmo/top/physical#emmo_6e046dd0_9634_4013_b2b1_9cc468087c83)

**Elucidation:** A relation that isolates a proper part that extends itself in time through a portion of the lifetime whole.

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a owl:TransitiveProperty
  - is_a [hasProperPart](#hasproperpart)
  - domain [Item](#item)
  - range [Item](#item)






### hasParticipant
**IRI:** [http://emmo.info/emmo/middle/holistic#EMMO_ae2d1a96_bfa1_409a_a7d2_03d69e8a125a](http://emmo.info/emmo/middle/holistic#emmo_ae2d1a96_bfa1_409a_a7d2_03d69e8a125a)

**Elucidation:** The relation between a process and an object participating to it.

**Comment:** Participation is a parthood relation: you must be part (and then be connected) of the process to contribute to it.

**Comment:** Participation is not under direct parthood since a process is not strictly related to reductionism, but it's a way to categorize temporal regions by the interpreters.

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a [hasPart](#haspart)
  - domain [Process](#process)
  - range [Participant](#participant)






### hasReferenceUnit
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_67fc0a36_8dcb_4ffa_9a43_31074efa3296](http://emmo.info/emmo/middle/metrology#emmo_67fc0a36_8dcb_4ffa_9a43_31074efa3296)

**Comment:** Relates the physical quantity to its unit through spatial direct parthood.

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a owl:FunctionalProperty
  - is_a owl:InverseFunctionalProperty
  - is_a owl:AsymmetricProperty
  - is_a owl:IrreflexiveProperty
  - is_a [hasSpatialDirectPart](#hasspatialdirectpart)
  - domain [Quantity](#quantity)
  - range [ReferenceUnit](#referenceunit)






### hasPart
**IRI:** [http://emmo.info/emmo/top/mereotopology#EMMO_17e27c22_37e1_468c_9dd7_95e137f73e7f](http://emmo.info/emmo/top/mereotopology#emmo_17e27c22_37e1_468c_9dd7_95e137f73e7f)

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a owl:TransitiveProperty
  - is_a [encloses](#encloses)
  - is_a [hasOverlapWith](#hasoverlapwith)
  - Inverse(mereotopology.hasOverlapWith)






### hasQuantityValue
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_8ef3cd6d_ae58_4a8d_9fc0_ad8f49015cd0](http://emmo.info/emmo/middle/metrology#emmo_8ef3cd6d_ae58_4a8d_9fc0_ad8f49015cd0)

**Comment:** Relates a quantity to its reference unit through spatial direct parthood.

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a owl:FunctionalProperty
  - is_a owl:InverseFunctionalProperty
  - is_a owl:AsymmetricProperty
  - is_a owl:IrreflexiveProperty
  - is_a [hasSpatialDirectPart](#hasspatialdirectpart)
  - domain [Quantity](#quantity)
  - range [Numerical](#numerical)






### hasSpatialPart
**IRI:** [http://emmo.info/emmo/top/physical#EMMO_f68030be_94b8_4c61_a161_886468558054](http://emmo.info/emmo/top/physical#emmo_f68030be_94b8_4c61_a161_886468558054)

**Elucidation:** A relation that isolates a proper part that extends itself in time within the overall lifetime of the whole, without covering the full spatial extension of the 4D whole (i.e. is not a temporal part).

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a owl:TransitiveProperty
  - is_a [hasProperPart](#hasproperpart)
  - domain [Item](#item)
  - range [Item](#item)






### hasProperParticipant
**IRI:** [http://emmo.info/emmo/middle/holistic#EMMO_c5aae418_1622_4d02_93c5_21159e28e6c1](http://emmo.info/emmo/middle/holistic#emmo_c5aae418_1622_4d02_93c5_21159e28e6c1)

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a [hasParticipant](#hasparticipant)
  - is_a [hasProperPart](#hasproperpart)






### hasSpatialDirectPart
**IRI:** [http://emmo.info/emmo/middle/reductionistic#EMMO_b2282816_b7a3_44c6_b2cb_3feff1ceb7fe](http://emmo.info/emmo/middle/reductionistic#emmo_b2282816_b7a3_44c6_b2cb_3feff1ceb7fe)

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a owl:InverseFunctionalProperty
  - is_a owl:AsymmetricProperty
  - is_a owl:IrreflexiveProperty
  - is_a [hasSpatialPart](#hasspatialpart)
  - domain [State](#state)






### hasMember
**IRI:** [http://emmo.info/emmo/top/mereotopology#EMMO_6b7276a4_4b9d_440a_b577_0277539c0fc4](http://emmo.info/emmo/top/mereotopology#emmo_6b7276a4_4b9d_440a_b577_0277539c0fc4)

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a owl:AsymmetricProperty
  - is_a owl:IrreflexiveProperty
  - is_a [hasProperPart](#hasproperpart)
  - domain [Collection](#collection)
  - range [Item](#item)







## Semiotical branch
![Semiotical branch.](genfigs/semioticalT.pdf){ width=563px }


### semiotical
**IRI:** [http://emmo.info/emmo/top/semiotics#EMMO_2337e25c_3c60_43fc_a8f9_b11a3f974291](http://emmo.info/emmo/top/semiotics#emmo_2337e25c_3c60_43fc_a8f9_b11a3f974291)

**Elucidation:** The generic EMMO semiotical relation.

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a [EMMORelation](#emmorelation)
  - Inverse(mereotopology.EMMORelation)






### hasProperty
**IRI:** [http://emmo.info/emmo/middle/properties#EMMO_e1097637_70d2_4895_973f_2396f04fa204](http://emmo.info/emmo/middle/properties#emmo_e1097637_70d2_4895_973f_2396f04fa204)

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a [hasConvention](#hasconvention)
  - domain [Object](#object)
  - range [Property](#property)






### hasPhysicsDimension
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_bed1d005_b04e_4a90_94cf_02bc678a8569](http://emmo.info/emmo/middle/metrology#emmo_bed1d005_b04e_4a90_94cf_02bc678a8569)

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a [hasProperty](#hasproperty)
  - range [PhysicsDimension](#physicsdimension)






### hasSign
**IRI:** [http://emmo.info/emmo/top/semiotics#EMMO_60577dea_9019_4537_ac41_80b0fb563d41](http://emmo.info/emmo/top/semiotics#emmo_60577dea_9019_4537_ac41_80b0fb563d41)

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a [semiotical](#semiotical)
  - domain [Object](#object)
  - range [Sign](#sign)






### hasVariable
**IRI:** [http://emmo.info/emmo/middle/math#EMMO_3446e167_c576_49d6_846c_215bb8878a55](http://emmo.info/emmo/middle/math#emmo_3446e167_c576_49d6_846c_215bb8878a55)

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a [hasConvention](#hasconvention)
  - domain [Mathematical](#mathematical)
  - range [Variable](#variable)






### hasConvention
**IRI:** [http://emmo.info/emmo/top/semiotics#EMMO_eb3518bf_f799_4f9e_8c3e_ce59af11453b](http://emmo.info/emmo/top/semiotics#emmo_eb3518bf_f799_4f9e_8c3e_ce59af11453b)

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a [hasSign](#hassign)
  - range [Conventional](#conventional)






### hasModel
**IRI:** [http://emmo.info/emmo/middle/models#EMMO_24c71baf_6db6_48b9_86c8_8c70cf36db0c](http://emmo.info/emmo/middle/models#emmo_24c71baf_6db6_48b9_86c8_8c70cf36db0c)

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a [hasIcon](#hasicon)






### hasIndex
**IRI:** [http://emmo.info/emmo/top/semiotics#EMMO_297999d6_c9e4_4262_9536_bd524d1c6e21](http://emmo.info/emmo/top/semiotics#emmo_297999d6_c9e4_4262_9536_bd524d1c6e21)

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a [hasSign](#hassign)
  - range [Index](#index)






### hasInterpretant
**IRI:** [http://emmo.info/emmo/top/semiotics#EMMO_7fb7fe7e_bdf9_4eeb_adad_e384dd5285c6](http://emmo.info/emmo/top/semiotics#emmo_7fb7fe7e_bdf9_4eeb_adad_e384dd5285c6)

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a [hasSign](#hassign)
  - range [Interpretant](#interpretant)






### hasIcon
**IRI:** [http://emmo.info/emmo/top/semiotics#EMMO_39c3815d_8cae_4c8f_b2ff_eeba24bec455](http://emmo.info/emmo/top/semiotics#emmo_39c3815d_8cae_4c8f_b2ff_eeba24bec455)

**Relations:** 

  - is_a owl:ObjectProperty
  - is_a [hasSign](#hassign)
  - range [Icon](#icon)










[RDF]: https://en.wikipedia.org/wiki/Resource_Description_Framework




# EMMO Classes

*emmo* is a class representing the collection of all the individuals
(signs) that are used in the ontology. Individuals are declared by the
EMMO users when they want to apply the EMMO to represent the world.



## EMMO branch
![EMMO branch.](genfigs/EMMOT.pdf){ width=668px }

The root of all classes used to represent the world.  It has two children;
*collection* and *item*.

*collection* is the class representing the collection of all the
individuals (signs) that represents a collection of non-connected real world
objects.

*item* Is the class that collects all the individuals that are members
of a set (it's the most comprehensive set individual).  It is the
branch of mereotopology.


### Physical
**IRI:** [http://emmo.info/emmo/top/physical#EMMO_c5ddfdba_c074_4aa4_ad6b_1ac4942d300d](http://emmo.info/emmo/top/physical#emmo_c5ddfdba_c074_4aa4_ad6b_1ac4942d300d)

**Elucidation:** A 'Item' that has part some 'Elementary' and whose temporal proper parts are only 'Physical'-s (i.e. it can be perceived without interruptions in time).

**Comment:** A 'Physical' is the class that contains all the individuals that stand for real world objects that interact physically with the ontologist, i.e. physical objects.

A physical object must be perceived through physical interaction by the ontologist. Then the ontologist can declare an individual standing for the physical object just perceived.

Perception is a subcategory of physical interactions. It is an interaction that stimulate a representation of the physical object within the ontologist (the agent).

**Comment:** A 'Physical' must include at least an 'Elementary' part, and can include 'Void' parts.

A 'Physical' may include as part also the 'Void' surrounding or enclosed by its 'Physical' sub parts.

There are no particular criteria for 'Physical'-s structure, except that is made of some 'Elementary'-s as proper parts and not only 'Void'.

This is done in order to take into account the quantum nature of physical systems, in which the actual position of sub-components (e.g. electrons in an atom) is not known except for its probability distribution function (according to the Copenhagen interpretation.)

e.g. a real world object that has spatial parts an atom and a cubic light year of void, extending for some time, can be a physical object.

**Comment:** A 'Physical' with dimensions other than 4D cannot exist, following the restriction of the parent 'EMMO' class.

It follows from the fact that perception is always unfolding in time.

e.g. you always have an aperture time when you take a picture or measure a property. Instantaneous perceptions are idealizations (abstractions) or a very small time measurement.

**Comment:** From Latin physica "study of nature" (and Ancient Greek $\upvarphi$$\upupsilon$$\upsigma$$\upiota$$\upkappa$$\acute{o}$$\upvarsigma$, “natural”). 

Here the word relates to things perceived through the senses as opposed to the mind; tangible or concrete.

**Comment:** In the EMMO there are no relations such as occupiesSpace, since 'Physical'-s are themselves the 4D regions.

**Comment:** The EMMO can be used to represent real world entities as 'Physical'-s that are easy to connect to classical or quantum mechanical based models.

Classical mechanics poses no representational issues, for the EMMO: the 4D representation of 'Physical'-s is consistent with classical physics systems.

However, the representation of 'Physical'-s that are typically analized through quantum mechanics (e.g. molecules, atoms, clusters), is not straightforward.

1) De Broglie - Bohm interpretation
The most simple approach is to rely on Bohmian mechanics, in which each particle is supposed to exists in a specific position between measurements (hidden variables approach), while its trajectory is calculated using a Guiding Equation based on a quantum field calculated with the Schroedinger Equation.

While this approach is really easy to implement in an ontology, since each entity has its own well defined 4D region, its mathematical representation failed to receive large consensus due to the difficulties to include relativistic effects, to be extended to subnuclear scale and the strong non-locality assumtpion of the quantum field.

Nevertheless, the Bohmian mechanics is a numerical approach that is used in electronic models to reduce the computational effort of the solution of Schroedinger Equation.

In practice, an EMMO user can declare a 'physical' individual that stand for the whole quantum system to be described, and at the same time all sub-parts individuals can be declared, having them a well defined position in time, according to De Broglie - Bohm interpretation. The Hamiltonian can be calculated by considering the sub-part individuals.

'physical'-s are then made of 'physical' parts and 'void' parts that stand for the space between 'physical'-s (e.g. the void between electrons and nucleus in an atom).

2) Copenhagen interpretation
In this interpretation the properties (e.g. energy level, position, spin) of a particle are not defined in the interval between two measurements and the quantum system is entangled (i.e. properties of particles in the sysyem are correlated) and described by a global wavefunction obtained solving the Schroedinger Equation. 

Upon measurement, the wavefunction collapses to a combination of close eigenstates that provide information about bservables of the system components (e.g. position, energy).

The EMMO can be used to represent 'physical'-s that can be related to Copenhagen based models. In practice, the user should follow these steps:

a) define the quantum system as a 'physical' individual (e.g. an H2 molecule) under a specific class (e.g. 'h2_molecule'). This individual is the whole.

b) define the axioms of the  class that describe how many sub-parts are expected for the whole and their class types (e.g. 'h2_molecule' has axioms 'has_proper_part exactly 2 electron' and 'has_proper_part exactly 2 nucleus)

c) the user can now connect the whole to a Schroedinger equation based model whose Hamiltonian is calculated trough the information coming only from the axioms. No individuals are declared for the subparts!

d) a measurement done on the quantum system that provides information on the sub-part observables is interpreted as wavefunction collapse and leads to the end of the whole and the declaration of the sub-parts individuals which can be themselves other quantum systems 

e.g. if the outer electron of the H2 molecule interacts with another entity defining its state, then the whole that stands for the entangled H2 molecule becomes a 'physical' made of an electron individual, a quantum system made of one electron and two nuclei and the void between them.

e.g. in the Born-Oppenheimer approximation the user represent the atom by un-entangling nucleus and electronic cloud. The un-entanglement comes in the form of declaration of individual as parts.

e.g. the double slit experiment can be represent in the EMMO as:
a) before the slit: a 'physical' that extend in space and has parts 'electron' and 'void', called 'single_electron_wave_function'. 'electron' and 'void' are only in the axioms and not decalred individuals.
b) during slit passage: a 'physical' made of one declared individual, the 'electron'.
c) after the slit: again 'single_electron_wave_function'
d) upon collision with the detector:  'physical' made of one declared individual, the 'electron'.

**Comment:** The purpose of the 'Physical' branch is to provide a representation of the real world objects, while the models used to name, explain or predict the behaviour of the real world objects lay under the 'Semiotic' branch.

More than one semiotic representation can be connected to the same 'Physical'.

e.g. Navier-Stokes or Euler equation applied to the same fluid are an example of mathematical model used to represent a physical object for some specific interpreter.

**Relations:** 

  - is_a [Item](#item)
  - [hasPart](#haspart) some [Elementary](#elementary)
  - [hasTemporalPart](#hastemporalpart) only [Physical](#physical)
  - disjoint_with [Collection](#collection), [Void](#void)



**Individuals:** 

  - [Universe](#universe)






### Collection
**IRI:** [http://emmo.info/emmo/top/mereotopology#EMMO_2d2ecd97_067f_4d0e_950c_d746b7700a31](http://emmo.info/emmo/top/mereotopology#emmo_2d2ecd97_067f_4d0e_950c_d746b7700a31)

**Elucidation:** The class of all individuals that stand for a real world not self-connected object.

**Comment:** A 'Collection' individual stands for a non-self-connected real world object.

A 'Collection' individual is related to each 'Item' individuals of the collection (i.e. the members) through the membership relation.

An 'Item' individual stands for a real world self-connected object which can be represented as a whole made of connected parts (e.g. a car made of components).

**Comment:** Formally, 'Collection' is axiomatized as the class of individuals that hasMember some 'Item'.

A 'Collection' cannot have as member another 'Collection'.

**Comment:** From Latin collectio, from colligere ‘gather together’.

**Comment:** e.g. the collection of users of a particular software, the collection of atoms that have been part of that just dissociated molecule, or even the collection of atoms that are part of a molecule considered as single individual non-connected objects and not as a mereotopological self-connected fusion.

**Relations:** 

  - is_a [EMMO](#emmo)
  - [hasMember](#hasmember) some [Item](#item)
  - disjoint_with [Item](#item)






### EMMO
**IRI:** [http://emmo.info/emmo/top/mereotopology#EMMO_802d3e92_8770_4f98_a289_ccaaab7fdddf](http://emmo.info/emmo/top/mereotopology#emmo_802d3e92_8770_4f98_a289_ccaaab7fdddf)

**Elucidation:** The class representing the collection of all the individuals declared in this ontology standing for real world objects.

**Comment:** 'EMMO' is the disjoint union of 'Item' and 'Collection' (covering axiom).

The union implies that 'EMMO' individuals can only be 'Item' individuals (standing for self-connected real world objects) or 'Collection' individuals (standing for a collection of disconnected items).

Disjointness means that a 'Collection' individual cannot be an 'Item' individual and viceversa, representing the fact that a real world object cannot be self-connected and non-self connected at the same time.

**Comment:** For the EMMO ontologist the whole universe is represented as a 4D path-connected topological manifold (i.e. the spacetime).

A real world object is then a 4D topological sub-region of the universe. 

A universe sub-region is isolated and defined as a real world object by the ontologist. Then, through a semiotic process that occurs at meta-ontological level (i.e. outside the ontology). an EMMO ontology entity (e.g. an OWL individual) is assigned to represent that real world object.

The fundamental distinction between real world objects, upon which the EMMO is based, is self-connectedness: a real world object can be self-connected xor not self-connected.

**Comment:** In the EMMO we will refer to the universe as a Minkowski space, restricting the ontology to special relativity only. However, exension to general relativity, will adding more complexity, should not change the overall approach.

**Comment:** Mereotopology is the fundamental logical representation used by the EMMO ontologist to characterize the universe and to provide the definitions to connect real world objects to the EMMO concepts.

Parthood relations do not change dimensionality of the real world object referred by an 'EMMO' individual, i.e. every part of a real world object always retains its 4D dimensionality. 

The smallest part of a real world object (i.e. a part that has no proper parts) is referred in the EMMO by a 'Quantum' individual.

It follows that, for the EMMO, real world objects of dimensionality lower than 4D (e.g. surfaces, lines) do not exist.

**Relations:** 

  - is_a owl:Thing
  - [hasPart](#haspart) some [Quantum](#quantum)
  - equivalent_to Inverse([hasPart](#haspart)) value [Universe](#universe)
  - disjoint_with 
  - disjoint_union_of [Collection](#collection), [Item](#item)






### Item
**IRI:** [http://emmo.info/emmo/top/mereotopology#EMMO_eb3a768e_d53e_4be9_a23b_0714833c36de](http://emmo.info/emmo/top/mereotopology#emmo_eb3a768e_d53e_4be9_a23b_0714833c36de)

**Comment:** A real world object is self-connected if any two parts that make up the whole are connected to each other (here the concept of connection is primitive). 

Alternatively, using the primitive path-connectivity concept we can define a self-connected real world object as an object for which each couple of points is path-connected.

**Comment:** An 'Item' individual stands for a real world self-connected object which can be represented as a whole made of connected parts (e.g. a car made of components).

In the EMMO, connectivity is the topological foundation of causality.

All physical systems, i.e. systems whose behaviour is explained by physics laws, are represented only by 'Item'-s.

Members of a 'Collection' lack of causality connection, i.e. they do not constitute a physical system as a whole.

**Comment:** From Latin item, "likewise, just so, moreover".

**Relations:** 

  - is_a [EMMO](#emmo)
  - disjoint_with [Collection](#collection)
  - disjoint_union_of [Void](#void), [Physical](#physical)






### Quantum
**IRI:** [http://emmo.info/emmo/top/mereotopology#EMMO_3f9ae00e_810c_4518_aec2_7200e424cf68](http://emmo.info/emmo/top/mereotopology#emmo_3f9ae00e_810c_4518_aec2_7200e424cf68)

**Elucidation:** The class of 'EMMO' individuals that stand for real world objects that can't be further divided in time nor in space.

**Example:** For a physics based ontology the 'Quantum' can stand for the smallest identifiable portion of spacetime defined by the Planck limit in length (1.616e-35 m) and time (5.39e-44 s).

However, the quantum mereotopology approach is not restricted only to physics. For example, in a manpower management ontology, a 'Quantum' can stand for an hour (time) of a worker (space) activity.

**Comment:** A 'Quantum' is the most fundamental subclass of 'Item', since its individuals stand for the smallest possible self-connected 4D real world objects.

The quantum concept recalls the fact that there is lower epistemological limit to our knowledge of the universe, related to the uncertainity principle.

**Comment:** A 'Quantum' stands for a 4D real world object.

**Comment:** A quantum is the EMMO mereological 4D a-tomic entity. 

To avoid confusion with the concept of atom coming from physics, we will use the expression quantum mereology, instead of a-tomistic mereology.

**Comment:** From Latin quantum (plural quanta) "as much as, so much as;", introduced in physics directly from Latin by Max Planck, 1900.

**Relations:** 

  - is_a [Item](#item)
  - is_a [EMMO](#emmo)
  - [hasProperPart](#hasproperpart) only owl:Nothing
  - disjoint_with [Semiosis](#semiosis), [Collection](#collection), [Manufacturing](#manufacturing), [PhysicsBasedModel](#physicsbasedmodel), [Reductionistic](#reductionistic), [Interpreter](#interpreter), [System](#system)






### Void
**IRI:** [http://emmo.info/emmo/top/physical#EMMO_29072ec4_ffcb_42fb_bdc7_26f05a2e9873](http://emmo.info/emmo/top/physical#emmo_29072ec4_ffcb_42fb_bdc7_26f05a2e9873)

**Elucidation:** A 'Item' that has no 'Physical' parts.

**Comment:** From Latin vacuus, “empty”.

**Relations:** 

  - is_a [Item](#item)
  - [hasPart](#haspart) only [Void](#void)
  - disjoint_with [Physical](#physical), [Collection](#collection)








## Elementary branch
![Elementary branch.](genfigs/ElementaryT.pdf){ width=443px }


### Elementary
**IRI:** [http://emmo.info/emmo/top/physical#EMMO_0f795e3e_c602_4577_9a43_d5a231aa1360](http://emmo.info/emmo/top/physical#emmo_0f795e3e_c602_4577_9a43_d5a231aa1360)

**Elucidation:** The basic constituent of 'item'-s that can be proper partitioned only in time up to quantum level.

**Comment:** According to mereology, this should be call 'a-tomistic' in the strict etimological sense of the word (from greek, a-tomos: un-divisible).

Mereology based on such items is called atomistic mereology.

However, in order not to confuse the lexicon between mereology and physics (in which an atom is a divisible physical entity) we prefer to call it 'elementary', recalling the concept of elementary particle coming from the standard particles model.

**Comment:** From Latin elementārius (“elementary”), from elementum (“one of the four elements of antiquity; fundamentals”)

**Comment:** While a 'Quantum' is a-tomistic in time and space, an 'elementary' is a-tomistic only in space, recalling the concept of elementary particle.

**Relations:** 

  - is_a [Physical](#physical)
  - [hasTemporalPart](#hastemporalpart) only [Elementary](#elementary)
  - [hasSpatialPart](#hasspatialpart) only owl:Nothing
  - disjoint_with [System](#system), [Collection](#collection), [PhysicsBasedModel](#physicsbasedmodel), [Reductionistic](#reductionistic), [Interpreter](#interpreter), [Void](#void)






## Perspective branch
![Perspective branch.](genfigs/PerspectiveT.pdf){ width=668px }


### Perspective
**IRI:** [http://emmo.info/emmo/top#EMMO_49267eba_5548_4163_8f36_518d65b583f9](http://emmo.info/emmo/top#emmo_49267eba_5548_4163_8f36_518d65b583f9)

**Elucidation:** The class of individuals that stand for real world objects according to a specific representational perspective.

**Comment:** This class is the practical implementation of the EMMO pluralistic approach for which that only objective categorization is provide by the Universe individual and all the 'Elementary' individuals.

Between these two extremes, there are several subjective ways to categorize real world objects, each one provide under a 'Perspective' subclass.

**Relations:** 

  - is_a [Physical](#physical)
  - disjoint_with [Collection](#collection), [Void](#void)








## Holistic branch
![Holistic branch.](genfigs/HolisticT.pdf){ width=461px }


### Holistic
**IRI:** [http://emmo.info/emmo/middle/holistic#EMMO_0277f24a_ea7f_4917_81b7_fb0406c8fc62](http://emmo.info/emmo/middle/holistic#emmo_0277f24a_ea7f_4917_81b7_fb0406c8fc62)

**Elucidation:** A union of classes that categorize physicals under a holistic perspective, meaning that the interest is on the whole 4D object (process) and the role of its spatial parts (participants) without going further into its subparts.

**Comment:** An holistic perspective considers each part of the whole as equally important, without the need of a granularity hierarchy, assigning a role to the whole.

Meaning that a molecule of a body can have role in the body evolution, without caring if its part of a specific organ.

This class allows the picking of parts without necessarily going trough a rigid hierarchy of compositions (e.g. body -> organ -> cell -> molecule).

**Comment:** Holism (from Greek $\acute{o}$$\uplambda$o$\upvarsigma$ holos "all, whole, entire")

**Relations:** 

  - is_a [Perspective](#perspective)
  - equivalent_to [Process](#process) or [Participant](#participant)
  - disjoint_with [Collection](#collection), [Void](#void)






### Participant
**IRI:** [http://emmo.info/emmo/middle/holistic#EMMO_49804605_c0fe_4538_abda_f70ba1dc8a5d](http://emmo.info/emmo/middle/holistic#emmo_49804605_c0fe_4538_abda_f70ba1dc8a5d)

**Elucidation:** A portion of a 'Process' that participates to the process with a specific role.

**Comment:** In the EMMO the relation of participation to a process falls under mereotopology.

Since topological connection means causality, then the only way for a real world object to participate to a process is to be a part of it.

**Relations:** 

  - is_a [Holistic](#holistic)
  - is_a [Physical](#physical)
  - Inverse([hasParticipant](#hasparticipant)) some [Process](#process)
  - disjoint_with [Collection](#collection), [Void](#void)






### Component
**IRI:** [http://emmo.info/emmo/middle/manufacturing#EMMO_494b372c_cfdf_47d3_a4de_5e037c540de8](http://emmo.info/emmo/middle/manufacturing#emmo_494b372c_cfdf_47d3_a4de_5e037c540de8)

**Relations:** 

  - is_a [Engineered](#engineered)
  - disjoint_with [Collection](#collection), [Void](#void)






### Engineered
**IRI:** [http://emmo.info/emmo/middle/manufacturing#EMMO_86ca9b93_1183_4b65_81b8_c0fcd3bba5ad](http://emmo.info/emmo/middle/manufacturing#emmo_86ca9b93_1183_4b65_81b8_c0fcd3bba5ad)

**Elucidation:** A 'physical' that stands for a real world object that has been manufacturedfor a particular purpose.

**Example:** Car, tire, composite material.

**Comment:** The 'Engineered' branch represents real world objects that show some level of complexity/heterogeneity in their composition, and are made for a specific use.

**Relations:** 

  - is_a [Participant](#participant)
  - Inverse([hasProperParticipant](#hasproperparticipant)) some [Manufacturing](#manufacturing)
  - disjoint_with [Collection](#collection), [Void](#void)






### System
**IRI:** [http://emmo.info/emmo/middle/manufacturing#EMMO_e775e341_5687_4d45_b50c_379b098a8c26](http://emmo.info/emmo/middle/manufacturing#emmo_e775e341_5687_4d45_b50c_379b098a8c26)

**Relations:** 

  - is_a [Engineered](#engineered)
  - equivalent_to [hasSpatialPart](#hasspatialpart) some [Component](#component)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Void](#void), [Elementary](#elementary)






## Semiotic branch
![Semiotic branch.](genfigs/SemioticT.pdf){ width=464px }


### Semiotic
**IRI:** [http://emmo.info/emmo/top/semiotics#EMMO_b803f122_4acb_4064_9d71_c1e5fd091fc9](http://emmo.info/emmo/top/semiotics#emmo_b803f122_4acb_4064_9d71_c1e5fd091fc9)

**Elucidation:** The class of individuals that stands for semiotic objects, i.e. objects that take part on a semiotic process.

**Comment:** Semiotic subclasse are defined using Peirce's semiotic theory.

"Namely, a sign is something, A, which brings something, B, its interpretant sign determined or created by it, into the same sort of correspondence with something, C, its object, as that in which itself stands to C." (Peirce 1902, NEM 4, 20–21).

The triadic elements:
- 'sign': the sign A (e.g. a name)
- 'interpretant': the sign B as the effects of the sign A on the interpreter (e.g. the mental concept of what a name means)
- 'object': the object C (e.g. the entity to which the sign A and B refer to)

This class includes also the 'interpeter' i.e. the entity that connects the 'sign' to the 'object'

**Relations:** 

  - is_a [Participant](#participant)
  - Inverse([hasProperParticipant](#hasproperparticipant)) some [Semiosis](#semiosis)
  - equivalent_to [Interpreter](#interpreter) or [Object](#object) or [Sign](#sign)
  - disjoint_with [Collection](#collection), [Void](#void)






## Sign branch
![Sign branch.](genfigs/SignT.pdf){ width=668px }


### Sign
**IRI:** [http://emmo.info/emmo/top/semiotics#EMMO_b21a56ed_f969_4612_a6ec_cb7766f7f31d](http://emmo.info/emmo/top/semiotics#emmo_b21a56ed_f969_4612_a6ec_cb7766f7f31d)

**Elucidation:** An 'Physical' that is used as sign ("semeion" in greek) that stands for another 'Physical' through an semiotic process.

**Example:** A novel is made of chapters, paragraphs, sentences, words and characters (in a direct parthood mereological hierarchy). 

Each of them are 'sign'-s. 

A character can be the a-tomistic 'sign' for the class of texts.

The horizontal segment in the character "A" is direct part of "A" but it is not a 'sign' itself.

For plain text we can propose the ASCII symbols, for math the fundamental math symbols.

**Comment:** A 'Sign' can have temporal-direct-parts which are 'Sign' themselves.

A 'Sign' usually have 'sign' spatial direct parts only up to a certain elementary semiotic level, in which the part is only a 'Physical' and no more a 'Sign' (i.e. it stands for nothing). This elementary semiotic level is peculiar to each particular system of signs (e.g. text, painting).

Just like an 'Elementary' in the 'Physical' branch, each 'Sign' branch should have an a-tomistic mereological part.

**Comment:** According to Peirce, 'Sign' includes three subcategories:
- symbols: that stand for an object through convention
- indeces: that stand for an object due to causal continguity
- icon: that stand for an object due to similitudes e.g. in shape or composition

**Relations:** 

  - is_a [Semiotic](#semiotic)
  - equivalent_to [Index](#index) or [Conventional](#conventional) or [Icon](#icon)
  - disjoint_with [Collection](#collection), [Void](#void)






### SpecialUnit
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_3ee80521_3c23_4dd1_935d_9d522614a3e2](http://emmo.info/emmo/middle/metrology#emmo_3ee80521_3c23_4dd1_935d_9d522614a3e2)

**Elucidation:** A unit symbol that stands for a derived unit.

**Example:** Pa stands for N/m2
J stands for N m

**Comment:** Special units are semiotic shortcuts to more complex composed symbolic objects.

**Relations:** 

  - is_a [DerivedUnit](#derivedunit)
  - is_a [UnitSymbol](#unitsymbol)
  - is_a [Sign](#sign)
  - Inverse([hasSign](#hassign)) some [DerivedUnit](#derivedunit)
  - disjoint_with [Collection](#collection), [Equation](#equation), [PhysicsBasedModel](#physicsbasedmodel), [BaseUnit](#baseunit), [Quantity](#quantity), [PrefixedUnit](#prefixedunit), [Void](#void)






### Interpretant
**IRI:** [http://emmo.info/emmo/top/semiotics#EMMO_054af807_85cd_4a13_8eba_119dfdaaf38b](http://emmo.info/emmo/top/semiotics#emmo_054af807_85cd_4a13_8eba_119dfdaaf38b)

**Elucidation:** The interpreter's internal representation of the object in a semiosis process.

**Relations:** 

  - is_a [Sign](#sign)
  - disjoint_with [Collection](#collection), [Void](#void)






### Index
**IRI:** [http://emmo.info/emmo/top/semiotics#EMMO_0cd58641_824c_4851_907f_f4c3be76630c](http://emmo.info/emmo/top/semiotics#emmo_0cd58641_824c_4851_907f_f4c3be76630c)

**Elucidation:** A 'Sign' that stands for an 'Object' due to causal continguity.

**Example:** Smoke stands for a combustion process (a fire).
My facial expression stands for my emotional status.

**Relations:** 

  - is_a [Sign](#sign)
  - disjoint_with [Collection](#collection), [Void](#void)






## Interpreter branch
![Interpreter branch.](genfigs/InterpreterT.pdf){ width=408px }


### MeasurementInstrument
**IRI:** [http://emmo.info/emmo/middle/properties#EMMO_f2d5d3ad_2e00_417f_8849_686f3988d929](http://emmo.info/emmo/middle/properties#emmo_f2d5d3ad_2e00_417f_8849_686f3988d929)

**Relations:** 

  - is_a [Observer](#observer)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Void](#void), [Elementary](#elementary)






### Observer
**IRI:** [http://emmo.info/emmo/middle/properties#EMMO_1b52ee70_121e_4d8d_8419_3f97cd0bd89c](http://emmo.info/emmo/middle/properties#emmo_1b52ee70_121e_4d8d_8419_3f97cd0bd89c)

**Elucidation:** An 'interpreter' that perceives another 'entity' (the 'object') through a specific perception mechanism and produces a 'property' (the 'sign') that stands for the result of that particular perception.

**Relations:** 

  - is_a [Interpreter](#interpreter)
  - Inverse([hasParticipant](#hasparticipant)) some [Observation](#observation)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Void](#void), [Elementary](#elementary)






### Interpreter
**IRI:** [http://emmo.info/emmo/top/semiotics#EMMO_0527413c_b286_4e9c_b2d0_03fb2a038dee](http://emmo.info/emmo/top/semiotics#emmo_0527413c_b286_4e9c_b2d0_03fb2a038dee)

**Elucidation:** The entity (or agent, or observer, or cognitive entity) who connects 'Sign', 'Interpretant' and 'Object'.

**Relations:** 

  - is_a [Semiotic](#semiotic)
  - [hasSpatialPart](#hasspatialpart) some [Interpretant](#interpretant)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Void](#void), [Elementary](#elementary)






## Object branch
![Object branch.](genfigs/ObjectT.pdf){ width=448px }


### Object
**IRI:** [http://emmo.info/emmo/top/semiotics#EMMO_6f5af708_f825_4feb_a0d1_a8d813d3022b](http://emmo.info/emmo/top/semiotics#emmo_6f5af708_f825_4feb_a0d1_a8d813d3022b)

**Elucidation:** The object, in Peirce semiotics.

**Comment:** Here is assumed that the concept of 'object' is always relative to a 'semiotic' process. An 'object' does not exists per se, but it's always part of an interpretation.

The EMMO relies on strong reductionism, i.e. everything real is a formless collection of elementary particles: we give a meaning to real world entities only by giving them boundaries and defining them using 'sign'-s. 

In this way the 'sign'-ed entity become and 'object', and the 'object' is the basic entity needed in order to apply a logical formalism to the real world entities (i.e. we can speak of it through its sign, and use logics on it through its sign).

**Relations:** 

  - is_a [Semiotic](#semiotic)
  - disjoint_with [Collection](#collection), [Void](#void)






### SIUnitSymbol
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_32129fb5_df25_48fd_a29c_18a2f22a2dd5](http://emmo.info/emmo/middle/siunits#emmo_32129fb5_df25_48fd_a29c_18a2f22a2dd5)

**Relations:** 

  - is_a [UnitSymbol](#unitsymbol)
  - is_a [SICoherentUnit](#sicoherentunit)
  - is_a [Object](#object)
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Exa](#exa), [Kilo](#kilo), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)
  - disjoint_union_of [SIBaseUnit](#sibaseunit), [SISpecialUnit](#sispecialunit)






## Conventional branch
![Conventional branch.](genfigs/ConventionalT.pdf){ width=668px }


### Theory
**IRI:** [http://emmo.info/emmo/middle/models#EMMO_8d2d9374_ef3a_47e6_8595_6bc208e07519](http://emmo.info/emmo/middle/models#emmo_8d2d9374_ef3a_47e6_8595_6bc208e07519)

**Elucidation:** A 'conventional' that stand for a 'physical'.

**Comment:** The 'theory' is e.g. a proposition, a book or a paper whose sub-symbols suggest in the mind of the interpreter an interpretant structure that can represent a 'physical'.

It is not an 'icon' (like a math equation), because it has no common resemblance or logical structure with the 'physical'.

In Peirce semiotics: legisign-symbol-argument

**Relations:** 

  - is_a [Conventional](#conventional)
  - disjoint_with [Collection](#collection), [Void](#void)






### Conventional
**IRI:** [http://emmo.info/emmo/top/semiotics#EMMO_35d2e130_6e01_41ed_94f7_00b333d46cf9](http://emmo.info/emmo/top/semiotics#emmo_35d2e130_6e01_41ed_94f7_00b333d46cf9)

**Elucidation:** A 'Sign' that stands for an 'Object' through convention, norm or habit, without any resemblance to it.

**Comment:** In Peirce semiotics this kind of sign category is called symbol. However, since symbol is also used in formal languages, the name is changed in conventional.

**Relations:** 

  - is_a [Sign](#sign)
  - disjoint_with [Collection](#collection), [Void](#void)






### Constant
**IRI:** [http://emmo.info/emmo/middle/math#EMMO_ae15fb4f_8e4d_41de_a0f9_3997f89ba6a2](http://emmo.info/emmo/middle/math#emmo_ae15fb4f_8e4d_41de_a0f9_3997f89ba6a2)

**Elucidation:** A 'varaible' that stand for a well known constant.

**Example:** $\uppi$ refers to the constant number ~3.14

**Relations:** 

  - is_a [Variable](#variable)
  - Inverse([hasVariable](#hasvariable)) only [Numerical](#numerical)
  - disjoint_with [Collection](#collection), [Void](#void)






### MaterialLaw
**IRI:** [http://emmo.info/emmo/middle/models#EMMO_f19ff3b4_6bfe_4c41_a2b2_9affd39c140b](http://emmo.info/emmo/middle/models#emmo_f19ff3b4_6bfe_4c41_a2b2_9affd39c140b)

**Relations:** 

  - is_a [NaturalLaw](#naturallaw)
  - disjoint_with [Collection](#collection), [Void](#void)






### Unknown
**IRI:** [http://emmo.info/emmo/middle/math#EMMO_fe7e56ce_118b_4243_9aad_20eb9f4f31f6](http://emmo.info/emmo/middle/math#emmo_fe7e56ce_118b_4243_9aad_20eb9f4f31f6)

**Elucidation:** The dependent variable for which an equation has been written.

**Example:** Velocity, for the Navier-Stokes equation.

**Relations:** 

  - is_a [Variable](#variable)
  - disjoint_with [Collection](#collection), [Void](#void)






### Parameter
**IRI:** [http://emmo.info/emmo/middle/math#EMMO_d1d436e7_72fc_49cd_863b_7bfb4ba5276a](http://emmo.info/emmo/middle/math#emmo_d1d436e7_72fc_49cd_863b_7bfb4ba5276a)

**Example:** viscosity in the Navier-Stokes equation

**Comment:** A 'variable' whose value is assumed to be known independently from the equation, but whose value is not explicitated in the equation.

**Relations:** 

  - is_a [Variable](#variable)
  - disjoint_with [Collection](#collection), [Void](#void)






### PhysicalLaw
**IRI:** [http://emmo.info/emmo/middle/models#EMMO_9c32fd69_f480_4130_83b3_fb25d9face14](http://emmo.info/emmo/middle/models#emmo_9c32fd69_f480_4130_83b3_fb25d9face14)

**Relations:** 

  - is_a [NaturalLaw](#naturallaw)
  - disjoint_with [Collection](#collection), [Void](#void)






### NaturalLaw
**IRI:** [http://emmo.info/emmo/middle/models#EMMO_db9a009e_f097_43f5_9520_6cbc07e7610b](http://emmo.info/emmo/middle/models#emmo_db9a009e_f097_43f5_9520_6cbc07e7610b)

**Relations:** 

  - is_a [Theory](#theory)
  - disjoint_with [Collection](#collection), [Void](#void)






### Variable
**IRI:** [http://emmo.info/emmo/middle/math#EMMO_1eed0732_e3f1_4b2c_a9c4_b4e75eeb5895](http://emmo.info/emmo/middle/math#emmo_1eed0732_e3f1_4b2c_a9c4_b4e75eeb5895)

**Elucidation:** A 'Variable' is a symbolic object that stands for a numerical defined 'Mathematical' object like e.g. a number, a vector, a matrix.

**Example:** x
k

**Relations:** 

  - is_a [Mathematical](#mathematical)
  - is_a [Conventional](#conventional)
  - Inverse([hasVariable](#hasvariable)) some [Mathematical](#mathematical)
  - disjoint_with [Collection](#collection), [Void](#void)






## Property branch
![Property branch.](genfigs/PropertyT.pdf){ width=668px }


### QuantitativeProperty
**IRI:** [http://emmo.info/emmo/middle/properties#EMMO_dd4a7f3e_ef56_466c_ac1a_d2716b5f87ec](http://emmo.info/emmo/middle/properties#emmo_dd4a7f3e_ef56_466c_ac1a_d2716b5f87ec)

**Elucidation:** A 'Quantity' that can be quantified with respect to a standardized reference physical instance (e.g. the prototype meter bar, the kg prototype) or method (e.g. resilience) through a measurement process.

**Comment:** "A property of a phenomenon, body, or substance, where the property has a magnitude that can be expressed by means of a number and a reference"
ISO 80000-1

"A reference can be a measurement unit, a measurement procedure, a reference material, or a combination of such."
International vocabulary of metrology (VIM)

**Comment:** A quantitative property is always expresssed as a quantity (i.e. a number and a reference unit). For the EMMO, a nominalistic ontology, there is no property as abstract object.

A property is a sign that stands for an object according to a specific code shared by some observers.

For quantititative properties, one possible code that is shared between the scientific community (the observers) is the SI system of units.

**Comment:** Subclasses of 'QuantitativeProperty' classify objects according to the type semiosis that is used to connect the property to the object (e.g. by measurement, by convention, by modelling).

**Relations:** 

  - is_a [Quantity](#quantity)
  - is_a [ObjectiveProperty](#objectiveproperty)
  - equivalent_to [MeasuredQuantitativeProperty](#measuredquantitativeproperty) or [ModelledQuantitativeProperty](#modelledquantitativeproperty) or [ConventionalQuantitativeProperty](#conventionalquantitativeproperty)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [SubjectiveProperty](#subjectiveproperty), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### ObjectiveProperty
**IRI:** [http://emmo.info/emmo/middle/properties#EMMO_2a888cdf_ec4a_4ec5_af1c_0343372fc978](http://emmo.info/emmo/middle/properties#emmo_2a888cdf_ec4a_4ec5_af1c_0343372fc978)

**Elucidation:** A 'Property' that is determined by each 'Observer' following a well defined 'Observation' procedure through a specific perception channel.

**Comment:** The word objective does not mean that each observation will provide the same results. It means that the observation followed a well defined procedure.

**Comment:** This class refers to what is commonly known as physical property, i.e. a measurable property of physical system, whether is quantifiable or not.

**Relations:** 

  - is_a [Property](#property)
  - disjoint_with [Collection](#collection), [SubjectiveProperty](#subjectiveproperty), [Void](#void)






### NominalProperty
**IRI:** [http://emmo.info/emmo/middle/properties#EMMO_909415d1_7c43_4d5e_bbeb_7e1910159f66](http://emmo.info/emmo/middle/properties#emmo_909415d1_7c43_4d5e_bbeb_7e1910159f66)

**Elucidation:** An 'ObjectiveProperty' that cannot be quantified.

**Example:** CFC is a 'sign' that stands for the fact that the morphology of atoms composing the microstructure of an entity is predominantly Cubic Face Centered

A color is a nominal property.

Sex of a human being.

**Comment:** "Property of a phenomenon, body, or substance, where the property has no magnitude."

"A nominal property has a value, which can be expressed in words, by alphanumerical codes, or by other means."

International vocabulary of metrology (VIM)

**Relations:** 

  - is_a [ObjectiveProperty](#objectiveproperty)
  - disjoint_with [Collection](#collection), [SubjectiveProperty](#subjectiveproperty), [Void](#void)






### SubjectiveProperty
**IRI:** [http://emmo.info/emmo/middle/properties#EMMO_251cfb4f_5c75_4778_91ed_6c8395212fd8](http://emmo.info/emmo/middle/properties#emmo_251cfb4f_5c75_4778_91ed_6c8395212fd8)

**Elucidation:** A 'Property' that cannot be univocally determined and depends on an agent (e.g. a human individual, a community) acting as black-box.

**Example:** The beauty of that girl.
The style of your clothing.

**Comment:** The word subjective means that a non-well defined or an unknown procedure is used for the definition of the property.

This happens due to e.g. the complexity of the object, the lack of a underlying model for the representation of the object, the non-well specified meaning of the property symbols. 

A 'SubjectiveProperty' cannot be used to univocally compare 'Object'-s.

e.g. you cannot evaluate the beauty of a person on objective basis.

**Relations:** 

  - is_a [Property](#property)
  - disjoint_with [Collection](#collection), [Void](#void), [ObjectiveProperty](#objectiveproperty)






### ConventionalQuantitativeProperty
**IRI:** [http://emmo.info/emmo/middle/properties#EMMO_d8aa8e1f_b650_416d_88a0_5118de945456](http://emmo.info/emmo/middle/properties#emmo_d8aa8e1f_b650_416d_88a0_5118de945456)

**Elucidation:** A quantitative property attributed by agreement to a quantity for a given purpose.

**Example:** The thermal conductivity of a copper sample in my laboratory can be assumed to be the conductivity that appears in the vendor specification. This value has been obtained by measurement of a sample which is not the one I have in my laboratory. This conductivity value is then a conventional quantitiative property assigned to my sample through a semiotic process in which no actual measurement is done by my laboratory.

If I don't believe the vendor, then I can measure the actual thermal conductivity. I then perform a measurement process that semiotically assign another value for the conductivity, which is a measured property, since is part of a measurement process.

Then I have two different physical quantities that are properties thanks to two different semiotic processes.

**Comment:** A property that is associated to an object by convention, or assumption.

**Relations:** 

  - is_a [QuantitativeProperty](#quantitativeproperty)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [SubjectiveProperty](#subjectiveproperty), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### Property
**IRI:** [http://emmo.info/emmo/middle/properties#EMMO_b7bcff25_ffc3_474e_9ab5_01b1664bd4ba](http://emmo.info/emmo/middle/properties#emmo_b7bcff25_ffc3_474e_9ab5_01b1664bd4ba)

**Elucidation:** A 'Perceptual' referring to a specific code that is used as 'Conventional' sign to represent an 'Object' according to a specific interaction mechanism by an 'Observer'.

(A property is always a partial representation of an 'Object' since it reflects the 'Object' capability to be part of a specific 'Observation' process)

**Example:** Hardness is a subclass of properties.

Vickers hardness is a subclass of hardness that involves the procedures and instruments defined by the standard hardness test.

**Example:** Let's define the class 'colour' as the subclass of the properties that involve photon emission and an electromagnetic radiation sensible observer.

An individual C of this class 'colour' can be defined be declaring the process individual (e.g. daylight illumination) and the observer (e.g. my eyes)

Stating that an entity E has_property C, we mean that it can be observed by such setup of process + observer (i.e. observed by my eyes under daylight).

This definition can be generalized by using a generic human eye, so that the observer can be a generic human.

This can be used in material characterization, to define exactly the type of measurement done, including the instrument type.

**Comment:** A 'Property' is a sort of name or label that we put upon objects that interact with an observer in the same specific way.

e.g. "hot" objects are objects that interact with an observer through a perception mechanism aimed to perceive an heat source.

**Comment:** We know real world entities through observation/perception.

A non-perceivable real world entity does not exist (or it exists on a plane of existance that has no intersection with us and we can say nothing about it).

Perception/observation of a real wolrd entity occurs when the entity stimulate an observer in a peculiar way through a well defined perception channel.

For this reason each property is related to a specific observation process which involves a specific observer with its own perception mechanisms.

The observation process (e.g. a look, a photo shot, a measurement) is performed  by an observer (e.g. you, a camera, an instrument) through a specific perception mechanism (e.g. retina impression, CMOS excitation, piezoelectric sensor activation) and involves an observed entity.

An observation is a semiotic process, since it stimulate an interpretant within the interpreter who can communicate the perception result to other interpreters through a sign which is the property. 

Property subclasses are specializations that depend on the type of observation processes.

e.g. the property 'colour' is related to a process that involves emission or interaction of photon and an observer who can perceive electromagnetic radiation in the visible frequency range. 

Properties usually relies on symbolic systems (e.g. for colour it can be palette or RGB).

**Relations:** 

  - is_a [Conventional](#conventional)
  - Inverse([hasParticipant](#hasparticipant)) some [Observation](#observation)
  - Inverse([hasProperty](#hasproperty)) some [Object](#object)
  - disjoint_with [Collection](#collection), [Void](#void)
  - disjoint_union_of [SubjectiveProperty](#subjectiveproperty), [ObjectiveProperty](#objectiveproperty)






### ModelledQuantitativeProperty
**IRI:** [http://emmo.info/emmo/middle/properties#EMMO_d0200cf1_e4f4_45ae_873f_b9359daea3cd](http://emmo.info/emmo/middle/properties#emmo_d0200cf1_e4f4_45ae_873f_b9359daea3cd)

**Relations:** 

  - is_a [QuantitativeProperty](#quantitativeproperty)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [SubjectiveProperty](#subjectiveproperty), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### MeasuredQuantitativeProperty
**IRI:** [http://emmo.info/emmo/middle/properties#EMMO_873b0ab3_88e6_4054_b901_5531e01f14a4](http://emmo.info/emmo/middle/properties#emmo_873b0ab3_88e6_4054_b901_5531e01f14a4)

**Relations:** 

  - is_a [QuantitativeProperty](#quantitativeproperty)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [SubjectiveProperty](#subjectiveproperty), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






## Icon branch
![Icon branch.](genfigs/IconT.pdf){ width=360px }


### Icon
**IRI:** [http://emmo.info/emmo/top/semiotics#EMMO_d7788d1a_020d_4c78_85a1_13563fcec168](http://emmo.info/emmo/top/semiotics#emmo_d7788d1a_020d_4c78_85a1_13563fcec168)

**Elucidation:** A 'Sign' that stands for an 'Object' by resembling or imitating it, in shape or by sharing a similar logical structure.

**Example:** A picture that reproduces the aspect of a person. 

An equation that reproduces the logical connection of the properties of a physical entity.

**Comment:** Three subtypes of icon are possible:
 
(a) the image, which depends on a simple quality (e.g. picture)

(b) the diagram, whose internal relations, mainly dyadic or so taken, represent by analogy the relations in something (e.g. math formula, geometric flowchart)

(c) the metaphor, which represents the representative character of a sign by representing a parallelism in something else

[Wikipedia]

**Relations:** 

  - is_a [Sign](#sign)
  - disjoint_with [Collection](#collection), [Void](#void)






### Model
**IRI:** [http://emmo.info/emmo/middle/models#EMMO_939483b1_0148_43d1_8b35_851d2cd5d939](http://emmo.info/emmo/middle/models#emmo_939483b1_0148_43d1_8b35_851d2cd5d939)

**Elucidation:** A 'sign' that not only stands for a 'physical' or a 'process', but it is also a simplified representation, aimed to assist calculations for its description or for predictions of its behaviour.

A 'model' represents a 'physical' or a 'process' by direct similitude (e.g. small scale replica) or by capturing in a logical framework the relations between its properties (e.g. mathematical model).

**Comment:** A 'model' prediction is always a prediction of the properties of an entity, since an entity is known by an interpreter only through perception.

**Relations:** 

  - is_a [Icon](#icon)
  - equivalent_to Inverse([hasModel](#hasmodel)) some [Physical](#physical)
  - disjoint_with [Collection](#collection), [Void](#void)






## Process branch
![Process branch.](genfigs/ProcessT.pdf){ width=668px }


### Semiosis
**IRI:** [http://emmo.info/emmo/top/semiotics#EMMO_008fd3b2_4013_451f_8827_52bceab11841](http://emmo.info/emmo/top/semiotics#emmo_008fd3b2_4013_451f_8827_52bceab11841)

**Elucidation:** A 'Process', that has participant an 'Interpreter', that is aimed to produce a 'Sign' representing another participant, the 'Object'.

**Example:** Me looking a cat and saying loud: "Cat!" -> the semiosis process

me -> interpreter
cat -> object (in Peirce semiotics)
the cat perceived by my mind -> interpretant
"Cat!" -> sign, the produced sign

**Relations:** 

  - is_a [Process](#process)
  - [hasProperParticipant](#hasproperparticipant) some [Interpreter](#interpreter)
  - [hasProperParticipant](#hasproperparticipant) some [Object](#object)
  - [hasProperParticipant](#hasproperparticipant) some [Sign](#sign)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Void](#void)






### Manufacturing
**IRI:** [http://emmo.info/emmo/middle/manufacturing#EMMO_a4d66059_5dd3_4b90_b4cb_10960559441b](http://emmo.info/emmo/middle/manufacturing#emmo_a4d66059_5dd3_4b90_b4cb_10960559441b)

**Relations:** 

  - is_a [Process](#process)
  - [hasProperParticipant](#hasproperparticipant) some [Engineered](#engineered)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Void](#void)






### Measurement
**IRI:** [http://emmo.info/emmo/middle/properties#EMMO_463bcfda_867b_41d9_a967_211d4d437cfb](http://emmo.info/emmo/middle/properties#emmo_463bcfda_867b_41d9_a967_211d4d437cfb)

**Elucidation:** An 'observation' that results in a quantitative comparison of a 'property' of an 'object' with a standard reference.

**Relations:** 

  - is_a [Observation](#observation)
  - [hasParticipant](#hasparticipant) some [MeasurementInstrument](#measurementinstrument)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Void](#void)






### Theorization
**IRI:** [http://emmo.info/emmo/middle/models#EMMO_6c739b1a_a774_4416_bb31_1961486fa9ed](http://emmo.info/emmo/middle/models#emmo_6c739b1a_a774_4416_bb31_1961486fa9ed)

**Elucidation:** The 'semiosis' process of interpreting a 'physical' and provide a complec sign, 'theory' that stands for it and explain it to another interpreter.

**Relations:** 

  - is_a [Observation](#observation)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Void](#void)






### PhysicalPhenomenon
**IRI:** [http://emmo.info/emmo/middle/models#EMMO_314d0bd5_67ed_437e_a609_36d46147cea7](http://emmo.info/emmo/middle/models#emmo_314d0bd5_67ed_437e_a609_36d46147cea7)

**Elucidation:** A 'process' that is recognized by physical sciences and is catogrized accordingly.

**Comment:** While every 'process' in the EMMO involves physical objects, this class is devoted to represent real world objects that express a phenomena relevant for the ontologist.

**Relations:** 

  - is_a [Process](#process)
  - disjoint_with [Collection](#collection), [Void](#void)






### Process
**IRI:** [http://emmo.info/emmo/middle/holistic#EMMO_43e9a05d_98af_41b4_92f6_00f79a09bfce](http://emmo.info/emmo/middle/holistic#emmo_43e9a05d_98af_41b4_92f6_00f79a09bfce)

**Elucidation:** A temporal part of a 'physical' that identifies a particular type of evolution in time.

**Comment:** A 'Process' is always a 'Physical', since a 'Void' does not have elements that evolves in time.

**Comment:** A 'Process' is defined as a temporal part of a 'Physical' that is categorized according to an EMMO user that recognizes a particular type of evolution in time of the real world object.

Following the common definition of process, every 'Physical' should be a process, since every 4D object always has a time dimension. 

However, in the EMMO we restrict the meaning of the word process to 'Physical'-s whose evolution in time have a particular meaning for the ontologist.

A 'Process' is not only something that unfolds in time (which is automatically represented in a 4D ontology), but something that has a meaning for the ontologist, i.e. that the ontologist can separate from the rest of the 4D physical for any reason.

**Relations:** 

  - is_a [Holistic](#holistic)
  - is_a [Physical](#physical)
  - [hasParticipant](#hasparticipant) some [Participant](#participant)
  - disjoint_with [Collection](#collection), [Void](#void)






### Experiment
**IRI:** [http://emmo.info/emmo/middle/models#EMMO_22522299_4091_4d1f_82a2_3890492df6db](http://emmo.info/emmo/middle/models#emmo_22522299_4091_4d1f_82a2_3890492df6db)

**Elucidation:** An experiment is a process that is intended to replicate a physical phenomenon in a controlled environment.

**Relations:** 

  - is_a [Observation](#observation)
  - [hasParticipant](#hasparticipant) some [PhysicalPhenomenon](#physicalphenomenon)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Void](#void)






### Observation
**IRI:** [http://emmo.info/emmo/middle/properties#EMMO_10a5fd39_06aa_4648_9e70_f962a9cb2069](http://emmo.info/emmo/middle/properties#emmo_10a5fd39_06aa_4648_9e70_f962a9cb2069)

**Elucidation:** A 'Semiosis' that involves an 'Observer' that perceives another 'Physical' (the 'Object') through a specific perception mechanism and produces a 'Property' (the 'Sign') that stands for the result of that particular perception.

**Relations:** 

  - is_a [Semiosis](#semiosis)
  - [hasParticipant](#hasparticipant) some [Observer](#observer)
  - [hasParticipant](#hasparticipant) some [Property](#property)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Void](#void)








## Perceptual branch
![Perceptual branch.](genfigs/PerceptualT.pdf){ width=489px }


### Noise
**IRI:** [http://emmo.info/emmo/middle/perceptual#EMMO_91756568_8655_4060_8937_a1a906dad8c1](http://emmo.info/emmo/middle/perceptual#emmo_91756568_8655_4060_8937_a1a906dad8c1)

**Relations:** 

  - is_a [Acoustical](#acoustical)
  - disjoint_with [Collection](#collection), [Void](#void)






### Music
**IRI:** [http://emmo.info/emmo/middle/perceptual#EMMO_0d69f94a_f4fa_49d9_bf90_ace770eeab02](http://emmo.info/emmo/middle/perceptual#emmo_0d69f94a_f4fa_49d9_bf90_ace770eeab02)

**Elucidation:** A 'acoustical' that can be categorized as music by the ontologist.

**Comment:** A music score is not a 'music' individual.

A music score is a 'graphical' that can stand for a 'music' (or vice versa) since it comes through a different perception mechanism.

The 'music' individual is the sound itself as produced and delivered by a source in the form of sound wave through a medium.

**Relations:** 

  - is_a [Acoustical](#acoustical)
  - disjoint_with [Collection](#collection), [Void](#void)






### Perceptual
**IRI:** [http://emmo.info/emmo/middle/perceptual#EMMO_649bf97b_4397_4005_90d9_219755d92e34](http://emmo.info/emmo/middle/perceptual#emmo_649bf97b_4397_4005_90d9_219755d92e34)

**Elucidation:** A 'Physical' which stands for a real world object that can stimulate a perception (e.g. a mental impression, the excitation of a sensor) to an interpreter (human or non-human).

**Example:** A line scratched on a surface.
A sound.
A smell.
The word 'cat' and the sound of the word 'cat' (the first one is graphical and the second acoustical).

**Example:** The meta-semiotic process:
I see a cloud in the sky. Since I'm an EMMO ontologist, I create an individual named Cloud under the 'Impression' class.  This semiotic process occurs at meta-level: it's how I use the EMMO as tool for a direct representation of the world.

The semiotic process within EMMO:
My friend looks at the same cloud and says: "It is an elephant".
I use the EMMO to record this experience by declaring:
    - my friend as MyFriend individual, belonging to 'Interpreter' classes
    - the sound of the word "elephant" as an acoustical impression individual named ElephantWord, belonging to 'Impression'
    - a relation hasSign between Cloud and ElephantWord, that makes ElephantWord also belonging to 'Sign' class and Cloud belonging also to 'Object' class
    - a 'Semiosis' individual called MyFriendElephantCloud that hasParticipant: Cloud, ElephantWord and MyFriend, respectively as object, sign and interpreter.

**Comment:** 'Perceptual' includes real world objects that:
- are part of a communication system (e.g. words, speech, alphabets)
- are not part of a communication system, but can be identified and referred by an interpreter

**Comment:** A 'Perceptual' is a meta-object, meaning that is addressed by the ontologist (the meta-interpreter) in a meta-semiotic process occurring outside the EMMO.

A 'Perceptual' becomes an 'Object', when it is part of a 'Semiotic' process described by the ontologist through the EMMO.

**Comment:** From Latin percepti$\bar{\mathrm{o}}$ (“a receiving or collecting, perception, comprehension”), from perceptus (“perceived, observed”).

**Comment:** This class is the most general superclass for the categorization of real world objects that are recognizable by an interpreter (agent).

A 'Perceptual' can stand for something else in a semiotic process (acting as sign or as object). 

However, a perceptual is not necessarily a 'Sign' (e.g. a line sketched on a blackboard is a recognizable 'Perceptual' but it may stand for nothing).

**Relations:** 

  - is_a [Perspective](#perspective)
  - disjoint_with [Collection](#collection), [Void](#void)






### Acoustical
**IRI:** [http://emmo.info/emmo/middle/perceptual#EMMO_4b3afb22_27cf_4ce3_88bc_492bfccb546b](http://emmo.info/emmo/middle/perceptual#emmo_4b3afb22_27cf_4ce3_88bc_492bfccb546b)

**Elucidation:** An 'impression' which stands for a real world object whose spatiotemporal pattern makes it identifiable by an observer as a sound.

**Comment:** 'acoustical' refers to the perception mechanism of the observer that can occur through a microphone, a ear.

**Relations:** 

  - is_a [Perceptual](#perceptual)
  - disjoint_with [Collection](#collection), [Void](#void)






### Speech
**IRI:** [http://emmo.info/emmo/middle/perceptual#EMMO_660ef3b0_6692_4c51_8f69_763c7817b2e1](http://emmo.info/emmo/middle/perceptual#emmo_660ef3b0_6692_4c51_8f69_763c7817b2e1)

**Relations:** 

  - is_a [Acoustical](#acoustical)
  - disjoint_with [Collection](#collection), [Void](#void)






## Graphical branch
![Graphical branch.](genfigs/GraphicalT.pdf){ width=668px }


### Symbolic
**IRI:** [http://emmo.info/emmo/middle/perceptual#EMMO_057e7d57_aff0_49de_911a_8861d85cef40](http://emmo.info/emmo/middle/perceptual#emmo_057e7d57_aff0_49de_911a_8861d85cef40)

**Elucidation:** An 'Graphical' that stands for a token or a composition of tokens from one or more alphabets, without necessarily respecting syntactic rules.

**Example:** fe780
emmo
!5*a
cat

**Relations:** 

  - is_a [Graphical](#graphical)
  - disjoint_with [Collection](#collection), [Void](#void)






### Graphical
**IRI:** [http://emmo.info/emmo/middle/perceptual#EMMO_c74da218_9147_4f03_92d1_8894abca55f3](http://emmo.info/emmo/middle/perceptual#emmo_c74da218_9147_4f03_92d1_8894abca55f3)

**Elucidation:** A 'Phenomenic' which stands for a real world object whose spatial configuration shows a pattern identifiable by an observer.

**Example:** 'Graphical' objects include writings, pictures, sketches ...

**Comment:** From the Ancient Greek $\upgamma$$\uprho$$\upalpha$$\upvarphi$$\acute{\upeta}$ (graph$\acute{\bar{\mathrm{e}}}$) which means drawing, painting, writing, a writing, description, and from $\upgamma$$\uprho$$\acute{\upalpha}$$\upvarphi$$\upomega$ (gr$\acute{\mathrm{a}}$ph$\bar{\mathrm{o}}$) which means scratch, carve.

**Relations:** 

  - is_a [Perceptual](#perceptual)
  - disjoint_with [Collection](#collection), [Void](#void)






### SymbolicComposition
**IRI:** [http://emmo.info/emmo/middle/perceptual#EMMO_89a0c87c_0804_4013_937a_6fe234d9499c](http://emmo.info/emmo/middle/perceptual#emmo_89a0c87c_0804_4013_937a_6fe234d9499c)

**Elucidation:** A symbolic entity made of other symbolic entities according to a specific spatial configuration.

**Relations:** 

  - is_a [Symbolic](#symbolic)
  - is_a [State](#state)
  - [hasSpatialDirectPart](#hasspatialdirectpart) some [Symbolic](#symbolic)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Void](#void), [Elementary](#elementary)






### Pictorial
**IRI:** [http://emmo.info/emmo/middle/perceptual#EMMO_1da53c06_9577_4008_8652_272fa3b62be7](http://emmo.info/emmo/middle/perceptual#emmo_1da53c06_9577_4008_8652_272fa3b62be7)

**Elucidation:** A 'Graphical' that stands for a real world object that shows a recognizable pictorial pattern without being necessarily associated to a symbolic language.

**Example:** A drawing of a cat.
A circle on a paper sheet.
The Mona Lisa.

**Relations:** 

  - is_a [Graphical](#graphical)
  - disjoint_with [Collection](#collection), [Void](#void)






### Language
**IRI:** [http://emmo.info/emmo/middle/perceptual#EMMO_d8d2144e_5c8d_455d_a643_5caf4d8d9df8](http://emmo.info/emmo/middle/perceptual#emmo_d8d2144e_5c8d_455d_a643_5caf4d8d9df8)

**Elucidation:** A language object is a symbolic object respecting a specific language syntactic rules (a well-formed formula).

**Relations:** 

  - is_a [Symbolic](#symbolic)
  - disjoint_with [Collection](#collection), [Void](#void)






### String
**IRI:** [http://emmo.info/emmo/middle/perceptual#EMMO_50ea1ec5_f157_41b0_b46b_a9032f17ca10](http://emmo.info/emmo/middle/perceptual#emmo_50ea1ec5_f157_41b0_b46b_a9032f17ca10)

**Elucidation:** A physical made of more than one symbol sequentially arranged.

**Example:** The word "cat" considered as a collection of 'symbol'-s respecting the rules of english language. 

In this example the 'symbolic' entity "cat" is not related to the real cat, but it is only a word (like it would be to an italian person that ignores the meaning of this english word).

If an 'interpreter' skilled in english language is involved in a 'semiotic' process with this word, that "cat" became also a 'sign' i.e. it became for the 'interpreter' a representation for a real cat.

**Comment:** A string is made of concatenated symbols whose arrangement is one-dimensional. Each symbol can have only one previous and one next neighborhood (bidirectional list).

**Comment:** A string is not requested to respect any syntactic rule: it's simply directly made of symbols.

**Relations:** 

  - is_a [Symbolic](#symbolic)
  - is_a [State](#state)
  - [hasSpatialDirectPart](#hasspatialdirectpart) some [Symbol](#symbol)
  - [hasSpatialDirectPart](#hasspatialdirectpart) only [Symbol](#symbol)
  - disjoint_with [Collection](#collection), [PhysicsEquation](#physicsequation), [MaterialRelation](#materialrelation), [Quantum](#quantum), [Void](#void), [Elementary](#elementary)






## Geometrical branch
![Geometrical branch.](genfigs/GeometricalT.pdf){ width=668px }


### Circle
**IRI:** [http://emmo.info/emmo/middle/perceptual#EMMO_b2a234a8_579a_422c_9305_b8f7e72c76cd](http://emmo.info/emmo/middle/perceptual#emmo_b2a234a8_579a_422c_9305_b8f7e72c76cd)

**Relations:** 

  - is_a [1-manifold](#1-manifold)
  - disjoint_with [Collection](#collection), [Void](#void)






### Line
**IRI:** [http://emmo.info/emmo/middle/perceptual#EMMO_3e309118_e8b7_4021_80f4_642d2df65d94](http://emmo.info/emmo/middle/perceptual#emmo_3e309118_e8b7_4021_80f4_642d2df65d94)

**Relations:** 

  - is_a [1-manifold](#1-manifold)
  - disjoint_with [Collection](#collection), [Void](#void)






### 0-manifold
**IRI:** [http://emmo.info/emmo/middle/perceptual#EMMO_0ab0485c_9e5b_4257_a679_90a2dfba5c7c](http://emmo.info/emmo/middle/perceptual#emmo_0ab0485c_9e5b_4257_a679_90a2dfba5c7c)

**Relations:** 

  - is_a [Geometrical](#geometrical)
  - disjoint_with [Collection](#collection), [Void](#void)






### Point
**IRI:** [http://emmo.info/emmo/middle/perceptual#EMMO_39362460_2a97_4367_8f93_0418c2ac9a08](http://emmo.info/emmo/middle/perceptual#emmo_39362460_2a97_4367_8f93_0418c2ac9a08)

**Relations:** 

  - is_a [0-manifold](#0-manifold)
  - disjoint_with [Collection](#collection), [Void](#void)






### Geometrical
**IRI:** [http://emmo.info/emmo/middle/perceptual#EMMO_b5957cef_a287_442d_a3ce_fd39f20ba1cd](http://emmo.info/emmo/middle/perceptual#emmo_b5957cef_a287_442d_a3ce_fd39f20ba1cd)

**Elucidation:** A 'graphical' aimed to represent a geometrical concept.

**Comment:** A 'geometrical' stands for real world objects that express a geometrical concept.

This can be achieved in many different ways. For example, a line can be expressed by:
a) an equation like y=mx+q, which is both an 'equation' and a 'geometrical'
b) a line drawn with a pencil on a paper, which is simply a 'graphical' object
c) a set of axioms, when the properties of a line are inferred by the interpreter reading them, that are both 'graphical' and also 'formula'

The case a) is a geometrical and mathematical, b) is geometrical and pictorial, while c) is geometrical and a composition of idiomatic strings.

**Relations:** 

  - is_a [Graphical](#graphical)
  - disjoint_with [Collection](#collection), [Void](#void)






### Torus
**IRI:** [http://emmo.info/emmo/middle/perceptual#EMMO_86060335_31c2_4820_b433_27c64aea0366](http://emmo.info/emmo/middle/perceptual#emmo_86060335_31c2_4820_b433_27c64aea0366)

**Relations:** 

  - is_a [2-manifold](#2-manifold)
  - disjoint_with [Collection](#collection), [Void](#void)






### Plane
**IRI:** [http://emmo.info/emmo/middle/perceptual#EMMO_25f5ca8e_8f7f_44d8_a392_bd3fe8894458](http://emmo.info/emmo/middle/perceptual#emmo_25f5ca8e_8f7f_44d8_a392_bd3fe8894458)

**Relations:** 

  - is_a [2-manifold](#2-manifold)
  - disjoint_with [Collection](#collection), [Void](#void)






### EuclideanSpace
**IRI:** [http://emmo.info/emmo/middle/perceptual#EMMO_5f278af9_8593_4e27_a717_ccc9e07a0ddf](http://emmo.info/emmo/middle/perceptual#emmo_5f278af9_8593_4e27_a717_ccc9e07a0ddf)

**Relations:** 

  - is_a [3-manifold](#3-manifold)
  - disjoint_with [Collection](#collection), [Void](#void)






### 2-manifold
**IRI:** [http://emmo.info/emmo/middle/perceptual#EMMO_9268958f_7f54_48ab_a693_febe2645892b](http://emmo.info/emmo/middle/perceptual#emmo_9268958f_7f54_48ab_a693_febe2645892b)

**Relations:** 

  - is_a [Geometrical](#geometrical)
  - disjoint_with [Collection](#collection), [Void](#void)






### Curve
**IRI:** [http://emmo.info/emmo/middle/perceptual#EMMO_0ef4ff4a_5458_4f2a_b51f_4689d472a3f2](http://emmo.info/emmo/middle/perceptual#emmo_0ef4ff4a_5458_4f2a_b51f_4689d472a3f2)

**Relations:** 

  - is_a [1-manifold](#1-manifold)
  - disjoint_with [Collection](#collection), [Void](#void)






### Sphere
**IRI:** [http://emmo.info/emmo/middle/perceptual#EMMO_d7bf784a_db94_4dd9_861c_54f262846fbf](http://emmo.info/emmo/middle/perceptual#emmo_d7bf784a_db94_4dd9_861c_54f262846fbf)

**Relations:** 

  - is_a [2-manifold](#2-manifold)
  - disjoint_with [Collection](#collection), [Void](#void)






### 3-manifold
**IRI:** [http://emmo.info/emmo/middle/perceptual#EMMO_46f0f8df_4dc6_418f_8036_10427a3a288e](http://emmo.info/emmo/middle/perceptual#emmo_46f0f8df_4dc6_418f_8036_10427a3a288e)

**Relations:** 

  - is_a [Geometrical](#geometrical)
  - disjoint_with [Collection](#collection), [Void](#void)






### 1-manifold
**IRI:** [http://emmo.info/emmo/middle/perceptual#EMMO_0c576e13_4ee7_4f3d_bfe9_1614243df018](http://emmo.info/emmo/middle/perceptual#emmo_0c576e13_4ee7_4f3d_bfe9_1614243df018)

**Relations:** 

  - is_a [Geometrical](#geometrical)
  - disjoint_with [Collection](#collection), [Void](#void)






## Symbol branch
![Symbol branch.](genfigs/SymbolT.pdf){ width=668px }


### BaseUnit
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_db716151_6b73_45ff_910c_d182fdcbb4f5](http://emmo.info/emmo/middle/metrology#emmo_db716151_6b73_45ff_910c_d182fdcbb4f5)

**Elucidation:** A set of units that correspond to the base quantities in a system of units.

**Relations:** 

  - is_a [UnitSymbol](#unitsymbol)
  - disjoint_with [Collection](#collection), [Equation](#equation), [PhysicsBasedModel](#physicsbasedmodel), [Quantity](#quantity), [PrefixedUnit](#prefixedunit), [Void](#void), [SpecialUnit](#specialunit)






### UnitSymbol
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_216f448e_cdbc_4aeb_a529_7a5fe7fc38bb](http://emmo.info/emmo/middle/metrology#emmo_216f448e_cdbc_4aeb_a529_7a5fe7fc38bb)

**Elucidation:** A symbol that stands for a single unit.

**Example:** Some examples are "Pa", "m" and "J".

**Relations:** 

  - is_a [MetrologicalSymbol](#metrologicalsymbol)
  - is_a [NonPrefixedUnit](#nonprefixedunit)
  - equivalent_to [MeasurementUnit](#measurementunit) and [Symbol](#symbol)
  - disjoint_with [Collection](#collection), [Equation](#equation), [PhysicsBasedModel](#physicsbasedmodel), [Quantity](#quantity), [PrefixedUnit](#prefixedunit), [Void](#void)
  - disjoint_union_of [SpecialUnit](#specialunit), [BaseUnit](#baseunit)






### UnitOne
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_5ebd5e01_0ed3_49a2_a30d_cd05cbe72978](http://emmo.info/emmo/middle/metrology#emmo_5ebd5e01_0ed3_49a2_a30d_cd05cbe72978)

**Elucidation:** Represents the number 1, used as an explicit unit to say something has no units.

**Example:** Refractive index or volume fraction.

**Example:** Typically used for ratios of two units whos dimensions cancels out.

**Qudtmatch:** [http://qudt.org/vocab/unit/UNITLESS](http://qudt.org/vocab/unit/unitless)

**Relations:** 

  - is_a [BaseUnit](#baseunit)
  - disjoint_with [Collection](#collection), [Equation](#equation), [PhysicsBasedModel](#physicsbasedmodel), [Quantity](#quantity), [PrefixedUnit](#prefixedunit), [Void](#void), [SpecialUnit](#specialunit)






### MetrologicalSymbol
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_50a3552e_859a_4ff7_946d_76d537cabce6](http://emmo.info/emmo/middle/metrology#emmo_50a3552e_859a_4ff7_946d_76d537cabce6)

**Elucidation:** A symbol that stands for a concept in the language of the meterological domain of ISO 80000.

**Relations:** 

  - is_a [Metrological](#metrological)
  - is_a [Symbol](#symbol)
  - [hasProperPart](#hasproperpart) only not [Metrological](#metrological)
  - equivalent_to [Metrological](#metrological) and [Symbol](#symbol)
  - disjoint_with [Collection](#collection), [Equation](#equation), [PhysicsBasedModel](#physicsbasedmodel), [Quantity](#quantity), [PrefixedUnit](#prefixedunit), [Void](#void)






### Symbol
**IRI:** [http://emmo.info/emmo/middle/perceptual#EMMO_a1083d0a_c1fb_471f_8e20_a98f881ad527](http://emmo.info/emmo/middle/perceptual#emmo_a1083d0a_c1fb_471f_8e20_a98f881ad527)

**Elucidation:** The class of individuals that stand for an elementary mark of a specific symbolic code (alphabet).

**Example:** The class of letter "A" is the symbol as idea and the letter A that you see on the screen is the mark.

**Comment:** Subclasses of 'Symbol' are alphabets, in formal languages terminology.

A 'Symbol' is atomic for that alphabet, i.e. it has no parts that are symbols for the same alphabet.
e.g. a math symbol is not made of other math symbols

A Symbol may be a String in another language.
e.g. "Bq" is the symbol for Becquerel units when dealing with metrology, or a string of "B" and "q" symbols when dealing with characters.

**Comment:** Symbols of a formal language need not be symbols of anything. For instance there are logical constants which do not refer to any idea, but rather serve as a form of punctuation in the language (e.g. parentheses). 

Symbols of a formal language must be capable of being specified without any reference to any interpretation of them. 
(Wikipedia)

**Comment:** The class is the idea of the symbol, while the individual of that class stands for a specific mark (or token) of that idea.

**Relations:** 

  - is_a [Symbolic](#symbolic)
  - [hasSymbolData](#hassymboldata) exactly 1 type
  - disjoint_with [Collection](#collection), [Equation](#equation), [PhysicsBasedModel](#physicsbasedmodel), [Quantity](#quantity), [PrefixedUnit](#prefixedunit), [Void](#void)



**Individuals:** 

  - [b](#b)
  - [a](#a)






### SpecialUnit
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_3ee80521_3c23_4dd1_935d_9d522614a3e2](http://emmo.info/emmo/middle/metrology#emmo_3ee80521_3c23_4dd1_935d_9d522614a3e2)

**Elucidation:** A unit symbol that stands for a derived unit.

**Example:** Pa stands for N/m2
J stands for N m

**Comment:** Special units are semiotic shortcuts to more complex composed symbolic objects.

**Relations:** 

  - is_a [DerivedUnit](#derivedunit)
  - is_a [UnitSymbol](#unitsymbol)
  - is_a [Sign](#sign)
  - Inverse([hasSign](#hassign)) some [DerivedUnit](#derivedunit)
  - disjoint_with [Collection](#collection), [Equation](#equation), [PhysicsBasedModel](#physicsbasedmodel), [BaseUnit](#baseunit), [Quantity](#quantity), [PrefixedUnit](#prefixedunit), [Void](#void)






### SIUnitSymbol
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_32129fb5_df25_48fd_a29c_18a2f22a2dd5](http://emmo.info/emmo/middle/siunits#emmo_32129fb5_df25_48fd_a29c_18a2f22a2dd5)

**Relations:** 

  - is_a [UnitSymbol](#unitsymbol)
  - is_a [SICoherentUnit](#sicoherentunit)
  - is_a [Object](#object)
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Exa](#exa), [Kilo](#kilo), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)
  - disjoint_union_of [SIBaseUnit](#sibaseunit), [SISpecialUnit](#sispecialunit)






## Mathematical branch
![Mathematical branch.](genfigs/MathematicalT.pdf){ width=668px }


### Constant
**IRI:** [http://emmo.info/emmo/middle/math#EMMO_ae15fb4f_8e4d_41de_a0f9_3997f89ba6a2](http://emmo.info/emmo/middle/math#emmo_ae15fb4f_8e4d_41de_a0f9_3997f89ba6a2)

**Elucidation:** A 'varaible' that stand for a well known constant.

**Example:** $\uppi$ refers to the constant number ~3.14

**Relations:** 

  - is_a [Variable](#variable)
  - Inverse([hasVariable](#hasvariable)) only [Numerical](#numerical)
  - disjoint_with [Collection](#collection), [Void](#void)






### Vector
**IRI:** [http://emmo.info/emmo/middle/math#EMMO_06658d8d_dcde_4fc9_aae1_17f71c0bcdec](http://emmo.info/emmo/middle/math#emmo_06658d8d_dcde_4fc9_aae1_17f71c0bcdec)

**Relations:** 

  - is_a [Array](#array)
  - disjoint_with [Collection](#collection), [Void](#void)






### Unknown
**IRI:** [http://emmo.info/emmo/middle/math#EMMO_fe7e56ce_118b_4243_9aad_20eb9f4f31f6](http://emmo.info/emmo/middle/math#emmo_fe7e56ce_118b_4243_9aad_20eb9f4f31f6)

**Elucidation:** The dependent variable for which an equation has been written.

**Example:** Velocity, for the Navier-Stokes equation.

**Relations:** 

  - is_a [Variable](#variable)
  - disjoint_with [Collection](#collection), [Void](#void)






### Array
**IRI:** [http://emmo.info/emmo/top/math#EMMO_28fbea28_2204_4613_87ff_6d877b855fcd](http://emmo.info/emmo/top/math#emmo_28fbea28_2204_4613_87ff_6d877b855fcd)

**Relations:** 

  - is_a [Mathematical](#mathematical)
  - disjoint_with [Collection](#collection), [Void](#void)






### Parameter
**IRI:** [http://emmo.info/emmo/middle/math#EMMO_d1d436e7_72fc_49cd_863b_7bfb4ba5276a](http://emmo.info/emmo/middle/math#emmo_d1d436e7_72fc_49cd_863b_7bfb4ba5276a)

**Example:** viscosity in the Navier-Stokes equation

**Comment:** A 'variable' whose value is assumed to be known independently from the equation, but whose value is not explicitated in the equation.

**Relations:** 

  - is_a [Variable](#variable)
  - disjoint_with [Collection](#collection), [Void](#void)






### Mathematical
**IRI:** [http://emmo.info/emmo/middle/math#EMMO_54ee6b5e_5261_44a8_86eb_5717e7fdb9d0](http://emmo.info/emmo/middle/math#emmo_54ee6b5e_5261_44a8_86eb_5717e7fdb9d0)

**Elucidation:** The class of general mathematical symbolic objects respecting mathematical syntactic rules.

**Relations:** 

  - is_a [Language](#language)
  - disjoint_with [Collection](#collection), [Void](#void)






### Numerical
**IRI:** [http://emmo.info/emmo/middle/math#EMMO_4ce76d7f_03f8_45b6_9003_90052a79bfaa](http://emmo.info/emmo/middle/math#emmo_4ce76d7f_03f8_45b6_9003_90052a79bfaa)

**Elucidation:** A 'Mathematical' that has no unknown value, i.e. all its 'Variable"-s parts refers to a 'Number' (for scalars that have a built-in datatype) or to another 'Numerical' (for complex numerical data structures that should rely on external implementations).

**Relations:** 

  - is_a [Mathematical](#mathematical)
  - disjoint_with [Collection](#collection), [Void](#void)






### Matrix
**IRI:** [http://emmo.info/emmo/top/math#EMMO_1cba0b27_15d0_4326_933f_379d0b3565b6](http://emmo.info/emmo/top/math#emmo_1cba0b27_15d0_4326_933f_379d0b3565b6)

**Relations:** 

  - is_a [Array](#array)
  - disjoint_with [Collection](#collection), [Void](#void)






### Variable
**IRI:** [http://emmo.info/emmo/middle/math#EMMO_1eed0732_e3f1_4b2c_a9c4_b4e75eeb5895](http://emmo.info/emmo/middle/math#emmo_1eed0732_e3f1_4b2c_a9c4_b4e75eeb5895)

**Elucidation:** A 'Variable' is a symbolic object that stands for a numerical defined 'Mathematical' object like e.g. a number, a vector, a matrix.

**Example:** x
k

**Relations:** 

  - is_a [Mathematical](#mathematical)
  - is_a [Conventional](#conventional)
  - Inverse([hasVariable](#hasvariable)) some [Mathematical](#mathematical)
  - disjoint_with [Collection](#collection), [Void](#void)






## Mathematical Symbol branch
![Mathematical Symbol branch.](genfigs/MathematicalSymbolT.pdf){ width=668px }


### Equals
**IRI:** [http://emmo.info/emmo/top/math#EMMO_535d75a4_1972_40bc_88c6_ca566386934f](http://emmo.info/emmo/top/math#emmo_535d75a4_1972_40bc_88c6_ca566386934f)

**Elucidation:** The equals symbol.

**Relations:** 

  - is_a [MathematicalSymbol](#mathematicalsymbol)
  - is_a [Mathematical](#mathematical)
  - is_a [Symbol](#symbol)
  - equivalent_to [hasSymbolData](#hassymboldata) value "="
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### MathematicalSymbol
**IRI:** [http://emmo.info/emmo/middle/math#EMMO_5be83f9c_a4ba_4b9a_be1a_5bfc6e891231](http://emmo.info/emmo/middle/math#emmo_5be83f9c_a4ba_4b9a_be1a_5bfc6e891231)

**Relations:** 

  - is_a [Mathematical](#mathematical)
  - is_a [Symbol](#symbol)
  - [hasProperPart](#hasproperpart) only not [Mathematical](#mathematical)
  - equivalent_to [Mathematical](#mathematical) and [Symbol](#symbol)
  - disjoint_with [Collection](#collection), [Equation](#equation), [PhysicsBasedModel](#physicsbasedmodel), [Quantity](#quantity), [PrefixedUnit](#prefixedunit), [Void](#void)






## Mathematical Model branch
![Mathematical Model branch.](genfigs/MathematicalModelT.pdf){ width=668px }


### AtomisticModel
**IRI:** [http://emmo.info/emmo/middle/models#EMMO_84cadc45_6758_46f2_ba2a_5ead65c70213](http://emmo.info/emmo/middle/models#emmo_84cadc45_6758_46f2_ba2a_5ead65c70213)

**Elucidation:** A physics-based model based on a physics equation describing the behaviour of atoms.

**Relations:** 

  - is_a [PhysicsBasedModel](#physicsbasedmodel)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### DataBasedModel
**IRI:** [http://emmo.info/emmo/middle/models#EMMO_a4b14b83_9392_4a5f_a2e8_b2b58793f59b](http://emmo.info/emmo/middle/models#emmo_a4b14b83_9392_4a5f_a2e8_b2b58793f59b)

**Elucidation:** A computational model that uses data to create new insight into the behaviour of a system.

**Relations:** 

  - is_a [MathematicalModel](#mathematicalmodel)
  - disjoint_with [Collection](#collection), [Void](#void)






### PhysicsBasedModel
**IRI:** [http://emmo.info/emmo/middle/models#EMMO_b29fd350_39aa_4af7_9459_3faa0544cba6](http://emmo.info/emmo/middle/models#emmo_b29fd350_39aa_4af7_9459_3faa0544cba6)

**Elucidation:** A solvable set of one Physics Equation and one or more Materials Relations.

**Relations:** 

  - is_a [MathematicalModel](#mathematicalmodel)
  - [hasSpatialPart](#hasspatialpart) some [PhysicsEquation](#physicsequation)
  - [hasSpatialPart](#hasspatialpart) some [MaterialRelation](#materialrelation)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### ElectronicModel
**IRI:** [http://emmo.info/emmo/middle/models#EMMO_6eca09be_17e9_445e_abc9_000aa61b7a11](http://emmo.info/emmo/middle/models#emmo_6eca09be_17e9_445e_abc9_000aa61b7a11)

**Elucidation:** A physics-based model based on a physics equation describing the behaviour of electrons.

**Example:** Density functional theory.
Hartree-Fock.

**Relations:** 

  - is_a [PhysicsBasedModel](#physicsbasedmodel)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### PhysicsEquation
**IRI:** [http://emmo.info/emmo/middle/models#EMMO_27c5d8c6_8af7_4d63_beb1_ec37cd8b3fa3](http://emmo.info/emmo/middle/models#emmo_27c5d8c6_8af7_4d63_beb1_ec37cd8b3fa3)

**Elucidation:** An 'equation' that stands for a 'physical_law' by mathematically defining the relations between physics_quantities.

**Comment:** The Newton's equation of motion.

The Schrodinger equation.

The Navier-Stokes equation.

**Relations:** 

  - is_a [Equation](#equation)
  - is_a [MathematicalModel](#mathematicalmodel)
  - [hasSpatialDirectPart](#hasspatialdirectpart) some [PhysicalQuantity](#physicalquantity)
  - Inverse([hasModel](#hasmodel)) some [PhysicalPhenomenon](#physicalphenomenon)
  - disjoint_with [Symbol](#symbol), [Collection](#collection), [Quantum](#quantum), [String](#string), [PrefixedUnit](#prefixedunit), [Void](#void), [Elementary](#elementary)






### MesoscopicModel
**IRI:** [http://emmo.info/emmo/middle/models#EMMO_53935db0_af45_4426_b9e9_244a0d77db00](http://emmo.info/emmo/middle/models#emmo_53935db0_af45_4426_b9e9_244a0d77db00)

**Elucidation:** A physics-based model based on a physics equation describing the behaviour of mesoscopic entities, i.e. a set of bounded atoms like a molecule, bead or nanoparticle.

**Relations:** 

  - is_a [PhysicsBasedModel](#physicsbasedmodel)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### MathematicalModel
**IRI:** [http://emmo.info/emmo/middle/models#EMMO_f7ed665b_c2e1_42bc_889b_6b42ed3a36f0](http://emmo.info/emmo/middle/models#emmo_f7ed665b_c2e1_42bc_889b_6b42ed3a36f0)

**Comment:** A mathematical model can be defined as a description of a system using mathematical concepts and language to facilitate proper explanation of a system or to study the effects of different components and to make predictions on patterns of behaviour. 

Abramowitz and Stegun, 1968

**Relations:** 

  - is_a [Mathematical](#mathematical)
  - is_a [Model](#model)
  - equivalent_to [Mathematical](#mathematical) and [Model](#model)
  - disjoint_with [Collection](#collection), [Void](#void)






### ContinuumModel
**IRI:** [http://emmo.info/emmo/middle/models#EMMO_4456a5d2_16a6_4ee1_9a8e_5c75956b28ea](http://emmo.info/emmo/middle/models#emmo_4456a5d2_16a6_4ee1_9a8e_5c75956b28ea)

**Elucidation:** A physics-based model based on a physics equation describing the behaviour of continuum volume.

**Relations:** 

  - is_a [PhysicsBasedModel](#physicsbasedmodel)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






## Mathematical Operator branch
![Mathematical Operator branch.](genfigs/MathematicalOperatorT.pdf){ width=668px }


### Laplacian
**IRI:** [http://emmo.info/emmo/top/math#EMMO_048a14e3_65fb_457d_8695_948965c89492](http://emmo.info/emmo/top/math#emmo_048a14e3_65fb_457d_8695_948965c89492)

**Relations:** 

  - is_a [DifferentialOperator](#differentialoperator)
  - equivalent_to [hasSymbolData](#hassymboldata) value "Δ"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### Exponent
**IRI:** [http://emmo.info/emmo/top/math#EMMO_223d9523_4169_4ecd_b8af_acad1215e1ff](http://emmo.info/emmo/top/math#emmo_223d9523_4169_4ecd_b8af_acad1215e1ff)

**Relations:** 

  - is_a [AlgebricOperator](#algebricoperator)
  - disjoint_with [Collection](#collection), [Equation](#equation), [PhysicsBasedModel](#physicsbasedmodel), [Quantity](#quantity), [PrefixedUnit](#prefixedunit), [Void](#void)






### DifferentialOperator
**IRI:** [http://emmo.info/emmo/top/math#EMMO_f8a2fe9f_458b_4771_9aba_a50e76afc52d](http://emmo.info/emmo/top/math#emmo_f8a2fe9f_458b_4771_9aba_a50e76afc52d)

**Relations:** 

  - is_a [MathematicalOperator](#mathematicaloperator)
  - disjoint_with [Collection](#collection), [Equation](#equation), [PhysicsBasedModel](#physicsbasedmodel), [Quantity](#quantity), [PrefixedUnit](#prefixedunit), [Void](#void)






### Minus
**IRI:** [http://emmo.info/emmo/top/math#EMMO_46d5643b_9706_4b67_8bea_ed77d6026539](http://emmo.info/emmo/top/math#emmo_46d5643b_9706_4b67_8bea_ed77d6026539)

**Relations:** 

  - is_a [ArithmeticOperator](#arithmeticoperator)
  - equivalent_to [hasSymbolData](#hassymboldata) value "-"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### MathematicalOperator
**IRI:** [http://emmo.info/emmo/top/math#EMMO_f6d0c26a_98b6_4cf8_8632_aa259131faaa](http://emmo.info/emmo/top/math#emmo_f6d0c26a_98b6_4cf8_8632_aa259131faaa)

**Relations:** 

  - is_a [MathematicalSymbol](#mathematicalsymbol)
  - is_a [Mathematical](#mathematical)
  - is_a [Symbol](#symbol)
  - disjoint_with [Collection](#collection), [Equation](#equation), [PhysicsBasedModel](#physicsbasedmodel), [Quantity](#quantity), [PrefixedUnit](#prefixedunit), [Void](#void)






### Multiplication
**IRI:** [http://emmo.info/emmo/top/math#EMMO_2b1303e8_d4c3_453b_9918_76f1d009543f](http://emmo.info/emmo/top/math#emmo_2b1303e8_d4c3_453b_9918_76f1d009543f)

**Relations:** 

  - is_a [ArithmeticOperator](#arithmeticoperator)
  - equivalent_to [hasSymbolData](#hassymboldata) value "*"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### Division
**IRI:** [http://emmo.info/emmo/top/math#EMMO_a365b3c1_7bde_41d7_a15b_2820762e85f4](http://emmo.info/emmo/top/math#emmo_a365b3c1_7bde_41d7_a15b_2820762e85f4)

**Relations:** 

  - is_a [ArithmeticOperator](#arithmeticoperator)
  - equivalent_to [hasSymbolData](#hassymboldata) value "/"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### Gradient
**IRI:** [http://emmo.info/emmo/top/math#EMMO_b5c58790_fb2d_42eb_b184_2a3f6ca60acb](http://emmo.info/emmo/top/math#emmo_b5c58790_fb2d_42eb_b184_2a3f6ca60acb)

**Relations:** 

  - is_a [DifferentialOperator](#differentialoperator)
  - equivalent_to [hasSymbolData](#hassymboldata) value "∇"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### ArithmeticOperator
**IRI:** [http://emmo.info/emmo/middle/math#EMMO_707f0cd1_941c_4b57_9f20_d0ba30cd6ff3](http://emmo.info/emmo/middle/math#emmo_707f0cd1_941c_4b57_9f20_d0ba30cd6ff3)

**Relations:** 

  - is_a [AlgebricOperator](#algebricoperator)
  - disjoint_with [Collection](#collection), [Equation](#equation), [PhysicsBasedModel](#physicsbasedmodel), [Quantity](#quantity), [PrefixedUnit](#prefixedunit), [Void](#void)






### AlgebricOperator
**IRI:** [http://emmo.info/emmo/top/math#EMMO_3c424d37_cf62_41b1_ac9d_a316f8d113d6](http://emmo.info/emmo/top/math#emmo_3c424d37_cf62_41b1_ac9d_a316f8d113d6)

**Relations:** 

  - is_a [MathematicalOperator](#mathematicaloperator)
  - disjoint_with [Collection](#collection), [Equation](#equation), [PhysicsBasedModel](#physicsbasedmodel), [Quantity](#quantity), [PrefixedUnit](#prefixedunit), [Void](#void)






### Plus
**IRI:** [http://emmo.info/emmo/top/math#EMMO_8de14a59_660b_454f_aff8_76a07ce185f4](http://emmo.info/emmo/top/math#emmo_8de14a59_660b_454f_aff8_76a07ce185f4)

**Relations:** 

  - is_a [ArithmeticOperator](#arithmeticoperator)
  - equivalent_to [hasSymbolData](#hassymboldata) value "+"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






## Metrological branch
![Metrological branch.](genfigs/MetrologicalT.pdf){ width=668px }


### UnitSymbol
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_216f448e_cdbc_4aeb_a529_7a5fe7fc38bb](http://emmo.info/emmo/middle/metrology#emmo_216f448e_cdbc_4aeb_a529_7a5fe7fc38bb)

**Elucidation:** A symbol that stands for a single unit.

**Example:** Some examples are "Pa", "m" and "J".

**Relations:** 

  - is_a [MetrologicalSymbol](#metrologicalsymbol)
  - is_a [NonPrefixedUnit](#nonprefixedunit)
  - equivalent_to [MeasurementUnit](#measurementunit) and [Symbol](#symbol)
  - disjoint_with [Collection](#collection), [Equation](#equation), [PhysicsBasedModel](#physicsbasedmodel), [Quantity](#quantity), [PrefixedUnit](#prefixedunit), [Void](#void)
  - disjoint_union_of [SpecialUnit](#specialunit), [BaseUnit](#baseunit)






### ProcedureUnit
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_c9c8f824_9127_4f93_bc21_69fe78a7f6f2](http://emmo.info/emmo/middle/metrology#emmo_c9c8f824_9127_4f93_bc21_69fe78a7f6f2)

**Elucidation:** A reference unit provided by a measurement procedure.

**Example:** Rockwell C hardness of a given sample (150 kg load): 43.5HRC(150 kg)

**Relations:** 

  - is_a [ReferenceUnit](#referenceunit)
  - disjoint_with [Collection](#collection), [Void](#void)






### StandardUnit
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_acd1a504_ca32_4f30_86ad_0b62cea5bc02](http://emmo.info/emmo/middle/metrology#emmo_acd1a504_ca32_4f30_86ad_0b62cea5bc02)

**Elucidation:** A reference unit provided by a reference material.
International vocabulary of metrology (VIM)

**Example:** Arbitrary amount-of-substance concentration of lutropin in a given sample of plasma (WHO international standard 80/552): 5.0 International Unit/l

**Relations:** 

  - is_a [ReferenceUnit](#referenceunit)
  - disjoint_with [Collection](#collection), [Void](#void)






### SIUnitSymbol
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_32129fb5_df25_48fd_a29c_18a2f22a2dd5](http://emmo.info/emmo/middle/siunits#emmo_32129fb5_df25_48fd_a29c_18a2f22a2dd5)

**Relations:** 

  - is_a [UnitSymbol](#unitsymbol)
  - is_a [SICoherentUnit](#sicoherentunit)
  - is_a [Object](#object)
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Exa](#exa), [Kilo](#kilo), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)
  - disjoint_union_of [SIBaseUnit](#sibaseunit), [SISpecialUnit](#sispecialunit)






### BaseUnit
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_db716151_6b73_45ff_910c_d182fdcbb4f5](http://emmo.info/emmo/middle/metrology#emmo_db716151_6b73_45ff_910c_d182fdcbb4f5)

**Elucidation:** A set of units that correspond to the base quantities in a system of units.

**Relations:** 

  - is_a [UnitSymbol](#unitsymbol)
  - disjoint_with [Collection](#collection), [Equation](#equation), [PhysicsBasedModel](#physicsbasedmodel), [Quantity](#quantity), [PrefixedUnit](#prefixedunit), [Void](#void), [SpecialUnit](#specialunit)






### UnitOne
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_5ebd5e01_0ed3_49a2_a30d_cd05cbe72978](http://emmo.info/emmo/middle/metrology#emmo_5ebd5e01_0ed3_49a2_a30d_cd05cbe72978)

**Elucidation:** Represents the number 1, used as an explicit unit to say something has no units.

**Example:** Refractive index or volume fraction.

**Example:** Typically used for ratios of two units whos dimensions cancels out.

**Qudtmatch:** [http://qudt.org/vocab/unit/UNITLESS](http://qudt.org/vocab/unit/unitless)

**Relations:** 

  - is_a [BaseUnit](#baseunit)
  - disjoint_with [Collection](#collection), [Equation](#equation), [PhysicsBasedModel](#physicsbasedmodel), [Quantity](#quantity), [PrefixedUnit](#prefixedunit), [Void](#void), [SpecialUnit](#specialunit)






### MetrologicalSymbol
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_50a3552e_859a_4ff7_946d_76d537cabce6](http://emmo.info/emmo/middle/metrology#emmo_50a3552e_859a_4ff7_946d_76d537cabce6)

**Elucidation:** A symbol that stands for a concept in the language of the meterological domain of ISO 80000.

**Relations:** 

  - is_a [Metrological](#metrological)
  - is_a [Symbol](#symbol)
  - [hasProperPart](#hasproperpart) only not [Metrological](#metrological)
  - equivalent_to [Metrological](#metrological) and [Symbol](#symbol)
  - disjoint_with [Collection](#collection), [Equation](#equation), [PhysicsBasedModel](#physicsbasedmodel), [Quantity](#quantity), [PrefixedUnit](#prefixedunit), [Void](#void)






### Metrological
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_985bec21_989f_4b9e_a4b3_735d88099c3c](http://emmo.info/emmo/middle/metrology#emmo_985bec21_989f_4b9e_a4b3_735d88099c3c)

**Elucidation:** A symbolic object used in metrology.

**Comment:** This language domain makes use of ISO 80000 concepts.

**Relations:** 

  - is_a [Language](#language)
  - disjoint_with [Collection](#collection), [Void](#void)






### ReferenceUnit
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_18ce5200_00f5_45bb_8c6f_6fb128cd41ae](http://emmo.info/emmo/middle/metrology#emmo_18ce5200_00f5_45bb_8c6f_6fb128cd41ae)

**Comment:** A reference can be a measurement unit, a measurement procedure, a reference material, or a combination of such.
International vocabulary of metrology (VIM)

**Comment:** A symbolic is recognized as reference unit also if it is not part of a quatity (e.g. as in the sentence "the Bq is the reference unit of Becquerel").

For this reason we can't declare the axiom:
ReferenceUnit SubClassOf: inverse(hasReferenceUnit) some Quantity
because there exist reference units without being part of a quantity.

This is peculiar to EMMO, where quantities (symbolic) are distinct with properties (semiotics).

**Relations:** 

  - is_a [Metrological](#metrological)
  - disjoint_with [Collection](#collection), [Void](#void)






### SpecialUnit
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_3ee80521_3c23_4dd1_935d_9d522614a3e2](http://emmo.info/emmo/middle/metrology#emmo_3ee80521_3c23_4dd1_935d_9d522614a3e2)

**Elucidation:** A unit symbol that stands for a derived unit.

**Example:** Pa stands for N/m2
J stands for N m

**Comment:** Special units are semiotic shortcuts to more complex composed symbolic objects.

**Relations:** 

  - is_a [DerivedUnit](#derivedunit)
  - is_a [UnitSymbol](#unitsymbol)
  - is_a [Sign](#sign)
  - Inverse([hasSign](#hassign)) some [DerivedUnit](#derivedunit)
  - disjoint_with [Collection](#collection), [Equation](#equation), [PhysicsBasedModel](#physicsbasedmodel), [BaseUnit](#baseunit), [Quantity](#quantity), [PrefixedUnit](#prefixedunit), [Void](#void)






## Physics Dimension branch
![Physics Dimension branch.](genfigs/PhysicsDimensionT.pdf){ width=668px }


### MassSquareLengthPerSquareTimeCurrentDimension
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_4c49ab58_a6f6_409e_b849_f873ae1dcbee](http://emmo.info/emmo/middle/isq#emmo_4c49ab58_a6f6_409e_b849_f873ae1dcbee)

**Relations:** 

  - is_a [PhysicsDimension](#physicsdimension)
  - equivalent_to [hasSymbolData](#hassymboldata) value "T-2 L+2 M+1 I-1 Θ0 N0 J0"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [AmountPerTimeDimension](#amountpertimedimension), [Division](#division), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### TimeCurrentDimension
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_ab79e92b_5377_454d_be06_d61b50db295a](http://emmo.info/emmo/middle/isq#emmo_ab79e92b_5377_454d_be06_d61b50db295a)

**Relations:** 

  - is_a [PhysicsDimension](#physicsdimension)
  - equivalent_to [hasSymbolData](#hassymboldata) value "T+1 L0 M0 I+1 Θ0 N0 J0"
  - disjoint_with [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [GreekSmallLetterMu](#greeksmalllettermu), [LengthPerTimeDimension](#lengthpertimedimension), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [AmountPerTimeDimension](#amountpertimedimension), [Division](#division), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### QuarticTimeSquareCurrentPerMassSquareLengthDimension
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_b14d9be5_f81e_469b_abca_379c2e83feab](http://emmo.info/emmo/middle/isq#emmo_b14d9be5_f81e_469b_abca_379c2e83feab)

**Relations:** 

  - is_a [PhysicsDimension](#physicsdimension)
  - equivalent_to [hasSymbolData](#hassymboldata) value "T+4 L-2 M-1 I+2 Θ0 N0 J0"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [GreekSmallLetterMu](#greeksmalllettermu), [LengthPerTimeDimension](#lengthpertimedimension), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [AmountPerTimeDimension](#amountpertimedimension), [Division](#division), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [LengthDimension](#lengthdimension)






### MassSquareLengthPerTemperatureSquareTimeDimension
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_3ecff38b_b3cf_4a78_b49f_8580abf8715b](http://emmo.info/emmo/middle/isq#emmo_3ecff38b_b3cf_4a78_b49f_8580abf8715b)

**Relations:** 

  - is_a [PhysicsDimension](#physicsdimension)
  - equivalent_to [hasSymbolData](#hassymboldata) value "T-2 L+2 M+1 I0 Θ-1 N0 J0"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [AmountPerTimeDimension](#amountpertimedimension), [Division](#division), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### LuminousIntensityPerSquareLengthDimension
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_668e6ead_1530_40cc_ad5e_24b880edff50](http://emmo.info/emmo/middle/isq#emmo_668e6ead_1530_40cc_ad5e_24b880edff50)

**Relations:** 

  - is_a [PhysicsDimension](#physicsdimension)
  - equivalent_to [hasSymbolData](#hassymboldata) value "T0 L-2 M0 I0 Θ0 N0 J+1"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [GreekSmallLetterMu](#greeksmalllettermu), [LengthPerTimeDimension](#lengthpertimedimension), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [AmountPerTimeDimension](#amountpertimedimension), [Division](#division), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### TemperatureDimension
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_a77a0a4b_6bd2_42b2_be27_4b63cebbb59e](http://emmo.info/emmo/middle/isq#emmo_a77a0a4b_6bd2_42b2_be27_4b63cebbb59e)

**Relations:** 

  - is_a [PhysicsDimension](#physicsdimension)
  - equivalent_to [hasSymbolData](#hassymboldata) value "T0 L0 M0 I0 Θ+1 N0 J0"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [GreekSmallLetterMu](#greeksmalllettermu), [LengthPerTimeDimension](#lengthpertimedimension), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [AmountPerTimeDimension](#amountpertimedimension), [Division](#division), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### AmountDimension
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_e501069c_34d3_4dc7_ac87_c90c7342192b](http://emmo.info/emmo/middle/isq#emmo_e501069c_34d3_4dc7_ac87_c90c7342192b)

**Relations:** 

  - is_a [PhysicsDimension](#physicsdimension)
  - equivalent_to [hasSymbolData](#hassymboldata) value "T0 L0 M0 I0 Θ0 N+1 J0"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [GreekSmallLetterMu](#greeksmalllettermu), [LengthPerTimeDimension](#lengthpertimedimension), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### MassSquareLengthPerSquareTimeDimension
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_f6070071_d054_4b17_9d2d_f446f7147d0f](http://emmo.info/emmo/middle/isq#emmo_f6070071_d054_4b17_9d2d_f446f7147d0f)

**Relations:** 

  - is_a [PhysicsDimension](#physicsdimension)
  - equivalent_to [hasSymbolData](#hassymboldata) value "T-2 L+2 M+1 I0 Θ0 N0 J0"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [GreekSmallLetterMu](#greeksmalllettermu), [LengthPerTimeDimension](#lengthpertimedimension), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### LuminousIntensityCubicTimePerMassLengthDimension
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_5c003f53_20a2_4bd7_8445_58187e582578](http://emmo.info/emmo/middle/isq#emmo_5c003f53_20a2_4bd7_8445_58187e582578)

**Relations:** 

  - is_a [PhysicsDimension](#physicsdimension)
  - equivalent_to [hasSymbolData](#hassymboldata) value "T+3 L-1 M-1 I0 Θ0 N0 J+1"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [GreekSmallLetterMu](#greeksmalllettermu), [LengthPerTimeDimension](#lengthpertimedimension), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [AmountPerTimeDimension](#amountpertimedimension), [Division](#division), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### PhysicsDimension
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_9895a1b4_f0a5_4167_ac5e_97db40b8bfcc](http://emmo.info/emmo/middle/metrology#emmo_9895a1b4_f0a5_4167_ac5e_97db40b8bfcc)

**Elucidation:** A symbol that, following SI specifications, describe the physical dimensionality of a physical quantity and the exponents of the base units in a measurement unit.

**Comment:** All physical quantities, with the exception of counts, are derived quantities, which may be written in terms of base quantities according to the equations of physics. The dimensions of the derived quantities are written as products of powers of the dimensions of the base quantities using the equations that relate the derived quantities to the base quantities.
In general the dimension of any quantity Q is written in the form of a dimensional product,

dim Q = T^$\upalpha$ L^$\upbeta$ M^$\upgamma$ I^$\updelta$ $\Uptheta$^$\upepsilon$ N^$\upzeta$ J^$\upeta$

where the exponents $\upalpha$, $\upbeta$, $\upgamma$, $\updelta$, $\upepsilon$, $\upzeta$ and $\upeta$, which are generally small integers, which can be positive, negative, or zero, are called the dimensional exponents.
(SI brochure)

**Comment:** The conventional symbolic representation of the dimension of a base quantity is a single upper case letter in roman (upright) type. The conventional symbolic representation of the dimension of a derived quantity is the product of powers of the dimensions of the base quantities according to the definition of the derived quantity. The dimension of a quantity Q is denoted by dim Q.
ISO 80000-1

**Comment:** The expression used by the EMMO for physical dimensions is a metrological symbol (but a string at meta level, i.e. the ontologist level) like this:
 
Ta Lb Mc Id $\Uptheta$e Nf Jg

where a, b, c, d, e, f and g are 0 or signed integers.

Regex for the physical dimension symbol for the EMMO is:
^T([+-][1-9]|0) L([+-][1-9]|0) M([+-][1-9]|0) I([+-][1-9]|0) $\Uptheta$([+-][1-9]|0) N([+-][1-9]|0) J([+-][1-9]|0)$

Examples of correspondance between base units and physical dimensions are:
mol -> T0 L0 M0 I0 $\Uptheta$0 N+1 J0
s -> T+1 L0 M0 I0 $\Uptheta$0 N0 J0
A/m2 -> T0 L0 M-2 I+1 $\Uptheta$0 N0 J0

**Relations:** 

  - is_a [MetrologicalSymbol](#metrologicalsymbol)
  - is_a [Metrological](#metrological)
  - is_a [Symbol](#symbol)
  - disjoint_with [Collection](#collection), [Equation](#equation), [PhysicsBasedModel](#physicsbasedmodel), [Quantity](#quantity), [PrefixedUnit](#prefixedunit), [Void](#void)






### AmountPerTimeDimension
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_ce7d4720_aa20_4a8c_93e8_df41a35b6723](http://emmo.info/emmo/middle/isq#emmo_ce7d4720_aa20_4a8c_93e8_df41a35b6723)

**Relations:** 

  - is_a [PhysicsDimension](#physicsdimension)
  - equivalent_to [hasSymbolData](#hassymboldata) value "T-1 L0 M0 I0 Θ0 N+1 J0"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [GreekSmallLetterMu](#greeksmalllettermu), [LengthPerTimeDimension](#lengthpertimedimension), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### ElectricCurrentDimension
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_d5f3e0e5_fc7d_4e64_86ad_555e74aaff84](http://emmo.info/emmo/middle/isq#emmo_d5f3e0e5_fc7d_4e64_86ad_555e74aaff84)

**Relations:** 

  - is_a [PhysicsDimension](#physicsdimension)
  - equivalent_to [hasSymbolData](#hassymboldata) value "T0 L0 M0 I+1 Θ0 N0 J0"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [GreekSmallLetterMu](#greeksmalllettermu), [LengthPerTimeDimension](#lengthpertimedimension), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### DimensionOne
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_3227b821_26a5_4c7c_9c01_5c24483e0bd0](http://emmo.info/emmo/middle/isq#emmo_3227b821_26a5_4c7c_9c01_5c24483e0bd0)

**Relations:** 

  - is_a [PhysicsDimension](#physicsdimension)
  - equivalent_to [hasSymbolData](#hassymboldata) value "T0 L0 M0 I0 Θ0 N0 J0"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [AmountPerTimeDimension](#amountpertimedimension), [Division](#division), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### CubicTimeSquareCurrentPerMassSquareLengthDimension
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_321af35f_f0cc_4a5c_b4fe_8c2c0303fb0c](http://emmo.info/emmo/middle/isq#emmo_321af35f_f0cc_4a5c_b4fe_8c2c0303fb0c)

**Relations:** 

  - is_a [PhysicsDimension](#physicsdimension)
  - equivalent_to [hasSymbolData](#hassymboldata) value "T+3 L-2 M-1 I+2 Θ0 N0 J0"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [AmountPerTimeDimension](#amountpertimedimension), [Division](#division), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### TimeDimension
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_02e894c3_b793_4197_b120_3442e08f58d1](http://emmo.info/emmo/middle/isq#emmo_02e894c3_b793_4197_b120_3442e08f58d1)

**Relations:** 

  - is_a [PhysicsDimension](#physicsdimension)
  - equivalent_to [hasSymbolData](#hassymboldata) value "T+1 L0 M0 I0 Θ0 N0 J0"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [AmountPerTimeDimension](#amountpertimedimension), [Division](#division), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### MassPerSquareTimeCurrentDimension
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_ec903946_ddc9_464a_903c_7373e0d1eeb5](http://emmo.info/emmo/middle/isq#emmo_ec903946_ddc9_464a_903c_7373e0d1eeb5)

**Relations:** 

  - is_a [PhysicsDimension](#physicsdimension)
  - equivalent_to [hasSymbolData](#hassymboldata) value "T-2 L0 M+1 I-1 Θ0 N0 J0"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [GreekSmallLetterMu](#greeksmalllettermu), [LengthPerTimeDimension](#lengthpertimedimension), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### LuminousIntensityDimension
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_14ff4393_0f28_4fb4_abc7_c2cc00bc761d](http://emmo.info/emmo/middle/isq#emmo_14ff4393_0f28_4fb4_abc7_c2cc00bc761d)

**Relations:** 

  - is_a [PhysicsDimension](#physicsdimension)
  - equivalent_to [hasSymbolData](#hassymboldata) value "T0 L0 M0 I0 Θ0 N0 J+1"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [AmountPerTimeDimension](#amountpertimedimension), [Division](#division), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### MassSquareLengthPerCubicTimeCurrentDimension
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_2e7e5796_4a80_4d73_bb84_f31138446c0c](http://emmo.info/emmo/middle/isq#emmo_2e7e5796_4a80_4d73_bb84_f31138446c0c)

**Relations:** 

  - is_a [PhysicsDimension](#physicsdimension)
  - equivalent_to [hasSymbolData](#hassymboldata) value "T-3 L+2 M+1 I-1 Θ0 N0 J0"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [AmountPerTimeDimension](#amountpertimedimension), [Division](#division), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### MassSquareLengthPerSquareTimeSquareCurrentDimension
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_585e0ff0_9429_4d3c_b578_58abb1ba21d1](http://emmo.info/emmo/middle/isq#emmo_585e0ff0_9429_4d3c_b578_58abb1ba21d1)

**Relations:** 

  - is_a [PhysicsDimension](#physicsdimension)
  - equivalent_to [hasSymbolData](#hassymboldata) value "T-2 L+2 M+1 I-2 Θ0 N0 J0"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [GreekSmallLetterMu](#greeksmalllettermu), [LengthPerTimeDimension](#lengthpertimedimension), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [AmountPerTimeDimension](#amountpertimedimension), [Division](#division), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### SquareLengthPerSquareTimeDimension
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_847f1d9f_205e_46c1_8cb6_a9e479421f88](http://emmo.info/emmo/middle/isq#emmo_847f1d9f_205e_46c1_8cb6_a9e479421f88)

**Relations:** 

  - is_a [PhysicsDimension](#physicsdimension)
  - equivalent_to [hasSymbolData](#hassymboldata) value "T-2 L+2 M0 I0 Θ0 N0 J0"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [GreekSmallLetterMu](#greeksmalllettermu), [LengthPerTimeDimension](#lengthpertimedimension), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [AmountPerTimeDimension](#amountpertimedimension), [Division](#division), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### MassLengthPerSquareTimeDimension
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_53e825d9_1a09_483c_baa7_37501ebfbe1c](http://emmo.info/emmo/middle/isq#emmo_53e825d9_1a09_483c_baa7_37501ebfbe1c)

**Relations:** 

  - is_a [PhysicsDimension](#physicsdimension)
  - equivalent_to [hasSymbolData](#hassymboldata) value "T-2 L+1 M+1 I0 Θ0 N0 J0"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [GreekSmallLetterMu](#greeksmalllettermu), [LengthPerTimeDimension](#lengthpertimedimension), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [AmountPerTimeDimension](#amountpertimedimension), [Division](#division), [DimensionOne](#dimensionone), [Plus](#plus), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### MassPerLengthSquareTimeDimension
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_53bd0c90_41c3_46e2_8779_cd2a80f7e18b](http://emmo.info/emmo/middle/isq#emmo_53bd0c90_41c3_46e2_8779_cd2a80f7e18b)

**Relations:** 

  - is_a [PhysicsDimension](#physicsdimension)
  - equivalent_to [hasSymbolData](#hassymboldata) value "T-2 L-1 M+1 I0 Θ0 N0 J0"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Minus](#minus), [MicroUnit](#microunit), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [GreekSmallLetterMu](#greeksmalllettermu), [LengthPerTimeDimension](#lengthpertimedimension), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [AmountPerTimeDimension](#amountpertimedimension), [Division](#division), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### MassSquareLengthPerCubicTimeDimension
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_c8d084ad_f88e_4596_8e4d_982c6655ce6f](http://emmo.info/emmo/middle/isq#emmo_c8d084ad_f88e_4596_8e4d_982c6655ce6f)

**Relations:** 

  - is_a [PhysicsDimension](#physicsdimension)
  - equivalent_to [hasSymbolData](#hassymboldata) value "T-3 L+2 M+1 I0 Θ0 N0 J0"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [GreekSmallLetterMu](#greeksmalllettermu), [LengthPerTimeDimension](#lengthpertimedimension), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [AmountPerTimeDimension](#amountpertimedimension), [Division](#division), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### MassSquareLengthPerTimeDimension
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_501f9b3a_c469_48f7_9281_2e6a8d805d7a](http://emmo.info/emmo/middle/isq#emmo_501f9b3a_c469_48f7_9281_2e6a8d805d7a)

**Relations:** 

  - is_a [PhysicsDimension](#physicsdimension)
  - equivalent_to [hasSymbolData](#hassymboldata) value "T-1 L+2 M+1 I0 Θ0 N0 J0"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [GreekSmallLetterMu](#greeksmalllettermu), [LengthPerTimeDimension](#lengthpertimedimension), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [AmountPerTimeDimension](#amountpertimedimension), [Division](#division), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### PerTimeDimension
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_515b5579_d526_4842_9e6f_ecc34db6f368](http://emmo.info/emmo/middle/isq#emmo_515b5579_d526_4842_9e6f_ecc34db6f368)

**Relations:** 

  - is_a [PhysicsDimension](#physicsdimension)
  - equivalent_to [hasSymbolData](#hassymboldata) value "T-1 L0 M0 I0 Θ0 N0 J0"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [GreekSmallLetterMu](#greeksmalllettermu), [LengthPerTimeDimension](#lengthpertimedimension), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [AmountPerTimeDimension](#amountpertimedimension), [Division](#division), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### LengthPerTimeDimension
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_4f5c7c54_1c63_4d17_b12b_ea0792c2b187](http://emmo.info/emmo/middle/isq#emmo_4f5c7c54_1c63_4d17_b12b_ea0792c2b187)

**Relations:** 

  - is_a [PhysicsDimension](#physicsdimension)
  - equivalent_to [hasSymbolData](#hassymboldata) value "T-1 L+1 M0 I0 Θ0 N0 J0"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [AmountPerTimeDimension](#amountpertimedimension), [Division](#division), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### MassDimension
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_77e9dc31_5b19_463e_b000_44c6e79f98aa](http://emmo.info/emmo/middle/isq#emmo_77e9dc31_5b19_463e_b000_44c6e79f98aa)

**Relations:** 

  - is_a [PhysicsDimension](#physicsdimension)
  - equivalent_to [hasSymbolData](#hassymboldata) value "T0 L0 M+1 I0 Θ0 N0 J0"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [GreekSmallLetterMu](#greeksmalllettermu), [LengthPerTimeDimension](#lengthpertimedimension), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [AmountPerTimeDimension](#amountpertimedimension), [Division](#division), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### PerAmountDimension
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_af24ae20_8ef2_435a_86a1_2ea44488b318](http://emmo.info/emmo/middle/isq#emmo_af24ae20_8ef2_435a_86a1_2ea44488b318)

**Relations:** 

  - is_a [PhysicsDimension](#physicsdimension)
  - equivalent_to [hasSymbolData](#hassymboldata) value "T0 L0 M0 I0 Θ0 N-1 J0"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [GreekSmallLetterMu](#greeksmalllettermu), [LengthPerTimeDimension](#lengthpertimedimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [AmountPerTimeDimension](#amountpertimedimension), [Division](#division), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### MassSquareLengthPerCubicTimeSquareCurrentDimension
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_7610efb8_c7c6_4684_abc1_774783c62472](http://emmo.info/emmo/middle/isq#emmo_7610efb8_c7c6_4684_abc1_774783c62472)

**Relations:** 

  - is_a [PhysicsDimension](#physicsdimension)
  - equivalent_to [hasSymbolData](#hassymboldata) value "T-3 L+2 M+1 I-2 Θ0 N0 J0"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [GreekSmallLetterMu](#greeksmalllettermu), [LengthPerTimeDimension](#lengthpertimedimension), [PerAmountDimension](#peramountdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [AmountPerTimeDimension](#amountpertimedimension), [Division](#division), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### LengthDimension
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_b3600e73_3e05_479d_9714_c041c3acf5cc](http://emmo.info/emmo/middle/isq#emmo_b3600e73_3e05_479d_9714_c041c3acf5cc)

**Relations:** 

  - is_a [PhysicsDimension](#physicsdimension)
  - equivalent_to [hasSymbolData](#hassymboldata) value "T0 L+1 M0 I0 Θ0 N0 J0"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [GreekSmallLetterMu](#greeksmalllettermu), [LengthPerTimeDimension](#lengthpertimedimension), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Equation](#equation), [Laplacian](#laplacian), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [AmountPerTimeDimension](#amountpertimedimension), [Division](#division), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension)






## Physical Quantity branch
![Physical Quantity branch.](genfigs/PhysicalQuantityT.pdf){ width=668px }


### CelsiusTemperature
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_66bc9029_f473_45ff_bab9_c3509ff37a22](http://emmo.info/emmo/middle/isq#emmo_66bc9029_f473_45ff_bab9_c3509ff37a22)

**Elucidation:** An objective comparative measure of hot or cold. 

Temperature is a relative quantity that can be used to express temperature differences. Unlike ThermodynamicTemperature, it cannot express absolute temperatures.

**Dbpediamatch:** [http://dbpedia.org/page/Temperature](http://dbpedia.org/page/temperature)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.T06261](https://doi.org/10.1351/goldbook.t06261)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [TemperatureDimension](#temperaturedimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### ElectricConductance
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_ffb73b1e_5786_43e4_a964_cb32ac7affb7](http://emmo.info/emmo/middle/isq#emmo_ffb73b1e_5786_43e4_a964_cb32ac7affb7)

**Elucidation:** Measure of the ease for electric current to pass through a material.

**Altlabel:** Conductance

**Comment:** Inverse of 'ElectricalResistance'.

**Dbpediamatch:** [http://dbpedia.org/page/Electrical_resistance_and_conductance](http://dbpedia.org/page/electrical_resistance_and_conductance)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.E01925](https://doi.org/10.1351/goldbook.e01925)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### ISQDerivedQuantity
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_2946d40b_24a1_47fa_8176_e3f79bb45064](http://emmo.info/emmo/middle/isq#emmo_2946d40b_24a1_47fa_8176_e3f79bb45064)

**Elucidation:** Derived quantities defined in the International System of Quantities (ISQ).

**Relations:** 

  - is_a [InternationalSystemOfQuantity](#internationalsystemofquantity)
  - is_a [DerivedQuantity](#derivedquantity)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### ElementaryCharge
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_58a650f0_a638_4743_8439_535a325e5c4c](http://emmo.info/emmo/middle/siunits#emmo_58a650f0_a638_4743_8439_535a325e5c4c)

**Elucidation:** The magnitude of the electric charge carried by a single electron.

**Comment:** The DBpedia definition (http://dbpedia.org/page/Elementary_charge) is outdated as May 20, 2019. It is now an exact quantity.

**Dbpediamatch:** [http://dbpedia.org/page/Elementary_charge](http://dbpedia.org/page/elementary_charge)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.E02032](https://doi.org/10.1351/goldbook.e02032)

**Qudtmatch:** [http://physics.nist.gov/cuu/CODATA-Value_ElementaryCharge](http://physics.nist.gov/cuu/codata-value_elementarycharge)

**Relations:** 

  - is_a [ElectricCharge](#electriccharge)
  - is_a [SIExactConstant](#siexactconstant)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [MeasuredConstant](#measuredconstant), [AvogadroConstant](#avogadroconstant), [Quantum](#quantum), [LuminousEfficacy](#luminousefficacy), [BoltzmannConstant](#boltzmannconstant), [BaseQuantity](#basequantity), [HyperfineTransitionFrequencyOfCs](#hyperfinetransitionfrequencyofcs), [PlanckConstant](#planckconstant), [SpeedOfLightInVacuum](#speedoflightinvacuum), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### Capacitance
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_99dba333_0dbd_4f75_8841_8c0f97fd58e2](http://emmo.info/emmo/middle/isq#emmo_99dba333_0dbd_4f75_8841_8c0f97fd58e2)

**Elucidation:** The derivative of the electric charge of a system with respect to the electric potential.

**Altlabel:** ElectricCapacitance

**Dbpediamatch:** [http://dbpedia.org/page/Capacitance](http://dbpedia.org/page/capacitance)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.C00791](https://doi.org/10.1351/goldbook.c00791)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### MagneticFlux
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_3b931698_937e_49be_ab1b_36fa52d91181](http://emmo.info/emmo/middle/isq#emmo_3b931698_937e_49be_ab1b_36fa52d91181)

**Elucidation:** Measure of magnetism, taking account of the strength and the extent of a magnetic field.

**Dbpediamatch:** [http://dbpedia.org/page/Magnetic_flux](http://dbpedia.org/page/magnetic_flux)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.M03684](https://doi.org/10.1351/goldbook.m03684)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### InternationalSystemOfQuantity
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_f35cff4d_dc09_44cf_a729_22fb79e3bfb2](http://emmo.info/emmo/middle/isq#emmo_f35cff4d_dc09_44cf_a729_22fb79e3bfb2)

**Elucidation:** Quantities declared under the ISO 8000.

**Seealso:** [https://www.iso.org/obp/ui/#iso:std:iso:80000:-1:ed-1:v1:en:sec:3.1](https://www.iso.org/obp/ui/#iso:std:iso:80000:-1:ed-1:v1:en:sec:3.1)

**Wikipediaentry:** [https://en.wikipedia.org/wiki/International_System_of_Quantities](https://en.wikipedia.org/wiki/international_system_of_quantities)

**Relations:** 

  - is_a [PhysicalQuantity](#physicalquantity)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### Angle
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_f3dd74c0_f480_49e8_9764_33b78638c235](http://emmo.info/emmo/middle/isq#emmo_f3dd74c0_f480_49e8_9764_33b78638c235)

**Definition:** Ratio of circular arc length to radius.

**Dbpediamatch:** [http://dbpedia.org/page/Angle](http://dbpedia.org/page/angle)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.A00346](https://doi.org/10.1351/goldbook.a00346)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [DimensionOne](#dimensionone)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### Radioactivity
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_8d3da9ac_2265_4382_bee5_db72046722f8](http://emmo.info/emmo/middle/isq#emmo_8d3da9ac_2265_4382_bee5_db72046722f8)

**Elucidation:** Decays per unit time.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.A00114](https://doi.org/10.1351/goldbook.a00114)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [PerTimeDimension](#pertimedimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### ElectricResistance
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_e88f75d6_9a17_4cfc_bdf7_43d7cea5a9a1](http://emmo.info/emmo/middle/isq#emmo_e88f75d6_9a17_4cfc_bdf7_43d7cea5a9a1)

**Elucidation:** Measure of the difficulty to pass an electric current through a material.

**Altlabel:** Resistance

**Comment:** Inverse of 'ElectricalConductance'.

**Dbpediamatch:** [http://dbpedia.org/page/Electrical_resistance_and_conductance](http://dbpedia.org/page/electrical_resistance_and_conductance)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.E01936](https://doi.org/10.1351/goldbook.e01936)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### Pressure
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_50a44256_9dc5_434b_bad4_74a4d9a29989](http://emmo.info/emmo/middle/isq#emmo_50a44256_9dc5_434b_bad4_74a4d9a29989)

**Elucidation:** The force applied perpendicular to the surface of an object per unit area over which that force is distributed.

**Dbpediamatch:** [http://dbpedia.org/page/Pressure](http://dbpedia.org/page/pressure)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.P04819](https://doi.org/10.1351/goldbook.p04819)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### ISQBaseQuantity
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_1a4c1a97_88a7_4d8e_b2f9_2ca58e92dde4](http://emmo.info/emmo/middle/isq#emmo_1a4c1a97_88a7_4d8e_b2f9_2ca58e92dde4)

**Elucidation:** Base quantities defined in the International System of Quantities (ISQ).

**Wikipediaentry:** [https://en.wikipedia.org/wiki/International_System_of_Quantities](https://en.wikipedia.org/wiki/international_system_of_quantities)

**Relations:** 

  - is_a [InternationalSystemOfQuantity](#internationalsystemofquantity)
  - is_a [BaseQuantity](#basequantity)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [DerivedQuantity](#derivedquantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)
  - disjoint_union_of [LuminousIntensity](#luminousintensity), [AmountOfSubstance](#amountofsubstance), [ThermodynamicTemperature](#thermodynamictemperature), [ElectricCurrent](#electriccurrent), [Length](#length), [Time](#time), [Mass](#mass)






### LuminousIntensity
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_50bf79a6_a48b_424d_9d2c_813bd631231a](http://emmo.info/emmo/middle/isq#emmo_50bf79a6_a48b_424d_9d2c_813bd631231a)

**Elucidation:** A measure of the wavelength-weighted power emitted by a light source in a particular direction per unit solid angle. It is based on the luminosity function, which is a standardized model of the sensitivity of the human eye.

**Dbpediamatch:** [http://dbpedia.org/page/Luminous_intensity](http://dbpedia.org/page/luminous_intensity)

**Relations:** 

  - is_a [ISQBaseQuantity](#isqbasequantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [LuminousIntensityDimension](#luminousintensitydimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [ThermodynamicTemperature](#thermodynamictemperature), [AmountOfSubstance](#amountofsubstance), [Quantum](#quantum), [ElectricCurrent](#electriccurrent), [DerivedQuantity](#derivedquantity), [Mass](#mass), [Length](#length), [Time](#time), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### ElectricCharge
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_1604f495_328a_4f28_9962_f4cc210739dd](http://emmo.info/emmo/middle/isq#emmo_1604f495_328a_4f28_9962_f4cc210739dd)

**Elucidation:** The physical property of matter that causes it to experience a force when placed in an electromagnetic field.

**Altlabel:** Charge

**Dbpediamatch:** [http://dbpedia.org/page/Electric_charge](http://dbpedia.org/page/electric_charge)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.E01923](https://doi.org/10.1351/goldbook.e01923)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [TimeCurrentDimension](#timecurrentdimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### Time
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_d4f7d378_5e3b_468a_baa1_a7e98358cda7](http://emmo.info/emmo/middle/isq#emmo_d4f7d378_5e3b_468a_baa1_a7e98358cda7)

**Elucidation:** The indefinite continued progress of existence and events that occur in apparently irreversible succession from the past through the present to the future.

**Dbpediamatch:** [http://dbpedia.org/page/Time](http://dbpedia.org/page/time)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.T06375](https://doi.org/10.1351/goldbook.t06375)

**Relations:** 

  - is_a [ISQBaseQuantity](#isqbasequantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [TimeDimension](#timedimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [ThermodynamicTemperature](#thermodynamictemperature), [AmountOfSubstance](#amountofsubstance), [Quantum](#quantum), [ElectricCurrent](#electriccurrent), [DerivedQuantity](#derivedquantity), [LuminousIntensity](#luminousintensity), [Mass](#mass), [Length](#length), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### Illuminance
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_b51fbd00_a857_4132_9711_0ef70e7bdd20](http://emmo.info/emmo/middle/isq#emmo_b51fbd00_a857_4132_9711_0ef70e7bdd20)

**Definition:** The total luminous flux incident on a surface, per unit area.

**Dbpediamatch:** [http://dbpedia.org/page/Illuminance](http://dbpedia.org/page/illuminance)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.I02941](https://doi.org/10.1351/goldbook.i02941)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### ThermodynamicTemperature
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_affe07e4_e9bc_4852_86c6_69e26182a17f](http://emmo.info/emmo/middle/isq#emmo_affe07e4_e9bc_4852_86c6_69e26182a17f)

**Elucidation:** Thermodynamic temperature is the absolute measure of temperature. It is defined by the third law of thermodynamics in which the theoretically lowest temperature is the null or zero point.

**Dbpediamatch:** [http://dbpedia.org/page/Thermodynamic_temperature](http://dbpedia.org/page/thermodynamic_temperature)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.T06321](https://doi.org/10.1351/goldbook.t06321)

**Relations:** 

  - is_a [ISQBaseQuantity](#isqbasequantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [TemperatureDimension](#temperaturedimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [AmountOfSubstance](#amountofsubstance), [Quantum](#quantum), [ElectricCurrent](#electriccurrent), [DerivedQuantity](#derivedquantity), [LuminousIntensity](#luminousintensity), [Mass](#mass), [Length](#length), [Time](#time), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### Inductance
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_04cc9451_5306_45d0_8554_22cee4d6e785](http://emmo.info/emmo/middle/isq#emmo_04cc9451_5306_45d0_8554_22cee4d6e785)

**Elucidation:** A property of an electrical conductor by which a change in current through it induces an electromotive force in both the conductor itself and in any nearby conductors by mutual inductance.

**Altlabel:** ElectricInductance

**Dbpediamatch:** [http://dbpedia.org/page/Inductance](http://dbpedia.org/page/inductance)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.M04076](https://doi.org/10.1351/goldbook.m04076)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### SolidAngle
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_e7c9f7fd_e534_4441_88fe_1fec6cb20f26](http://emmo.info/emmo/middle/isq#emmo_e7c9f7fd_e534_4441_88fe_1fec6cb20f26)

**Elucidation:** Ratio of area on a sphere to its radius squared.

**Dbpediamatch:** [http://dbpedia.org/page/Solid_angle](http://dbpedia.org/page/solid_angle)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.S05732](https://doi.org/10.1351/goldbook.s05732)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [DimensionOne](#dimensionone)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### DoseEquivalent
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_3df10765_f6ff_4c9e_be3d_10b1809d78bd](http://emmo.info/emmo/middle/isq#emmo_3df10765_f6ff_4c9e_be3d_10b1809d78bd)

**Elucidation:** A dose quantity used in the International Commission on Radiological Protection (ICRP) system of radiological protection.

**Dbpediamatch:** [http://dbpedia.org/page/Energy](http://dbpedia.org/page/energy)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.E02101](https://doi.org/10.1351/goldbook.e02101)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### LuminousFlux
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_e2ee1c98_497a_4f66_b4ed_5711496a848e](http://emmo.info/emmo/middle/isq#emmo_e2ee1c98_497a_4f66_b4ed_5711496a848e)

**Elucidation:** Perceived power of light.

**Dbpediamatch:** [http://dbpedia.org/page/Luminous_flux](http://dbpedia.org/page/luminous_flux)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.L03646](https://doi.org/10.1351/goldbook.l03646)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [LuminousIntensityDimension](#luminousintensitydimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### MagneticFluxDensity
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_961d1aba_f75e_4411_aaa4_457f7516ed6b](http://emmo.info/emmo/middle/isq#emmo_961d1aba_f75e_4411_aaa4_457f7516ed6b)

**Elucidation:** Strength of the magnetic field.

**Comment:** Often denoted B.

**Dbpediamatch:** [http://dbpedia.org/page/Magnetic_field](http://dbpedia.org/page/magnetic_field)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.M03686](https://doi.org/10.1351/goldbook.m03686)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### Mass
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_ed4af7ae_63a2_497e_bb88_2309619ea405](http://emmo.info/emmo/middle/isq#emmo_ed4af7ae_63a2_497e_bb88_2309619ea405)

**Elucidation:** Property of a physical body that express its resistance to acceleration (a change in its state of motion) when a force is applied.

**Dbpediamatch:** [http://dbpedia.org/page/Mass](http://dbpedia.org/page/mass)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.M03709](https://doi.org/10.1351/goldbook.m03709)

**Relations:** 

  - is_a [ISQBaseQuantity](#isqbasequantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [MassDimension](#massdimension)
  - Inverse([hasProperty](#hasproperty)) only [Matter](#matter)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [ThermodynamicTemperature](#thermodynamictemperature), [AmountOfSubstance](#amountofsubstance), [Quantum](#quantum), [ElectricCurrent](#electriccurrent), [DerivedQuantity](#derivedquantity), [LuminousIntensity](#luminousintensity), [Length](#length), [Time](#time), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### PhysicalQuantity
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_02c0621e_a527_4790_8a0f_2bb51973c819](http://emmo.info/emmo/middle/metrology#emmo_02c0621e_a527_4790_8a0f_2bb51973c819)

**Elucidation:** A 'Mathematical' entity that is made of a 'Number' and a 'MeasurementUnit' defined by a physical law, connected to a physical entity through a model perspective. Measurement is done according to the same model.

**Comment:** In the same system of quantities, dim $\uprho$B = ML−3 is the quantity dimension of mass concentration of component B, and ML−3 is also the quantity dimension of mass density, $\uprho$.
ISO 80000-1

**Comment:** Measured or simulated 'physical propertiy'-s are always defined by a physical law, connected to a physical entity through a model perspective and measurement is done according to the same model.

Systems of units suggests that this is the correct approach, since except for the fundamental units (length, time, charge) every other unit is derived by mathematical relations between these fundamental units, implying a physical laws or definitions.

**Comment:** Measurement units of quantities of the same quantity dimension may be designated by the same name and symbol even when the quantities are not of the same kind. 

For example, joule per kelvin and J/K are respectively the name and symbol of both a measurement unit of heat capacity and a measurement unit of entropy, which are generally not considered to be quantities of the same kind. 

However, in some cases special measurement unit names are restricted to be used with quantities of specific kind only. 

For example, the measurement unit ‘second to the power minus one’ (1/s) is called hertz (Hz) when used for frequencies and becquerel (Bq) when used for activities of radionuclides. 

As another example, the joule (J) is used as a unit of energy, but never as a unit of moment of force, i.e. the newton metre (N · m).

**Comment:** — quantities of the same kind have the same quantity dimension,
— quantities of different quantity dimensions are always of different kinds, and
— quantities having the same quantity dimension are not necessarily of the same kind.
ISO 80000-1

**Relations:** 

  - is_a [Mathematical](#mathematical)
  - is_a [Quantity](#quantity)
  - [hasReferenceUnit](#hasreferenceunit) only [MeasurementUnit](#measurementunit)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)
  - disjoint_union_of [DerivedQuantity](#derivedquantity), [BaseQuantity](#basequantity)






### HyperfineTransitionFrequencyOfCs
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_f96feb3f_4438_4e43_aa44_7458c4d87fc2](http://emmo.info/emmo/middle/siunits#emmo_f96feb3f_4438_4e43_aa44_7458c4d87fc2)

**Elucidation:** The frequency standard in the SI system in which the photon absorption by transitions between the two hyperfine ground states of caesium-133 atoms are used to control the output frequency.

**Relations:** 

  - is_a [Frequency](#frequency)
  - is_a [SIExactConstant](#siexactconstant)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [MeasuredConstant](#measuredconstant), [ElementaryCharge](#elementarycharge), [AvogadroConstant](#avogadroconstant), [Quantum](#quantum), [LuminousEfficacy](#luminousefficacy), [BoltzmannConstant](#boltzmannconstant), [BaseQuantity](#basequantity), [PlanckConstant](#planckconstant), [SpeedOfLightInVacuum](#speedoflightinvacuum), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### AbsorbedDose
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_8e5dd473_808b_4a8a_b7cd_63068c12ff57](http://emmo.info/emmo/middle/isq#emmo_8e5dd473_808b_4a8a_b7cd_63068c12ff57)

**Definition:** Energy imparted to matter by ionizing radiation in a suitable small element of volume divided by the mass of that element of volume.

**Dbpediamatch:** [http://dbpedia.org/page/Absorbed_dose](http://dbpedia.org/page/absorbed_dose)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.A00031](https://doi.org/10.1351/goldbook.a00031)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### Energy
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_31ec09ba_1713_42cb_83c7_b38bf6f9ced2](http://emmo.info/emmo/middle/isq#emmo_31ec09ba_1713_42cb_83c7_b38bf6f9ced2)

**Elucidation:** A property of objects which can be transferred to other objects or converted into different forms.

**Comment:** Energy is often defined as "ability of a system to perform work", but it might be misleading since is not necessarily available to do work.

**Dbpediamatch:** [http://dbpedia.org/page/Energy](http://dbpedia.org/page/energy)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.E02101](https://doi.org/10.1351/goldbook.e02101)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### Frequency
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_852b4ab8_fc29_4749_a8c7_b92d4fca7d5a](http://emmo.info/emmo/middle/isq#emmo_852b4ab8_fc29_4749_a8c7_b92d4fca7d5a)

**Elucidation:** Number of periods per time interval.

**Dbpediamatch:** [http://dbpedia.org/page/Frequency](http://dbpedia.org/page/frequency)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.FT07383](https://doi.org/10.1351/goldbook.ft07383)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [PerTimeDimension](#pertimedimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### AmountOfSubstance
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_8159c26a_494b_4fa0_9959_10888f152298](http://emmo.info/emmo/middle/isq#emmo_8159c26a_494b_4fa0_9959_10888f152298)

**Elucidation:** The number of elementary entities present.

**Dbpediamatch:** [http://dbpedia.org/page/Amount_of_substance](http://dbpedia.org/page/amount_of_substance)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.A00297](https://doi.org/10.1351/goldbook.a00297)

**Relations:** 

  - is_a [ISQBaseQuantity](#isqbasequantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [AmountDimension](#amountdimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [ThermodynamicTemperature](#thermodynamictemperature), [Quantum](#quantum), [ElectricCurrent](#electriccurrent), [DerivedQuantity](#derivedquantity), [LuminousIntensity](#luminousintensity), [Mass](#mass), [Length](#length), [Time](#time), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### ElectricCurrent
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_c995ae70_3b84_4ebb_bcfc_69e6a281bb88](http://emmo.info/emmo/middle/isq#emmo_c995ae70_3b84_4ebb_bcfc_69e6a281bb88)

**Elucidation:** A flow of electric charge.

**Dbpediamatch:** [http://dbpedia.org/page/Electric_current](http://dbpedia.org/page/electric_current)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.E01927](https://doi.org/10.1351/goldbook.e01927)

**Relations:** 

  - is_a [ISQBaseQuantity](#isqbasequantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [ElectricCurrentDimension](#electriccurrentdimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [ThermodynamicTemperature](#thermodynamictemperature), [AmountOfSubstance](#amountofsubstance), [Quantum](#quantum), [DerivedQuantity](#derivedquantity), [LuminousIntensity](#luminousintensity), [Mass](#mass), [Length](#length), [Time](#time), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### Force
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_1f087811_06cb_42d5_90fb_25d0e7e068ef](http://emmo.info/emmo/middle/isq#emmo_1f087811_06cb_42d5_90fb_25d0e7e068ef)

**Elucidation:** Any interaction that, when unopposed, will change the motion of an object.

**Dbpediamatch:** [http://dbpedia.org/page/Force](http://dbpedia.org/page/force)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.F02480](https://doi.org/10.1351/goldbook.f02480)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### CatalyticActivity
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_bd67d149_24c2_4bc9_833a_c2bc26f98fd3](http://emmo.info/emmo/middle/isq#emmo_bd67d149_24c2_4bc9_833a_c2bc26f98fd3)

**Elucidation:** Increase in the rate of reaction of a specified chemical reaction that an enzyme produces in a specific assay system.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.C00881](https://doi.org/10.1351/goldbook.c00881)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [AmountPerTimeDimension](#amountpertimedimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### Length
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_cd2cd0de_e0cc_4ef1_b27e_2e88db027bac](http://emmo.info/emmo/middle/isq#emmo_cd2cd0de_e0cc_4ef1_b27e_2e88db027bac)

**Elucidation:** Extend of a spatial dimension.

**Dbpediamatch:** [http://dbpedia.org/page/Length](http://dbpedia.org/page/length)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.L03498](https://doi.org/10.1351/goldbook.l03498)

**Relations:** 

  - is_a [ISQBaseQuantity](#isqbasequantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [LengthDimension](#lengthdimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [ThermodynamicTemperature](#thermodynamictemperature), [AmountOfSubstance](#amountofsubstance), [Quantum](#quantum), [ElectricCurrent](#electriccurrent), [DerivedQuantity](#derivedquantity), [LuminousIntensity](#luminousintensity), [Mass](#mass), [Time](#time), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### ElectricPotential
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_4f2d3939_91b1_4001_b8ab_7d19074bf845](http://emmo.info/emmo/middle/isq#emmo_4f2d3939_91b1_4001_b8ab_7d19074bf845)

**Elucidation:** Energy required to move a unit charge through an electric field from a reference point.

**Altlabel:** Voltage

**Dbpediamatch:** [http://dbpedia.org/page/Voltage](http://dbpedia.org/page/voltage)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.A00424](https://doi.org/10.1351/goldbook.a00424)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### Power
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_09b9021b_f97b_43eb_b83d_0a764b472bc2](http://emmo.info/emmo/middle/isq#emmo_09b9021b_f97b_43eb_b83d_0a764b472bc2)

**Elucidation:** Rate of transfer of energy per unit time.

**Dbpediamatch:** [http://dbpedia.org/page/Power_(physics)](http://dbpedia.org/page/power_(physics))

**Iupacdoi:** [https://doi.org/10.1351/goldbook.P04792](https://doi.org/10.1351/goldbook.p04792)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






## Number branch
![Number branch.](genfigs/NumberT.pdf){ width=437px }


### Real
**IRI:** [http://emmo.info/emmo/middle/math#EMMO_18d180e4_5e3e_42f7_820c_e08951223486](http://emmo.info/emmo/middle/math#emmo_18d180e4_5e3e_42f7_820c_e08951223486)

**Relations:** 

  - is_a [Number](#number)
  - [hasNumericalData](#hasnumericaldata) only type
  - [hasNumericalData](#hasnumericaldata) exactly 1 type
  - equivalent_to [hasNumericalData](#hasnumericaldata) some type
  - disjoint_with [Collection](#collection), [Boolean](#boolean), [PhysicsBasedModel](#physicsbasedmodel), [Equation](#equation), [Integer](#integer), [Quantity](#quantity), [PrefixedUnit](#prefixedunit), [Void](#void)






### Boolean
**IRI:** [http://emmo.info/emmo/middle/math#EMMO_54dc83cb_06e1_4739_9e45_bc09cead7f48](http://emmo.info/emmo/middle/math#emmo_54dc83cb_06e1_4739_9e45_bc09cead7f48)

**Relations:** 

  - is_a [Number](#number)
  - [hasNumericalData](#hasnumericaldata) only type
  - [hasNumericalData](#hasnumericaldata) exactly 1 type
  - equivalent_to [hasNumericalData](#hasnumericaldata) some type
  - disjoint_with [Collection](#collection), [Equation](#equation), [PhysicsBasedModel](#physicsbasedmodel), [Real](#real), [Integer](#integer), [Quantity](#quantity), [PrefixedUnit](#prefixedunit), [Void](#void)






### Integer
**IRI:** [http://emmo.info/emmo/middle/math#EMMO_f8bd64d5_5d3e_4ad4_a46e_c30714fecb7f](http://emmo.info/emmo/middle/math#emmo_f8bd64d5_5d3e_4ad4_a46e_c30714fecb7f)

**Relations:** 

  - is_a [Number](#number)
  - [hasNumericalData](#hasnumericaldata) only type
  - [hasNumericalData](#hasnumericaldata) exactly 1 type
  - equivalent_to [hasNumericalData](#hasnumericaldata) some type
  - disjoint_with [Collection](#collection), [Equation](#equation), [PhysicsBasedModel](#physicsbasedmodel), [Boolean](#boolean), [Real](#real), [Quantity](#quantity), [PrefixedUnit](#prefixedunit), [Void](#void)






### Number
**IRI:** [http://emmo.info/emmo/middle/math#EMMO_21f56795_ee72_4858_b571_11cfaa59c1a8](http://emmo.info/emmo/middle/math#emmo_21f56795_ee72_4858_b571_11cfaa59c1a8)

**Elucidation:** A numerical data value.

**Comment:** A number is actually a string (e.g. 1.4, 1e-8) of numerical digits and other symbols. However, in order not to increase complexity of the taxonomy and relations, here we take a number as an "atomic" object (i.e. we do not include digits in the EMMO as alphabet for numbers).

A 'Number' individual provide the link between the ontology and the actual data, through the data property hasNumericalValue.

**Relations:** 

  - is_a [Numerical](#numerical)
  - is_a [MathematicalSymbol](#mathematicalsymbol)
  - is_a [Symbol](#symbol)
  - disjoint_with [Collection](#collection), [Equation](#equation), [PhysicsBasedModel](#physicsbasedmodel), [Quantity](#quantity), [PrefixedUnit](#prefixedunit), [Void](#void)






## Measurement Unit branch
![Measurement Unit branch.](genfigs/MeasurementUnitT.pdf){ width=668px }


### MeasurementUnit
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_b081b346_7279_46ef_9a3d_2c088fcd79f4](http://emmo.info/emmo/middle/metrology#emmo_b081b346_7279_46ef_9a3d_2c088fcd79f4)

**Elucidation:** A 'Quantity' that stands for the standard reference magnitude of a specific class of measurement processes, defined and adopted by convention or by law.

The numerical quantity value of the 'MeasurementUnit' is conventionally 1 and does not appear.

Quantitative measurement results are expressed as a multiple of the 'MeasurementUnit'.

**Comment:** "Real scalar quantity, defined and adopted by convention, with which any other quantity of the same kind can be compared to express the ratio of the second quantity to the first one as a number"
ISO 80000-1

**Comment:** "Unit symbols are mathematical entities and not abbreviations."

"Symbols for units are treated as mathematical entities. In expressing the value of a quantity as the product of a numerical value and a unit, both the numerical value and the unit may be treated by the ordinary rules of algebra."

https://www.bipm.org/utils/common/pdf/si-brochure/SI-Brochure-9-EN.pdf

**Comment:** While the SI brochure treats 'MeasurementUnit' as a 'PhysicalQuantity', in the EMMO this is not possible since the latter always has two direct parts, a 'Numerical' and a 'MeasurementUnit', while the former a single 'Symbol'.

SI distinguishes between a quantity (an abstract concept) and the quantity value (a number and a reference). The EMMO, following strict nominalism, considers a SI quantity as a SI quantity value, collapsing the two concepts into one: the 'Quantity'.

So, for the EMMO the symbol "kg" is not a physical quantity but a 'MeasurementUnit', while the string "1 kg" is 'Physical Quantity'.

**Relations:** 

  - is_a [ReferenceUnit](#referenceunit)
  - disjoint_with [Collection](#collection), [Void](#void)
  - disjoint_union_of [NonPrefixedUnit](#nonprefixedunit), [PrefixedUnit](#prefixedunit)






### UnitSymbol
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_216f448e_cdbc_4aeb_a529_7a5fe7fc38bb](http://emmo.info/emmo/middle/metrology#emmo_216f448e_cdbc_4aeb_a529_7a5fe7fc38bb)

**Elucidation:** A symbol that stands for a single unit.

**Example:** Some examples are "Pa", "m" and "J".

**Relations:** 

  - is_a [MetrologicalSymbol](#metrologicalsymbol)
  - is_a [NonPrefixedUnit](#nonprefixedunit)
  - equivalent_to [MeasurementUnit](#measurementunit) and [Symbol](#symbol)
  - disjoint_with [Collection](#collection), [Equation](#equation), [PhysicsBasedModel](#physicsbasedmodel), [Quantity](#quantity), [PrefixedUnit](#prefixedunit), [Void](#void)
  - disjoint_union_of [SpecialUnit](#specialunit), [BaseUnit](#baseunit)






### DerivedUnit
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_08b308d4_31cd_4779_a784_aa92fc730f39](http://emmo.info/emmo/middle/metrology#emmo_08b308d4_31cd_4779_a784_aa92fc730f39)

**Elucidation:** Derived units are defined as products of powers of the base units corresponding to the relations defining the derived quantities in terms of the base quantities.

**Relations:** 

  - is_a [NonPrefixedUnit](#nonprefixedunit)
  - disjoint_with [Collection](#collection), [PrefixedUnit](#prefixedunit), [Void](#void)






### OffSystemUnit
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_591e02fd_8d37_45a6_9d11_bb21cef391a0](http://emmo.info/emmo/middle/metrology#emmo_591e02fd_8d37_45a6_9d11_bb21cef391a0)

**Elucidation:** A unit that does not belong to any system of units.

**Example:** eV
barn

**Relations:** 

  - is_a [MeasurementUnit](#measurementunit)
  - disjoint_with [Collection](#collection), [Void](#void)






### SINonCoherentDerivedUnit
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_60b78cc3_6011_4134_95ab_956f56d4bdc1](http://emmo.info/emmo/middle/siunits#emmo_60b78cc3_6011_4134_95ab_956f56d4bdc1)

**Elucidation:** A derived unit whos numerical factor in front of the product of base units is NOT equal to one.

**Relations:** 

  - is_a [SINonCoherentUnit](#sinoncoherentunit)
  - disjoint_with [Void](#void), [Collection](#collection), [SICoherentUnit](#sicoherentunit), [SIPrefixedUnit](#siprefixedunit)






### NonPrefixedUnit
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_868ae137_4d25_493e_b270_21ea3d94849e](http://emmo.info/emmo/middle/metrology#emmo_868ae137_4d25_493e_b270_21ea3d94849e)

**Elucidation:** A measurement unit symbol that do not have a metric prefix as a direct spatial part.

**Relations:** 

  - is_a [MeasurementUnit](#measurementunit)
  - [hasSpatialDirectPart](#hasspatialdirectpart) only not [MetricPrefix](#metricprefix)
  - equivalent_to [DerivedUnit](#derivedunit) or [UnitSymbol](#unitsymbol)
  - disjoint_with [Collection](#collection), [PrefixedUnit](#prefixedunit), [Void](#void)






### SIPrefixedUnit
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_d41ce84b_4317_41fb_a5d1_6cd281fca106](http://emmo.info/emmo/middle/siunits#emmo_d41ce84b_4317_41fb_a5d1_6cd281fca106)

**Elucidation:** A SI base or special unit with a metric prefix.

**Comment:** The presence of the prefix makes this units non-coherent with SI system.

**Relations:** 

  - is_a [PrefixedUnit](#prefixedunit)
  - is_a [SINonCoherentUnit](#sinoncoherentunit)
  - [hasSpatialDirectPart](#hasspatialdirectpart) exactly 1 [SIUnitSymbol](#siunitsymbol)
  - disjoint_with [Collection](#collection), [PhysicsEquation](#physicsequation), [AvogadroConstant](#avogadroconstant), [MaterialRelation](#materialrelation), [SINonCoherentDerivedUnit](#sinoncoherentderivedunit), [Quantum](#quantum), [LuminousEfficacy](#luminousefficacy), [ArithmeticExpression](#arithmeticexpression), [NonPrefixedUnit](#nonprefixedunit), [BoltzmannConstant](#boltzmannconstant), [SICoherentUnit](#sicoherentunit), [PlanckConstant](#planckconstant), [SpeedOfLightInVacuum](#speedoflightinvacuum), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### SIUnitSymbol
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_32129fb5_df25_48fd_a29c_18a2f22a2dd5](http://emmo.info/emmo/middle/siunits#emmo_32129fb5_df25_48fd_a29c_18a2f22a2dd5)

**Relations:** 

  - is_a [UnitSymbol](#unitsymbol)
  - is_a [SICoherentUnit](#sicoherentunit)
  - is_a [Object](#object)
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Exa](#exa), [Kilo](#kilo), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)
  - disjoint_union_of [SIBaseUnit](#sibaseunit), [SISpecialUnit](#sispecialunit)






### BaseUnit
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_db716151_6b73_45ff_910c_d182fdcbb4f5](http://emmo.info/emmo/middle/metrology#emmo_db716151_6b73_45ff_910c_d182fdcbb4f5)

**Elucidation:** A set of units that correspond to the base quantities in a system of units.

**Relations:** 

  - is_a [UnitSymbol](#unitsymbol)
  - disjoint_with [Collection](#collection), [Equation](#equation), [PhysicsBasedModel](#physicsbasedmodel), [Quantity](#quantity), [PrefixedUnit](#prefixedunit), [Void](#void), [SpecialUnit](#specialunit)






### SINonCoherentUnit
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_8246541a_f1f6_4d03_8bd7_fc6b76d17375](http://emmo.info/emmo/middle/siunits#emmo_8246541a_f1f6_4d03_8bd7_fc6b76d17375)

**Relations:** 

  - is_a [SIUnit](#siunit)
  - disjoint_with [Collection](#collection), [SICoherentUnit](#sicoherentunit), [Void](#void)
  - disjoint_union_of [SINonCoherentDerivedUnit](#sinoncoherentderivedunit), [SIPrefixedUnit](#siprefixedunit)






### SICoherentUnit
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_707c6032_e272_4a20_98b5_d35c4f67be68](http://emmo.info/emmo/middle/siunits#emmo_707c6032_e272_4a20_98b5_d35c4f67be68)

**Comment:** Derived units are defined as products of powers of the base units. When the numerical factor of this product is one, the derived units are called coherent derived units. The base and coherent derived units of the SI form a coherent set, designated the set of coherent SI units.

**Relations:** 

  - is_a [SIUnit](#siunit)
  - disjoint_with [Collection](#collection), [Void](#void), [SINonCoherentUnit](#sinoncoherentunit)
  - disjoint_union_of [SICoherentDerivedUnit](#sicoherentderivedunit), [SIBaseUnit](#sibaseunit), [SISpecialUnit](#sispecialunit)






### UnitOne
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_5ebd5e01_0ed3_49a2_a30d_cd05cbe72978](http://emmo.info/emmo/middle/metrology#emmo_5ebd5e01_0ed3_49a2_a30d_cd05cbe72978)

**Elucidation:** Represents the number 1, used as an explicit unit to say something has no units.

**Example:** Refractive index or volume fraction.

**Example:** Typically used for ratios of two units whos dimensions cancels out.

**Qudtmatch:** [http://qudt.org/vocab/unit/UNITLESS](http://qudt.org/vocab/unit/unitless)

**Relations:** 

  - is_a [BaseUnit](#baseunit)
  - disjoint_with [Collection](#collection), [Equation](#equation), [PhysicsBasedModel](#physicsbasedmodel), [Quantity](#quantity), [PrefixedUnit](#prefixedunit), [Void](#void), [SpecialUnit](#specialunit)






### SIUnit
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_feb03a8a_bbb6_4918_a891_46713ef557f4](http://emmo.info/emmo/middle/siunits#emmo_feb03a8a_bbb6_4918_a891_46713ef557f4)

**Elucidation:** The set of units provided by the SI referring to the ISQ.

**Comment:** The complete set of SI units includes both the coherent set and the multiples and sub-multiples formed by using the SI prefixes.

**Relations:** 

  - is_a [MeasurementUnit](#measurementunit)
  - disjoint_with [Collection](#collection), [Void](#void)
  - disjoint_union_of [SICoherentDerivedUnit](#sicoherentderivedunit), [SIBaseUnit](#sibaseunit), [SINonCoherentDerivedUnit](#sinoncoherentderivedunit), [SIPrefixedUnit](#siprefixedunit), [SISpecialUnit](#sispecialunit)






### SICoherentDerivedUnit
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_1273eb34_de48_43a9_925f_104110469dd2](http://emmo.info/emmo/middle/siunits#emmo_1273eb34_de48_43a9_925f_104110469dd2)

**Elucidation:** A SI derived unit whos numerical factor in front of the product of SI base units is one.

**Example:** m/s
kg/m^3

**Comment:** This class collects all units that are products or powers of SI base or SI special units only.

**Relations:** 

  - is_a [SICoherentUnit](#sicoherentunit)
  - disjoint_with [Collection](#collection), [Void](#void), [SINonCoherentUnit](#sinoncoherentunit), [SIUnitSymbol](#siunitsymbol)






### SpecialUnit
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_3ee80521_3c23_4dd1_935d_9d522614a3e2](http://emmo.info/emmo/middle/metrology#emmo_3ee80521_3c23_4dd1_935d_9d522614a3e2)

**Elucidation:** A unit symbol that stands for a derived unit.

**Example:** Pa stands for N/m2
J stands for N m

**Comment:** Special units are semiotic shortcuts to more complex composed symbolic objects.

**Relations:** 

  - is_a [DerivedUnit](#derivedunit)
  - is_a [UnitSymbol](#unitsymbol)
  - is_a [Sign](#sign)
  - Inverse([hasSign](#hassign)) some [DerivedUnit](#derivedunit)
  - disjoint_with [Collection](#collection), [Equation](#equation), [PhysicsBasedModel](#physicsbasedmodel), [BaseUnit](#baseunit), [Quantity](#quantity), [PrefixedUnit](#prefixedunit), [Void](#void)






## UTF8 branch
![UTF8 branch.](genfigs/UTF8T.pdf){ width=668px }


### Ampere
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_db5dd38d_ac79_4af6_8782_fee7e7150ae8](http://emmo.info/emmo/middle/siunits#emmo_db5dd38d_ac79_4af6_8782_fee7e7150ae8)

**Definition:** The ampere, symbol A, is the SI unit of electric current. It is defined by taking the fixed numerical value of the elementary charge e to be 1.602176634×10−19 when expressed in the unit C, which is equal to A s, where the second is defined in terms of $\nabla$$\upnu$Cs.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.A00300](https://doi.org/10.1351/goldbook.a00300)

**Qudtmatch:** [http://qudt.org/vocab/unit/A](http://qudt.org/vocab/unit/a)

**Relations:** 

  - is_a [LatinCapitalLetterA](#latincapitallettera)
  - is_a [SIBaseUnit](#sibaseunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [ElectricCurrentDimension](#electriccurrentdimension)
  - [hasSymbolData](#hassymboldata) value "A"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [SpecialUnit](#specialunit), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [Kelvin](#kelvin), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Kilogram](#kilogram), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [Mole](#mole), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [LengthDimension](#lengthdimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Second](#second), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [Candela](#candela)






### Milli
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_a3a701ed_6f7d_4a10_9aee_dfa1961fc7b7](http://emmo.info/emmo/middle/siunits#emmo_a3a701ed_6f7d_4a10_9aee_dfa1961fc7b7)

**Relations:** 

  - is_a [LatinSmallLetterM](#latinsmallletterm)
  - is_a [SIMetricPrefix](#simetricprefix)
  - Inverse([hasVariable](#hasvariable)) only [hasNumericalData](#hasnumericaldata) value 0.001
  - [hasSymbolData](#hassymboldata) value "m"
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [SISpecialUnit](#sispecialunit), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Tera](#tera), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [Kelvin](#kelvin), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [Minus](#minus), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Kilogram](#kilogram), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Mole](#mole), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [LengthDimension](#lengthdimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Exa](#exa), [Kilo](#kilo), [Second](#second), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [Candela](#candela)






### LatinSmallLetterM
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_aa0d5cde_cbdc_4815_b46d_2f76b00a6bde](http://emmo.info/emmo/middle/metrology#emmo_aa0d5cde_cbdc_4815_b46d_2f76b00a6bde)

**Altlabel:** m

**Relations:** 

  - is_a [UTF8](#utf8)
  - equivalent_to [hasSymbolData](#hassymboldata) value "m"
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [SISpecialUnit](#sispecialunit), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Candela](#candela), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Tera](#tera), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Kelvin](#kelvin), [Giga](#giga), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [Minus](#minus), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Kilogram](#kilogram), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Mole](#mole), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Exa](#exa), [Kilo](#kilo), [Second](#second), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### MicroUnit
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_2cfdcca6_6231_48aa_81b5_388b464bfe80](http://emmo.info/emmo/middle/metrology#emmo_2cfdcca6_6231_48aa_81b5_388b464bfe80)

**Altlabel:** µ

**Relations:** 

  - is_a [UTF8](#utf8)
  - equivalent_to [hasSymbolData](#hassymboldata) value "µ"
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Tera](#tera), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [Quantity](#quantity), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Exa](#exa), [Kilo](#kilo), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### Micro
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_9ff3bf8e_2168_406e_8251_1d158fc948ae](http://emmo.info/emmo/middle/siunits#emmo_9ff3bf8e_2168_406e_8251_1d158fc948ae)

**Relations:** 

  - is_a [MicroUnit](#microunit)
  - is_a [SIMetricPrefix](#simetricprefix)
  - Inverse([hasVariable](#hasvariable)) only [hasNumericalData](#hasnumericaldata) value 1e-06
  - [hasSymbolData](#hassymboldata) value "µ"
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Tera](#tera), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [Quantity](#quantity), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [LengthDimension](#lengthdimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Kilo](#kilo), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [Exa](#exa)






### Metre
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_7db11dbf_a643_464a_9b56_07eabcc3e9c5](http://emmo.info/emmo/middle/siunits#emmo_7db11dbf_a643_464a_9b56_07eabcc3e9c5)

**Definition:** The metre, symbol m, is the SI unit of length. It is defined by taking the fixed numerical value of the speed of light in vacuum c to be 299792458 when expressed in the unit m s−1, where the second is defined in terms of $\nabla$$\upnu$Cs.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.M03884](https://doi.org/10.1351/goldbook.m03884)

**Qudtmatch:** [http://qudt.org/vocab/unit/M](http://qudt.org/vocab/unit/m)

**Relations:** 

  - is_a [LatinSmallLetterM](#latinsmallletterm)
  - is_a [SIBaseUnit](#sibaseunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [LengthDimension](#lengthdimension)
  - [hasSymbolData](#hassymboldata) value "m"
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Candela](#candela), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [SpecialUnit](#specialunit), [Yocto](#yocto), [Equals](#equals), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Tera](#tera), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [Kelvin](#kelvin), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [Minus](#minus), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Kilogram](#kilogram), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Mole](#mole), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Exa](#exa), [Kilo](#kilo), [Second](#second), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### LatinCapitalLetterA
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_2125f2d0_5050_49e3_a579_4c74bc9fd02e](http://emmo.info/emmo/middle/metrology#emmo_2125f2d0_5050_49e3_a579_4c74bc9fd02e)

**Altlabel:** A

**Relations:** 

  - is_a [UTF8](#utf8)
  - equivalent_to [hasSymbolData](#hassymboldata) value "A"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [SISpecialUnit](#sispecialunit), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Candela](#candela), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [Kelvin](#kelvin), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Kilogram](#kilogram), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [Mole](#mole), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Second](#second), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### Atto
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_42955b2d_b465_4666_86cc_ea3c2d685753](http://emmo.info/emmo/middle/siunits#emmo_42955b2d_b465_4666_86cc_ea3c2d685753)

**Relations:** 

  - is_a [LatinSmallLetterA](#latinsmalllettera)
  - is_a [SIMetricPrefix](#simetricprefix)
  - Inverse([hasVariable](#hasvariable)) only [hasNumericalData](#hasnumericaldata) value 1e-18
  - [hasSymbolData](#hassymboldata) value "a"
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Tera](#tera), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Exa](#exa), [Kilo](#kilo), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### GreekSmallLetterMu
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_1e9c2a4b_abb9_4b27_bd9c_e31aac337a04](http://emmo.info/emmo/middle/metrology#emmo_1e9c2a4b_abb9_4b27_bd9c_e31aac337a04)

**Altlabel:** $\upmu$

**Relations:** 

  - is_a [UTF8](#utf8)
  - equivalent_to [hasSymbolData](#hassymboldata) value "μ"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [MicroUnit](#microunit), [Multiplication](#multiplication), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### Space
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_ea192c80_6029_4410_863c_8eed7ea52037](http://emmo.info/emmo/middle/metrology#emmo_ea192c80_6029_4410_863c_8eed7ea52037)

**Altlabel:** 

**Comment:** U+0020

**Relations:** 

  - is_a [UTF8](#utf8)
  - equivalent_to [hasSymbolData](#hassymboldata) value " "
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [LengthPerTimeDimension](#lengthpertimedimension), [LuminousIntensityDimension](#luminousintensitydimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### LatinSmallLetterA
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_cfcf0f48_09ac_4770_a06a_684a42b4a14c](http://emmo.info/emmo/middle/metrology#emmo_cfcf0f48_09ac_4770_a06a_684a42b4a14c)

**Altlabel:** a

**Relations:** 

  - is_a [UTF8](#utf8)
  - equivalent_to [hasSymbolData](#hassymboldata) value "a"
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Tera](#tera), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Exa](#exa), [Kilo](#kilo), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### UTF8
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_e13b2173_1dec_4b97_9ac1_1dc4b418612a](http://emmo.info/emmo/middle/metrology#emmo_e13b2173_1dec_4b97_9ac1_1dc4b418612a)

**Relations:** 

  - is_a [Symbol](#symbol)
  - disjoint_with [Collection](#collection), [Equation](#equation), [PhysicsBasedModel](#physicsbasedmodel), [Quantity](#quantity), [PrefixedUnit](#prefixedunit), [Void](#void)






## SI Base Unit branch
![SI Base Unit branch.](genfigs/SIBaseUnitT.pdf){ width=668px }


### Metre
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_7db11dbf_a643_464a_9b56_07eabcc3e9c5](http://emmo.info/emmo/middle/siunits#emmo_7db11dbf_a643_464a_9b56_07eabcc3e9c5)

**Definition:** The metre, symbol m, is the SI unit of length. It is defined by taking the fixed numerical value of the speed of light in vacuum c to be 299792458 when expressed in the unit m s−1, where the second is defined in terms of $\nabla$$\upnu$Cs.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.M03884](https://doi.org/10.1351/goldbook.m03884)

**Qudtmatch:** [http://qudt.org/vocab/unit/M](http://qudt.org/vocab/unit/m)

**Relations:** 

  - is_a [LatinSmallLetterM](#latinsmallletterm)
  - is_a [SIBaseUnit](#sibaseunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [LengthDimension](#lengthdimension)
  - [hasSymbolData](#hassymboldata) value "m"
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Candela](#candela), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [SpecialUnit](#specialunit), [Yocto](#yocto), [Equals](#equals), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Tera](#tera), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [Kelvin](#kelvin), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [Minus](#minus), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Kilogram](#kilogram), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Mole](#mole), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Exa](#exa), [Kilo](#kilo), [Second](#second), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### Ampere
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_db5dd38d_ac79_4af6_8782_fee7e7150ae8](http://emmo.info/emmo/middle/siunits#emmo_db5dd38d_ac79_4af6_8782_fee7e7150ae8)

**Definition:** The ampere, symbol A, is the SI unit of electric current. It is defined by taking the fixed numerical value of the elementary charge e to be 1.602176634×10−19 when expressed in the unit C, which is equal to A s, where the second is defined in terms of $\nabla$$\upnu$Cs.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.A00300](https://doi.org/10.1351/goldbook.a00300)

**Qudtmatch:** [http://qudt.org/vocab/unit/A](http://qudt.org/vocab/unit/a)

**Relations:** 

  - is_a [LatinCapitalLetterA](#latincapitallettera)
  - is_a [SIBaseUnit](#sibaseunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [ElectricCurrentDimension](#electriccurrentdimension)
  - [hasSymbolData](#hassymboldata) value "A"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [SpecialUnit](#specialunit), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [Kelvin](#kelvin), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Kilogram](#kilogram), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [Mole](#mole), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [LengthDimension](#lengthdimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Second](#second), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [Candela](#candela)






### Kilogram
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_9bfd6f1e_b0ce_459c_beb7_8f1f41708bba](http://emmo.info/emmo/middle/siunits#emmo_9bfd6f1e_b0ce_459c_beb7_8f1f41708bba)

**Definition:** The kilogram, symbol kg, is the SI unit of mass. It is defined by taking the fixed numerical value of the Planck constant h to be 6.62607015×10−34 when expressed in the unit J s, which is equal to kg m2 s−1, where the metre and the second are defined in terms of c and $\nabla$$\upnu$Cs.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.K03391](https://doi.org/10.1351/goldbook.k03391)

**Qudtmatch:** [http://qudt.org/vocab/unit/KiloGM](http://qudt.org/vocab/unit/kilogm)

**Relations:** 

  - is_a [SIBaseUnit](#sibaseunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [MassDimension](#massdimension)
  - [hasSymbolData](#hassymboldata) value "kg"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [SpecialUnit](#specialunit), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [Kelvin](#kelvin), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [Mole](#mole), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [LengthDimension](#lengthdimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Second](#second), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [Candela](#candela)






### Kelvin
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_2e5e45fc_f52c_4294_bdc2_5ed7a06dfce7](http://emmo.info/emmo/middle/siunits#emmo_2e5e45fc_f52c_4294_bdc2_5ed7a06dfce7)

**Definition:** The kelvin, symbol K, is the SI unit of thermodynamic temperature. It is defined by taking the fixed numerical value of the Boltzmann constant k to be 1.380649×10−23 when expressed in the unit J K−1, which is equal to kg m2 s−2 K−1, where the kilogram, metre and second are defined in terms of h, c and $\nabla$$\upnu$Cs.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.K03374](https://doi.org/10.1351/goldbook.k03374)

**Qudtmatch:** [http://qudt.org/vocab/unit/K](http://qudt.org/vocab/unit/k)

**Relations:** 

  - is_a [SIBaseUnit](#sibaseunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [TemperatureDimension](#temperaturedimension)
  - [hasSymbolData](#hassymboldata) value "K"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Candela](#candela), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [SpecialUnit](#specialunit), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Kilogram](#kilogram), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [Mole](#mole), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Second](#second), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### Second
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_314ba716_2d3d_4462_9a4f_d3419ae1df43](http://emmo.info/emmo/middle/siunits#emmo_314ba716_2d3d_4462_9a4f_d3419ae1df43)

**Definition:** The second, symbol s, is the SI unit of time. It is defined by taking the fixed numerical value of the caesium frequency $\nabla$$\upnu$Cs, the unperturbed ground-state hyperfine transition frequency of the caesium 133 atom, to be 9192631770 when expressed in the unit Hz, which is equal to s−1.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.S05513](https://doi.org/10.1351/goldbook.s05513)

**Qudtmatch:** [http://qudt.org/vocab/unit/SEC](http://qudt.org/vocab/unit/sec)

**Relations:** 

  - is_a [SIBaseUnit](#sibaseunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [TimeDimension](#timedimension)
  - [hasSymbolData](#hassymboldata) value "s"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Candela](#candela), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [SpecialUnit](#specialunit), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [Kelvin](#kelvin), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Kilogram](#kilogram), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [Mole](#mole), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### Mole
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_df6eeb01_1b41_4bd8_9257_a04fbd7cf000](http://emmo.info/emmo/middle/siunits#emmo_df6eeb01_1b41_4bd8_9257_a04fbd7cf000)

**Definition:** The mole, symbol mol, is the SI unit of amount of substance. One mole contains exactly 6.022 140 76 × 1023 elementary entities. This number is the fixed numerical value of the Avogadro constant, NA, when expressed in the unit mol−1 and is called the Avogadro number. The amount of substance, symbol n, of a system is a measure of the number of specified elementary entities. An elementary entity may be an atom, a molecule, an ion, an electron, any other particle or specified group of particles.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.M03980](https://doi.org/10.1351/goldbook.m03980)

**Qudtmatch:** [http://qudt.org/vocab/unit/MOL](http://qudt.org/vocab/unit/mol)

**Relations:** 

  - is_a [SIBaseUnit](#sibaseunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [AmountDimension](#amountdimension)
  - [hasSymbolData](#hassymboldata) value "mol"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [SpecialUnit](#specialunit), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [Kelvin](#kelvin), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Kilogram](#kilogram), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [LengthDimension](#lengthdimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Second](#second), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [Candela](#candela)






### SIBaseUnit
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_3a185e6c_9e19_4776_b583_19c978156aa0](http://emmo.info/emmo/middle/siunits#emmo_3a185e6c_9e19_4776_b583_19c978156aa0)

**Elucidation:** The base units in the SI system.

**Seealso:** [https://www.bipm.org/utils/common/pdf/si-brochure/SI-Brochure-9-EN.pdf](https://www.bipm.org/utils/common/pdf/si-brochure/si-brochure-9-en.pdf)

**Relations:** 

  - is_a [BaseUnit](#baseunit)
  - is_a [SIUnitSymbol](#siunitsymbol)
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [SpecialUnit](#specialunit), [Yocto](#yocto), [Equals](#equals), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Tera](#tera), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Exa](#exa), [Kilo](#kilo), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)
  - disjoint_union_of [Kelvin](#kelvin), [Second](#second), [Metre](#metre), [Candela](#candela), [Kilogram](#kilogram), [Ampere](#ampere), [Mole](#mole)






### Candela
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_8d00f093_3f45_4ea3_986c_b3545c3c2f4c](http://emmo.info/emmo/middle/siunits#emmo_8d00f093_3f45_4ea3_986c_b3545c3c2f4c)

**Definition:** The candela, symbol cd, is the SI unit of luminous intensity in a given direction. It is defined by taking the fixed numerical value of the luminous efficacy of monochromatic radiation of frequency 540×1012 Hz, Kcd, to be 683 when expressed in the unit lm W−1, which is equal to cd sr W−1, or cd sr kg−1 m−2 s3, where the kilogram, metre and second are defined in terms of h, c and $\nabla$$\upnu$Cs.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.C00787](https://doi.org/10.1351/goldbook.c00787)

**Qudtmatch:** [http://qudt.org/vocab/unit/CD](http://qudt.org/vocab/unit/cd)

**Relations:** 

  - is_a [SIBaseUnit](#sibaseunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [LuminousIntensityDimension](#luminousintensitydimension)
  - [hasSymbolData](#hassymboldata) value "cd"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [SpecialUnit](#specialunit), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [Kelvin](#kelvin), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Kilogram](#kilogram), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [Mole](#mole), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Second](#second), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






## SI Special Unit branch
![SI Special Unit branch.](genfigs/SISpecialUnitT.pdf){ width=352px }


### Watt
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_080052a1_f295_44be_a60f_1326ce13f1ba](http://emmo.info/emmo/middle/siunits#emmo_080052a1_f295_44be_a60f_1326ce13f1ba)

**Comment:** Measurement unit for power.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.W06656](https://doi.org/10.1351/goldbook.w06656)

**Qudtmatch:** [http://qudt.org/vocab/unit/W](http://qudt.org/vocab/unit/w)

**Relations:** 

  - is_a [SISpecialUnit](#sispecialunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension)
  - [hasSymbolData](#hassymboldata) value "W"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [Steradian](#steradian), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Henry](#henry), [Gradient](#gradient), [LatinSmallLetterA](#latinsmalllettera), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Becquerel](#becquerel), [Equals](#equals), [Newton](#newton), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Lux](#lux), [PhysicsBasedModel](#physicsbasedmodel), [Weber](#weber), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [Radian](#radian), [Volt](#volt), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [BaseUnit](#baseunit), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [DegreeCelsius](#degreecelsius), [Quantity](#quantity), [Multiplication](#multiplication), [MicroUnit](#microunit), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Ohm](#ohm), [Joule](#joule), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [Sievert](#sievert), [Gray](#gray), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Siemens](#siemens), [Katal](#katal), [Farad](#farad), [Lumen](#lumen), [Hertz](#hertz), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Pascal](#pascal), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [Coulomb](#coulomb), [Tesla](#tesla), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### Ohm
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_59c10c5c_47bd_4348_ba39_38836607dfa1](http://emmo.info/emmo/middle/siunits#emmo_59c10c5c_47bd_4348_ba39_38836607dfa1)

**Comment:** Measurement unit for resistance.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.O04280](https://doi.org/10.1351/goldbook.o04280)

**Qudtmatch:** [http://qudt.org/vocab/unit/OHM](http://qudt.org/vocab/unit/ohm)

**Relations:** 

  - is_a [SISpecialUnit](#sispecialunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension)
  - [hasSymbolData](#hassymboldata) value "Ω"
  - disjoint_with [Watt](#watt), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [Steradian](#steradian), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Henry](#henry), [Gradient](#gradient), [LatinSmallLetterA](#latinsmalllettera), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Becquerel](#becquerel), [Equals](#equals), [Newton](#newton), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Lux](#lux), [PhysicsBasedModel](#physicsbasedmodel), [Weber](#weber), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [Radian](#radian), [Volt](#volt), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [BaseUnit](#baseunit), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [DegreeCelsius](#degreecelsius), [Quantity](#quantity), [Multiplication](#multiplication), [MicroUnit](#microunit), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Joule](#joule), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [Sievert](#sievert), [Gray](#gray), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Siemens](#siemens), [Farad](#farad), [Katal](#katal), [Lumen](#lumen), [Hertz](#hertz), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Pascal](#pascal), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [Coulomb](#coulomb), [Tesla](#tesla), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### Gray
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_00199e76_69dc_45b6_a9c6_98cc90cdc0f5](http://emmo.info/emmo/middle/siunits#emmo_00199e76_69dc_45b6_a9c6_98cc90cdc0f5)

**Comment:** Measurement unit for absorbed dose.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.G02696](https://doi.org/10.1351/goldbook.g02696)

**Qudtmatch:** [http://qudt.org/vocab/unit/GRAY](http://qudt.org/vocab/unit/gray)

**Relations:** 

  - is_a [SISpecialUnit](#sispecialunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension)
  - [hasSymbolData](#hassymboldata) value "Gy"
  - disjoint_with [Watt](#watt), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [Steradian](#steradian), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Henry](#henry), [Gradient](#gradient), [LatinSmallLetterA](#latinsmalllettera), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Becquerel](#becquerel), [Equals](#equals), [Newton](#newton), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Lux](#lux), [PhysicsBasedModel](#physicsbasedmodel), [Weber](#weber), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [Radian](#radian), [Volt](#volt), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [BaseUnit](#baseunit), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [DegreeCelsius](#degreecelsius), [Quantity](#quantity), [Multiplication](#multiplication), [MicroUnit](#microunit), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Ohm](#ohm), [Joule](#joule), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [Sievert](#sievert), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Siemens](#siemens), [Katal](#katal), [Farad](#farad), [Lumen](#lumen), [Hertz](#hertz), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Pascal](#pascal), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [Coulomb](#coulomb), [Tesla](#tesla), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### Joule
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_8a70dea4_d6ab_4260_b931_a3e990982416](http://emmo.info/emmo/middle/siunits#emmo_8a70dea4_d6ab_4260_b931_a3e990982416)

**Comment:** Measurement unit for energy.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.J03363](https://doi.org/10.1351/goldbook.j03363)

**Qudtmatch:** [http://qudt.org/vocab/unit/J](http://qudt.org/vocab/unit/j)

**Relations:** 

  - is_a [SISpecialUnit](#sispecialunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension)
  - [hasSymbolData](#hassymboldata) value "J"
  - disjoint_with [Watt](#watt), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [Steradian](#steradian), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Henry](#henry), [Gradient](#gradient), [LatinSmallLetterA](#latinsmalllettera), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Becquerel](#becquerel), [Equals](#equals), [Newton](#newton), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Lux](#lux), [PhysicsBasedModel](#physicsbasedmodel), [Weber](#weber), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [Radian](#radian), [Volt](#volt), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [BaseUnit](#baseunit), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [DegreeCelsius](#degreecelsius), [Quantity](#quantity), [Multiplication](#multiplication), [MicroUnit](#microunit), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Ohm](#ohm), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [Sievert](#sievert), [Gray](#gray), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Siemens](#siemens), [Farad](#farad), [Katal](#katal), [Lumen](#lumen), [Hertz](#hertz), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Pascal](#pascal), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [Coulomb](#coulomb), [Tesla](#tesla), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### SISpecialUnit
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_e9ffc696_5228_4ff9_8a60_0f5e05e9931b](http://emmo.info/emmo/middle/siunits#emmo_e9ffc696_5228_4ff9_8a60_0f5e05e9931b)

**Elucidation:** The 22 derived units that are given a special name in the SI system that stands for units derived by SI base units.

**Comment:** These units are SI coherent by definition.

**Wikipediaentry:** [https://en.wikipedia.org/wiki/International_System_of_Units#Derived_units](https://en.wikipedia.org/wiki/international_system_of_units#derived_units)

**Relations:** 

  - is_a [SpecialUnit](#specialunit)
  - is_a [SIUnitSymbol](#siunitsymbol)
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [BaseUnit](#baseunit), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [LengthDimension](#lengthdimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Kilo](#kilo), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [Exa](#exa)
  - disjoint_union_of [Gray](#gray), [Watt](#watt), [Katal](#katal), [Ohm](#ohm), [Coulomb](#coulomb), [Joule](#joule), [Radian](#radian), [Pascal](#pascal), [Farad](#farad), [Newton](#newton), [Tesla](#tesla), [DegreeCelsius](#degreecelsius), [Becquerel](#becquerel), [Steradian](#steradian), [Lumen](#lumen), [Weber](#weber), [Lux](#lux), [Sievert](#sievert), [Volt](#volt), [Hertz](#hertz), [Siemens](#siemens), [Henry](#henry)






### Steradian
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_cf3dd6cc_c5d6_4b3d_aef4_82f3b7a361af](http://emmo.info/emmo/middle/siunits#emmo_cf3dd6cc_c5d6_4b3d_aef4_82f3b7a361af)

**Elucidation:** Dimensionless measurement unit for solid angle.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.S05971](https://doi.org/10.1351/goldbook.s05971)

**Qudtmatch:** [http://qudt.org/vocab/unit/SR](http://qudt.org/vocab/unit/sr)

**Relations:** 

  - is_a [SISpecialUnit](#sispecialunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [DimensionOne](#dimensionone)
  - [hasSymbolData](#hassymboldata) value "sr"
  - disjoint_with [Watt](#watt), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Henry](#henry), [Gradient](#gradient), [LatinSmallLetterA](#latinsmalllettera), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Becquerel](#becquerel), [Equals](#equals), [Newton](#newton), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Lux](#lux), [PhysicsBasedModel](#physicsbasedmodel), [Weber](#weber), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [Radian](#radian), [Volt](#volt), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [BaseUnit](#baseunit), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [Quantity](#quantity), [MicroUnit](#microunit), [DegreeCelsius](#degreecelsius), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Ohm](#ohm), [Joule](#joule), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [Gray](#gray), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Siemens](#siemens), [Katal](#katal), [Farad](#farad), [Lumen](#lumen), [Hertz](#hertz), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Pascal](#pascal), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [Coulomb](#coulomb), [LatinCapitalLetterA](#latincapitallettera), [Tesla](#tesla), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [Sievert](#sievert), [LengthDimension](#lengthdimension)






### Henry
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_fab003c8_f7a6_4346_9988_7161325ed7a3](http://emmo.info/emmo/middle/siunits#emmo_fab003c8_f7a6_4346_9988_7161325ed7a3)

**Comment:** Measurement unit for electrical inductance.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.H02782](https://doi.org/10.1351/goldbook.h02782)

**Qudtmatch:** [http://qudt.org/vocab/unit/H](http://qudt.org/vocab/unit/h)

**Relations:** 

  - is_a [SISpecialUnit](#sispecialunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension)
  - [hasSymbolData](#hassymboldata) value "H"
  - disjoint_with [Watt](#watt), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [Steradian](#steradian), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Becquerel](#becquerel), [Equals](#equals), [Newton](#newton), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Lux](#lux), [PhysicsBasedModel](#physicsbasedmodel), [Weber](#weber), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [Radian](#radian), [Volt](#volt), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [BaseUnit](#baseunit), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [Quantity](#quantity), [MicroUnit](#microunit), [DegreeCelsius](#degreecelsius), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Ohm](#ohm), [Joule](#joule), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [Gray](#gray), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Siemens](#siemens), [Katal](#katal), [Farad](#farad), [Lumen](#lumen), [Hertz](#hertz), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Pascal](#pascal), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [Coulomb](#coulomb), [LatinCapitalLetterA](#latincapitallettera), [Tesla](#tesla), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [Sievert](#sievert), [LengthDimension](#lengthdimension)






### Becquerel
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_b71e4ba5_8f73_4199_8c96_7ea7f94d9e2a](http://emmo.info/emmo/middle/siunits#emmo_b71e4ba5_8f73_4199_8c96_7ea7f94d9e2a)

**Definition:** Radioactive decays per second.

**Comment:** Unit for radioactive activity.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.B00624](https://doi.org/10.1351/goldbook.b00624)

**Qudtmatch:** [http://qudt.org/vocab/unit/BQ](http://qudt.org/vocab/unit/bq)

**Relations:** 

  - is_a [SISpecialUnit](#sispecialunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [PerTimeDimension](#pertimedimension)
  - [hasSymbolData](#hassymboldata) value "Bq"
  - disjoint_with [Watt](#watt), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [Steradian](#steradian), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Henry](#henry), [Gradient](#gradient), [LatinSmallLetterA](#latinsmalllettera), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [Newton](#newton), [Lux](#lux), [PhysicsBasedModel](#physicsbasedmodel), [Weber](#weber), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [Radian](#radian), [Volt](#volt), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [BaseUnit](#baseunit), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [Quantity](#quantity), [MicroUnit](#microunit), [DegreeCelsius](#degreecelsius), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Ohm](#ohm), [Joule](#joule), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [Gray](#gray), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Siemens](#siemens), [Katal](#katal), [Farad](#farad), [Lumen](#lumen), [Hertz](#hertz), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Pascal](#pascal), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [Coulomb](#coulomb), [LatinCapitalLetterA](#latincapitallettera), [Tesla](#tesla), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [Sievert](#sievert), [LengthDimension](#lengthdimension)






### Siemens
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_f2523820_04a6_44ab_bb67_8237dda2b0c2](http://emmo.info/emmo/middle/siunits#emmo_f2523820_04a6_44ab_bb67_8237dda2b0c2)

**Comment:** Measurement unit for electrical conductance.

**Relations:** 

  - is_a [SISpecialUnit](#sispecialunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension)
  - [hasSymbolData](#hassymboldata) value "S"
  - disjoint_with [Watt](#watt), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [Steradian](#steradian), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Henry](#henry), [Gradient](#gradient), [LatinSmallLetterA](#latinsmalllettera), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Becquerel](#becquerel), [Equals](#equals), [Newton](#newton), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Lux](#lux), [PhysicsBasedModel](#physicsbasedmodel), [Weber](#weber), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [Radian](#radian), [Volt](#volt), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [BaseUnit](#baseunit), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [Quantity](#quantity), [MicroUnit](#microunit), [DegreeCelsius](#degreecelsius), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Ohm](#ohm), [Joule](#joule), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [Gray](#gray), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Katal](#katal), [Farad](#farad), [Lumen](#lumen), [Hertz](#hertz), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Pascal](#pascal), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [Coulomb](#coulomb), [LatinCapitalLetterA](#latincapitallettera), [Tesla](#tesla), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [Sievert](#sievert), [LengthDimension](#lengthdimension)






### Newton
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_a979c531_f9fa_4a6e_93c1.0.0-alpha2960241ca6](http://emmo.info/emmo/middle/siunits#emmo_a979c531_f9fa_4a6e_93c1.0.0-alpha2960241ca6)

**Comment:** Measurement unit for force.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.N04135](https://doi.org/10.1351/goldbook.n04135)

**Qudtmatch:** [http://qudt.org/vocab/unit/N](http://qudt.org/vocab/unit/n)

**Relations:** 

  - is_a [SISpecialUnit](#sispecialunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension)
  - [hasSymbolData](#hassymboldata) value "N"
  - disjoint_with [Watt](#watt), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [Steradian](#steradian), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Henry](#henry), [Gradient](#gradient), [LatinSmallLetterA](#latinsmalllettera), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Becquerel](#becquerel), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Lux](#lux), [PhysicsBasedModel](#physicsbasedmodel), [Weber](#weber), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [Radian](#radian), [Volt](#volt), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [BaseUnit](#baseunit), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [DegreeCelsius](#degreecelsius), [Quantity](#quantity), [Multiplication](#multiplication), [MicroUnit](#microunit), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Ohm](#ohm), [Joule](#joule), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [Sievert](#sievert), [Gray](#gray), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Siemens](#siemens), [Katal](#katal), [Farad](#farad), [Lumen](#lumen), [Hertz](#hertz), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Pascal](#pascal), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [Coulomb](#coulomb), [Tesla](#tesla), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### Katal
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_33b67e69_3645_4c73_b100_5ea6759221b4](http://emmo.info/emmo/middle/siunits#emmo_33b67e69_3645_4c73_b100_5ea6759221b4)

**Comment:** Measurement unit for catalytic activity.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.K03372](https://doi.org/10.1351/goldbook.k03372)

**Qudtmatch:** [http://qudt.org/vocab/unit/KAT](http://qudt.org/vocab/unit/kat)

**Relations:** 

  - is_a [SISpecialUnit](#sispecialunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [AmountPerTimeDimension](#amountpertimedimension)
  - [hasSymbolData](#hassymboldata) value "kat"
  - disjoint_with [Watt](#watt), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [Steradian](#steradian), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Henry](#henry), [Gradient](#gradient), [LatinSmallLetterA](#latinsmalllettera), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Becquerel](#becquerel), [Equals](#equals), [Newton](#newton), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Lux](#lux), [PhysicsBasedModel](#physicsbasedmodel), [Weber](#weber), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [Radian](#radian), [Volt](#volt), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [BaseUnit](#baseunit), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [DegreeCelsius](#degreecelsius), [Quantity](#quantity), [Multiplication](#multiplication), [MicroUnit](#microunit), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Ohm](#ohm), [Joule](#joule), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [Sievert](#sievert), [Gray](#gray), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Siemens](#siemens), [Farad](#farad), [Lumen](#lumen), [Hertz](#hertz), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Pascal](#pascal), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [Coulomb](#coulomb), [Tesla](#tesla), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### Farad
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_a9201b2f_e6de_442a_b3a6_d291.0.0-alpha2a582](http://emmo.info/emmo/middle/siunits#emmo_a9201b2f_e6de_442a_b3a6_d291.0.0-alpha2a582)

**Comment:** Measurement unit for electric capacitance.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.F02320](https://doi.org/10.1351/goldbook.f02320)

**Qudtmatch:** [http://qudt.org/vocab/unit/FARAD](http://qudt.org/vocab/unit/farad)

**Relations:** 

  - is_a [SISpecialUnit](#sispecialunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension)
  - [hasSymbolData](#hassymboldata) value "F"
  - disjoint_with [Watt](#watt), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [Steradian](#steradian), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Henry](#henry), [Gradient](#gradient), [LatinSmallLetterA](#latinsmalllettera), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Becquerel](#becquerel), [Equals](#equals), [Newton](#newton), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Lux](#lux), [PhysicsBasedModel](#physicsbasedmodel), [Weber](#weber), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [Radian](#radian), [Volt](#volt), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [BaseUnit](#baseunit), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [DegreeCelsius](#degreecelsius), [Quantity](#quantity), [Multiplication](#multiplication), [MicroUnit](#microunit), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Ohm](#ohm), [Joule](#joule), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [Sievert](#sievert), [Gray](#gray), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Siemens](#siemens), [Katal](#katal), [Lumen](#lumen), [Hertz](#hertz), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Pascal](#pascal), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [Coulomb](#coulomb), [Tesla](#tesla), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### Lux
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_da1dd4a7_c611_4ad4_bef6_7646f28aa598](http://emmo.info/emmo/middle/siunits#emmo_da1dd4a7_c611_4ad4_bef6_7646f28aa598)

**Comment:** Measurement unit for illuminance.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.L03651](https://doi.org/10.1351/goldbook.l03651)

**Qudtmatch:** [http://qudt.org/vocab/unit/LUX](http://qudt.org/vocab/unit/lux)

**Relations:** 

  - is_a [SISpecialUnit](#sispecialunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension)
  - [hasSymbolData](#hassymboldata) value "lx"
  - disjoint_with [Watt](#watt), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [Steradian](#steradian), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Henry](#henry), [Gradient](#gradient), [LatinSmallLetterA](#latinsmalllettera), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Becquerel](#becquerel), [Equals](#equals), [Newton](#newton), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Weber](#weber), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [Radian](#radian), [Volt](#volt), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [BaseUnit](#baseunit), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [Quantity](#quantity), [MicroUnit](#microunit), [DegreeCelsius](#degreecelsius), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Ohm](#ohm), [Joule](#joule), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [Gray](#gray), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Siemens](#siemens), [Katal](#katal), [Farad](#farad), [Lumen](#lumen), [Hertz](#hertz), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Pascal](#pascal), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [Coulomb](#coulomb), [LatinCapitalLetterA](#latincapitallettera), [Tesla](#tesla), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [Sievert](#sievert), [LengthDimension](#lengthdimension)






### Weber
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_d7f11b34_a121_4519_87c0_aa754f1c4737](http://emmo.info/emmo/middle/siunits#emmo_d7f11b34_a121_4519_87c0_aa754f1c4737)

**Comment:** Measurement unit for magnetic flux.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.W06666](https://doi.org/10.1351/goldbook.w06666)

**Qudtmatch:** [http://qudt.org/vocab/unit/WB](http://qudt.org/vocab/unit/wb)

**Relations:** 

  - is_a [SISpecialUnit](#sispecialunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension)
  - [hasSymbolData](#hassymboldata) value "Wb"
  - disjoint_with [Watt](#watt), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [Steradian](#steradian), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Henry](#henry), [Gradient](#gradient), [LatinSmallLetterA](#latinsmalllettera), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Becquerel](#becquerel), [Equals](#equals), [Newton](#newton), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Lux](#lux), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [Radian](#radian), [Volt](#volt), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [BaseUnit](#baseunit), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [Quantity](#quantity), [MicroUnit](#microunit), [DegreeCelsius](#degreecelsius), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Ohm](#ohm), [Joule](#joule), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [Gray](#gray), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Siemens](#siemens), [Katal](#katal), [Farad](#farad), [Lumen](#lumen), [Hertz](#hertz), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Pascal](#pascal), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [Coulomb](#coulomb), [LatinCapitalLetterA](#latincapitallettera), [Tesla](#tesla), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [Sievert](#sievert), [LengthDimension](#lengthdimension)






### Lumen
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_d7b7fd1e_645a_42cb_8f40_85f0d034d3ae](http://emmo.info/emmo/middle/siunits#emmo_d7b7fd1e_645a_42cb_8f40_85f0d034d3ae)

**Comment:** Measurement unit for luminous flux.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.L03639](https://doi.org/10.1351/goldbook.l03639)

**Qudtmatch:** [http://qudt.org/vocab/unit/LM](http://qudt.org/vocab/unit/lm)

**Relations:** 

  - is_a [SISpecialUnit](#sispecialunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [LuminousIntensityDimension](#luminousintensitydimension)
  - [hasSymbolData](#hassymboldata) value "lm"
  - disjoint_with [Watt](#watt), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [Steradian](#steradian), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Henry](#henry), [Gradient](#gradient), [LatinSmallLetterA](#latinsmalllettera), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Becquerel](#becquerel), [Equals](#equals), [Newton](#newton), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Lux](#lux), [PhysicsBasedModel](#physicsbasedmodel), [Weber](#weber), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [Radian](#radian), [Volt](#volt), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [BaseUnit](#baseunit), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [Quantity](#quantity), [MicroUnit](#microunit), [DegreeCelsius](#degreecelsius), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Ohm](#ohm), [Joule](#joule), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [Gray](#gray), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Siemens](#siemens), [Katal](#katal), [Farad](#farad), [Hertz](#hertz), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Pascal](#pascal), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [Coulomb](#coulomb), [LatinCapitalLetterA](#latincapitallettera), [Tesla](#tesla), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [Sievert](#sievert), [LengthDimension](#lengthdimension)






### Hertz
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_e75f580e_52bf_4dd5_af70_df409cec08fd](http://emmo.info/emmo/middle/siunits#emmo_e75f580e_52bf_4dd5_af70_df409cec08fd)

**Comment:** Measurement unit for frequence.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.H02785](https://doi.org/10.1351/goldbook.h02785)

**Qudtmatch:** [http://qudt.org/vocab/unit/HZ](http://qudt.org/vocab/unit/hz)

**Relations:** 

  - is_a [SISpecialUnit](#sispecialunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [PerTimeDimension](#pertimedimension)
  - [hasSymbolData](#hassymboldata) value "Hz"
  - disjoint_with [Watt](#watt), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [Steradian](#steradian), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Henry](#henry), [Gradient](#gradient), [LatinSmallLetterA](#latinsmalllettera), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Becquerel](#becquerel), [Equals](#equals), [Newton](#newton), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Lux](#lux), [PhysicsBasedModel](#physicsbasedmodel), [Weber](#weber), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [Radian](#radian), [Volt](#volt), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [BaseUnit](#baseunit), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [Quantity](#quantity), [MicroUnit](#microunit), [DegreeCelsius](#degreecelsius), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Ohm](#ohm), [Joule](#joule), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [Gray](#gray), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Siemens](#siemens), [Katal](#katal), [Farad](#farad), [Lumen](#lumen), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Pascal](#pascal), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [Coulomb](#coulomb), [LatinCapitalLetterA](#latincapitallettera), [Tesla](#tesla), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [Sievert](#sievert), [LengthDimension](#lengthdimension)






### Radian
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_a121bb1d_5225_4c78_809b_0268c3012208](http://emmo.info/emmo/middle/siunits#emmo_a121bb1d_5225_4c78_809b_0268c3012208)

**Elucidation:** Measure of plane angle.

**Comment:** Dimensionless measurement unit for plane angle.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.R05036](https://doi.org/10.1351/goldbook.r05036)

**Qudtmatch:** [http://qudt.org/vocab/unit/RAD](http://qudt.org/vocab/unit/rad)

**Relations:** 

  - is_a [SISpecialUnit](#sispecialunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [DimensionOne](#dimensionone)
  - [hasSymbolData](#hassymboldata) value "rad"
  - disjoint_with [Watt](#watt), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [Steradian](#steradian), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Henry](#henry), [Gradient](#gradient), [LatinSmallLetterA](#latinsmalllettera), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Becquerel](#becquerel), [Equals](#equals), [Newton](#newton), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Lux](#lux), [PhysicsBasedModel](#physicsbasedmodel), [Weber](#weber), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [Volt](#volt), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [BaseUnit](#baseunit), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [DegreeCelsius](#degreecelsius), [Quantity](#quantity), [Multiplication](#multiplication), [MicroUnit](#microunit), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Ohm](#ohm), [Joule](#joule), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [Sievert](#sievert), [Gray](#gray), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Siemens](#siemens), [Farad](#farad), [Katal](#katal), [Lumen](#lumen), [Hertz](#hertz), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Pascal](#pascal), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [Coulomb](#coulomb), [Tesla](#tesla), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### Pascal
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_a80dc6f5_b1aa_41a7_a3a8_cd5040da2162](http://emmo.info/emmo/middle/siunits#emmo_a80dc6f5_b1aa_41a7_a3a8_cd5040da2162)

**Comment:** Measurement unit for pressure.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.P04442](https://doi.org/10.1351/goldbook.p04442)

**Qudtmatch:** [http://qudt.org/vocab/unit/PA](http://qudt.org/vocab/unit/pa)

**Relations:** 

  - is_a [SISpecialUnit](#sispecialunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension)
  - [hasSymbolData](#hassymboldata) value "Pa"
  - disjoint_with [Watt](#watt), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [Steradian](#steradian), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Henry](#henry), [Gradient](#gradient), [LatinSmallLetterA](#latinsmalllettera), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Becquerel](#becquerel), [Equals](#equals), [Newton](#newton), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Lux](#lux), [PhysicsBasedModel](#physicsbasedmodel), [Weber](#weber), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [Radian](#radian), [Volt](#volt), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [BaseUnit](#baseunit), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [DegreeCelsius](#degreecelsius), [Quantity](#quantity), [Multiplication](#multiplication), [MicroUnit](#microunit), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Ohm](#ohm), [Joule](#joule), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [Sievert](#sievert), [Gray](#gray), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Siemens](#siemens), [Farad](#farad), [Katal](#katal), [Lumen](#lumen), [Hertz](#hertz), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [Coulomb](#coulomb), [Tesla](#tesla), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### DegreeCelsius
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_b20be325_8bfd_4237_bee7_201ab0fd9c75](http://emmo.info/emmo/middle/siunits#emmo_b20be325_8bfd_4237_bee7_201ab0fd9c75)

**Comment:** Measurement unit for Celsius temperature. This unit can only be used for expressing temperature differences.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.D01561](https://doi.org/10.1351/goldbook.d01561)

**Qudtmatch:** [http://qudt.org/vocab/unit/DEG_C](http://qudt.org/vocab/unit/deg_c)

**Relations:** 

  - is_a [SISpecialUnit](#sispecialunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [TemperatureDimension](#temperaturedimension)
  - [hasSymbolData](#hassymboldata) value "°C"
  - disjoint_with [Watt](#watt), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [Steradian](#steradian), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Henry](#henry), [Gradient](#gradient), [LatinSmallLetterA](#latinsmalllettera), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Becquerel](#becquerel), [Equals](#equals), [Newton](#newton), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Lux](#lux), [PhysicsBasedModel](#physicsbasedmodel), [Weber](#weber), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [Radian](#radian), [Volt](#volt), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [BaseUnit](#baseunit), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [Quantity](#quantity), [MicroUnit](#microunit), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Ohm](#ohm), [Joule](#joule), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [Gray](#gray), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Siemens](#siemens), [Katal](#katal), [Farad](#farad), [Lumen](#lumen), [Hertz](#hertz), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Pascal](#pascal), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [Coulomb](#coulomb), [LatinCapitalLetterA](#latincapitallettera), [Tesla](#tesla), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [Sievert](#sievert), [LengthDimension](#lengthdimension)






### Volt
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_e2207e91_02b0_4a8a_b13e_61d2a2a839f1](http://emmo.info/emmo/middle/siunits#emmo_e2207e91_02b0_4a8a_b13e_61d2a2a839f1)

**Comment:** Measurement unit for voltage.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.V06634](https://doi.org/10.1351/goldbook.v06634)

**Qudtmatch:** [http://qudt.org/vocab/unit/V](http://qudt.org/vocab/unit/v)

**Relations:** 

  - is_a [SISpecialUnit](#sispecialunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension)
  - [hasSymbolData](#hassymboldata) value "V"
  - disjoint_with [Watt](#watt), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [Steradian](#steradian), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Henry](#henry), [Gradient](#gradient), [LatinSmallLetterA](#latinsmalllettera), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Becquerel](#becquerel), [Equals](#equals), [Newton](#newton), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Lux](#lux), [PhysicsBasedModel](#physicsbasedmodel), [Weber](#weber), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [Radian](#radian), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [BaseUnit](#baseunit), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [DegreeCelsius](#degreecelsius), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Ohm](#ohm), [Joule](#joule), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [Gray](#gray), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Siemens](#siemens), [Katal](#katal), [Farad](#farad), [Lumen](#lumen), [Hertz](#hertz), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Pascal](#pascal), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [Coulomb](#coulomb), [LatinCapitalLetterA](#latincapitallettera), [Tesla](#tesla), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [Sievert](#sievert), [LengthDimension](#lengthdimension)






### Tesla
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_acb50123_87a2_4753_b36c_f87114ad4de2](http://emmo.info/emmo/middle/siunits#emmo_acb50123_87a2_4753_b36c_f87114ad4de2)

**Comment:** Measurement unit for magnetic flux density or induction.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.T06283](https://doi.org/10.1351/goldbook.t06283)

**Qudtmatch:** [http://qudt.org/vocab/unit/T](http://qudt.org/vocab/unit/t)

**Relations:** 

  - is_a [SISpecialUnit](#sispecialunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension)
  - [hasSymbolData](#hassymboldata) value "T"
  - disjoint_with [Watt](#watt), [Gradient](#gradient), [Newton](#newton), [Lux](#lux), [Weber](#weber), [Minus](#minus), [Volt](#volt), [BaseUnit](#baseunit), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [Ohm](#ohm), [Joule](#joule), [Hertz](#hertz), [Pascal](#pascal), [PerTimeDimension](#pertimedimension), [MassDimension](#massdimension), [Void](#void), [Exa](#exa), [LengthDimension](#lengthdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Steradian](#steradian), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [Equals](#equals), [Yotta](#yotta), [Giga](#giga), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [Quantity](#quantity), [Mega](#mega), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [Plus](#plus), [Siemens](#siemens), [Katal](#katal), [Farad](#farad), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Coulomb](#coulomb), [TimeCurrentDimension](#timecurrentdimension), [Zetta](#zetta), [AmountDimension](#amountdimension), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Becquerel](#becquerel), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Pico](#pico), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [Deka](#deka), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [Kilo](#kilo), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Sievert](#sievert), [Hecto](#hecto), [LatinSmallLetterM](#latinsmallletterm), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Henry](#henry), [Peta](#peta), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Radian](#radian), [DegreeCelsius](#degreecelsius), [Multiplication](#multiplication), [MicroUnit](#microunit), [Femto](#femto), [Gray](#gray), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [DimensionOne](#dimensionone), [Lumen](#lumen), [Centi](#centi), [Nano](#nano), [Zepto](#zepto), [LatinSmallLetterA](#latinsmalllettera), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension)






### Coulomb
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_696ed548_9477_45ea_993c_6a8f5271914a](http://emmo.info/emmo/middle/siunits#emmo_696ed548_9477_45ea_993c_6a8f5271914a)

**Comment:** Measurement unit for electric charge.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.C01365](https://doi.org/10.1351/goldbook.c01365)

**Qudtmatch:** [http://qudt.org/vocab/unit/C](http://qudt.org/vocab/unit/c)

**Relations:** 

  - is_a [SISpecialUnit](#sispecialunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [TimeCurrentDimension](#timecurrentdimension)
  - [hasSymbolData](#hassymboldata) value "C"
  - disjoint_with [Watt](#watt), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [Steradian](#steradian), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Henry](#henry), [Gradient](#gradient), [LatinSmallLetterA](#latinsmalllettera), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Becquerel](#becquerel), [Equals](#equals), [Newton](#newton), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Lux](#lux), [PhysicsBasedModel](#physicsbasedmodel), [Weber](#weber), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [Radian](#radian), [Volt](#volt), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [BaseUnit](#baseunit), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [DegreeCelsius](#degreecelsius), [Quantity](#quantity), [Multiplication](#multiplication), [MicroUnit](#microunit), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Joule](#joule), [Ohm](#ohm), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [Sievert](#sievert), [Gray](#gray), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Siemens](#siemens), [Farad](#farad), [Katal](#katal), [Lumen](#lumen), [Hertz](#hertz), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Pascal](#pascal), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [Tesla](#tesla), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### Sievert
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_dc232f53_8ed8_4ddd_9f41_cc057985eadb](http://emmo.info/emmo/middle/siunits#emmo_dc232f53_8ed8_4ddd_9f41_cc057985eadb)

**Comment:** Measurement unit for equivalent doseof ionizing radiation. 

Sievert is derived from absorbed dose, but takes into account the biological effectiveness of the radiation, which is dependent on the radiation type and energy.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.S05658](https://doi.org/10.1351/goldbook.s05658)

**Qudtmatch:** [http://qudt.org/vocab/unit/SV](http://qudt.org/vocab/unit/sv)

**Wikipediaentry:** [https://en.wikipedia.org/wiki/Equivalent_dose](https://en.wikipedia.org/wiki/equivalent_dose)

**Relations:** 

  - is_a [SISpecialUnit](#sispecialunit)
  - [hasPhysicsDimension](#hasphysicsdimension) some [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension)
  - [hasSymbolData](#hassymboldata) value "Sv"
  - disjoint_with [Watt](#watt), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [Steradian](#steradian), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Henry](#henry), [Gradient](#gradient), [LatinSmallLetterA](#latinsmalllettera), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [SICoherentDerivedUnit](#sicoherentderivedunit), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Becquerel](#becquerel), [Equals](#equals), [Newton](#newton), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Lux](#lux), [PhysicsBasedModel](#physicsbasedmodel), [Weber](#weber), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [Radian](#radian), [Volt](#volt), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [BaseUnit](#baseunit), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [Quantity](#quantity), [MicroUnit](#microunit), [DegreeCelsius](#degreecelsius), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Ohm](#ohm), [Joule](#joule), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [Gray](#gray), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Siemens](#siemens), [Katal](#katal), [Farad](#farad), [Lumen](#lumen), [Hertz](#hertz), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Pascal](#pascal), [SINonCoherentUnit](#sinoncoherentunit), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [Coulomb](#coulomb), [LatinCapitalLetterA](#latincapitallettera), [Tesla](#tesla), [MassDimension](#massdimension), [SIMetricPrefix](#simetricprefix), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






## Prefixed Unit branch
![Prefixed Unit branch.](genfigs/PrefixedUnitT.pdf){ width=666px }


### PrefixedUnit
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_c6d4a5e0_7e95_44df_a6db_84ee0a8bbc8e](http://emmo.info/emmo/middle/metrology#emmo_c6d4a5e0_7e95_44df_a6db_84ee0a8bbc8e)

**Elucidation:** A measurement unit that is made of a metric prefix and a unit symbol.

**Relations:** 

  - is_a [MeasurementUnit](#measurementunit)
  - is_a [State](#state)
  - [hasSpatialDirectPart](#hasspatialdirectpart) only ([UnitSymbol](#unitsymbol) or [MetricPrefix](#metricprefix))
  - [hasSpatialDirectPart](#hasspatialdirectpart) exactly 1 [UnitSymbol](#unitsymbol)
  - [hasSpatialDirectPart](#hasspatialdirectpart) exactly 1 [MetricPrefix](#metricprefix)
  - disjoint_with [Collection](#collection), [PhysicsEquation](#physicsequation), [MaterialRelation](#materialrelation), [Quantum](#quantum), [NonPrefixedUnit](#nonprefixedunit), [ArithmeticExpression](#arithmeticexpression), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)
  - disjoint_union_of [MultipleUnit](#multipleunit), [SubMultipleUnit](#submultipleunit)






### SubMultipleUnit
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_a2f94f33_71fa_443c_a1fb_d1685fc537ec](http://emmo.info/emmo/middle/metrology#emmo_a2f94f33_71fa_443c_a1fb_d1685fc537ec)

**Relations:** 

  - is_a [PrefixedUnit](#prefixedunit)
  - disjoint_with [Collection](#collection), [PhysicsEquation](#physicsequation), [MaterialRelation](#materialrelation), [Quantum](#quantum), [NonPrefixedUnit](#nonprefixedunit), [MultipleUnit](#multipleunit), [ArithmeticExpression](#arithmeticexpression), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### SIPrefixedUnit
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_d41ce84b_4317_41fb_a5d1_6cd281fca106](http://emmo.info/emmo/middle/siunits#emmo_d41ce84b_4317_41fb_a5d1_6cd281fca106)

**Elucidation:** A SI base or special unit with a metric prefix.

**Comment:** The presence of the prefix makes this units non-coherent with SI system.

**Relations:** 

  - is_a [PrefixedUnit](#prefixedunit)
  - is_a [SINonCoherentUnit](#sinoncoherentunit)
  - [hasSpatialDirectPart](#hasspatialdirectpart) exactly 1 [SIUnitSymbol](#siunitsymbol)
  - disjoint_with [Collection](#collection), [PhysicsEquation](#physicsequation), [AvogadroConstant](#avogadroconstant), [MaterialRelation](#materialrelation), [SINonCoherentDerivedUnit](#sinoncoherentderivedunit), [Quantum](#quantum), [LuminousEfficacy](#luminousefficacy), [ArithmeticExpression](#arithmeticexpression), [NonPrefixedUnit](#nonprefixedunit), [BoltzmannConstant](#boltzmannconstant), [SICoherentUnit](#sicoherentunit), [PlanckConstant](#planckconstant), [SpeedOfLightInVacuum](#speedoflightinvacuum), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### MultipleUnit
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_62f0d847_3603_45b4_bfc4_dd4511355ff2](http://emmo.info/emmo/middle/metrology#emmo_62f0d847_3603_45b4_bfc4_dd4511355ff2)

**Relations:** 

  - is_a [PrefixedUnit](#prefixedunit)
  - disjoint_with [Collection](#collection), [PhysicsEquation](#physicsequation), [MaterialRelation](#materialrelation), [SubMultipleUnit](#submultipleunit), [Quantum](#quantum), [NonPrefixedUnit](#nonprefixedunit), [ArithmeticExpression](#arithmeticexpression), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






## Metric Prefix branch
![Metric Prefix branch.](genfigs/MetricPrefixT.pdf){ width=460px }


### Hecto
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_21aaefc1_3f86_4208_b7db_a755f31f0f8c](http://emmo.info/emmo/middle/siunits#emmo_21aaefc1_3f86_4208_b7db_a755f31f0f8c)

**Relations:** 

  - is_a [SIMetricPrefix](#simetricprefix)
  - Inverse([hasVariable](#hasvariable)) only [hasNumericalData](#hasnumericaldata) value 100.0
  - [hasSymbolData](#hassymboldata) value "h"
  - disjoint_with [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Tera](#tera), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Exa](#exa), [Kilo](#kilo), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### MetricPrefix
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_7d2afa66_ae9e_4095_a9bf_421d0be401b6](http://emmo.info/emmo/middle/metrology#emmo_7d2afa66_ae9e_4095_a9bf_421d0be401b6)

**Elucidation:** Dimensionless multiplicative unit prefix.

**Seealso:** [https://en.wikipedia.org/wiki/Metric_prefix](https://en.wikipedia.org/wiki/metric_prefix)

**Relations:** 

  - is_a [MathematicalSymbol](#mathematicalsymbol)
  - is_a [Constant](#constant)
  - is_a [MetrologicalSymbol](#metrologicalsymbol)
  - is_a [Metrological](#metrological)
  - is_a [Symbol](#symbol)
  - disjoint_with [Collection](#collection), [Equation](#equation), [PhysicsBasedModel](#physicsbasedmodel), [Quantity](#quantity), [PrefixedUnit](#prefixedunit), [Void](#void)






### Deka
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_1d8b370b_c672_4d0c_964e_eaafcbf2f51f](http://emmo.info/emmo/middle/siunits#emmo_1d8b370b_c672_4d0c_964e_eaafcbf2f51f)

**Relations:** 

  - is_a [SIMetricPrefix](#simetricprefix)
  - Inverse([hasVariable](#hasvariable)) only [hasNumericalData](#hasnumericaldata) value 10.0
  - [hasSymbolData](#hassymboldata) value "da"
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Tera](#tera), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Exa](#exa), [Kilo](#kilo), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### Zetta
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_daa9ee97_4c5f_42e5_918c_44d7523e8958](http://emmo.info/emmo/middle/siunits#emmo_daa9ee97_4c5f_42e5_918c_44d7523e8958)

**Relations:** 

  - is_a [SIMetricPrefix](#simetricprefix)
  - Inverse([hasVariable](#hasvariable)) only [hasNumericalData](#hasnumericaldata) value 1e+21
  - [hasSymbolData](#hassymboldata) value "Z"
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Tera](#tera), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [LengthDimension](#lengthdimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Kilo](#kilo), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [Exa](#exa)






### Peta
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_43a6b269_da31_4bb6_a537_c97df4fff32a](http://emmo.info/emmo/middle/siunits#emmo_43a6b269_da31_4bb6_a537_c97df4fff32a)

**Relations:** 

  - is_a [SIMetricPrefix](#simetricprefix)
  - Inverse([hasVariable](#hasvariable)) only [hasNumericalData](#hasnumericaldata) value 1000000000000000.0
  - [hasSymbolData](#hassymboldata) value "P"
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Tera](#tera), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Exa](#exa), [Kilo](#kilo), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### Deci
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_1181c938_c8f0_4ad6_bc7a_2bfdc0903d29](http://emmo.info/emmo/middle/siunits#emmo_1181c938_c8f0_4ad6_bc7a_2bfdc0903d29)

**Relations:** 

  - is_a [SIMetricPrefix](#simetricprefix)
  - Inverse([hasVariable](#hasvariable)) only [hasNumericalData](#hasnumericaldata) value 0.1
  - [hasSymbolData](#hassymboldata) value "d"
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Peta](#peta), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Tera](#tera), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Exa](#exa), [Kilo](#kilo), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### Atto
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_42955b2d_b465_4666_86cc_ea3c2d685753](http://emmo.info/emmo/middle/siunits#emmo_42955b2d_b465_4666_86cc_ea3c2d685753)

**Relations:** 

  - is_a [LatinSmallLetterA](#latinsmalllettera)
  - is_a [SIMetricPrefix](#simetricprefix)
  - Inverse([hasVariable](#hasvariable)) only [hasNumericalData](#hasnumericaldata) value 1e-18
  - [hasSymbolData](#hassymboldata) value "a"
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Tera](#tera), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Exa](#exa), [Kilo](#kilo), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### Yocto
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_f5769206_9257_4b08_bf7b_dad7868c6afc](http://emmo.info/emmo/middle/siunits#emmo_f5769206_9257_4b08_bf7b_dad7868c6afc)

**Relations:** 

  - is_a [SIMetricPrefix](#simetricprefix)
  - Inverse([hasVariable](#hasvariable)) only [hasNumericalData](#hasnumericaldata) value 1e-24
  - [hasSymbolData](#hassymboldata) value "y"
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Tera](#tera), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [LengthDimension](#lengthdimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Kilo](#kilo), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [Exa](#exa)






### Kilo
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_74931b1b_c133_4e59_9a75_1bf0e1626201](http://emmo.info/emmo/middle/siunits#emmo_74931b1b_c133_4e59_9a75_1bf0e1626201)

**Relations:** 

  - is_a [SIMetricPrefix](#simetricprefix)
  - Inverse([hasVariable](#hasvariable)) only [hasNumericalData](#hasnumericaldata) value 1000.0
  - [hasSymbolData](#hassymboldata) value "k"
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Tera](#tera), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [LengthDimension](#lengthdimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [Exa](#exa)






### Tera
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_3a204900_2b33_47d1_b444_815cc4c8cffa](http://emmo.info/emmo/middle/siunits#emmo_3a204900_2b33_47d1_b444_815cc4c8cffa)

**Relations:** 

  - is_a [SIMetricPrefix](#simetricprefix)
  - Inverse([hasVariable](#hasvariable)) only [hasNumericalData](#hasnumericaldata) value 1000000000000.0
  - [hasSymbolData](#hassymboldata) value "T"
  - disjoint_with [Watt](#watt), [Gradient](#gradient), [Newton](#newton), [Lux](#lux), [Weber](#weber), [Minus](#minus), [Volt](#volt), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [Ohm](#ohm), [Joule](#joule), [Hertz](#hertz), [Pascal](#pascal), [SIBaseUnit](#sibaseunit), [PerTimeDimension](#pertimedimension), [MassDimension](#massdimension), [Void](#void), [LengthDimension](#lengthdimension), [Exa](#exa), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Steradian](#steradian), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [Equals](#equals), [Yotta](#yotta), [Giga](#giga), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [Quantity](#quantity), [Mega](#mega), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [Plus](#plus), [Siemens](#siemens), [Farad](#farad), [Katal](#katal), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Coulomb](#coulomb), [TimeCurrentDimension](#timecurrentdimension), [Zetta](#zetta), [AmountDimension](#amountdimension), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Becquerel](#becquerel), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Pico](#pico), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [Deka](#deka), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [Kilo](#kilo), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Sievert](#sievert), [Hecto](#hecto), [LatinSmallLetterM](#latinsmallletterm), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Henry](#henry), [Peta](#peta), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Radian](#radian), [DegreeCelsius](#degreecelsius), [Multiplication](#multiplication), [MicroUnit](#microunit), [Femto](#femto), [Gray](#gray), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [DimensionOne](#dimensionone), [Lumen](#lumen), [Centi](#centi), [Nano](#nano), [Zepto](#zepto), [LatinSmallLetterA](#latinsmalllettera), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension)






### Yotta
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_e79c62ff_10ad_4ec0_baba_c19ddd4eaa11](http://emmo.info/emmo/middle/siunits#emmo_e79c62ff_10ad_4ec0_baba_c19ddd4eaa11)

**Relations:** 

  - is_a [SIMetricPrefix](#simetricprefix)
  - Inverse([hasVariable](#hasvariable)) only [hasNumericalData](#hasnumericaldata) value 1e+24
  - [hasSymbolData](#hassymboldata) value "Y"
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Tera](#tera), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [Giga](#giga), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [LengthDimension](#lengthdimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Kilo](#kilo), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [Exa](#exa)






### Milli
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_a3a701ed_6f7d_4a10_9aee_dfa1961fc7b7](http://emmo.info/emmo/middle/siunits#emmo_a3a701ed_6f7d_4a10_9aee_dfa1961fc7b7)

**Relations:** 

  - is_a [LatinSmallLetterM](#latinsmallletterm)
  - is_a [SIMetricPrefix](#simetricprefix)
  - Inverse([hasVariable](#hasvariable)) only [hasNumericalData](#hasnumericaldata) value 0.001
  - [hasSymbolData](#hassymboldata) value "m"
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [SISpecialUnit](#sispecialunit), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Tera](#tera), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [Kelvin](#kelvin), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [Minus](#minus), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Kilogram](#kilogram), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Mole](#mole), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [LengthDimension](#lengthdimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Exa](#exa), [Kilo](#kilo), [Second](#second), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [Candela](#candela)






### Giga
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_a8eb4bbb_1bd3_4ad4_b114_2789bcbd2134](http://emmo.info/emmo/middle/siunits#emmo_a8eb4bbb_1bd3_4ad4_b114_2789bcbd2134)

**Relations:** 

  - is_a [SIMetricPrefix](#simetricprefix)
  - Inverse([hasVariable](#hasvariable)) only [hasNumericalData](#hasnumericaldata) value 1000000000.0
  - [hasSymbolData](#hassymboldata) value "G"
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Tera](#tera), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [LengthDimension](#lengthdimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Kilo](#kilo), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [Exa](#exa)






### Centi
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_b55cd09a_e54d_4eb1_81dd_03c29d1b878e](http://emmo.info/emmo/middle/siunits#emmo_b55cd09a_e54d_4eb1_81dd_03c29d1b878e)

**Relations:** 

  - is_a [SIMetricPrefix](#simetricprefix)
  - Inverse([hasVariable](#hasvariable)) only [hasNumericalData](#hasnumericaldata) value 0.01
  - [hasSymbolData](#hassymboldata) value "c"
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Tera](#tera), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [LengthDimension](#lengthdimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Kilo](#kilo), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [Exa](#exa)






### Micro
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_9ff3bf8e_2168_406e_8251_1d158fc948ae](http://emmo.info/emmo/middle/siunits#emmo_9ff3bf8e_2168_406e_8251_1d158fc948ae)

**Relations:** 

  - is_a [MicroUnit](#microunit)
  - is_a [SIMetricPrefix](#simetricprefix)
  - Inverse([hasVariable](#hasvariable)) only [hasNumericalData](#hasnumericaldata) value 1e-06
  - [hasSymbolData](#hassymboldata) value "µ"
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Tera](#tera), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [Quantity](#quantity), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [LengthDimension](#lengthdimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Kilo](#kilo), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [Exa](#exa)






### Nano
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_e1981c25_7c55_4020_aa7a_d2e14ced86d4](http://emmo.info/emmo/middle/siunits#emmo_e1981c25_7c55_4020_aa7a_d2e14ced86d4)

**Relations:** 

  - is_a [SIMetricPrefix](#simetricprefix)
  - Inverse([hasVariable](#hasvariable)) only [hasNumericalData](#hasnumericaldata) value 1e-09
  - [hasSymbolData](#hassymboldata) value "n"
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Tera](#tera), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [LengthDimension](#lengthdimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Kilo](#kilo), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [Exa](#exa)






### Zepto
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_254472c6_3dbd_4f02_bc43_571389cd281f](http://emmo.info/emmo/middle/siunits#emmo_254472c6_3dbd_4f02_bc43_571389cd281f)

**Relations:** 

  - is_a [SIMetricPrefix](#simetricprefix)
  - Inverse([hasVariable](#hasvariable)) only [hasNumericalData](#hasnumericaldata) value 1e-21
  - [hasSymbolData](#hassymboldata) value "z"
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Tera](#tera), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Exa](#exa), [Kilo](#kilo), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Nano](#nano), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### Pico
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_068c4e58_2470_4b1c_8454_010dd4906100](http://emmo.info/emmo/middle/siunits#emmo_068c4e58_2470_4b1c_8454_010dd4906100)

**Relations:** 

  - is_a [SIMetricPrefix](#simetricprefix)
  - Inverse([hasVariable](#hasvariable)) only [hasNumericalData](#hasnumericaldata) value 1e-12
  - [hasSymbolData](#hassymboldata) value "p"
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Tera](#tera), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Exa](#exa), [Kilo](#kilo), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### Mega
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_5eaecadc_4f0d_4a3a_afc7_1fc0b83cc928](http://emmo.info/emmo/middle/siunits#emmo_5eaecadc_4f0d_4a3a_afc7_1fc0b83cc928)

**Relations:** 

  - is_a [SIMetricPrefix](#simetricprefix)
  - Inverse([hasVariable](#hasvariable)) only [hasNumericalData](#hasnumericaldata) value 1000000.0
  - [hasSymbolData](#hassymboldata) value "M"
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Tera](#tera), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [Femto](#femto), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [LengthDimension](#lengthdimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Kilo](#kilo), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [Exa](#exa)






### Femto
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_23bfe79a_cade_48f1_9a8c_fd96e6bac8ba](http://emmo.info/emmo/middle/siunits#emmo_23bfe79a_cade_48f1_9a8c_fd96e6bac8ba)

**Relations:** 

  - is_a [SIMetricPrefix](#simetricprefix)
  - Inverse([hasVariable](#hasvariable)) only [hasNumericalData](#hasnumericaldata) value 1e-15
  - [hasSymbolData](#hassymboldata) value "f"
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Tera](#tera), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Exa](#exa), [Kilo](#kilo), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






### SIMetricPrefix
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_471cb92b_edca_4cf9_bce8_a75084d876b8](http://emmo.info/emmo/middle/siunits#emmo_471cb92b_edca_4cf9_bce8_a75084d876b8)

**Relations:** 

  - is_a [MetricPrefix](#metricprefix)
  - disjoint_with [Watt](#watt), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Steradian](#steradian), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [Henry](#henry), [Gradient](#gradient), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Becquerel](#becquerel), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [Equals](#equals), [Newton](#newton), [Lux](#lux), [PhysicsBasedModel](#physicsbasedmodel), [Weber](#weber), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Kelvin](#kelvin), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [Radian](#radian), [Volt](#volt), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [DegreeCelsius](#degreecelsius), [Multiplication](#multiplication), [Quantity](#quantity), [Kilogram](#kilogram), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [Mole](#mole), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Ohm](#ohm), [Joule](#joule), [Laplacian](#laplacian), [Equation](#equation), [TemperatureDimension](#temperaturedimension), [Sievert](#sievert), [Gray](#gray), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [LengthDimension](#lengthdimension), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Siemens](#siemens), [Farad](#farad), [Katal](#katal), [Lumen](#lumen), [Second](#second), [Hertz](#hertz), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Pascal](#pascal), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [Coulomb](#coulomb), [LatinCapitalLetterA](#latincapitallettera), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [Candela](#candela)
  - disjoint_union_of [Pico](#pico), [Deci](#deci), [Deka](#deka), [Hecto](#hecto), [Femto](#femto), [Zepto](#zepto), [Tera](#tera), [Atto](#atto), [Peta](#peta), [Exa](#exa), [Mega](#mega), [Kilo](#kilo), [Micro](#micro), [Milli](#milli), [Giga](#giga), [Centi](#centi), [Zetta](#zetta), [Nano](#nano), [Yotta](#yotta), [Yocto](#yocto)






### Exa
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_5cf9f86c_86f5_40c4_846d_60371f670e0a](http://emmo.info/emmo/middle/siunits#emmo_5cf9f86c_86f5_40c4_846d_60371f670e0a)

**Relations:** 

  - is_a [SIMetricPrefix](#simetricprefix)
  - Inverse([hasVariable](#hasvariable)) only [hasNumericalData](#hasnumericaldata) value 1e+18
  - [hasSymbolData](#hassymboldata) value "E"
  - disjoint_with [Hecto](#hecto), [TimeCurrentDimension](#timecurrentdimension), [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension), [Zetta](#zetta), [LatinSmallLetterM](#latinsmallletterm), [AmountDimension](#amountdimension), [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension), [LatinSmallLetterA](#latinsmalllettera), [Gradient](#gradient), [Peta](#peta), [Deci](#deci), [ElectricCurrentDimension](#electriccurrentdimension), [PrefixedUnit](#prefixedunit), [TimeDimension](#timedimension), [Yocto](#yocto), [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension), [Tera](#tera), [Equals](#equals), [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension), [PhysicsBasedModel](#physicsbasedmodel), [Yotta](#yotta), [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension), [Giga](#giga), [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension), [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension), [Minus](#minus), [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension), [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension), [Multiplication](#multiplication), [MicroUnit](#microunit), [Quantity](#quantity), [Pico](#pico), [Space](#space), [LuminousIntensityDimension](#luminousintensitydimension), [Mega](#mega), [LengthPerTimeDimension](#lengthpertimedimension), [GreekSmallLetterMu](#greeksmalllettermu), [PerAmountDimension](#peramountdimension), [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension), [Femto](#femto), [Collection](#collection), [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension), [Laplacian](#laplacian), [Equation](#equation), [Deka](#deka), [TemperatureDimension](#temperaturedimension), [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension), [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension), [SIUnitSymbol](#siunitsymbol), [Division](#division), [AmountPerTimeDimension](#amountpertimedimension), [DimensionOne](#dimensionone), [Plus](#plus), [Kilo](#kilo), [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension), [Centi](#centi), [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension), [PerTimeDimension](#pertimedimension), [LatinCapitalLetterA](#latincapitallettera), [Nano](#nano), [Zepto](#zepto), [MassDimension](#massdimension), [Void](#void), [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension), [LengthDimension](#lengthdimension)






## Quantity branch
![Quantity branch.](genfigs/QuantityT.pdf){ width=668px }


### QuantitativeProperty
**IRI:** [http://emmo.info/emmo/middle/properties#EMMO_dd4a7f3e_ef56_466c_ac1a_d2716b5f87ec](http://emmo.info/emmo/middle/properties#emmo_dd4a7f3e_ef56_466c_ac1a_d2716b5f87ec)

**Elucidation:** A 'Quantity' that can be quantified with respect to a standardized reference physical instance (e.g. the prototype meter bar, the kg prototype) or method (e.g. resilience) through a measurement process.

**Comment:** "A property of a phenomenon, body, or substance, where the property has a magnitude that can be expressed by means of a number and a reference"
ISO 80000-1

"A reference can be a measurement unit, a measurement procedure, a reference material, or a combination of such."
International vocabulary of metrology (VIM)

**Comment:** A quantitative property is always expresssed as a quantity (i.e. a number and a reference unit). For the EMMO, a nominalistic ontology, there is no property as abstract object.

A property is a sign that stands for an object according to a specific code shared by some observers.

For quantititative properties, one possible code that is shared between the scientific community (the observers) is the SI system of units.

**Comment:** Subclasses of 'QuantitativeProperty' classify objects according to the type semiosis that is used to connect the property to the object (e.g. by measurement, by convention, by modelling).

**Relations:** 

  - is_a [Quantity](#quantity)
  - is_a [ObjectiveProperty](#objectiveproperty)
  - equivalent_to [MeasuredQuantitativeProperty](#measuredquantitativeproperty) or [ModelledQuantitativeProperty](#modelledquantitativeproperty) or [ConventionalQuantitativeProperty](#conventionalquantitativeproperty)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [SubjectiveProperty](#subjectiveproperty), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### OrdinalQuantity
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_c46f091c_0420_4c1a_af30_0a2c8ebcf7d7](http://emmo.info/emmo/middle/metrology#emmo_c46f091c_0420_4c1a_af30_0a2c8ebcf7d7)

**Elucidation:** "Quantity, defined by a conventional measurement procedure, for which a total ordering relation can be established, according to magnitude, with other quantities of the same kind, but for which no algebraic operations among those quantities exist"
International vocabulary of metrology (VIM)

**Example:** Hardness
Resilience

**Comment:** "Ordinal quantities, such as Rockwell C hardness, are usually not considered to be part of a system of quantities because they are related to other quantities through empirical relations only."
International vocabulary of metrology (VIM)

**Relations:** 

  - is_a [Quantity](#quantity)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [PhysicalQuantity](#physicalquantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### ConventionalQuantitativeProperty
**IRI:** [http://emmo.info/emmo/middle/properties#EMMO_d8aa8e1f_b650_416d_88a0_5118de945456](http://emmo.info/emmo/middle/properties#emmo_d8aa8e1f_b650_416d_88a0_5118de945456)

**Elucidation:** A quantitative property attributed by agreement to a quantity for a given purpose.

**Example:** The thermal conductivity of a copper sample in my laboratory can be assumed to be the conductivity that appears in the vendor specification. This value has been obtained by measurement of a sample which is not the one I have in my laboratory. This conductivity value is then a conventional quantitiative property assigned to my sample through a semiotic process in which no actual measurement is done by my laboratory.

If I don't believe the vendor, then I can measure the actual thermal conductivity. I then perform a measurement process that semiotically assign another value for the conductivity, which is a measured property, since is part of a measurement process.

Then I have two different physical quantities that are properties thanks to two different semiotic processes.

**Comment:** A property that is associated to an object by convention, or assumption.

**Relations:** 

  - is_a [QuantitativeProperty](#quantitativeproperty)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [SubjectiveProperty](#subjectiveproperty), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### Quantity
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_f658c301_ce93_46cf_9639_4eace2c5d1d5](http://emmo.info/emmo/middle/metrology#emmo_f658c301_ce93_46cf_9639_4eace2c5d1d5)

**Elucidation:** A symbolic that has parts a reference unit and a numerical object separated by a space expressing the value of a quantitative property (expressed as the product of the numerical and the unit).

**Example:** 6.8 m
0.9 km
8 K
6 MeV
43.5 HRC(150 kg)

**Comment:** A quantity is not necessarily a property, since it is possible to write "10 kg", without assigning this quantity to a specific object.

However, a quantitative property is always a quantity.

**Comment:** Referred as Quantity Value in International vocabulary of metrology (VIM)

**Comment:** SI distinguishes between a quantity (an abstract concept) and the quantity value (a number and a reference). 

The EMMO, following strict nominalism, denies the existence of abstract objects and then collapses the two concepts of SI quantity and SI quantity value into a single one: the 'Quantity'.

So, for the EMMO the symbol "kg" is not a physical quantity but simply a 'Symbolic' object categorized as a 'MeasurementUnit'.

While the string "1 kg" is a 'Physical Quantity'.

**Relations:** 

  - is_a [Metrological](#metrological)
  - is_a [State](#state)
  - [hasReferenceUnit](#hasreferenceunit) exactly 1 [ReferenceUnit](#referenceunit)
  - [hasQuantityValue](#hasquantityvalue) exactly 1 [Numerical](#numerical)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)
  - disjoint_union_of [PhysicalQuantity](#physicalquantity), [OrdinalQuantity](#ordinalquantity)






### ModelledQuantitativeProperty
**IRI:** [http://emmo.info/emmo/middle/properties#EMMO_d0200cf1_e4f4_45ae_873f_b9359daea3cd](http://emmo.info/emmo/middle/properties#emmo_d0200cf1_e4f4_45ae_873f_b9359daea3cd)

**Relations:** 

  - is_a [QuantitativeProperty](#quantitativeproperty)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [SubjectiveProperty](#subjectiveproperty), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### MeasuredQuantitativeProperty
**IRI:** [http://emmo.info/emmo/middle/properties#EMMO_873b0ab3_88e6_4054_b901_5531e01f14a4](http://emmo.info/emmo/middle/properties#emmo_873b0ab3_88e6_4054_b901_5531e01f14a4)

**Relations:** 

  - is_a [QuantitativeProperty](#quantitativeproperty)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [SubjectiveProperty](#subjectiveproperty), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






## Base Quantity branch
![Base Quantity branch.](genfigs/BaseQuantityT.pdf){ width=668px }


### ThermodynamicTemperature
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_affe07e4_e9bc_4852_86c6_69e26182a17f](http://emmo.info/emmo/middle/isq#emmo_affe07e4_e9bc_4852_86c6_69e26182a17f)

**Elucidation:** Thermodynamic temperature is the absolute measure of temperature. It is defined by the third law of thermodynamics in which the theoretically lowest temperature is the null or zero point.

**Dbpediamatch:** [http://dbpedia.org/page/Thermodynamic_temperature](http://dbpedia.org/page/thermodynamic_temperature)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.T06321](https://doi.org/10.1351/goldbook.t06321)

**Relations:** 

  - is_a [ISQBaseQuantity](#isqbasequantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [TemperatureDimension](#temperaturedimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [AmountOfSubstance](#amountofsubstance), [Quantum](#quantum), [ElectricCurrent](#electriccurrent), [DerivedQuantity](#derivedquantity), [LuminousIntensity](#luminousintensity), [Mass](#mass), [Length](#length), [Time](#time), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### AmountOfSubstance
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_8159c26a_494b_4fa0_9959_10888f152298](http://emmo.info/emmo/middle/isq#emmo_8159c26a_494b_4fa0_9959_10888f152298)

**Elucidation:** The number of elementary entities present.

**Dbpediamatch:** [http://dbpedia.org/page/Amount_of_substance](http://dbpedia.org/page/amount_of_substance)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.A00297](https://doi.org/10.1351/goldbook.a00297)

**Relations:** 

  - is_a [ISQBaseQuantity](#isqbasequantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [AmountDimension](#amountdimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [ThermodynamicTemperature](#thermodynamictemperature), [Quantum](#quantum), [ElectricCurrent](#electriccurrent), [DerivedQuantity](#derivedquantity), [LuminousIntensity](#luminousintensity), [Mass](#mass), [Length](#length), [Time](#time), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### ElectricCurrent
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_c995ae70_3b84_4ebb_bcfc_69e6a281bb88](http://emmo.info/emmo/middle/isq#emmo_c995ae70_3b84_4ebb_bcfc_69e6a281bb88)

**Elucidation:** A flow of electric charge.

**Dbpediamatch:** [http://dbpedia.org/page/Electric_current](http://dbpedia.org/page/electric_current)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.E01927](https://doi.org/10.1351/goldbook.e01927)

**Relations:** 

  - is_a [ISQBaseQuantity](#isqbasequantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [ElectricCurrentDimension](#electriccurrentdimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [ThermodynamicTemperature](#thermodynamictemperature), [AmountOfSubstance](#amountofsubstance), [Quantum](#quantum), [DerivedQuantity](#derivedquantity), [LuminousIntensity](#luminousintensity), [Mass](#mass), [Length](#length), [Time](#time), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### ISQBaseQuantity
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_1a4c1a97_88a7_4d8e_b2f9_2ca58e92dde4](http://emmo.info/emmo/middle/isq#emmo_1a4c1a97_88a7_4d8e_b2f9_2ca58e92dde4)

**Elucidation:** Base quantities defined in the International System of Quantities (ISQ).

**Wikipediaentry:** [https://en.wikipedia.org/wiki/International_System_of_Quantities](https://en.wikipedia.org/wiki/international_system_of_quantities)

**Relations:** 

  - is_a [InternationalSystemOfQuantity](#internationalsystemofquantity)
  - is_a [BaseQuantity](#basequantity)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [DerivedQuantity](#derivedquantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)
  - disjoint_union_of [LuminousIntensity](#luminousintensity), [AmountOfSubstance](#amountofsubstance), [ThermodynamicTemperature](#thermodynamictemperature), [ElectricCurrent](#electriccurrent), [Length](#length), [Time](#time), [Mass](#mass)






### BaseQuantity
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_acaaa124_3dde_48b6_86e6_6ec6f364f408](http://emmo.info/emmo/middle/metrology#emmo_acaaa124_3dde_48b6_86e6_6ec6f364f408)

**Elucidation:** "Quantity in a conventionally chosen subset of a given system of quantities, where no quantity in the subset can be expressed in terms of the other quantities within that subset"
ISO 80000-1

**Relations:** 

  - is_a [PhysicalQuantity](#physicalquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [BaseUnit](#baseunit)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [DerivedQuantity](#derivedquantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### LuminousIntensity
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_50bf79a6_a48b_424d_9d2c_813bd631231a](http://emmo.info/emmo/middle/isq#emmo_50bf79a6_a48b_424d_9d2c_813bd631231a)

**Elucidation:** A measure of the wavelength-weighted power emitted by a light source in a particular direction per unit solid angle. It is based on the luminosity function, which is a standardized model of the sensitivity of the human eye.

**Dbpediamatch:** [http://dbpedia.org/page/Luminous_intensity](http://dbpedia.org/page/luminous_intensity)

**Relations:** 

  - is_a [ISQBaseQuantity](#isqbasequantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [LuminousIntensityDimension](#luminousintensitydimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [ThermodynamicTemperature](#thermodynamictemperature), [AmountOfSubstance](#amountofsubstance), [Quantum](#quantum), [ElectricCurrent](#electriccurrent), [DerivedQuantity](#derivedquantity), [Mass](#mass), [Length](#length), [Time](#time), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### Mass
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_ed4af7ae_63a2_497e_bb88_2309619ea405](http://emmo.info/emmo/middle/isq#emmo_ed4af7ae_63a2_497e_bb88_2309619ea405)

**Elucidation:** Property of a physical body that express its resistance to acceleration (a change in its state of motion) when a force is applied.

**Dbpediamatch:** [http://dbpedia.org/page/Mass](http://dbpedia.org/page/mass)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.M03709](https://doi.org/10.1351/goldbook.m03709)

**Relations:** 

  - is_a [ISQBaseQuantity](#isqbasequantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [MassDimension](#massdimension)
  - Inverse([hasProperty](#hasproperty)) only [Matter](#matter)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [ThermodynamicTemperature](#thermodynamictemperature), [AmountOfSubstance](#amountofsubstance), [Quantum](#quantum), [ElectricCurrent](#electriccurrent), [DerivedQuantity](#derivedquantity), [LuminousIntensity](#luminousintensity), [Length](#length), [Time](#time), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### Length
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_cd2cd0de_e0cc_4ef1_b27e_2e88db027bac](http://emmo.info/emmo/middle/isq#emmo_cd2cd0de_e0cc_4ef1_b27e_2e88db027bac)

**Elucidation:** Extend of a spatial dimension.

**Dbpediamatch:** [http://dbpedia.org/page/Length](http://dbpedia.org/page/length)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.L03498](https://doi.org/10.1351/goldbook.l03498)

**Relations:** 

  - is_a [ISQBaseQuantity](#isqbasequantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [LengthDimension](#lengthdimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [ThermodynamicTemperature](#thermodynamictemperature), [AmountOfSubstance](#amountofsubstance), [Quantum](#quantum), [ElectricCurrent](#electriccurrent), [DerivedQuantity](#derivedquantity), [LuminousIntensity](#luminousintensity), [Mass](#mass), [Time](#time), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### Time
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_d4f7d378_5e3b_468a_baa1_a7e98358cda7](http://emmo.info/emmo/middle/isq#emmo_d4f7d378_5e3b_468a_baa1_a7e98358cda7)

**Elucidation:** The indefinite continued progress of existence and events that occur in apparently irreversible succession from the past through the present to the future.

**Dbpediamatch:** [http://dbpedia.org/page/Time](http://dbpedia.org/page/time)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.T06375](https://doi.org/10.1351/goldbook.t06375)

**Relations:** 

  - is_a [ISQBaseQuantity](#isqbasequantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [TimeDimension](#timedimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [ThermodynamicTemperature](#thermodynamictemperature), [AmountOfSubstance](#amountofsubstance), [Quantum](#quantum), [ElectricCurrent](#electriccurrent), [DerivedQuantity](#derivedquantity), [LuminousIntensity](#luminousintensity), [Mass](#mass), [Length](#length), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






## Derived Quantity branch
![Derived Quantity branch.](genfigs/DerivedQuantityT.pdf){ width=668px }


### Inductance
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_04cc9451_5306_45d0_8554_22cee4d6e785](http://emmo.info/emmo/middle/isq#emmo_04cc9451_5306_45d0_8554_22cee4d6e785)

**Elucidation:** A property of an electrical conductor by which a change in current through it induces an electromotive force in both the conductor itself and in any nearby conductors by mutual inductance.

**Altlabel:** ElectricInductance

**Dbpediamatch:** [http://dbpedia.org/page/Inductance](http://dbpedia.org/page/inductance)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.M04076](https://doi.org/10.1351/goldbook.m04076)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [MassSquareLengthPerSquareTimeSquareCurrentDimension](#masssquarelengthpersquaretimesquarecurrentdimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### CelsiusTemperature
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_66bc9029_f473_45ff_bab9_c3509ff37a22](http://emmo.info/emmo/middle/isq#emmo_66bc9029_f473_45ff_bab9_c3509ff37a22)

**Elucidation:** An objective comparative measure of hot or cold. 

Temperature is a relative quantity that can be used to express temperature differences. Unlike ThermodynamicTemperature, it cannot express absolute temperatures.

**Dbpediamatch:** [http://dbpedia.org/page/Temperature](http://dbpedia.org/page/temperature)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.T06261](https://doi.org/10.1351/goldbook.t06261)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [TemperatureDimension](#temperaturedimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### SolidAngle
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_e7c9f7fd_e534_4441_88fe_1fec6cb20f26](http://emmo.info/emmo/middle/isq#emmo_e7c9f7fd_e534_4441_88fe_1fec6cb20f26)

**Elucidation:** Ratio of area on a sphere to its radius squared.

**Dbpediamatch:** [http://dbpedia.org/page/Solid_angle](http://dbpedia.org/page/solid_angle)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.S05732](https://doi.org/10.1351/goldbook.s05732)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [DimensionOne](#dimensionone)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### ElectricConductance
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_ffb73b1e_5786_43e4_a964_cb32ac7affb7](http://emmo.info/emmo/middle/isq#emmo_ffb73b1e_5786_43e4_a964_cb32ac7affb7)

**Elucidation:** Measure of the ease for electric current to pass through a material.

**Altlabel:** Conductance

**Comment:** Inverse of 'ElectricalResistance'.

**Dbpediamatch:** [http://dbpedia.org/page/Electrical_resistance_and_conductance](http://dbpedia.org/page/electrical_resistance_and_conductance)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.E01925](https://doi.org/10.1351/goldbook.e01925)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [CubicTimeSquareCurrentPerMassSquareLengthDimension](#cubictimesquarecurrentpermasssquarelengthdimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### ISQDerivedQuantity
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_2946d40b_24a1_47fa_8176_e3f79bb45064](http://emmo.info/emmo/middle/isq#emmo_2946d40b_24a1_47fa_8176_e3f79bb45064)

**Elucidation:** Derived quantities defined in the International System of Quantities (ISQ).

**Relations:** 

  - is_a [InternationalSystemOfQuantity](#internationalsystemofquantity)
  - is_a [DerivedQuantity](#derivedquantity)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### ElementaryCharge
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_58a650f0_a638_4743_8439_535a325e5c4c](http://emmo.info/emmo/middle/siunits#emmo_58a650f0_a638_4743_8439_535a325e5c4c)

**Elucidation:** The magnitude of the electric charge carried by a single electron.

**Comment:** The DBpedia definition (http://dbpedia.org/page/Elementary_charge) is outdated as May 20, 2019. It is now an exact quantity.

**Dbpediamatch:** [http://dbpedia.org/page/Elementary_charge](http://dbpedia.org/page/elementary_charge)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.E02032](https://doi.org/10.1351/goldbook.e02032)

**Qudtmatch:** [http://physics.nist.gov/cuu/CODATA-Value_ElementaryCharge](http://physics.nist.gov/cuu/codata-value_elementarycharge)

**Relations:** 

  - is_a [ElectricCharge](#electriccharge)
  - is_a [SIExactConstant](#siexactconstant)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [MeasuredConstant](#measuredconstant), [AvogadroConstant](#avogadroconstant), [Quantum](#quantum), [LuminousEfficacy](#luminousefficacy), [BoltzmannConstant](#boltzmannconstant), [BaseQuantity](#basequantity), [HyperfineTransitionFrequencyOfCs](#hyperfinetransitionfrequencyofcs), [PlanckConstant](#planckconstant), [SpeedOfLightInVacuum](#speedoflightinvacuum), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### DoseEquivalent
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_3df10765_f6ff_4c9e_be3d_10b1809d78bd](http://emmo.info/emmo/middle/isq#emmo_3df10765_f6ff_4c9e_be3d_10b1809d78bd)

**Elucidation:** A dose quantity used in the International Commission on Radiological Protection (ICRP) system of radiological protection.

**Dbpediamatch:** [http://dbpedia.org/page/Energy](http://dbpedia.org/page/energy)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.E02101](https://doi.org/10.1351/goldbook.e02101)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### DerivedQuantity
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_71f6ab56_342c_484b_bbe0_de86b7367cb3](http://emmo.info/emmo/middle/metrology#emmo_71f6ab56_342c_484b_bbe0_de86b7367cb3)

**Elucidation:** "Quantity, in a system of quantities, defined in terms of the base quantities of that system".

**Relations:** 

  - is_a [PhysicalQuantity](#physicalquantity)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### Capacitance
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_99dba333_0dbd_4f75_8841_8c0f97fd58e2](http://emmo.info/emmo/middle/isq#emmo_99dba333_0dbd_4f75_8841_8c0f97fd58e2)

**Elucidation:** The derivative of the electric charge of a system with respect to the electric potential.

**Altlabel:** ElectricCapacitance

**Dbpediamatch:** [http://dbpedia.org/page/Capacitance](http://dbpedia.org/page/capacitance)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.C00791](https://doi.org/10.1351/goldbook.c00791)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [QuarticTimeSquareCurrentPerMassSquareLengthDimension](#quartictimesquarecurrentpermasssquarelengthdimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### LuminousFlux
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_e2ee1c98_497a_4f66_b4ed_5711496a848e](http://emmo.info/emmo/middle/isq#emmo_e2ee1c98_497a_4f66_b4ed_5711496a848e)

**Elucidation:** Perceived power of light.

**Dbpediamatch:** [http://dbpedia.org/page/Luminous_flux](http://dbpedia.org/page/luminous_flux)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.L03646](https://doi.org/10.1351/goldbook.l03646)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [LuminousIntensityDimension](#luminousintensitydimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### MagneticFlux
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_3b931698_937e_49be_ab1b_36fa52d91181](http://emmo.info/emmo/middle/isq#emmo_3b931698_937e_49be_ab1b_36fa52d91181)

**Elucidation:** Measure of magnetism, taking account of the strength and the extent of a magnetic field.

**Dbpediamatch:** [http://dbpedia.org/page/Magnetic_flux](http://dbpedia.org/page/magnetic_flux)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.M03684](https://doi.org/10.1351/goldbook.m03684)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [MassSquareLengthPerSquareTimeCurrentDimension](#masssquarelengthpersquaretimecurrentdimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### MagneticFluxDensity
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_961d1aba_f75e_4411_aaa4_457f7516ed6b](http://emmo.info/emmo/middle/isq#emmo_961d1aba_f75e_4411_aaa4_457f7516ed6b)

**Elucidation:** Strength of the magnetic field.

**Comment:** Often denoted B.

**Dbpediamatch:** [http://dbpedia.org/page/Magnetic_field](http://dbpedia.org/page/magnetic_field)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.M03686](https://doi.org/10.1351/goldbook.m03686)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [MassPerSquareTimeCurrentDimension](#masspersquaretimecurrentdimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### Angle
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_f3dd74c0_f480_49e8_9764_33b78638c235](http://emmo.info/emmo/middle/isq#emmo_f3dd74c0_f480_49e8_9764_33b78638c235)

**Definition:** Ratio of circular arc length to radius.

**Dbpediamatch:** [http://dbpedia.org/page/Angle](http://dbpedia.org/page/angle)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.A00346](https://doi.org/10.1351/goldbook.a00346)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [DimensionOne](#dimensionone)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### HyperfineTransitionFrequencyOfCs
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_f96feb3f_4438_4e43_aa44_7458c4d87fc2](http://emmo.info/emmo/middle/siunits#emmo_f96feb3f_4438_4e43_aa44_7458c4d87fc2)

**Elucidation:** The frequency standard in the SI system in which the photon absorption by transitions between the two hyperfine ground states of caesium-133 atoms are used to control the output frequency.

**Relations:** 

  - is_a [Frequency](#frequency)
  - is_a [SIExactConstant](#siexactconstant)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [MeasuredConstant](#measuredconstant), [ElementaryCharge](#elementarycharge), [AvogadroConstant](#avogadroconstant), [Quantum](#quantum), [LuminousEfficacy](#luminousefficacy), [BoltzmannConstant](#boltzmannconstant), [BaseQuantity](#basequantity), [PlanckConstant](#planckconstant), [SpeedOfLightInVacuum](#speedoflightinvacuum), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### AbsorbedDose
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_8e5dd473_808b_4a8a_b7cd_63068c12ff57](http://emmo.info/emmo/middle/isq#emmo_8e5dd473_808b_4a8a_b7cd_63068c12ff57)

**Definition:** Energy imparted to matter by ionizing radiation in a suitable small element of volume divided by the mass of that element of volume.

**Dbpediamatch:** [http://dbpedia.org/page/Absorbed_dose](http://dbpedia.org/page/absorbed_dose)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.A00031](https://doi.org/10.1351/goldbook.a00031)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [SquareLengthPerSquareTimeDimension](#squarelengthpersquaretimedimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### Radioactivity
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_8d3da9ac_2265_4382_bee5_db72046722f8](http://emmo.info/emmo/middle/isq#emmo_8d3da9ac_2265_4382_bee5_db72046722f8)

**Elucidation:** Decays per unit time.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.A00114](https://doi.org/10.1351/goldbook.a00114)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [PerTimeDimension](#pertimedimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### Energy
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_31ec09ba_1713_42cb_83c7_b38bf6f9ced2](http://emmo.info/emmo/middle/isq#emmo_31ec09ba_1713_42cb_83c7_b38bf6f9ced2)

**Elucidation:** A property of objects which can be transferred to other objects or converted into different forms.

**Comment:** Energy is often defined as "ability of a system to perform work", but it might be misleading since is not necessarily available to do work.

**Dbpediamatch:** [http://dbpedia.org/page/Energy](http://dbpedia.org/page/energy)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.E02101](https://doi.org/10.1351/goldbook.e02101)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [MassSquareLengthPerSquareTimeDimension](#masssquarelengthpersquaretimedimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### Frequency
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_852b4ab8_fc29_4749_a8c7_b92d4fca7d5a](http://emmo.info/emmo/middle/isq#emmo_852b4ab8_fc29_4749_a8c7_b92d4fca7d5a)

**Elucidation:** Number of periods per time interval.

**Dbpediamatch:** [http://dbpedia.org/page/Frequency](http://dbpedia.org/page/frequency)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.FT07383](https://doi.org/10.1351/goldbook.ft07383)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [PerTimeDimension](#pertimedimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### ElectricResistance
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_e88f75d6_9a17_4cfc_bdf7_43d7cea5a9a1](http://emmo.info/emmo/middle/isq#emmo_e88f75d6_9a17_4cfc_bdf7_43d7cea5a9a1)

**Elucidation:** Measure of the difficulty to pass an electric current through a material.

**Altlabel:** Resistance

**Comment:** Inverse of 'ElectricalConductance'.

**Dbpediamatch:** [http://dbpedia.org/page/Electrical_resistance_and_conductance](http://dbpedia.org/page/electrical_resistance_and_conductance)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.E01936](https://doi.org/10.1351/goldbook.e01936)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [MassSquareLengthPerCubicTimeSquareCurrentDimension](#masssquarelengthpercubictimesquarecurrentdimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### Force
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_1f087811_06cb_42d5_90fb_25d0e7e068ef](http://emmo.info/emmo/middle/isq#emmo_1f087811_06cb_42d5_90fb_25d0e7e068ef)

**Elucidation:** Any interaction that, when unopposed, will change the motion of an object.

**Dbpediamatch:** [http://dbpedia.org/page/Force](http://dbpedia.org/page/force)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.F02480](https://doi.org/10.1351/goldbook.f02480)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [MassLengthPerSquareTimeDimension](#masslengthpersquaretimedimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### Pressure
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_50a44256_9dc5_434b_bad4_74a4d9a29989](http://emmo.info/emmo/middle/isq#emmo_50a44256_9dc5_434b_bad4_74a4d9a29989)

**Elucidation:** The force applied perpendicular to the surface of an object per unit area over which that force is distributed.

**Dbpediamatch:** [http://dbpedia.org/page/Pressure](http://dbpedia.org/page/pressure)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.P04819](https://doi.org/10.1351/goldbook.p04819)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [MassPerLengthSquareTimeDimension](#massperlengthsquaretimedimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### CatalyticActivity
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_bd67d149_24c2_4bc9_833a_c2bc26f98fd3](http://emmo.info/emmo/middle/isq#emmo_bd67d149_24c2_4bc9_833a_c2bc26f98fd3)

**Elucidation:** Increase in the rate of reaction of a specified chemical reaction that an enzyme produces in a specific assay system.

**Iupacdoi:** [https://doi.org/10.1351/goldbook.C00881](https://doi.org/10.1351/goldbook.c00881)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [AmountPerTimeDimension](#amountpertimedimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### ElectricCharge
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_1604f495_328a_4f28_9962_f4cc210739dd](http://emmo.info/emmo/middle/isq#emmo_1604f495_328a_4f28_9962_f4cc210739dd)

**Elucidation:** The physical property of matter that causes it to experience a force when placed in an electromagnetic field.

**Altlabel:** Charge

**Dbpediamatch:** [http://dbpedia.org/page/Electric_charge](http://dbpedia.org/page/electric_charge)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.E01923](https://doi.org/10.1351/goldbook.e01923)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [TimeCurrentDimension](#timecurrentdimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### Illuminance
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_b51fbd00_a857_4132_9711_0ef70e7bdd20](http://emmo.info/emmo/middle/isq#emmo_b51fbd00_a857_4132_9711_0ef70e7bdd20)

**Definition:** The total luminous flux incident on a surface, per unit area.

**Dbpediamatch:** [http://dbpedia.org/page/Illuminance](http://dbpedia.org/page/illuminance)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.I02941](https://doi.org/10.1351/goldbook.i02941)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [LuminousIntensityPerSquareLengthDimension](#luminousintensitypersquarelengthdimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### ElectricPotential
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_4f2d3939_91b1_4001_b8ab_7d19074bf845](http://emmo.info/emmo/middle/isq#emmo_4f2d3939_91b1_4001_b8ab_7d19074bf845)

**Elucidation:** Energy required to move a unit charge through an electric field from a reference point.

**Altlabel:** Voltage

**Dbpediamatch:** [http://dbpedia.org/page/Voltage](http://dbpedia.org/page/voltage)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.A00424](https://doi.org/10.1351/goldbook.a00424)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [MassSquareLengthPerCubicTimeCurrentDimension](#masssquarelengthpercubictimecurrentdimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### Power
**IRI:** [http://emmo.info/emmo/middle/isq#EMMO_09b9021b_f97b_43eb_b83d_0a764b472bc2](http://emmo.info/emmo/middle/isq#emmo_09b9021b_f97b_43eb_b83d_0a764b472bc2)

**Elucidation:** Rate of transfer of energy per unit time.

**Dbpediamatch:** [http://dbpedia.org/page/Power_(physics)](http://dbpedia.org/page/power_(physics))

**Iupacdoi:** [https://doi.org/10.1351/goldbook.P04792](https://doi.org/10.1351/goldbook.p04792)

**Relations:** 

  - is_a [ISQDerivedQuantity](#isqderivedquantity)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [MassSquareLengthPerCubicTimeDimension](#masssquarelengthpercubictimedimension)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [BaseQuantity](#basequantity), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






## Physical Constant branch
![Physical Constant branch.](genfigs/PhysicalConstantT.pdf){ width=668px }


### MeasuredConstant
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_3f15d200_c97b_42c8_8ac0_d81d150361e2](http://emmo.info/emmo/middle/metrology#emmo_3f15d200_c97b_42c8_8ac0_d81d150361e2)

**Elucidation:** For a given unit system, measured constants are physical constants that are not used to define the unit system. Hence, these constants have to be measured and will therefore be associated with an uncertainty.

**Relations:** 

  - is_a [PhysicalConstant](#physicalconstant)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [ExactConstant](#exactconstant), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### ElementaryCharge
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_58a650f0_a638_4743_8439_535a325e5c4c](http://emmo.info/emmo/middle/siunits#emmo_58a650f0_a638_4743_8439_535a325e5c4c)

**Elucidation:** The magnitude of the electric charge carried by a single electron.

**Comment:** The DBpedia definition (http://dbpedia.org/page/Elementary_charge) is outdated as May 20, 2019. It is now an exact quantity.

**Dbpediamatch:** [http://dbpedia.org/page/Elementary_charge](http://dbpedia.org/page/elementary_charge)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.E02032](https://doi.org/10.1351/goldbook.e02032)

**Qudtmatch:** [http://physics.nist.gov/cuu/CODATA-Value_ElementaryCharge](http://physics.nist.gov/cuu/codata-value_elementarycharge)

**Relations:** 

  - is_a [ElectricCharge](#electriccharge)
  - is_a [SIExactConstant](#siexactconstant)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [MeasuredConstant](#measuredconstant), [AvogadroConstant](#avogadroconstant), [Quantum](#quantum), [LuminousEfficacy](#luminousefficacy), [BoltzmannConstant](#boltzmannconstant), [BaseQuantity](#basequantity), [HyperfineTransitionFrequencyOfCs](#hyperfinetransitionfrequencyofcs), [PlanckConstant](#planckconstant), [SpeedOfLightInVacuum](#speedoflightinvacuum), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### PhysicalConstant
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_b953f2b1_c8d1_4dd9_b630_d3ef6580c2bb](http://emmo.info/emmo/middle/metrology#emmo_b953f2b1_c8d1_4dd9_b630_d3ef6580c2bb)

**Comment:** Physical constants are categorised into "exact" and measured constants. 

With "exact" constants, we refer to physical constants that have an exact numerical value after the revision of the SI system that was enforsed May 2019.

**Wikipediaentry:** [https://en.wikipedia.org/wiki/List_of_physical_constants](https://en.wikipedia.org/wiki/list_of_physical_constants)

**Relations:** 

  - is_a [PhysicalQuantity](#physicalquantity)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [Quantum](#quantum), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)
  - disjoint_union_of [MeasuredConstant](#measuredconstant), [ExactConstant](#exactconstant)






### AvogadroConstant
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_176cae33_b83e_4cd2_a6bc_281f42f0ccc8](http://emmo.info/emmo/middle/siunits#emmo_176cae33_b83e_4cd2_a6bc_281f42f0ccc8)

**Elucidation:** The number of constituent particles, usually atoms or molecules, that are contained in the amount of substance given by one mole.

**Comment:** The DBpedia definition (http://dbpedia.org/page/Avogadro_constant) is outdated as May 20, 2019. It is now an exact quantity.

**Dbpediamatch:** [http://dbpedia.org/page/Avogadro_constant](http://dbpedia.org/page/avogadro_constant)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.A00543](https://doi.org/10.1351/goldbook.a00543)

**Qudtmatch:** [http://physics.nist.gov/cuu/CODATA-Value_AvogadroConstant](http://physics.nist.gov/cuu/codata-value_avogadroconstant)

**Relations:** 

  - is_a [SIExactConstant](#siexactconstant)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [PerAmountDimension](#peramountdimension)
  - disjoint_with [Collection](#collection), [OrdinalQuantity](#ordinalquantity), [MeasuredConstant](#measuredconstant), [ElementaryCharge](#elementarycharge), [Quantum](#quantum), [SIPrefixedUnit](#siprefixedunit), [LuminousEfficacy](#luminousefficacy), [BoltzmannConstant](#boltzmannconstant), [HyperfineTransitionFrequencyOfCs](#hyperfinetransitionfrequencyofcs), [PlanckConstant](#planckconstant), [SpeedOfLightInVacuum](#speedoflightinvacuum), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### LuminousEfficacy
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_506f7823_52bc_40cb_be07_b3b1e10cce13](http://emmo.info/emmo/middle/siunits#emmo_506f7823_52bc_40cb_be07_b3b1e10cce13)

**Elucidation:** The luminous efficacy of monochromatic radiation of frequency 540 × 10 12 Hz, K cd , is a technical constant that gives an exact numerical relationship between the purely physical characteristics of the radiant power stimulating the human eye (W) and its photobiological response defined by the luminous flux due to the spectral responsivity of a standard observer (lm) at a frequency of 540 × 10 12 hertz.

**Relations:** 

  - is_a [SIExactConstant](#siexactconstant)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [LuminousIntensityCubicTimePerMassLengthDimension](#luminousintensitycubictimepermasslengthdimension)
  - disjoint_with [Collection](#collection), [OrdinalQuantity](#ordinalquantity), [MeasuredConstant](#measuredconstant), [ElementaryCharge](#elementarycharge), [AvogadroConstant](#avogadroconstant), [Quantum](#quantum), [SIPrefixedUnit](#siprefixedunit), [BoltzmannConstant](#boltzmannconstant), [HyperfineTransitionFrequencyOfCs](#hyperfinetransitionfrequencyofcs), [PlanckConstant](#planckconstant), [SpeedOfLightInVacuum](#speedoflightinvacuum), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### SIExactConstant
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_f2ca6dd0_0e5f_4392_a92d_cafdae6cfc95](http://emmo.info/emmo/middle/siunits#emmo_f2ca6dd0_0e5f_4392_a92d_cafdae6cfc95)

**Elucidation:** Physical constant that by definition (after the latest revision of the SI system that was enforsed May 2019) has a known exact numerical value when expressed in SI units.

**Relations:** 

  - is_a [ExactConstant](#exactconstant)
  - disjoint_with [Collection](#collection), [OrdinalQuantity](#ordinalquantity), [MeasuredConstant](#measuredconstant), [Quantum](#quantum), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)
  - disjoint_union_of [AvogadroConstant](#avogadroconstant), [LuminousEfficacy](#luminousefficacy), [ElementaryCharge](#elementarycharge), [PlanckConstant](#planckconstant), [SpeedOfLightInVacuum](#speedoflightinvacuum), [HyperfineTransitionFrequencyOfCs](#hyperfinetransitionfrequencyofcs), [BoltzmannConstant](#boltzmannconstant)






### ExactConstant
**IRI:** [http://emmo.info/emmo/middle/metrology#EMMO_89762966_8076_4f7c_b745_f718d653e8e2](http://emmo.info/emmo/middle/metrology#emmo_89762966_8076_4f7c_b745_f718d653e8e2)

**Comment:** Physical constant used to define a unit system. Hence, when expressed in that unit system they have an exact value with no associated uncertainty.

**Relations:** 

  - is_a [PhysicalConstant](#physicalconstant)
  - disjoint_with [Collection](#collection), [OrdinalQuantity](#ordinalquantity), [MeasuredConstant](#measuredconstant), [Quantum](#quantum), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### BoltzmannConstant
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_ffc7735f_c177_46a4_98e9_a54440d29209](http://emmo.info/emmo/middle/siunits#emmo_ffc7735f_c177_46a4_98e9_a54440d29209)

**Elucidation:** A physical constant relating energy at the individual particle level with temperature. It is the gas constant R divided by the Avogadro constant.

**Comment:** The DBpedia definition (http://dbpedia.org/page/Boltzmann_constant) is outdated as May 20, 2019. It is now an exact quantity.

**Dbpediamatch:** [http://dbpedia.org/page/Boltzmann_constant](http://dbpedia.org/page/boltzmann_constant)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.B00695](https://doi.org/10.1351/goldbook.b00695)

**Qudtmatch:** [http://physics.nist.gov/cuu/CODATA-Value_BoltzmannConstant](http://physics.nist.gov/cuu/codata-value_boltzmannconstant)

**Relations:** 

  - is_a [SIExactConstant](#siexactconstant)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [MassSquareLengthPerTemperatureSquareTimeDimension](#masssquarelengthpertemperaturesquaretimedimension)
  - disjoint_with [Collection](#collection), [OrdinalQuantity](#ordinalquantity), [MeasuredConstant](#measuredconstant), [ElementaryCharge](#elementarycharge), [AvogadroConstant](#avogadroconstant), [Quantum](#quantum), [SIPrefixedUnit](#siprefixedunit), [LuminousEfficacy](#luminousefficacy), [HyperfineTransitionFrequencyOfCs](#hyperfinetransitionfrequencyofcs), [PlanckConstant](#planckconstant), [SpeedOfLightInVacuum](#speedoflightinvacuum), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### HyperfineTransitionFrequencyOfCs
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_f96feb3f_4438_4e43_aa44_7458c4d87fc2](http://emmo.info/emmo/middle/siunits#emmo_f96feb3f_4438_4e43_aa44_7458c4d87fc2)

**Elucidation:** The frequency standard in the SI system in which the photon absorption by transitions between the two hyperfine ground states of caesium-133 atoms are used to control the output frequency.

**Relations:** 

  - is_a [Frequency](#frequency)
  - is_a [SIExactConstant](#siexactconstant)
  - disjoint_with [OrdinalQuantity](#ordinalquantity), [Collection](#collection), [MeasuredConstant](#measuredconstant), [ElementaryCharge](#elementarycharge), [AvogadroConstant](#avogadroconstant), [Quantum](#quantum), [LuminousEfficacy](#luminousefficacy), [BoltzmannConstant](#boltzmannconstant), [BaseQuantity](#basequantity), [PlanckConstant](#planckconstant), [SpeedOfLightInVacuum](#speedoflightinvacuum), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### PlanckConstant
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_76cc4efc_231e_42b4_be83_2547681caed6](http://emmo.info/emmo/middle/siunits#emmo_76cc4efc_231e_42b4_be83_2547681caed6)

**Elucidation:** The quantum of action.

**Dbpediamatch:** [http://dbpedia.org/page/Planck_constant](http://dbpedia.org/page/planck_constant)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.P04685](https://doi.org/10.1351/goldbook.p04685)

**Qudtmatch:** [http://physics.nist.gov/cuu/CODATA-Value_PlankConstant](http://physics.nist.gov/cuu/codata-value_plankconstant)

**Relations:** 

  - is_a [SIExactConstant](#siexactconstant)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [MassSquareLengthPerTimeDimension](#masssquarelengthpertimedimension)
  - disjoint_with [Collection](#collection), [OrdinalQuantity](#ordinalquantity), [MeasuredConstant](#measuredconstant), [ElementaryCharge](#elementarycharge), [AvogadroConstant](#avogadroconstant), [Quantum](#quantum), [SIPrefixedUnit](#siprefixedunit), [LuminousEfficacy](#luminousefficacy), [BoltzmannConstant](#boltzmannconstant), [HyperfineTransitionFrequencyOfCs](#hyperfinetransitionfrequencyofcs), [SpeedOfLightInVacuum](#speedoflightinvacuum), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### SpeedOfLightInVacuum
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_99296e55_53f7_4333_9e06_760ad175a1b9](http://emmo.info/emmo/middle/siunits#emmo_99296e55_53f7_4333_9e06_760ad175a1b9)

**Elucidation:** The speed of light in vacuum.

**Dbpediamatch:** [http://dbpedia.org/page/Speed_of_light](http://dbpedia.org/page/speed_of_light)

**Iupacdoi:** [https://doi.org/10.1351/goldbook.S05854](https://doi.org/10.1351/goldbook.s05854)

**Qudtmatch:** [http://physics.nist.gov/cuu/CODATA-Value_SpeedOfLightInVacuum](http://physics.nist.gov/cuu/codata-value_speedoflightinvacuum)

**Relations:** 

  - is_a [SIExactConstant](#siexactconstant)
  - [hasReferenceUnit](#hasreferenceunit) only [hasPhysicsDimension](#hasphysicsdimension) only [LengthPerTimeDimension](#lengthpertimedimension)
  - disjoint_with [Collection](#collection), [OrdinalQuantity](#ordinalquantity), [MeasuredConstant](#measuredconstant), [ElementaryCharge](#elementarycharge), [AvogadroConstant](#avogadroconstant), [Quantum](#quantum), [SIPrefixedUnit](#siprefixedunit), [LuminousEfficacy](#luminousefficacy), [BoltzmannConstant](#boltzmannconstant), [HyperfineTransitionFrequencyOfCs](#hyperfinetransitionfrequencyofcs), [PlanckConstant](#planckconstant), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)








## Reductionistic branch
![Reductionistic branch.](genfigs/ReductionisticT.pdf){ width=668px }


### Reductionistic
**IRI:** [http://emmo.info/emmo/middle/reductionistic#EMMO_15db234d_ecaf_4715_9838_4b4ec424fb13](http://emmo.info/emmo/middle/reductionistic#emmo_15db234d_ecaf_4715_9838_4b4ec424fb13)

**Elucidation:** A class devoted to categorize 'Physical'-s according to their granularity relations, first in terms of time evolution (Existent) and then in terms of their composition (State), up to the spatial a-tomistic element (Elementary).

Direct parthood is the relation used to build the class hierarchy (and the granularity hierarchy).

**Relations:** 

  - is_a [Perspective](#perspective)
  - equivalent_to [State](#state) or [Existent](#existent)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Void](#void), [Elementary](#elementary)






### SymbolicComposition
**IRI:** [http://emmo.info/emmo/middle/perceptual#EMMO_89a0c87c_0804_4013_937a_6fe234d9499c](http://emmo.info/emmo/middle/perceptual#emmo_89a0c87c_0804_4013_937a_6fe234d9499c)

**Elucidation:** A symbolic entity made of other symbolic entities according to a specific spatial configuration.

**Relations:** 

  - is_a [Symbolic](#symbolic)
  - is_a [State](#state)
  - [hasSpatialDirectPart](#hasspatialdirectpart) some [Symbolic](#symbolic)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Void](#void), [Elementary](#elementary)






### Existent
**IRI:** [http://emmo.info/emmo/middle/reductionistic#EMMO_52211e5e_d767_4812_845e_eb6b402c476a](http://emmo.info/emmo/middle/reductionistic#emmo_52211e5e_d767_4812_845e_eb6b402c476a)

**Elucidation:** A 'Physical' which is a tessellation of 'State' temporal direct parts.

**Comment:** 'Existent' is the EMMO class to be used for representing real world physical objects under a reductionistic perspective (i.e. objects come from the composition of sub-part objects, both in time and space). 

'Existent' class collects all individuals that stand for physical objects that can be structured in well defined temporal sub-parts called states, through the temporal direct parthood relation.

This class provides a first granularity hierarchy in time, and a way to axiomatize tessellation principles for a specific whole with a non-transitivity relation (direct parthood) that helps to retain the granularity levels.

e.g. a car, a supersaturated gas with nucleating nanoparticles, an atom that becomes ionized and then recombines with an electron.

**Comment:** An 'Existent' individual stands for a real world object for which the ontologist can provide univocal tessellation in time.

By definition, the tiles are represented by 'State'-s individual.

Tiles are related to the 'Existent' through temporal direct parthood, enforcing non-transitivity and inverse-functionality.

**Comment:** Being hasTemporalDirectPart a proper parthood relation, there cannot be 'Existent' made of a single 'State'.

Moreover, due to inverse functionality, a 'State' can be part of only one 'Existent', preventing overlapping between 'Existent'-s.

**Comment:** ex-sistere (latin): to stay (to persist through time) outside others of the same type (to be distinct from the rest).

**Relations:** 

  - is_a [Reductionistic](#reductionistic)
  - [hasTemporalDirectPart](#hastemporaldirectpart) some [State](#state)
  - [hasTemporalDirectPart](#hastemporaldirectpart) only [State](#state)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Void](#void), [Elementary](#elementary)






### State
**IRI:** [http://emmo.info/emmo/middle/reductionistic#EMMO_36c79456_e29c_400d_8bd3_0eedddb82652](http://emmo.info/emmo/middle/reductionistic#emmo_36c79456_e29c_400d_8bd3_0eedddb82652)

**Elucidation:** A 'Physical' which is a tessellation of spatial direct parts.

**Example:** e.g. the existent in my glass is declared at t = t_start as made of two direct parts: the ice and the water. It will continue to exists as state as long as the ice is completely melt at t = t_end. The new state will be completely made of water. Between t_start and t_end there is an exchange of molecules between the ice and the water, but this does not affect the existence of the two states.

If we partition the existent in my glass as ice surrounded by several molecules (we do not use the object water as direct part) then the appearance of a molecule coming from the ice will cause a state to end and another state to begin.

**Comment:** Direct partitions declaration is a choice of the ontologist that choses the classes to be used as direct parts, according to its own world view.

A 'State' can always be direct partitioned in 'Elementary'-s and 'Void' or 'Physical'.

e.g. the water in my glass can be seen as a single object without declaring direct parts, or as made of H2O molecules direct parts.

**Comment:** The definition of 'State' implies that its spatial direct parts (i.e. 'physicals') are not gained or lost during its temporal extension (they exist from the left to the right side of the time interval), so that the cardinality of spatial direct parts in a 'State' is constant.

This does not mean that there cannot be a change in the internal structure of the 'State' direct parts. It means only that this change must not affect the existence of the direct part itself.

There is no change in granularity or cardinality of direct parts of a 'State'.

The use of spatial direct parthood in 'State' definition means that a 'State' cannot overlap in space another 'State'.

**Comment:** The usefulness of 'State' is that it makes it possible to describe the evolution in time of an 'Existent' in terms of series of 'State'-s that can take into account the disappearance or appearance of parts within a 'Physical'. 

A 'State' is a recognizable granularity level of matter, in the sense that its direct parts do not appear or disappear within its lifetime as it can be for a generic 'Existent'.

**Comment:** There is no change in granularity or cardinality of parts within a state.

The use of spatial direct parthood in state definition means that a state cannot overlap in space another state that is direct part of the same whole.

**Relations:** 

  - is_a [Reductionistic](#reductionistic)
  - [hasSpatialDirectPart](#hasspatialdirectpart) some [Physical](#physical)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Void](#void), [Elementary](#elementary)






### String
**IRI:** [http://emmo.info/emmo/middle/perceptual#EMMO_50ea1ec5_f157_41b0_b46b_a9032f17ca10](http://emmo.info/emmo/middle/perceptual#emmo_50ea1ec5_f157_41b0_b46b_a9032f17ca10)

**Elucidation:** A physical made of more than one symbol sequentially arranged.

**Example:** The word "cat" considered as a collection of 'symbol'-s respecting the rules of english language. 

In this example the 'symbolic' entity "cat" is not related to the real cat, but it is only a word (like it would be to an italian person that ignores the meaning of this english word).

If an 'interpreter' skilled in english language is involved in a 'semiotic' process with this word, that "cat" became also a 'sign' i.e. it became for the 'interpreter' a representation for a real cat.

**Comment:** A string is made of concatenated symbols whose arrangement is one-dimensional. Each symbol can have only one previous and one next neighborhood (bidirectional list).

**Comment:** A string is not requested to respect any syntactic rule: it's simply directly made of symbols.

**Relations:** 

  - is_a [Symbolic](#symbolic)
  - is_a [State](#state)
  - [hasSpatialDirectPart](#hasspatialdirectpart) some [Symbol](#symbol)
  - [hasSpatialDirectPart](#hasspatialdirectpart) only [Symbol](#symbol)
  - disjoint_with [Collection](#collection), [PhysicsEquation](#physicsequation), [MaterialRelation](#materialrelation), [Quantum](#quantum), [Void](#void), [Elementary](#elementary)






## Expression branch
![Expression branch.](genfigs/ExpressionT.pdf){ width=518px }


### Polynomial
**IRI:** [http://emmo.info/emmo/top/math#EMMO_91447ec0_fb55_49f2_85a5_3172dff6482c](http://emmo.info/emmo/top/math#emmo_91447ec0_fb55_49f2_85a5_3172dff6482c)

**Example:** 2 * x^2 + x + 3

**Relations:** 

  - is_a [AlgebricExpression](#algebricexpression)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Void](#void), [Elementary](#elementary)






### ArithmeticExpression
**IRI:** [http://emmo.info/emmo/middle/math#EMMO_89083bab_f69c_4d06_bf6d_62973b56cdc7](http://emmo.info/emmo/middle/math#emmo_89083bab_f69c_4d06_bf6d_62973b56cdc7)

**Example:** 2+2

**Relations:** 

  - is_a [AlgebricExpression](#algebricexpression)
  - is_a not [hasSpatialDirectPart](#hasspatialdirectpart) some [Variable](#variable)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [PrefixedUnit](#prefixedunit), [Void](#void), [Elementary](#elementary)






### Expression
**IRI:** [http://emmo.info/emmo/middle/math#EMMO_f9bc8b52_85e9_4b53_b969_dd7724d5b8e4](http://emmo.info/emmo/middle/math#emmo_f9bc8b52_85e9_4b53_b969_dd7724d5b8e4)

**Elucidation:** A well-formed finite combination of mathematical symbols according to some specific rules.

**Relations:** 

  - is_a [Mathematical](#mathematical)
  - is_a [SymbolicComposition](#symboliccomposition)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Void](#void), [Elementary](#elementary)






### AlgebricExpression
**IRI:** [http://emmo.info/emmo/top/math#EMMO_1aed91a3_d00c_48af_8f43_a0c958b2512a](http://emmo.info/emmo/top/math#emmo_1aed91a3_d00c_48af_8f43_a0c958b2512a)

**Example:** 2x+3

**Comment:** An expression that has parts only integer constants, variables, and the algebraic operations (addition, subtraction, multiplication, division and exponentiation by an exponent that is a rational number)

**Relations:** 

  - is_a [Expression](#expression)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Void](#void), [Elementary](#elementary)






## Formula branch
![Formula branch.](genfigs/FormulaT.pdf){ width=668px }


### Equation
**IRI:** [http://emmo.info/emmo/middle/math#EMMO_e56ee3eb_7609_4ae1_8bed_51974f0960a6](http://emmo.info/emmo/middle/math#emmo_e56ee3eb_7609_4ae1_8bed_51974f0960a6)

**Elucidation:** The class of 'mathematical'-s that stand for a statement of equality between two mathematical expressions.

**Example:** 2+3 = 5
x^2 +3x  = 5x
dv/dt = a
sin(x) = y

**Comment:** An equation with variables can always be represented as:

f(v0, v1, ..., vn) = g(v0, v1, ..., vn)

where f is the left hand and g the right hand  side expressions and v0, v1, ..., vn are the variables.

**Relations:** 

  - is_a [Formula](#formula)
  - is_a [Mathematical](#mathematical)
  - [hasSpatialDirectPart](#hasspatialdirectpart) some [Expression](#expression)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### FunctionDefinition
**IRI:** [http://emmo.info/emmo/top/math#EMMO_4bc29b0f_8fcc_4026_a291_f9774a66d9b8](http://emmo.info/emmo/top/math#emmo_4bc29b0f_8fcc_4026_a291_f9774a66d9b8)

**Elucidation:** A function defined using functional notation.

**Example:** y = f(x)

**Relations:** 

  - is_a [DefiningEquation](#definingequation)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### Formula
**IRI:** [http://emmo.info/emmo/middle/math#EMMO_88470739_03d3_4c47_a03e_b30a1288d50c](http://emmo.info/emmo/middle/math#emmo_88470739_03d3_4c47_a03e_b30a1288d50c)

**Elucidation:** A mathematica string that can be evaluated as true or false.

**Relations:** 

  - is_a [Mathematical](#mathematical)
  - is_a [SymbolicComposition](#symboliccomposition)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Void](#void), [Elementary](#elementary)






### PhysicsEquation
**IRI:** [http://emmo.info/emmo/middle/models#EMMO_27c5d8c6_8af7_4d63_beb1_ec37cd8b3fa3](http://emmo.info/emmo/middle/models#emmo_27c5d8c6_8af7_4d63_beb1_ec37cd8b3fa3)

**Elucidation:** An 'equation' that stands for a 'physical_law' by mathematically defining the relations between physics_quantities.

**Comment:** The Newton's equation of motion.

The Schrodinger equation.

The Navier-Stokes equation.

**Relations:** 

  - is_a [Equation](#equation)
  - is_a [MathematicalModel](#mathematicalmodel)
  - [hasSpatialDirectPart](#hasspatialdirectpart) some [PhysicalQuantity](#physicalquantity)
  - Inverse([hasModel](#hasmodel)) some [PhysicalPhenomenon](#physicalphenomenon)
  - disjoint_with [Symbol](#symbol), [Collection](#collection), [Quantum](#quantum), [String](#string), [PrefixedUnit](#prefixedunit), [Void](#void), [Elementary](#elementary)






### Inequality
**IRI:** [http://emmo.info/emmo/middle/math#EMMO_0b6ebe5a_0026_4bef_a1c1_5be00df9f98e](http://emmo.info/emmo/middle/math#emmo_0b6ebe5a_0026_4bef_a1c1_5be00df9f98e)

**Elucidation:** A relation which makes a non-equal comparison between two numbers or other mathematical expressions.

**Example:** f(x) > 0

**Relations:** 

  - is_a [Formula](#formula)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Void](#void), [Elementary](#elementary)






### MaterialRelation
**IRI:** [http://emmo.info/emmo/middle/models#EMMO_e5438930_04e7_4d42_ade5_3700d4a52ab7](http://emmo.info/emmo/middle/models#emmo_e5438930_04e7_4d42_ade5_3700d4a52ab7)

**Elucidation:** An 'equation' that stands for a physical assumption specific to a material, and provides an expression for a 'physics_quantity' (the dependent variable) as function of other variables, physics_quantity or data (independent variables).

**Example:** The Lennard-Jones potential.

A force field.

An Hamiltonian.

**Comment:** A material_relation can e.g. return a predefined number, return a database query, be an equation that depends on other physics_quantities.

**Relations:** 

  - is_a [Equation](#equation)
  - [hasSpatialDirectPart](#hasspatialdirectpart) some [PhysicalQuantity](#physicalquantity)
  - disjoint_with [Symbol](#symbol), [Collection](#collection), [Quantum](#quantum), [String](#string), [PrefixedUnit](#prefixedunit), [Void](#void), [Elementary](#elementary)






### AlgebricEquation
**IRI:** [http://emmo.info/emmo/top/math#EMMO_98d65021_4574_4890_b2fb_46430841077f](http://emmo.info/emmo/top/math#emmo_98d65021_4574_4890_b2fb_46430841077f)

**Example:** 2 * a - b = c

**Comment:** An 'equation' that has parts two 'polynomial'-s

**Relations:** 

  - is_a [Equation](#equation)
  - [hasSpatialDirectPart](#hasspatialdirectpart) some [AlgebricExpression](#algebricexpression)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### ArithmeticEquation
**IRI:** [http://emmo.info/emmo/top/math#EMMO_a6138ba7_e365_4f2d_b6b4_fe5a5918d403](http://emmo.info/emmo/top/math#emmo_a6138ba7_e365_4f2d_b6b4_fe5a5918d403)

**Example:** 1 + 1 = 2

**Relations:** 

  - is_a [Equation](#equation)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)






### DefiningEquation
**IRI:** [http://emmo.info/emmo/top/math#EMMO_29afdf54_90ae_4c98_8845_fa9ea3f143a8](http://emmo.info/emmo/top/math#emmo_29afdf54_90ae_4c98_8845_fa9ea3f143a8)

**Elucidation:** An equation that define a new variable in terms of other mathematical entities.

**Example:** The definition of velocity as v = dx/dt.

The definition of density as mass/volume.

y = f(x)

**Relations:** 

  - is_a [Equation](#equation)
  - disjoint_with [Collection](#collection), [Quantum](#quantum), [Symbol](#symbol), [Void](#void), [Elementary](#elementary)







## Physicalistic branch
![Physicalistic branch.](genfigs/PhysicalisticT.pdf){ width=668px }


### Physicalistic
**IRI:** [http://emmo.info/emmo/middle/physicalistic#EMMO_98ada9d8_f1c8_4f13_99b5_d890f5354152](http://emmo.info/emmo/middle/physicalistic#emmo_98ada9d8_f1c8_4f13_99b5_d890f5354152)

**Elucidation:** The perspective for which physical objects are categorized only by concepts coming from physics.

**Relations:** 

  - is_a [Perspective](#perspective)
  - equivalent_to [Matter](#matter) or [Field](#field)
  - disjoint_with [Collection](#collection), [Void](#void)






### Field
**IRI:** [http://emmo.info/emmo/middle/physicalistic#EMMO_70dac51e_bddd_48c2_8a98_7d8395e91fc2](http://emmo.info/emmo/middle/physicalistic#emmo_70dac51e_bddd_48c2_8a98_7d8395e91fc2)

**Elucidation:** A 'Physical' with 'Massless' parts that are mediators of interactions.

**Comment:** The concepts of matter and field for classical physics, upon which we can categorize physical entities, are replaced in quantum physics by the more general concepts of quantum field.

Here the class 'Field' refers to the quantum field of massless bosonic particles (i.e. photons, gluons), while the class 'Matter' refers to the quantum field of massive fermionic or bosonic particles (e.g. quarks, electrons).

**Relations:** 

  - is_a [Physicalistic](#physicalistic)
  - is_a [Physical](#physical)
  - [hasPart](#haspart) some [Massless](#massless)
  - [hasTemporalPart](#hastemporalpart) only [Field](#field)
  - disjoint_with [Collection](#collection), [Void](#void)






### Matter
**IRI:** [http://emmo.info/emmo/middle/physicalistic#EMMO_5b2222df_4da6_442f_8244_96e9e45887d1](http://emmo.info/emmo/middle/physicalistic#emmo_5b2222df_4da6_442f_8244_96e9e45887d1)

**Elucidation:** A 'Physical' that possesses some 'Massive' parts.

**Relations:** 

  - is_a [Physicalistic](#physicalistic)
  - is_a [Physical](#physical)
  - [hasPart](#haspart) some [Massive](#massive)
  - [hasTemporalPart](#hastemporalpart) only [Matter](#matter)
  - disjoint_with [Vacuum](#vacuum), [Collection](#collection), [Void](#void)






### Material
**IRI:** [http://emmo.info/emmo/middle/physicalistic#EMMO_4207e895_8b83_4318_996a_72cfb32acd94](http://emmo.info/emmo/middle/physicalistic#emmo_4207e895_8b83_4318_996a_72cfb32acd94)

**Elucidation:** A 'Physical' that stands for a real world object that represents an amount of a physical substance (or mixture of substances) that constitute (is part of) a more comprehensive real world object.

**Comment:** The definition states that a 'Material' is a portion of a real world object, being that a full functional device or component, or a sample made of that material (or the sample itself).

**Relations:** 

  - is_a [Matter](#matter)
  - disjoint_with [Vacuum](#vacuum), [Collection](#collection), [Void](#void)






### Vacuum
**IRI:** [http://emmo.info/emmo/middle/physicalistic#EMMO_3c218fbe_60c9_4597_8bcf_41eb1773af1f](http://emmo.info/emmo/middle/physicalistic#emmo_3c218fbe_60c9_4597_8bcf_41eb1773af1f)

**Elucidation:** A 'Physical' with no 'Massive' parts.

**Relations:** 

  - is_a [Field](#field)
  - equivalent_to [Field](#field) and not [Matter](#matter)
  - disjoint_with [Void](#void), [Collection](#collection), [Matter](#matter)






## Elementary Particle branch
![Elementary Particle branch.](genfigs/ElementaryParticleT.pdf){ width=668px }


### Massive
**IRI:** [http://emmo.info/emmo/middle/physicalistic#EMMO_385b8f6e_43ac_4596_ad76_ac322c68b7ca](http://emmo.info/emmo/middle/physicalistic#emmo_385b8f6e_43ac_4596_ad76_ac322c68b7ca)

**Elucidation:** The union of classes of elementary particles that possess mass.

**Relations:** 

  - is_a [ElementaryParticle](#elementaryparticle)
  - equivalent_to [Quark](#quark) or [Electron](#electron)
  - disjoint_with [System](#system), [Collection](#collection), [PhysicsBasedModel](#physicsbasedmodel), [Massless](#massless), [Reductionistic](#reductionistic), [Interpreter](#interpreter), [Void](#void)






### Photon
**IRI:** [http://emmo.info/emmo/middle/physicalistic#EMMO_25f8b804_9a0b_4387_a3e7_b35bce5365ee](http://emmo.info/emmo/middle/physicalistic#emmo_25f8b804_9a0b_4387_a3e7_b35bce5365ee)

**Comment:** The class of individuals that stand for photons elementary particles.

**Relations:** 

  - is_a [Massless](#massless)
  - is_a [Elementary](#elementary)
  - disjoint_with [Massive](#massive), [Collection](#collection), [System](#system), [PhysicsBasedModel](#physicsbasedmodel), [Graviton](#graviton), [Reductionistic](#reductionistic), [Interpreter](#interpreter), [Gluon](#gluon), [Void](#void)






### Massless
**IRI:** [http://emmo.info/emmo/middle/physicalistic#EMMO_e5488299_8dab_4ebb_900a_26d2abed8396](http://emmo.info/emmo/middle/physicalistic#emmo_e5488299_8dab_4ebb_900a_26d2abed8396)

**Elucidation:** The union of classes of elementary particles that do not possess mass.

**Relations:** 

  - is_a [ElementaryParticle](#elementaryparticle)
  - equivalent_to [Photon](#photon) or [Gluon](#gluon) or [Graviton](#graviton)
  - disjoint_with [Massive](#massive), [Collection](#collection), [System](#system), [PhysicsBasedModel](#physicsbasedmodel), [Reductionistic](#reductionistic), [Interpreter](#interpreter), [Void](#void)






### Graviton
**IRI:** [http://emmo.info/emmo/middle/physicalistic#EMMO_eb3c61f0_3983_4346_a0c6_e7f6b90a67a8](http://emmo.info/emmo/middle/physicalistic#emmo_eb3c61f0_3983_4346_a0c6_e7f6b90a67a8)

**Elucidation:** The class of individuals that stand for gravitons elementary particles.

**Comment:** While this particle is only supposed to exist, the EMMO approach to classical and quantum systems represents fields as made of particles.

For this reason graviton is an useful concept to homogenize the approach between different fields.

**Relations:** 

  - is_a [Massless](#massless)
  - is_a [Elementary](#elementary)
  - disjoint_with [Massive](#massive), [Collection](#collection), [System](#system), [PhysicsBasedModel](#physicsbasedmodel), [Photon](#photon), [Reductionistic](#reductionistic), [Interpreter](#interpreter), [Gluon](#gluon), [Void](#void)






### ElementaryParticle
**IRI:** [http://emmo.info/emmo/middle/physicalistic#EMMO_c26a0340_d619_4928_b1a1_1a04e88bb89d](http://emmo.info/emmo/middle/physicalistic#emmo_c26a0340_d619_4928_b1a1_1a04e88bb89d)

**Elucidation:** The union of all classes categorizing elementary particles according to the Standard Model.

**Comment:** Only a subset of elementary particles from the Standard Model are here included for the sake of simplicity.

**Relations:** 

  - is_a [Physicalistic](#physicalistic)
  - is_a [Elementary](#elementary)
  - disjoint_with [System](#system), [Collection](#collection), [PhysicsBasedModel](#physicsbasedmodel), [Reductionistic](#reductionistic), [Interpreter](#interpreter), [Void](#void)
  - disjoint_union_of [Photon](#photon), [Quark](#quark), [Gluon](#gluon), [Electron](#electron), [Graviton](#graviton)






### Electron
**IRI:** [http://emmo.info/emmo/middle/physicalistic#EMMO_8043d3c6_a4c1_4089_ba34_9744e28e5b3d](http://emmo.info/emmo/middle/physicalistic#emmo_8043d3c6_a4c1_4089_ba34_9744e28e5b3d)

**Elucidation:** The class of individuals that stand for electrons elemntary particles.

**Relations:** 

  - is_a [Massive](#massive)
  - is_a [Elementary](#elementary)
  - disjoint_with [System](#system), [Collection](#collection), [PhysicsBasedModel](#physicsbasedmodel), [Massless](#massless), [Reductionistic](#reductionistic), [Interpreter](#interpreter), [Quark](#quark), [Void](#void)






### Gluon
**IRI:** [http://emmo.info/emmo/middle/physicalistic#EMMO_7db59e56_f68b_48b7_ae99_891c35ae5c3b](http://emmo.info/emmo/middle/physicalistic#emmo_7db59e56_f68b_48b7_ae99_891c35ae5c3b)

**Elucidation:** The class of individuals that stand for gluons elementary particles.

**Relations:** 

  - is_a [Massless](#massless)
  - is_a [Elementary](#elementary)
  - disjoint_with [Massive](#massive), [Collection](#collection), [System](#system), [PhysicsBasedModel](#physicsbasedmodel), [Photon](#photon), [Graviton](#graviton), [Reductionistic](#reductionistic), [Interpreter](#interpreter), [Void](#void)






### Quark
**IRI:** [http://emmo.info/emmo/middle/physicalistic#EMMO_72d53756_7fb1_46ed_980f_83f47efbe105](http://emmo.info/emmo/middle/physicalistic#emmo_72d53756_7fb1_46ed_980f_83f47efbe105)

**Elucidation:** The class of individuals that stand for quarks elementary particles.

**Relations:** 

  - is_a [Massive](#massive)
  - is_a [Elementary](#elementary)
  - disjoint_with [System](#system), [Collection](#collection), [PhysicsBasedModel](#physicsbasedmodel), [Massless](#massless), [Electron](#electron), [Reductionistic](#reductionistic), [Interpreter](#interpreter), [Void](#void)






## Material State branch
![Material State branch.](genfigs/MaterialStateT.pdf){ width=554px }


### BondedAtom
**IRI:** [http://emmo.info/emmo/middle/materials#EMMO_8303a247_f9d9_4616_bdcd_f5cbd7b298e3](http://emmo.info/emmo/middle/materials#emmo_8303a247_f9d9_4616_bdcd_f5cbd7b298e3)

**Elucidation:** An bonded atom that shares at least one electron to the atom-based entity of which is part of.

**Comment:** A real bond between atoms is always something hybrid between covalent, metallic and ionic.

In general, metallic and ionic bonds have atoms sharing electrons.

**Comment:** The bond types that are covered by this definition are the strong electonic bonds: covalent, metallic and ionic.

**Comment:** This class can be used to represent molecules as simplified quantum systems, in which outer molecule shared electrons are un-entangled with the inner shells of the atoms composing the molecule.

**Relations:** 

  - is_a [Atom](#atom)
  - disjoint_with [Collection](#collection), [Vacuum](#vacuum), [Quantum](#quantum), [Void](#void), [Elementary](#elementary)






### Atom
**IRI:** [http://emmo.info/emmo/middle/materials#EMMO_eb77076b_a104_42ac_a065_798b2d2809ad](http://emmo.info/emmo/middle/materials#emmo_eb77076b_a104_42ac_a065_798b2d2809ad)

**Elucidation:** A standalone atom has direct part one 'nucleus' and one 'electron_cloud'. 

An O 'atom' within an O2 'molecule' is an 'e-bonded_atom'.

In this material branch, H atom is a particular case, with respect to higher atomic number atoms, since as soon as it shares its electron it has no nucleus entangled electron cloud.

We cannot say that H2 molecule has direct part two H atoms, but has direct part two H nucleus.

**Comment:** An 'atom' is a 'nucleus' surrounded by an 'electron_cloud', i.e. a quantum system made of one or more bounded electrons.

**Relations:** 

  - is_a [MaterialState](#materialstate)
  - is_a [Material](#material)
  - is_a [State](#state)
  - [hasSpatialDirectPart](#hasspatialdirectpart) some [ElectronCloud](#electroncloud)
  - [hasSpatialDirectPart](#hasspatialdirectpart) some [Nucleus](#nucleus)
  - disjoint_with [Collection](#collection), [Vacuum](#vacuum), [Quantum](#quantum), [Void](#void), [Elementary](#elementary)






### Molecule
**IRI:** [http://emmo.info/emmo/middle/materials#EMMO_3397f270_dfc1_4500_8f6f_4d0d85ac5f71](http://emmo.info/emmo/middle/materials#emmo_3397f270_dfc1_4500_8f6f_4d0d85ac5f71)

**Elucidation:** An atom_based state defined by an exact number of e-bonded atomic species and an electron cloud made of the shared electrons.

**Example:** H20, C6H12O6, CH4

**Comment:** An entity is called essential if removing one direct part will lead to a change in entity class.

An entity is called redundand if removing one direct part will not lead to a change in entity class.

**Comment:** This definition states that this object is a non-periodic set of atoms or a set with a finite periodicity.

Removing an atom from the state will result in another type of atom_based state.

e.g. you cannot remove H from H20 without changing the molecule type (essential). However, you can remove a C from a nanotube (redundant). C60 fullerene is a molecule, since it has a finite periodicity and is made of a well defined number of atoms (essential). A C nanotube is not a molecule, since it has an infinite periodicity (redundant).

**Relations:** 

  - is_a [MaterialState](#materialstate)
  - is_a [Material](#material)
  - is_a [State](#state)
  - disjoint_with [Collection](#collection), [Vacuum](#vacuum), [Quantum](#quantum), [Void](#void), [Elementary](#elementary)






### Solid
**IRI:** [http://emmo.info/emmo/middle/materials#EMMO_a2b006f2_bbfd_4dba_bcaa_3fca20cd6be1](http://emmo.info/emmo/middle/materials#emmo_a2b006f2_bbfd_4dba_bcaa_3fca20cd6be1)

**Elucidation:** A continuum characterized by structural rigidity and resistance to changes of shape or volume, that retains its shape and density when not confined.

**Relations:** 

  - is_a [Continuum](#continuum)
  - disjoint_with [Collection](#collection), [Vacuum](#vacuum), [Quantum](#quantum), [Void](#void), [Elementary](#elementary)






### MaterialState
**IRI:** [http://emmo.info/emmo/middle/materials#EMMO_20fff605_465f_4034_8696_e53e90ec83f4](http://emmo.info/emmo/middle/materials#emmo_20fff605_465f_4034_8696_e53e90ec83f4)

**Elucidation:** A union of the four base classes for the classification of materials according to the DG-RTD Review of Materials Modelling.

**Seealso:** [https://op.europa.eu/en/publication-detail/-/publication/e0845ae1-1b60-11e7-aeb3-01aa75ed71a1](https://op.europa.eu/en/publication-detail/-/publication/e0845ae1-1b60-11e7-aeb3-01aa75ed71a1)

**Relations:** 

  - is_a [Material](#material)
  - is_a [State](#state)
  - equivalent_to [Material](#material) and [State](#state)
  - disjoint_with [Collection](#collection), [Vacuum](#vacuum), [Quantum](#quantum), [Void](#void), [Elementary](#elementary)






### IonAtom
**IRI:** [http://emmo.info/emmo/middle/materials#EMMO_db03061b_db31_4132_a47a_6a634846578b](http://emmo.info/emmo/middle/materials#emmo_db03061b_db31_4132_a47a_6a634846578b)

**Elucidation:** A standalone atom with an unbalanced number of electrons with respect to its atomic number.

**Comment:** The ion_atom is the basic part of a pure ionic bonded compound i.e. without eclectron sharing,

**Relations:** 

  - is_a [StandaloneAtom](#standaloneatom)
  - disjoint_with [Collection](#collection), [Vacuum](#vacuum), [Quantum](#quantum), [NeutralAtom](#neutralatom), [Void](#void), [Elementary](#elementary)






### Fluid
**IRI:** [http://emmo.info/emmo/middle/materials#EMMO_87ac88ff_8379_4f5a_8c7b_424a8fff1ee8](http://emmo.info/emmo/middle/materials#emmo_87ac88ff_8379_4f5a_8c7b_424a8fff1ee8)

**Elucidation:** A continuum that has no fixed shape and yields easily to external pressure.

**Example:** Gas, liquid, plasma,

**Relations:** 

  - is_a [Continuum](#continuum)
  - disjoint_with [Collection](#collection), [Vacuum](#vacuum), [Quantum](#quantum), [Void](#void), [Elementary](#elementary)






### NeutralAtom
**IRI:** [http://emmo.info/emmo/middle/materials#EMMO_4588526f_8553_4f4d_aa73_a483e88d599b](http://emmo.info/emmo/middle/materials#emmo_4588526f_8553_4f4d_aa73_a483e88d599b)

**Elucidation:** A standalone atom that has no net charge.

**Relations:** 

  - is_a [StandaloneAtom](#standaloneatom)
  - disjoint_with [Collection](#collection), [Vacuum](#vacuum), [Quantum](#quantum), [IonAtom](#ionatom), [Void](#void), [Elementary](#elementary)






### Continuum
**IRI:** [http://emmo.info/emmo/middle/materials#EMMO_8b0923ab_b500_477b_9ce9_8b3a3e4dc4f2](http://emmo.info/emmo/middle/materials#emmo_8b0923ab_b500_477b_9ce9_8b3a3e4dc4f2)

**Elucidation:** A state that is a collection of sufficiently large number of other parts such that:
- it is the bearer of qualities that can exists only by the fact that it is a sum of parts
- the smallest partition dV of the state volume in which we are interested in, contains enough parts to be statistically consistent: n [#/m3] x dV [m3] >> 1

**Comment:** A continuum is made of a sufficient number of parts that it continues to exists as continuum individual even after the loss of one of them i.e. a continuum is a redundant.

**Comment:** A continuum is not necessarily small (i.e. composed by the minimum amount of sates to fulfill the definition).

A single continuum individual can be the whole fluid in a pipe.

**Comment:** A continuum is the bearer of properties that are generated by the interactions of parts such as viscosity and thermal or electrical conductivity.

**Relations:** 

  - is_a [MaterialState](#materialstate)
  - is_a [Material](#material)
  - is_a [State](#state)
  - disjoint_with [Collection](#collection), [Vacuum](#vacuum), [Quantum](#quantum), [Void](#void), [Elementary](#elementary)






### StandaloneAtom
**IRI:** [http://emmo.info/emmo/middle/materials#EMMO_2fd3f574_5e93_47fe_afca_ed80b0a21ab4](http://emmo.info/emmo/middle/materials#emmo_2fd3f574_5e93_47fe_afca_ed80b0a21ab4)

**Elucidation:** An atom that does not share electrons with other atoms.

**Comment:** A standalone atom can be bonded with other atoms by intermolecular forces (i.e. dipole–dipole, London dispersion force, hydrogen bonding), since this bonds does not involve electron sharing.

**Relations:** 

  - is_a [Atom](#atom)
  - disjoint_with [Collection](#collection), [Vacuum](#vacuum), [Quantum](#quantum), [Void](#void), [Elementary](#elementary)
  - disjoint_union_of [NeutralAtom](#neutralatom), [IonAtom](#ionatom)






## Subatomic branch
![Subatomic branch.](genfigs/SubatomicT.pdf){ width=668px }


### Nucleon
**IRI:** [http://emmo.info/emmo/middle/materials#EMMO_50781fd9_a9e4_46ad_b7be_4500371d188d](http://emmo.info/emmo/middle/materials#emmo_50781fd9_a9e4_46ad_b7be_4500371d188d)

**Relations:** 

  - is_a [Subatomic](#subatomic)
  - [hasSpatialDirectPart](#hasspatialdirectpart) some [Quark](#quark)
  - disjoint_with [Collection](#collection), [Vacuum](#vacuum), [Quantum](#quantum), [Void](#void), [Elementary](#elementary)
  - disjoint_union_of [Proton](#proton), [Neutron](#neutron)






### Neutron
**IRI:** [http://emmo.info/emmo/middle/materials#EMMO_df808271_df91_4f27_ba59_fa423c51896c](http://emmo.info/emmo/middle/materials#emmo_df808271_df91_4f27_ba59_fa423c51896c)

**Relations:** 

  - is_a [Nucleon](#nucleon)
  - disjoint_with [Collection](#collection), [Vacuum](#vacuum), [Quantum](#quantum), [Proton](#proton), [Void](#void), [Elementary](#elementary)






### ElectronCloud
**IRI:** [http://emmo.info/emmo/middle/materials#EMMO_1067b97a_84f8_4d22_8ace_b842b8ce355c](http://emmo.info/emmo/middle/materials#emmo_1067b97a_84f8_4d22_8ace_b842b8ce355c)

**Elucidation:** A 'spacetime' that stands for a quantum system made of electrons.

**Relations:** 

  - is_a [Subatomic](#subatomic)
  - [hasSpatialDirectPart](#hasspatialdirectpart) some [Electron](#electron)
  - disjoint_with [Collection](#collection), [Vacuum](#vacuum), [Quantum](#quantum), [Void](#void), [Elementary](#elementary)






### Proton
**IRI:** [http://emmo.info/emmo/middle/materials#EMMO_8f87e700_99a8_4427_8ffb_e493de05c217](http://emmo.info/emmo/middle/materials#emmo_8f87e700_99a8_4427_8ffb_e493de05c217)

**Relations:** 

  - is_a [Nucleon](#nucleon)
  - disjoint_with [Collection](#collection), [Neutron](#neutron), [Vacuum](#vacuum), [Quantum](#quantum), [Void](#void), [Elementary](#elementary)






### Nucleus
**IRI:** [http://emmo.info/emmo/middle/materials#EMMO_f835f4d4_c665_403d_ab25_dca5cc74be52](http://emmo.info/emmo/middle/materials#emmo_f835f4d4_c665_403d_ab25_dca5cc74be52)

**Relations:** 

  - is_a [Subatomic](#subatomic)
  - [hasSpatialDirectPart](#hasspatialdirectpart) some [Nucleon](#nucleon)
  - disjoint_with [Collection](#collection), [Vacuum](#vacuum), [Quantum](#quantum), [Void](#void), [Elementary](#elementary)






### Subatomic
**IRI:** [http://emmo.info/emmo/middle/materials#EMMO_7d66bde4_b68d_41cc_b5fc_6fd98c5e2ff0](http://emmo.info/emmo/middle/materials#emmo_7d66bde4_b68d_41cc_b5fc_6fd98c5e2ff0)

**Relations:** 

  - is_a [MaterialState](#materialstate)
  - is_a [Material](#material)
  - is_a [State](#state)
  - disjoint_with [Collection](#collection), [Vacuum](#vacuum), [Quantum](#quantum), [Void](#void), [Elementary](#elementary)









# Individuals

### Universe
**IRI:** [http://emmo.info/emmo/top/mereotopology#EMMO_08cb807c_e626_447b_863f_e2835540e918](http://emmo.info/emmo/top/mereotopology#emmo_08cb807c_e626_447b_863f_e2835540e918)

**Relations:** 

  - is_a [Physical](#physical)






### a
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_361c25b3_3c0d_4066_b622_72dcc71ab5cf](http://emmo.info/emmo/middle/siunits#emmo_361c25b3_3c0d_4066_b622_72dcc71ab5cf)

**Relations:** 

  - is_a [Symbol](#symbol)






### b
**IRI:** [http://emmo.info/emmo/middle/siunits#EMMO_05083b9c_c9d1_4202_b22d_5249067772ac](http://emmo.info/emmo/middle/siunits#emmo_05083b9c_c9d1_4202_b22d_5249067772ac)

**Relations:** 

  - is_a [Symbol](#symbol)








# Appendix


## The complete taxonomy of EMMO relations
![The complete taxonomy of EMMO relations.](genfigs/EMMORelation.pdf){ width=668px }



## The complete taxonomy of EMMO classes
![The complete taxonomy of EMMO classes.](genfigs/EMMO.pdf){ width=668px }

