"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const _1 = require("./");
const cdk = require("@aws-cdk/core");
const sns = require("@aws-cdk/aws-sns");
const app = new cdk.App();
const envJP = {
    region: 'ap-northeast-1',
    account: process.env.CDK_DEFAULT_ACCOUNT,
};
const envUS = {
    region: 'us-west-2',
    account: process.env.CDK_DEFAULT_ACCOUNT,
};
// first stack in JP
const stackJP = new cdk.Stack(app, 'demo-stack-jp', { env: envJP });
const topic = new sns.Topic(stackJP, 'Topic');
new cdk.CfnOutput(stackJP, 'TopicName', { value: topic.topicName });
// second stack in US
const stackUS = new cdk.Stack(app, 'demo-stack-us', { env: envUS });
// get the stackJP stack outputs from stackUS
const outputs = new _1.StackOutputs(stackUS, 'Outputs', { stack: stackJP });
const remoteOutputValue = outputs.getAttString('TopicName');
// the value should be exactly the same with the output value of `TopicName`
new cdk.CfnOutput(stackUS, 'RemoteTopicName', { value: remoteOutputValue });
//# sourceMappingURL=data:application/json;base64,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