from os.path import dirname, join
from pkg_resources import parse_version
from setuptools import setup, find_packages, __version__ as setuptools_version


with open(join(dirname(__file__), 'oceanmonkey/VERSION'), 'rb') as f:
    version = f.read().decode('ascii').strip()


def has_environment_marker_platform_impl_support():
    """Code extracted from 'pytest/setup.py'
    https://github.com/pytest-dev/pytest/blob/7538680c/setup.py#L31
    The first known release to support environment marker with range operators
    it is 18.5, see:
    https://setuptools.readthedocs.io/en/latest/history.html#id235
    """
    return parse_version(setuptools_version) >= parse_version('18.5')


install_requires = [
    'redis>=4.0.2',
    'asyncio',
    'w3lib>=1.17.0',
    'aiohttp>=3.8.1',
    'setuptools',
    'parsel>=1.6.0'
]
extras_require = {}

cpython_dependencies = [
    'lxml>=3.5.0',
    'PyDispatcher>=2.0.5',
]

if has_environment_marker_platform_impl_support():
    extras_require[':platform_python_implementation == "CPython"'] = cpython_dependencies
    extras_require[':platform_python_implementation == "PyPy"'] = [
        'lxml>=4.0.0',
        'PyPyDispatcher>=2.1.0',
    ]
else:
    install_requires.extend(cpython_dependencies)


setup(
    name='OceanMonkey',
    version=version,
    author='薯条老师',
    author_email='haokaixin@chipscoco.com',
    url='https://github.com/chipscoco/OceanMonkey',
    description='A High-Level Distributed Web Crawling and Web Scraping framework',
    long_description=open('README.rst').read(),
    license='BSD',
    packages=find_packages(exclude=("test", "test.*")),
    include_package_data=True,
    zip_safe=False,
    entry_points={
        'console_scripts': ['monkeys = oceanmonkey.cmdline:execute']
    },
    classifiers=[
        'Development Status :: 4 - Beta',
        'Environment :: Console',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9',
        'Programming Language :: Python :: 3.10',
        'Programming Language :: Python :: Implementation :: CPython',
        'Programming Language :: Python :: Implementation :: PyPy',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Software Development :: Libraries :: Application Frameworks',
        'Topic :: Software Development :: Libraries :: Python Modules',
    ],
    python_requires='>=3.5',
    install_requires=install_requires,
    extras_require=extras_require,
)