"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5.QtXmlPatterns import *
from PyQt5 import sip


class QXmlNodeModelIndex(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qxmlnodemodelindex.html

    **Detailed Description**

    QXmlNodeModelIndex is an index into an **XML node model** . It contains:

    * A pointer to an **XML node model** , which is returned by **model** (),
    and
      * Some data, which is returned by **data** (), **internalPointer** (),
    and **additionalData** ().

    Because QXmlNodeModelIndex is intentionally a simple class, it doesn't have
    member functions for accessing the properties of nodes. For example, it
    doesn't have functions for getting a node's name or its list of attributes
    or child nodes. If you find that you need to retrieve this kind of
    information from your query results, there are two ways to proceed.

    * Send the output of your **XQuery**  to an **XML receiver** , or
      * Let
    your **XQuery**  do all the work to produce the desired result.

    The second case is explained by example. Suppose you want to populate a list
    widget with the values of certain attributes from a set of result elements.
    You could write an **XQuery**  to return the set of elements, and then you
    would write the code to iterate over the result elements, get their
    attributes, and extract the desired string values. But the simpler way is to
    just augment your **XQuery**  to finding the desired attribute values. Then
    all you have to do is evaluate the **XQuery**  using the version of
    **QXmlQuery::evaluateTo** () that populates a **QStringList** , which you
    can send directly to your widget.

    QXmlNodeModelIndex doesn't impose any restrictions on the `data` value an
    QXmlNodeModelIndex should contain. The meaning of the data left to the
    associated **node model** . Because QXmlNodeModelIndex depends on a
    particular subclass of **QAbstractXmlNodeModel**  for its existence, the
    only way you can create an instance of QXmlNodeModelIndex is by asking the
    node model to create one for you with **QAbstractXmlNodeModel::createIndex**
    (). Since that function is protected, it is usually a good idea to write a
    public function that creates a QXmlNodeModelIndex from arguments that are
    appropriate for your particular node model.

    A default constructed node index is said to be null, i.e., **isNull** ()
    returns true.

    QXmlNodeModelIndex and **QAbstractXmlNodeModel**  follow the same design
    pattern used for **QModelIndex**  and **QAbstractItemModel** .
    """

    class DocumentOrder(int):
        Precedes: QXmlNodeModelIndex = ...
        Is: QXmlNodeModelIndex = ...
        Follows: QXmlNodeModelIndex = ...

    class NodeKind(int):
        Attribute: QXmlNodeModelIndex = ...
        Comment: QXmlNodeModelIndex = ...
        Document: QXmlNodeModelIndex = ...
        Element: QXmlNodeModelIndex = ...
        Namespace: QXmlNodeModelIndex = ...
        ProcessingInstruction: QXmlNodeModelIndex = ...
        Text: QXmlNodeModelIndex = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qxmlnodemodelindex.html#QXmlNodeModelIndex

        **QXmlNodeModelIndex::QXmlNodeModelIndex()**

        Default constructor. Creates an item that is `null`.

        **See also** **isNull** ().
        """
        ...

    @typing.overload
    def __init__(self, other: "QXmlNodeModelIndex") -> None:
        """
        https://doc.qt.io/qt-5/qxmlnodemodelindex.html#QXmlNodeModelIndex-1

        **QXmlNodeModelIndex::QXmlNodeModelIndex(const QXmlNodeModelIndex &
        other )**

        Standard copy constructor. Creates a QXmlNodeModelIndex instance that is
        a copy of **other**.
        """
        ...

    def __hash__(self) -> int:
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qxmlnodemodelindex.html#isNull

        **bool QXmlNodeModelIndex::isNull() const**

        Returns true if this **QXmlNodeModelIndex**  is a default constructed
        value, otherwise false.

        A null **QXmlNodeModelIndex**  doesn't represent any node and cannot be
        used in conjunction with **QAbstractXmlNodeModel** .
        """
        ...

    def additionalData(self) -> int:
        """
        https://doc.qt.io/qt-5/qxmlnodemodelindex.html#additionalData

        **qint64 QXmlNodeModelIndex::additionalData() const**

        Returns the second data value. The node index holds two data values.
        **data** () returns the first one.

        **See also** **data** ().
        """
        ...

    def model(self) -> "QAbstractXmlNodeModel":
        """
        https://doc.qt.io/qt-5/qxmlnodemodelindex.html#model

        **const QAbstractXmlNodeModel *QXmlNodeModelIndex::model() const**

        Returns the **QAbstractXmlNodeModel**  that this node index refers to.
        **QXmlNodeModelIndex**  does not own **QAbstractXmlNodeModel**  and does
        not keep track of its lifetime, so this pointer will dangle if the
        **QAbstractXmlNodeModel**  is deallocated first.

        There is no setter for the node model because instances of
        **QXmlNodeModelIndex**  instances are only created with
        **QAbstractXmlNodeModel::createIndex** ().
        """
        ...

    def internalPointer(self) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qxmlnodemodelindex.html#internalPointer

        **void *QXmlNodeModelIndex::internalPointer() const**

        Returns the first data value as a void* pointer.

        **See also** **additionalData** ().
        """
        ...

    def data(self) -> int:
        """
        https://doc.qt.io/qt-5/qxmlnodemodelindex.html#data

        **qint64 QXmlNodeModelIndex::data() const**

        Returns the first data value. The node index holds two data values.
        **additionalData** () returns the second one.

        **See also** **additionalData** ().
        """
        ...
