"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5.QtXml import *


class QDomCharacterData(QDomNode):
    """
    https://doc.qt.io/qt-5/qdomcharacterdata.html

    **Detailed Description**

    Character data as used in XML specifies a generic data string. More
    specialized versions of this class are **QDomText** , **QDomComment**  and
    **QDomCDATASection** .

    The data string is set with **setData** () and retrieved with **data** ().
    You can retrieve a portion of the data string using **substringData** ().
    Extra data can be appended with **appendData** (), or inserted with
    **insertData** (). Portions of the data string can be deleted with
    **deleteData** () or replaced with **replaceData** (). The length of the
    data string is returned by **length** ().

    The node type of the node containing this character data is returned by
    **nodeType** ().

    **See also** **QDomText** , **QDomComment** , and **QDomCDATASection** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qdomcharacterdata.html#QDomCharacterData

        **QDomCharacterData::QDomCharacterData()**

        Constructs an empty character data object.
        """
        ...

    @typing.overload
    def __init__(self, x: "QDomCharacterData") -> None:
        """
        https://doc.qt.io/qt-5/qdomcharacterdata.html#QDomCharacterData-1

        **QDomCharacterData::QDomCharacterData(const QDomCharacterData & x )**

        Constructs a copy of **x**.

        The data of the copy is shared (shallow copy): modifying one node will
        also change the other. If you want to make a deep copy, use
        **cloneNode** ().
        """
        ...

    def nodeType(self) -> QDomNode.NodeType:
        """
        https://doc.qt.io/qt-5/qdomcharacterdata.html#nodeType

        **QDomNode::NodeType QDomCharacterData::nodeType() const**

        Returns the type of node this object refers to (i.e. `TextNode`,
        `CDATASectionNode`, `CommentNode` or `CharacterDataNode`). For a **null
        node** , returns `CharacterDataNode`.
        """
        ...

    def setData(self, a0: str) -> None:
        """
        https://doc.qt.io/qt-5/qdomcharacterdata.html#setData

        **void QDomCharacterData::setData(const QString & v )**

        Sets this object's string to **v**.

        **See also** **data** ().
        """
        ...

    def data(self) -> str:
        """
        https://doc.qt.io/qt-5/qdomcharacterdata.html#data

        **QString QDomCharacterData::data() const**

        Returns the string stored in this object.

        If the node is a **null node** , it will return an empty string.

        **See also** **setData** ().
        """
        ...

    def length(self) -> int:
        """
        https://doc.qt.io/qt-5/qdomcharacterdata.html#length

        **int QDomCharacterData::length() const**

        Returns the length of the stored string.
        """
        ...

    def replaceData(self, offset: int, count: int, arg: str) -> None:
        """
        https://doc.qt.io/qt-5/qdomcharacterdata.html#replaceData

        **void QDomCharacterData::replaceData(unsigned long offset , unsigned
        long count , const QString & arg )**

        Replaces the substring of length **count** starting at position
        **offset** with the string **arg**.
        """
        ...

    def deleteData(self, offset: int, count: int) -> None:
        """
        https://doc.qt.io/qt-5/qdomcharacterdata.html#deleteData

        **void QDomCharacterData::deleteData(unsigned long offset , unsigned
        long count )**

        Deletes a substring of length **count** from position **offset**.
        """
        ...

    def insertData(self, offset: int, arg: str) -> None:
        """
        https://doc.qt.io/qt-5/qdomcharacterdata.html#insertData

        **void QDomCharacterData::insertData(unsigned long offset , const
        QString & arg )**

        Inserts the string **arg** into the stored string at position
        **offset**.
        """
        ...

    def appendData(self, arg: str) -> None:
        """
        https://doc.qt.io/qt-5/qdomcharacterdata.html#appendData

        **void QDomCharacterData::appendData(const QString & arg )**

        Appends the string **arg** to the stored string.
        """
        ...

    def substringData(self, offset: int, count: int) -> str:
        """
        https://doc.qt.io/qt-5/qdomcharacterdata.html#substringData

        **QString QDomCharacterData::substringData(unsigned long offset ,
        unsigned long count )**

        Returns the substring of length **count** from position **offset**.
        """
        ...
