"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5.QtWinExtras import *


class QWinThumbnailToolButton(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qwinthumbnailtoolbutton.html

    **Detailed Description**

    Buttons in a **QWinThumbnailToolBar**  are instances of
    QWinThumbnailToolButton. It provides a set of properties for specifying the
    attributes of a thumbnail toolbar button. It also provides a signal that is
    emitted whenever the button is **clicked** , and a slot to perform
    **clicks**  programmatically.

    **See also** **QWinThumbnailToolBar** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbutton.html#QWinThumbnailToolBut
        ton

        **QWinThumbnailToolButton::QWinThumbnailToolButton(QObject * parent =
        nullptr)**

        Constructs a QWinThumbnailToolButton with the specified **parent**.
        """
        ...

    def click(self) -> None:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbutton.html#click

        **[slot] void QWinThumbnailToolButton::click()**

        Performs a click. The **clicked** () signal is emitted as appropriate.

        This function does nothing if the button is **disabled**  or **non-
        interactive** .
        """
        ...

    def isFlat(self) -> bool:
        ...

    def setFlat(self, flat: bool) -> None:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbutton.html#flat-prop

        **flat : bool**

        This property holds whether the button is flat

        The default value is `false`.

        A flat button does not draw a background nor a frame - only an icon.

        **Access functions:**

        bool **isFlat** () const
        void **setFlat** (bool **flat** )
        """
        ...

    def dismissOnClick(self) -> bool:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbutton.html#dismissOnClick-prop

        **dismissOnClick : bool**

        This property holds whether the window thumbnail is dismissed after a
        button click

        The default value is `false`.

        **Access functions:**

        bool **dismissOnClick** () const
        void **setDismissOnClick** (bool
        **dismiss** )
        """
        ...

    def setDismissOnClick(self, dismiss: bool) -> None:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbutton.html#dismissOnClick-prop

        **dismissOnClick : bool**

        This property holds whether the window thumbnail is dismissed after a
        button click

        The default value is `false`.

        **Access functions:**

        bool **dismissOnClick** () const
        void **setDismissOnClick** (bool
        **dismiss** )
        """
        ...

    def isVisible(self) -> bool:
        ...

    def setVisible(self, visible: bool) -> None:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbutton.html#visible-prop

        **visible : bool**

        This property holds whether the button is visible

        The default value is `true`.

        **Access functions:**

        bool **isVisible** () const
        void **setVisible** (bool **visible** )

        **Member Function Documentation**
        """
        ...

    def isInteractive(self) -> bool:
        ...

    def setInteractive(self, interactive: bool) -> None:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbutton.html#interactive-prop

        **interactive : bool**

        This property holds whether the button is interactive

        The default value is `true`.

        A non-interactive button does not react to user interaction, but is
        still visually enabled. A typical use case for non- interactive buttons
        are notification icons.

        **Access functions:**

        bool **isInteractive** () const
        void **setInteractive** (bool
        **interactive** )

        **See also** **enabled** .
        """
        ...

    def isEnabled(self) -> bool:
        ...

    def setEnabled(self, enabled: bool) -> None:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbutton.html#enabled-prop

        **enabled : bool**

        This property holds whether the button is enabled

        The default value is `true`.

        A disabled button does not react to user interaction, and is also
        visually disabled.

        **Access functions:**

        bool **isEnabled** () const
        void **setEnabled** (bool **enabled** )

        **See also** **interactive** .
        """
        ...

    def icon(self) -> QtGui.QIcon:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbutton.html#icon-prop

        **icon : QIcon**

        This property holds the icon of the button

        **Access functions:**

        QIcon **icon** () const
        void **setIcon** (const QIcon & **icon** )
        """
        ...

    def setIcon(self, icon: QtGui.QIcon) -> None:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbutton.html#icon-prop

        **icon : QIcon**

        This property holds the icon of the button

        **Access functions:**

        QIcon **icon** () const
        void **setIcon** (const QIcon & **icon** )
        """
        ...

    def toolTip(self) -> str:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbutton.html#toolTip-prop

        **toolTip : QString**

        This property holds the tooltip of the button

        **Access functions:**

        QString **toolTip** () const
        void **setToolTip** (const QString &
        **toolTip** )
        """
        ...

    def setToolTip(self, toolTip: str) -> None:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbutton.html#toolTip-prop

        **toolTip : QString**

        This property holds the tooltip of the button

        **Access functions:**

        QString **toolTip** () const
        void **setToolTip** (const QString &
        **toolTip** )
        """
        ...

    @property
    def clicked(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qwinthumbnailtoolbutton.html#clicked

        **[signal] void QWinThumbnailToolButton::clicked()**

        This signal is emitted when the button is clicked.
        """
        ...
