"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *
from PyQt5 import sip


class QStyle(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qstyle.html

    **Detailed Description**

    Qt contains a set of QStyle subclasses that emulate the styles of the
    different platforms supported by Qt (QWindowsStyle, QMacStyle etc.). By
    default, these styles are built into the Qt GUI module. Styles can also be
    made available as plugins.

    Qt's built-in widgets use QStyle to perform nearly all of their drawing,
    ensuring that they look exactly like the equivalent native widgets. The
    diagram below shows a **QComboBox**  in nine different styles.

    ![Nine combo boxes](images/qstyle-comboboxes.png)

    Topics:

    **Setting a Style**

    The style of the entire application can be set using the
    **QApplication::setStyle** () function. It can also be specified by the user
    of the application, using the `-style` command-line option:

    ./myapplication -style windows

    If no style is specified, Qt will choose the most appropriate style for the
    user's platform or desktop environment.

    A style can also be set on an individual widget using the
    **QWidget::setStyle** () function.

    **Developing Style-Aware Custom Widgets**

    If you are developing custom widgets and want them to look good on all
    platforms, you can use QStyle functions to perform parts of the widget
    drawing, such as **drawItemText** (), **drawItemPixmap** (),
    **drawPrimitive** (), **drawControl** (), and **drawComplexControl** ().

    Most QStyle draw functions take four arguments:

    * an enum value specifying which graphical element to draw
      * a
    **QStyleOption**  specifying how and where to render that element
      * a
    **QPainter**  that should be used to draw the element
      * a **QWidget**  on
    which the drawing is performed (optional)

    For example, if you want to draw a focus rectangle on your widget, you can
    write:

    void MyWidget::paintEvent(**QPaintEvent**  * /* event */)
        {
    **QPainter**  painter(this);

            **QStyleOptionFocusRect**  option;
    option.initFrom(this);
            option.backgroundColor =
    palette().color(**QPalette** ::Background);
    style()->drawPrimitive(QStyle::PE_FrameFocusRect, &option, &painter, this);
    }

    QStyle gets all the information it needs to render the graphical element
    from **QStyleOption** . The widget is passed as the last argument in case
    the style needs it to perform special effects (such as animated default
    buttons on macOS), but it isn't mandatory. In fact, you can use QStyle to
    draw on any paint device, not just widgets, by setting the **QPainter**
    properly.

    **QStyleOption**  has various subclasses for the various types of graphical
    elements that can be drawn. For example, **PE_FrameFocusRect**  expects a
    **QStyleOptionFocusRect**  argument.

    To ensure that drawing operations are as fast as possible, **QStyleOption**
    and its subclasses have public data members. See the **QStyleOption**  class
    documentation for details on how to use it.

    For convenience, Qt provides the **QStylePainter**  class, which combines a
    QStyle, a **QPainter** , and a **QWidget** . This makes it possible to write

    **QStylePainter**  painter(this);
            ...
    painter.drawPrimitive(QStyle::PE_FrameFocusRect, option);

    instead of

    **QPainter**  painter(this);
            ...
    style()->drawPrimitive(QStyle::PE_FrameFocusRect, &option, &painter, this);

    **Creating a Custom Style**

    You can create a custom look and feel for your application by creating a
    custom style. There are two approaches to creating a custom style. In the
    static approach, you either choose an existing QStyle class, subclass it,
    and reimplement virtual functions to provide the custom behavior, or you
    create an entire QStyle class from scratch. In the dynamic approach, you
    modify the behavior of your system style at runtime. The static approach is
    described below. The dynamic approach is described in **QProxyStyle** .

    The first step in the static approach is to pick one of the styles provided
    by Qt from which you will build your custom style. Your choice of QStyle
    class will depend on which style resembles your desired style the most. The
    most general class that you can use as a base is **QCommonStyle**  (not
    QStyle). This is because Qt requires its styles to be **QCommonStyle** s.

    Depending on which parts of the base style you want to change, you must
    reimplement the functions that are used to draw those parts of the
    interface. To illustrate this, we will modify the look of the spin box
    arrows drawn by QWindowsStyle. The arrows are **primitive elements** that
    are drawn by the **drawPrimitive** () function, so we need to reimplement
    that function. We need the following class declaration:

    class CustomStyle : public **QProxyStyle**
        {
            Q_OBJECT
    public:
            CustomStyle();
            ~CustomStyle() {}

            void
    drawPrimitive(PrimitiveElement element, const **QStyleOption**  *option,
    **QPainter**  *painter, const **QWidget**  *widget) const override;
        };

    To draw its up and down arrows, **QSpinBox**  uses the
    **PE_IndicatorSpinUp**  and **PE_IndicatorSpinDown**  primitive elements.
    Here's how to reimplement the **drawPrimitive** () function to draw them
    differently:

    void CustomStyle::drawPrimitive(PrimitiveElement element, const
    **QStyleOption**  *option,
                                        **QPainter**
    *painter, const **QWidget**  *widget) const
        {
            if (element ==
    PE_IndicatorSpinUp || element == PE_IndicatorSpinDown) {
    **QPolygon**  points(3);
                int x = option->rect.x();
    int y = option->rect.y();
                int w = option->rect.width() / 2;
    int h = option->rect.height() / 2;
                x += (option->rect.width() -
    w) / 2;
                y += (option->rect.height() - h) / 2;
    if (element == PE_IndicatorSpinUp) {
                    points[0] = **QPoint**
    (x, y + h);
                    points[1] = **QPoint** (x + w, y + h);
    points[2] = **QPoint** (x + w / 2, y);
                } else { //
    PE_SpinBoxDown
                    points[0] = **QPoint** (x, y);
    points[1] = **QPoint** (x + w, y);
                    points[2] = **QPoint** (x
    + w / 2, y + h);
                }

                if (option->state &
    State_Enabled) {
    painter->setPen(option->palette.mid().color());
    painter->setBrush(option->palette.buttonText());
                } else {
    painter->setPen(option->palette.buttonText().color());
    painter->setBrush(option->palette.mid());
                }
    painter->drawPolygon(points);
            } else {
            **QProxyStyle**
    ::drawPrimitive(element, option, painter, widget);
            }
        }

    Notice that we don't use the `widget` argument, except to pass it on to the
    QWindowStyle::drawPrimitive() function. As mentioned earlier, the
    information about what is to be drawn and how it should be drawn is
    specified by a **QStyleOption**  object, so there is no need to ask the
    widget.

    If you need to use the `widget` argument to obtain additional information,
    be careful to ensure that it isn't 0 and that it is of the correct type
    before using it. For example:

    const **QSpinBox**  *spinBox = qobject_cast<const **QSpinBox**  *>(widget);
    if (spinBox) {
            ...
            }

    When implementing a custom style, you cannot assume that the widget is a
    **QSpinBox**  just because the enum value is called **PE_IndicatorSpinUp**
    or **PE_IndicatorSpinDown** .

    The documentation for the **Styles**  example covers this topic in more
    detail.

    **Warning:** Qt style sheets are currently not supported for custom QStyle
    subclasses. We plan to address this in some future release.

    **Using a Custom Style**

    There are several ways of using a custom style in a Qt application. The
    simplest way is to pass the custom style to the **QApplication::setStyle**
    () static function before creating the **QApplication**  object:

    #include <QtWidgets>

        #include "customstyle.h"

        int main(int
    argc, char *argv[])
        {
            **QApplication** ::setStyle(new
    CustomStyle);
            **QApplication**  app(argc, argv);
    **QSpinBox**  spinBox;
            spinBox.show();
            return app.exec();
    }

    You can call **QApplication::setStyle** () at any time, but by calling it
    before the constructor, you ensure that the user's preference, set using the
    `-style` command-line option, is respected.

    You may want to make your custom style available for use in other
    applications, which may not be yours and hence not available for you to
    recompile. The Qt Plugin system makes it possible to create styles as
    plugins. Styles created as plugins are loaded as shared objects at runtime
    by Qt itself. Please refer to the **Qt Plugin**  documentation for more
    information on how to go about creating a style plugin.

    Compile your plugin and put it into Qt's `plugins/styles` directory. We now
    have a pluggable style that Qt can load automatically. To use your new style
    with existing applications, simply start the application with the following
    argument:

    ./myapplication -style custom

    The application will use the look and feel from the custom style you
    implemented.

    **Right-to-Left Desktops**

    Languages written from right to left (such as Arabic and Hebrew) usually
    also mirror the whole layout of widgets, and require the light to come from
    the screen's top-right corner instead of top-left.

    If you create a custom style, you should take special care when drawing
    asymmetric elements to make sure that they also look correct in a mirrored
    layout. An easy way to test your styles is to run applications with the
    `-reverse` command-line option or to call
    **QApplication::setLayoutDirection** () in your `main()` function.

    Here are some things to keep in mind when making a style work well in a
    right-to-left environment:

    * **subControlRect** () and **subElementRect** () return rectangles in
    screen coordinates
      * **QStyleOption::direction**  indicates in which
    direction the item should be drawn in
      * If a style is not right-to-left
    aware it will display items as if it were left-to-right
      * **visualRect**
    (), **visualPos** (), and **visualAlignment** () are helpful functions that
    will translate from logical to screen representations.
      * **alignedRect**
    () will return a logical rect aligned for the current direction

    **Styles in Item Views**

    The painting of items in views is performed by a delegate. Qt's default
    delegate, **QStyledItemDelegate** , is also used for calculating bounding
    rectangles of items, and their sub-elements for the various kind of item
    **data roles**  **QStyledItemDelegate**  supports. See the
    **QStyledItemDelegate**  class description to find out which datatypes and
    roles are supported. You can read more about item data roles in **Model/View
    Programming** .

    When **QStyledItemDelegate**  paints its items, it draws **CE_ItemViewItem**
    , and calculates their size with **CT_ItemViewItem** . Note also that it
    uses **SE_ItemViewItemText**  to set the size of editors. When implementing
    a style to customize drawing of item views, you need to check the
    implementation of **QCommonStyle**  (and any other subclasses from which
    your style inherits). This way, you find out which and how other style
    elements are painted, and you can then reimplement the painting of elements
    that should be drawn differently.

    We include a small example where we customize the drawing of item
    backgrounds.

    switch (element) {
                case (PE_PanelItemViewItem): {
    painter->save();

                    **QPoint**  topLeft =
    option->rect.topLeft();
                    **QPoint**  bottomRight =
    option->rect.topRight();
                    **QLinearGradient**
    backgroundGradient(topLeft, bottomRight);
    backgroundGradient.setColorAt(0.0, **QColor** (Qt::yellow).lighter(190));
    backgroundGradient.setColorAt(1.0, Qt::white);
    painter->fillRect(option->rect, **QBrush** (backgroundGradient));
    painter->restore();
                break;
                }
                default:
    **QProxyStyle** ::drawPrimitive(element, option, painter, widget);
            }

    The primitive element **PE_PanelItemViewItem**  is responsible for painting
    the background of items, and is called from **QCommonStyle** 's
    implementation of **CE_ItemViewItem** .

    To add support for drawing of new datatypes and item data roles, it is
    necessary to create a custom delegate. But if you only need to support the
    datatypes implemented by the default delegate, a custom style does not need
    an accompanying delegate. The **QStyledItemDelegate**  class description
    gives more information on custom delegates.

    The drawing of item view headers is also done by the style, giving control
    over size of header items and row and column sizes.

    **See also** **QStyleOption** , **QStylePainter** , **Styles Example** ,
    **Styles and Style Aware Widgets** , **QStyledItemDelegate** , and
    **Styling** .
    """

    class RequestSoftwareInputPanel(int):
        RSIP_OnMouseClickAndAlreadyFocused: QStyle = ...
        RSIP_OnMouseClick: QStyle = ...

    class StandardPixmap(int):
        SP_TitleBarMenuButton: QStyle = ...
        SP_TitleBarMinButton: QStyle = ...
        SP_TitleBarMaxButton: QStyle = ...
        SP_TitleBarCloseButton: QStyle = ...
        SP_TitleBarNormalButton: QStyle = ...
        SP_TitleBarShadeButton: QStyle = ...
        SP_TitleBarUnshadeButton: QStyle = ...
        SP_TitleBarContextHelpButton: QStyle = ...
        SP_DockWidgetCloseButton: QStyle = ...
        SP_MessageBoxInformation: QStyle = ...
        SP_MessageBoxWarning: QStyle = ...
        SP_MessageBoxCritical: QStyle = ...
        SP_MessageBoxQuestion: QStyle = ...
        SP_DesktopIcon: QStyle = ...
        SP_TrashIcon: QStyle = ...
        SP_ComputerIcon: QStyle = ...
        SP_DriveFDIcon: QStyle = ...
        SP_DriveHDIcon: QStyle = ...
        SP_DriveCDIcon: QStyle = ...
        SP_DriveDVDIcon: QStyle = ...
        SP_DriveNetIcon: QStyle = ...
        SP_DirOpenIcon: QStyle = ...
        SP_DirClosedIcon: QStyle = ...
        SP_DirLinkIcon: QStyle = ...
        SP_FileIcon: QStyle = ...
        SP_FileLinkIcon: QStyle = ...
        SP_ToolBarHorizontalExtensionButton: QStyle = ...
        SP_ToolBarVerticalExtensionButton: QStyle = ...
        SP_FileDialogStart: QStyle = ...
        SP_FileDialogEnd: QStyle = ...
        SP_FileDialogToParent: QStyle = ...
        SP_FileDialogNewFolder: QStyle = ...
        SP_FileDialogDetailedView: QStyle = ...
        SP_FileDialogInfoView: QStyle = ...
        SP_FileDialogContentsView: QStyle = ...
        SP_FileDialogListView: QStyle = ...
        SP_FileDialogBack: QStyle = ...
        SP_DirIcon: QStyle = ...
        SP_DialogOkButton: QStyle = ...
        SP_DialogCancelButton: QStyle = ...
        SP_DialogHelpButton: QStyle = ...
        SP_DialogOpenButton: QStyle = ...
        SP_DialogSaveButton: QStyle = ...
        SP_DialogCloseButton: QStyle = ...
        SP_DialogApplyButton: QStyle = ...
        SP_DialogResetButton: QStyle = ...
        SP_DialogDiscardButton: QStyle = ...
        SP_DialogYesButton: QStyle = ...
        SP_DialogNoButton: QStyle = ...
        SP_ArrowUp: QStyle = ...
        SP_ArrowDown: QStyle = ...
        SP_ArrowLeft: QStyle = ...
        SP_ArrowRight: QStyle = ...
        SP_ArrowBack: QStyle = ...
        SP_ArrowForward: QStyle = ...
        SP_DirHomeIcon: QStyle = ...
        SP_CommandLink: QStyle = ...
        SP_VistaShield: QStyle = ...
        SP_BrowserReload: QStyle = ...
        SP_BrowserStop: QStyle = ...
        SP_MediaPlay: QStyle = ...
        SP_MediaStop: QStyle = ...
        SP_MediaPause: QStyle = ...
        SP_MediaSkipForward: QStyle = ...
        SP_MediaSkipBackward: QStyle = ...
        SP_MediaSeekForward: QStyle = ...
        SP_MediaSeekBackward: QStyle = ...
        SP_MediaVolume: QStyle = ...
        SP_MediaVolumeMuted: QStyle = ...
        SP_DirLinkOpenIcon: QStyle = ...
        SP_LineEditClearButton: QStyle = ...
        SP_DialogYesToAllButton: QStyle = ...
        SP_DialogNoToAllButton: QStyle = ...
        SP_DialogSaveAllButton: QStyle = ...
        SP_DialogAbortButton: QStyle = ...
        SP_DialogRetryButton: QStyle = ...
        SP_DialogIgnoreButton: QStyle = ...
        SP_RestoreDefaultsButton: QStyle = ...
        SP_CustomBase: QStyle = ...

    class StyleHint(int):
        SH_EtchDisabledText: QStyle = ...
        SH_DitherDisabledText: QStyle = ...
        SH_ScrollBar_MiddleClickAbsolutePosition: QStyle = ...
        SH_ScrollBar_ScrollWhenPointerLeavesControl: QStyle = ...
        SH_TabBar_SelectMouseType: QStyle = ...
        SH_TabBar_Alignment: QStyle = ...
        SH_Header_ArrowAlignment: QStyle = ...
        SH_Slider_SnapToValue: QStyle = ...
        SH_Slider_SloppyKeyEvents: QStyle = ...
        SH_ProgressDialog_CenterCancelButton: QStyle = ...
        SH_ProgressDialog_TextLabelAlignment: QStyle = ...
        SH_PrintDialog_RightAlignButtons: QStyle = ...
        SH_MainWindow_SpaceBelowMenuBar: QStyle = ...
        SH_FontDialog_SelectAssociatedText: QStyle = ...
        SH_Menu_AllowActiveAndDisabled: QStyle = ...
        SH_Menu_SpaceActivatesItem: QStyle = ...
        SH_Menu_SubMenuPopupDelay: QStyle = ...
        SH_ScrollView_FrameOnlyAroundContents: QStyle = ...
        SH_MenuBar_AltKeyNavigation: QStyle = ...
        SH_ComboBox_ListMouseTracking: QStyle = ...
        SH_Menu_MouseTracking: QStyle = ...
        SH_MenuBar_MouseTracking: QStyle = ...
        SH_ItemView_ChangeHighlightOnFocus: QStyle = ...
        SH_Widget_ShareActivation: QStyle = ...
        SH_Workspace_FillSpaceOnMaximize: QStyle = ...
        SH_ComboBox_Popup: QStyle = ...
        SH_TitleBar_NoBorder: QStyle = ...
        SH_ScrollBar_StopMouseOverSlider: QStyle = ...
        SH_BlinkCursorWhenTextSelected: QStyle = ...
        SH_RichText_FullWidthSelection: QStyle = ...
        SH_Menu_Scrollable: QStyle = ...
        SH_GroupBox_TextLabelVerticalAlignment: QStyle = ...
        SH_GroupBox_TextLabelColor: QStyle = ...
        SH_Menu_SloppySubMenus: QStyle = ...
        SH_Table_GridLineColor: QStyle = ...
        SH_LineEdit_PasswordCharacter: QStyle = ...
        SH_DialogButtons_DefaultButton: QStyle = ...
        SH_ToolBox_SelectedPageTitleBold: QStyle = ...
        SH_TabBar_PreferNoArrows: QStyle = ...
        SH_ScrollBar_LeftClickAbsolutePosition: QStyle = ...
        SH_UnderlineShortcut: QStyle = ...
        SH_SpinBox_AnimateButton: QStyle = ...
        SH_SpinBox_KeyPressAutoRepeatRate: QStyle = ...
        SH_SpinBox_ClickAutoRepeatRate: QStyle = ...
        SH_Menu_FillScreenWithScroll: QStyle = ...
        SH_ToolTipLabel_Opacity: QStyle = ...
        SH_DrawMenuBarSeparator: QStyle = ...
        SH_TitleBar_ModifyNotification: QStyle = ...
        SH_Button_FocusPolicy: QStyle = ...
        SH_MessageBox_UseBorderForButtonSpacing: QStyle = ...
        SH_TitleBar_AutoRaise: QStyle = ...
        SH_ToolButton_PopupDelay: QStyle = ...
        SH_FocusFrame_Mask: QStyle = ...
        SH_RubberBand_Mask: QStyle = ...
        SH_WindowFrame_Mask: QStyle = ...
        SH_SpinControls_DisableOnBounds: QStyle = ...
        SH_Dial_BackgroundRole: QStyle = ...
        SH_ComboBox_LayoutDirection: QStyle = ...
        SH_ItemView_EllipsisLocation: QStyle = ...
        SH_ItemView_ShowDecorationSelected: QStyle = ...
        SH_ItemView_ActivateItemOnSingleClick: QStyle = ...
        SH_ScrollBar_ContextMenu: QStyle = ...
        SH_ScrollBar_RollBetweenButtons: QStyle = ...
        SH_Slider_StopMouseOverSlider: QStyle = ...
        SH_Slider_AbsoluteSetButtons: QStyle = ...
        SH_Slider_PageSetButtons: QStyle = ...
        SH_Menu_KeyboardSearch: QStyle = ...
        SH_TabBar_ElideMode: QStyle = ...
        SH_DialogButtonLayout: QStyle = ...
        SH_ComboBox_PopupFrameStyle: QStyle = ...
        SH_MessageBox_TextInteractionFlags: QStyle = ...
        SH_DialogButtonBox_ButtonsHaveIcons: QStyle = ...
        SH_SpellCheckUnderlineStyle: QStyle = ...
        SH_MessageBox_CenterButtons: QStyle = ...
        SH_Menu_SelectionWrap: QStyle = ...
        SH_ItemView_MovementWithoutUpdatingSelection: QStyle = ...
        SH_ToolTip_Mask: QStyle = ...
        SH_FocusFrame_AboveWidget: QStyle = ...
        SH_TextControl_FocusIndicatorTextCharFormat: QStyle = ...
        SH_WizardStyle: QStyle = ...
        SH_ItemView_ArrowKeysNavigateIntoChildren: QStyle = ...
        SH_Menu_Mask: QStyle = ...
        SH_Menu_FlashTriggeredItem: QStyle = ...
        SH_Menu_FadeOutOnHide: QStyle = ...
        SH_SpinBox_ClickAutoRepeatThreshold: QStyle = ...
        SH_ItemView_PaintAlternatingRowColorsForEmptyArea: QStyle = ...
        SH_FormLayoutWrapPolicy: QStyle = ...
        SH_TabWidget_DefaultTabPosition: QStyle = ...
        SH_ToolBar_Movable: QStyle = ...
        SH_FormLayoutFieldGrowthPolicy: QStyle = ...
        SH_FormLayoutFormAlignment: QStyle = ...
        SH_FormLayoutLabelAlignment: QStyle = ...
        SH_ItemView_DrawDelegateFrame: QStyle = ...
        SH_TabBar_CloseButtonPosition: QStyle = ...
        SH_DockWidget_ButtonsHaveFrame: QStyle = ...
        SH_ToolButtonStyle: QStyle = ...
        SH_RequestSoftwareInputPanel: QStyle = ...
        SH_ListViewExpand_SelectMouseType: QStyle = ...
        SH_ScrollBar_Transient: QStyle = ...
        SH_Menu_SupportsSections: QStyle = ...
        SH_ToolTip_WakeUpDelay: QStyle = ...
        SH_ToolTip_FallAsleepDelay: QStyle = ...
        SH_Widget_Animate: QStyle = ...
        SH_Splitter_OpaqueResize: QStyle = ...
        SH_LineEdit_PasswordMaskDelay: QStyle = ...
        SH_TabBar_ChangeCurrentDelay: QStyle = ...
        SH_Menu_SubMenuUniDirection: QStyle = ...
        SH_Menu_SubMenuUniDirectionFailCount: QStyle = ...
        SH_Menu_SubMenuSloppySelectOtherActions: QStyle = ...
        SH_Menu_SubMenuSloppyCloseTimeout: QStyle = ...
        SH_Menu_SubMenuResetWhenReenteringParent: QStyle = ...
        SH_Menu_SubMenuDontStartSloppyOnLeave: QStyle = ...
        SH_ItemView_ScrollMode: QStyle = ...
        SH_TitleBar_ShowToolTipsOnButtons: QStyle = ...
        SH_Widget_Animation_Duration: QStyle = ...
        SH_ComboBox_AllowWheelScrolling: QStyle = ...
        SH_SpinBox_ButtonsInsideFrame: QStyle = ...
        SH_SpinBox_StepModifier: QStyle = ...
        SH_CustomBase: QStyle = ...

    class ContentsType(int):
        CT_PushButton: QStyle = ...
        CT_CheckBox: QStyle = ...
        CT_RadioButton: QStyle = ...
        CT_ToolButton: QStyle = ...
        CT_ComboBox: QStyle = ...
        CT_Splitter: QStyle = ...
        CT_ProgressBar: QStyle = ...
        CT_MenuItem: QStyle = ...
        CT_MenuBarItem: QStyle = ...
        CT_MenuBar: QStyle = ...
        CT_Menu: QStyle = ...
        CT_TabBarTab: QStyle = ...
        CT_Slider: QStyle = ...
        CT_ScrollBar: QStyle = ...
        CT_LineEdit: QStyle = ...
        CT_SpinBox: QStyle = ...
        CT_SizeGrip: QStyle = ...
        CT_TabWidget: QStyle = ...
        CT_DialogButtons: QStyle = ...
        CT_HeaderSection: QStyle = ...
        CT_GroupBox: QStyle = ...
        CT_MdiControls: QStyle = ...
        CT_ItemViewItem: QStyle = ...
        CT_CustomBase: QStyle = ...

    class PixelMetric(int):
        PM_ButtonMargin: QStyle = ...
        PM_ButtonDefaultIndicator: QStyle = ...
        PM_MenuButtonIndicator: QStyle = ...
        PM_ButtonShiftHorizontal: QStyle = ...
        PM_ButtonShiftVertical: QStyle = ...
        PM_DefaultFrameWidth: QStyle = ...
        PM_SpinBoxFrameWidth: QStyle = ...
        PM_ComboBoxFrameWidth: QStyle = ...
        PM_MaximumDragDistance: QStyle = ...
        PM_ScrollBarExtent: QStyle = ...
        PM_ScrollBarSliderMin: QStyle = ...
        PM_SliderThickness: QStyle = ...
        PM_SliderControlThickness: QStyle = ...
        PM_SliderLength: QStyle = ...
        PM_SliderTickmarkOffset: QStyle = ...
        PM_SliderSpaceAvailable: QStyle = ...
        PM_DockWidgetSeparatorExtent: QStyle = ...
        PM_DockWidgetHandleExtent: QStyle = ...
        PM_DockWidgetFrameWidth: QStyle = ...
        PM_TabBarTabOverlap: QStyle = ...
        PM_TabBarTabHSpace: QStyle = ...
        PM_TabBarTabVSpace: QStyle = ...
        PM_TabBarBaseHeight: QStyle = ...
        PM_TabBarBaseOverlap: QStyle = ...
        PM_ProgressBarChunkWidth: QStyle = ...
        PM_SplitterWidth: QStyle = ...
        PM_TitleBarHeight: QStyle = ...
        PM_MenuScrollerHeight: QStyle = ...
        PM_MenuHMargin: QStyle = ...
        PM_MenuVMargin: QStyle = ...
        PM_MenuPanelWidth: QStyle = ...
        PM_MenuTearoffHeight: QStyle = ...
        PM_MenuDesktopFrameWidth: QStyle = ...
        PM_MenuBarPanelWidth: QStyle = ...
        PM_MenuBarItemSpacing: QStyle = ...
        PM_MenuBarVMargin: QStyle = ...
        PM_MenuBarHMargin: QStyle = ...
        PM_IndicatorWidth: QStyle = ...
        PM_IndicatorHeight: QStyle = ...
        PM_ExclusiveIndicatorWidth: QStyle = ...
        PM_ExclusiveIndicatorHeight: QStyle = ...
        PM_DialogButtonsSeparator: QStyle = ...
        PM_DialogButtonsButtonWidth: QStyle = ...
        PM_DialogButtonsButtonHeight: QStyle = ...
        PM_MdiSubWindowFrameWidth: QStyle = ...
        PM_MDIFrameWidth: QStyle = ...
        PM_MdiSubWindowMinimizedWidth: QStyle = ...
        PM_MDIMinimizedWidth: QStyle = ...
        PM_HeaderMargin: QStyle = ...
        PM_HeaderMarkSize: QStyle = ...
        PM_HeaderGripMargin: QStyle = ...
        PM_TabBarTabShiftHorizontal: QStyle = ...
        PM_TabBarTabShiftVertical: QStyle = ...
        PM_TabBarScrollButtonWidth: QStyle = ...
        PM_ToolBarFrameWidth: QStyle = ...
        PM_ToolBarHandleExtent: QStyle = ...
        PM_ToolBarItemSpacing: QStyle = ...
        PM_ToolBarItemMargin: QStyle = ...
        PM_ToolBarSeparatorExtent: QStyle = ...
        PM_ToolBarExtensionExtent: QStyle = ...
        PM_SpinBoxSliderHeight: QStyle = ...
        PM_DefaultTopLevelMargin: QStyle = ...
        PM_DefaultChildMargin: QStyle = ...
        PM_DefaultLayoutSpacing: QStyle = ...
        PM_ToolBarIconSize: QStyle = ...
        PM_ListViewIconSize: QStyle = ...
        PM_IconViewIconSize: QStyle = ...
        PM_SmallIconSize: QStyle = ...
        PM_LargeIconSize: QStyle = ...
        PM_FocusFrameVMargin: QStyle = ...
        PM_FocusFrameHMargin: QStyle = ...
        PM_ToolTipLabelFrameWidth: QStyle = ...
        PM_CheckBoxLabelSpacing: QStyle = ...
        PM_TabBarIconSize: QStyle = ...
        PM_SizeGripSize: QStyle = ...
        PM_DockWidgetTitleMargin: QStyle = ...
        PM_MessageBoxIconSize: QStyle = ...
        PM_ButtonIconSize: QStyle = ...
        PM_DockWidgetTitleBarButtonMargin: QStyle = ...
        PM_RadioButtonLabelSpacing: QStyle = ...
        PM_LayoutLeftMargin: QStyle = ...
        PM_LayoutTopMargin: QStyle = ...
        PM_LayoutRightMargin: QStyle = ...
        PM_LayoutBottomMargin: QStyle = ...
        PM_LayoutHorizontalSpacing: QStyle = ...
        PM_LayoutVerticalSpacing: QStyle = ...
        PM_TabBar_ScrollButtonOverlap: QStyle = ...
        PM_TextCursorWidth: QStyle = ...
        PM_TabCloseIndicatorWidth: QStyle = ...
        PM_TabCloseIndicatorHeight: QStyle = ...
        PM_ScrollView_ScrollBarSpacing: QStyle = ...
        PM_SubMenuOverlap: QStyle = ...
        PM_ScrollView_ScrollBarOverlap: QStyle = ...
        PM_TreeViewIndentation: QStyle = ...
        PM_HeaderDefaultSectionSizeHorizontal: QStyle = ...
        PM_HeaderDefaultSectionSizeVertical: QStyle = ...
        PM_TitleBarButtonIconSize: QStyle = ...
        PM_TitleBarButtonSize: QStyle = ...
        PM_CustomBase: QStyle = ...

    class SubControl(int):
        SC_None: QStyle = ...
        SC_ScrollBarAddLine: QStyle = ...
        SC_ScrollBarSubLine: QStyle = ...
        SC_ScrollBarAddPage: QStyle = ...
        SC_ScrollBarSubPage: QStyle = ...
        SC_ScrollBarFirst: QStyle = ...
        SC_ScrollBarLast: QStyle = ...
        SC_ScrollBarSlider: QStyle = ...
        SC_ScrollBarGroove: QStyle = ...
        SC_SpinBoxUp: QStyle = ...
        SC_SpinBoxDown: QStyle = ...
        SC_SpinBoxFrame: QStyle = ...
        SC_SpinBoxEditField: QStyle = ...
        SC_ComboBoxFrame: QStyle = ...
        SC_ComboBoxEditField: QStyle = ...
        SC_ComboBoxArrow: QStyle = ...
        SC_ComboBoxListBoxPopup: QStyle = ...
        SC_SliderGroove: QStyle = ...
        SC_SliderHandle: QStyle = ...
        SC_SliderTickmarks: QStyle = ...
        SC_ToolButton: QStyle = ...
        SC_ToolButtonMenu: QStyle = ...
        SC_TitleBarSysMenu: QStyle = ...
        SC_TitleBarMinButton: QStyle = ...
        SC_TitleBarMaxButton: QStyle = ...
        SC_TitleBarCloseButton: QStyle = ...
        SC_TitleBarNormalButton: QStyle = ...
        SC_TitleBarShadeButton: QStyle = ...
        SC_TitleBarUnshadeButton: QStyle = ...
        SC_TitleBarContextHelpButton: QStyle = ...
        SC_TitleBarLabel: QStyle = ...
        SC_DialGroove: QStyle = ...
        SC_DialHandle: QStyle = ...
        SC_DialTickmarks: QStyle = ...
        SC_GroupBoxCheckBox: QStyle = ...
        SC_GroupBoxLabel: QStyle = ...
        SC_GroupBoxContents: QStyle = ...
        SC_GroupBoxFrame: QStyle = ...
        SC_MdiMinButton: QStyle = ...
        SC_MdiNormalButton: QStyle = ...
        SC_MdiCloseButton: QStyle = ...
        SC_CustomBase: QStyle = ...
        SC_All: QStyle = ...

    class ComplexControl(int):
        CC_SpinBox: QStyle = ...
        CC_ComboBox: QStyle = ...
        CC_ScrollBar: QStyle = ...
        CC_Slider: QStyle = ...
        CC_ToolButton: QStyle = ...
        CC_TitleBar: QStyle = ...
        CC_Dial: QStyle = ...
        CC_GroupBox: QStyle = ...
        CC_MdiControls: QStyle = ...
        CC_CustomBase: QStyle = ...

    class SubElement(int):
        SE_PushButtonContents: QStyle = ...
        SE_PushButtonFocusRect: QStyle = ...
        SE_CheckBoxIndicator: QStyle = ...
        SE_CheckBoxContents: QStyle = ...
        SE_CheckBoxFocusRect: QStyle = ...
        SE_CheckBoxClickRect: QStyle = ...
        SE_RadioButtonIndicator: QStyle = ...
        SE_RadioButtonContents: QStyle = ...
        SE_RadioButtonFocusRect: QStyle = ...
        SE_RadioButtonClickRect: QStyle = ...
        SE_ComboBoxFocusRect: QStyle = ...
        SE_SliderFocusRect: QStyle = ...
        SE_ProgressBarGroove: QStyle = ...
        SE_ProgressBarContents: QStyle = ...
        SE_ProgressBarLabel: QStyle = ...
        SE_ToolBoxTabContents: QStyle = ...
        SE_HeaderLabel: QStyle = ...
        SE_HeaderArrow: QStyle = ...
        SE_TabWidgetTabBar: QStyle = ...
        SE_TabWidgetTabPane: QStyle = ...
        SE_TabWidgetTabContents: QStyle = ...
        SE_TabWidgetLeftCorner: QStyle = ...
        SE_TabWidgetRightCorner: QStyle = ...
        SE_ViewItemCheckIndicator: QStyle = ...
        SE_TabBarTearIndicator: QStyle = ...
        SE_TreeViewDisclosureItem: QStyle = ...
        SE_LineEditContents: QStyle = ...
        SE_FrameContents: QStyle = ...
        SE_DockWidgetCloseButton: QStyle = ...
        SE_DockWidgetFloatButton: QStyle = ...
        SE_DockWidgetTitleBarText: QStyle = ...
        SE_DockWidgetIcon: QStyle = ...
        SE_CheckBoxLayoutItem: QStyle = ...
        SE_ComboBoxLayoutItem: QStyle = ...
        SE_DateTimeEditLayoutItem: QStyle = ...
        SE_DialogButtonBoxLayoutItem: QStyle = ...
        SE_LabelLayoutItem: QStyle = ...
        SE_ProgressBarLayoutItem: QStyle = ...
        SE_PushButtonLayoutItem: QStyle = ...
        SE_RadioButtonLayoutItem: QStyle = ...
        SE_SliderLayoutItem: QStyle = ...
        SE_SpinBoxLayoutItem: QStyle = ...
        SE_ToolButtonLayoutItem: QStyle = ...
        SE_FrameLayoutItem: QStyle = ...
        SE_GroupBoxLayoutItem: QStyle = ...
        SE_TabWidgetLayoutItem: QStyle = ...
        SE_ItemViewItemCheckIndicator: QStyle = ...
        SE_ItemViewItemDecoration: QStyle = ...
        SE_ItemViewItemText: QStyle = ...
        SE_ItemViewItemFocusRect: QStyle = ...
        SE_TabBarTabLeftButton: QStyle = ...
        SE_TabBarTabRightButton: QStyle = ...
        SE_TabBarTabText: QStyle = ...
        SE_ShapedFrameContents: QStyle = ...
        SE_ToolBarHandle: QStyle = ...
        SE_TabBarTearIndicatorLeft: QStyle = ...
        SE_TabBarScrollLeftButton: QStyle = ...
        SE_TabBarScrollRightButton: QStyle = ...
        SE_TabBarTearIndicatorRight: QStyle = ...
        SE_PushButtonBevel: QStyle = ...
        SE_CustomBase: QStyle = ...

    class ControlElement(int):
        CE_PushButton: QStyle = ...
        CE_PushButtonBevel: QStyle = ...
        CE_PushButtonLabel: QStyle = ...
        CE_CheckBox: QStyle = ...
        CE_CheckBoxLabel: QStyle = ...
        CE_RadioButton: QStyle = ...
        CE_RadioButtonLabel: QStyle = ...
        CE_TabBarTab: QStyle = ...
        CE_TabBarTabShape: QStyle = ...
        CE_TabBarTabLabel: QStyle = ...
        CE_ProgressBar: QStyle = ...
        CE_ProgressBarGroove: QStyle = ...
        CE_ProgressBarContents: QStyle = ...
        CE_ProgressBarLabel: QStyle = ...
        CE_MenuItem: QStyle = ...
        CE_MenuScroller: QStyle = ...
        CE_MenuVMargin: QStyle = ...
        CE_MenuHMargin: QStyle = ...
        CE_MenuTearoff: QStyle = ...
        CE_MenuEmptyArea: QStyle = ...
        CE_MenuBarItem: QStyle = ...
        CE_MenuBarEmptyArea: QStyle = ...
        CE_ToolButtonLabel: QStyle = ...
        CE_Header: QStyle = ...
        CE_HeaderSection: QStyle = ...
        CE_HeaderLabel: QStyle = ...
        CE_ToolBoxTab: QStyle = ...
        CE_SizeGrip: QStyle = ...
        CE_Splitter: QStyle = ...
        CE_RubberBand: QStyle = ...
        CE_DockWidgetTitle: QStyle = ...
        CE_ScrollBarAddLine: QStyle = ...
        CE_ScrollBarSubLine: QStyle = ...
        CE_ScrollBarAddPage: QStyle = ...
        CE_ScrollBarSubPage: QStyle = ...
        CE_ScrollBarSlider: QStyle = ...
        CE_ScrollBarFirst: QStyle = ...
        CE_ScrollBarLast: QStyle = ...
        CE_FocusFrame: QStyle = ...
        CE_ComboBoxLabel: QStyle = ...
        CE_ToolBar: QStyle = ...
        CE_ToolBoxTabShape: QStyle = ...
        CE_ToolBoxTabLabel: QStyle = ...
        CE_HeaderEmptyArea: QStyle = ...
        CE_ColumnViewGrip: QStyle = ...
        CE_ItemViewItem: QStyle = ...
        CE_ShapedFrame: QStyle = ...
        CE_CustomBase: QStyle = ...

    class PrimitiveElement(int):
        PE_Frame: QStyle = ...
        PE_FrameDefaultButton: QStyle = ...
        PE_FrameDockWidget: QStyle = ...
        PE_FrameFocusRect: QStyle = ...
        PE_FrameGroupBox: QStyle = ...
        PE_FrameLineEdit: QStyle = ...
        PE_FrameMenu: QStyle = ...
        PE_FrameStatusBar: QStyle = ...
        PE_FrameTabWidget: QStyle = ...
        PE_FrameWindow: QStyle = ...
        PE_FrameButtonBevel: QStyle = ...
        PE_FrameButtonTool: QStyle = ...
        PE_FrameTabBarBase: QStyle = ...
        PE_PanelButtonCommand: QStyle = ...
        PE_PanelButtonBevel: QStyle = ...
        PE_PanelButtonTool: QStyle = ...
        PE_PanelMenuBar: QStyle = ...
        PE_PanelToolBar: QStyle = ...
        PE_PanelLineEdit: QStyle = ...
        PE_IndicatorArrowDown: QStyle = ...
        PE_IndicatorArrowLeft: QStyle = ...
        PE_IndicatorArrowRight: QStyle = ...
        PE_IndicatorArrowUp: QStyle = ...
        PE_IndicatorBranch: QStyle = ...
        PE_IndicatorButtonDropDown: QStyle = ...
        PE_IndicatorViewItemCheck: QStyle = ...
        PE_IndicatorCheckBox: QStyle = ...
        PE_IndicatorDockWidgetResizeHandle: QStyle = ...
        PE_IndicatorHeaderArrow: QStyle = ...
        PE_IndicatorMenuCheckMark: QStyle = ...
        PE_IndicatorProgressChunk: QStyle = ...
        PE_IndicatorRadioButton: QStyle = ...
        PE_IndicatorSpinDown: QStyle = ...
        PE_IndicatorSpinMinus: QStyle = ...
        PE_IndicatorSpinPlus: QStyle = ...
        PE_IndicatorSpinUp: QStyle = ...
        PE_IndicatorToolBarHandle: QStyle = ...
        PE_IndicatorToolBarSeparator: QStyle = ...
        PE_PanelTipLabel: QStyle = ...
        PE_IndicatorTabTear: QStyle = ...
        PE_PanelScrollAreaCorner: QStyle = ...
        PE_Widget: QStyle = ...
        PE_IndicatorColumnViewArrow: QStyle = ...
        PE_FrameStatusBarItem: QStyle = ...
        PE_IndicatorItemViewItemCheck: QStyle = ...
        PE_IndicatorItemViewItemDrop: QStyle = ...
        PE_PanelItemViewItem: QStyle = ...
        PE_PanelItemViewRow: QStyle = ...
        PE_PanelStatusBar: QStyle = ...
        PE_IndicatorTabClose: QStyle = ...
        PE_PanelMenu: QStyle = ...
        PE_IndicatorTabTearLeft: QStyle = ...
        PE_IndicatorTabTearRight: QStyle = ...
        PE_CustomBase: QStyle = ...

    class StateFlag(int):
        State_None: QStyle = ...
        State_Enabled: QStyle = ...
        State_Raised: QStyle = ...
        State_Sunken: QStyle = ...
        State_Off: QStyle = ...
        State_NoChange: QStyle = ...
        State_On: QStyle = ...
        State_DownArrow: QStyle = ...
        State_Horizontal: QStyle = ...
        State_HasFocus: QStyle = ...
        State_Top: QStyle = ...
        State_Bottom: QStyle = ...
        State_FocusAtBorder: QStyle = ...
        State_AutoRaise: QStyle = ...
        State_MouseOver: QStyle = ...
        State_UpArrow: QStyle = ...
        State_Selected: QStyle = ...
        State_Active: QStyle = ...
        State_Open: QStyle = ...
        State_Children: QStyle = ...
        State_Item: QStyle = ...
        State_Sibling: QStyle = ...
        State_Editing: QStyle = ...
        State_KeyboardFocusChange: QStyle = ...
        State_ReadOnly: QStyle = ...
        State_Window: QStyle = ...
        State_Small: QStyle = ...
        State_Mini: QStyle = ...

    class State(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, f: typing.Union["QStyle.State", "QStyle.StateFlag"]) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QStyle.State") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QStyle.State":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class SubControls(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self, f: typing.Union["QStyle.SubControls", "QStyle.SubControl"]
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QStyle.SubControls") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QStyle.SubControls":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qstyle.html#QStyle-1

        **QStyle::QStyle()**

        Constructs a style object.
        """
        ...

    def proxy(self) -> "QStyle":
        """
        https://doc.qt.io/qt-5/qstyle.html#proxy

        **const QStyle *QStyle::proxy() const**

        This function returns the current proxy for this style. By default most
        styles will return themselves. However when a proxy style is in use, it
        will allow the style to call back into its proxy.

        This function was introduced in Qt 4.6.
        """
        ...

    def combinedLayoutSpacing(
        self,
        controls1: typing.Union["QSizePolicy.ControlTypes", "QSizePolicy.ControlType"],
        controls2: typing.Union["QSizePolicy.ControlTypes", "QSizePolicy.ControlType"],
        orientation: QtCore.Qt.Orientation,
        option: typing.Optional["QStyleOption"] = ...,
        widget: typing.Optional[QWidget] = ...,
    ) -> int:
        """
        https://doc.qt.io/qt-5/qstyle.html#combinedLayoutSpacing

        **int QStyle::combinedLayoutSpacing(QSizePolicy::ControlTypes controls1
        , QSizePolicy::ControlTypes controls2 , Qt::Orientation orientation ,
        QStyleOption * option = nullptr, QWidget * widget = nullptr) const**

        Returns the spacing that should be used between **controls1** and
        **controls2** in a layout. **orientation** specifies whether the
        controls are laid out side by side or stacked vertically. The **option**
        parameter can be used to pass extra information about the parent widget.
        The **widget** parameter is optional and can also be used if **option**
        is `nullptr`.

        **controls1** and **controls2** are OR-combination of zero or more
        **control types** .

        This function is called by the layout system. It is used only if
        **PM_LayoutHorizontalSpacing**  or **PM_LayoutVerticalSpacing**  returns
        a negative value.

        This function was introduced in Qt 4.3.

        **See also** **layoutSpacing** ().
        """
        ...

    def layoutSpacing(
        self,
        control1: "QSizePolicy.ControlType",
        control2: "QSizePolicy.ControlType",
        orientation: QtCore.Qt.Orientation,
        option: typing.Optional["QStyleOption"] = ...,
        widget: typing.Optional[QWidget] = ...,
    ) -> int:
        """
        https://doc.qt.io/qt-5/qstyle.html#layoutSpacing

        **[pure virtual] int QStyle::layoutSpacing(QSizePolicy::ControlType
        control1 , QSizePolicy::ControlType control2 , Qt::Orientation
        orientation , const QStyleOption * option = nullptr, const QWidget *
        widget = nullptr) const**

        Returns the spacing that should be used between **control1** and
        **control2** in a layout. **orientation** specifies whether the controls
        are laid out side by side or stacked vertically. The **option**
        parameter can be used to pass extra information about the parent widget.
        The **widget** parameter is optional and can also be used if **option**
        is `nullptr`.

        This function is called by the layout system. It is used only if
        **PM_LayoutHorizontalSpacing**  or **PM_LayoutVerticalSpacing**  returns
        a negative value.

        This function was introduced in Qt 4.3.

        **See also** **combinedLayoutSpacing** ().
        """
        ...

    @staticmethod
    def alignedRect(
        direction: QtCore.Qt.LayoutDirection,
        alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag],
        size: QtCore.QSize,
        rectangle: QtCore.QRect,
    ) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qstyle.html#alignedRect

        **[static] QRect QStyle::alignedRect(Qt::LayoutDirection direction ,
        Qt::Alignment alignment , const QSize & size , const QRect & rectangle
        )**

        Returns a new rectangle of the specified **size** that is aligned to the
        given **rectangle** according to the specified **alignment** and
        **direction**.
        """
        ...

    @staticmethod
    def visualAlignment(
        direction: QtCore.Qt.LayoutDirection,
        alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag],
    ) -> QtCore.Qt.Alignment:
        """
        https://doc.qt.io/qt-5/qstyle.html#visualAlignment

        **[static] Qt::Alignment QStyle::visualAlignment(Qt::LayoutDirection
        direction , Qt::Alignment alignment )**

        Transforms an **alignment** of **Qt::AlignLeft**  or **Qt::AlignRight**
        without **Qt::AlignAbsolute**  into **Qt::AlignLeft**  or
        **Qt::AlignRight**  with **Qt::AlignAbsolute**  according to the layout
        **direction**. The other alignment flags are left untouched.

        If no horizontal alignment was specified, the function returns the
        default alignment for the given layout **direction**.

        **QWidget::layoutDirection**
        """
        ...

    @staticmethod
    def sliderValueFromPosition(
        min: int, max: int, position: int, span: int, upsideDown: bool = ...
    ) -> int:
        """
        https://doc.qt.io/qt-5/qstyle.html#sliderValueFromPosition

        **[static] int QStyle::sliderValueFromPosition(int min , int max , int
        position , int span , bool upsideDown = false)**

        Converts the given pixel **position** to a logical value. 0 maps to the
        **min** parameter, **span** maps to **max** and other values are
        distributed evenly in-between.

        This function can handle the entire integer range without overflow.

        By default, this function assumes that the maximum value is on the right
        for horizontal items and on the bottom for vertical items. Set the
        **upsideDown** parameter to true to reverse this behavior.

        **See also** **sliderPositionFromValue** ().
        """
        ...

    @staticmethod
    def sliderPositionFromValue(
        min: int, max: int, logicalValue: int, span: int, upsideDown: bool = ...
    ) -> int:
        """
        https://doc.qt.io/qt-5/qstyle.html#sliderPositionFromValue

        **[static] int QStyle::sliderPositionFromValue(int min , int max , int
        logicalValue , int span , bool upsideDown = false)**

        Converts the given **logicalValue** to a pixel position. The **min**
        parameter maps to 0, **max** maps to **span** and other values are
        distributed evenly in-between.

        This function can handle the entire integer range without overflow,
        providing that **span** is less than 4096.

        By default, this function assumes that the maximum value is on the right
        for horizontal items and on the bottom for vertical items. Set the
        **upsideDown** parameter to true to reverse this behavior.

        **See also** **sliderValueFromPosition** ().
        """
        ...

    @staticmethod
    def visualPos(
        direction: QtCore.Qt.LayoutDirection,
        boundingRect: QtCore.QRect,
        logicalPos: QtCore.QPoint,
    ) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-5/qstyle.html#visualPos

        **[static] QPoint QStyle::visualPos(Qt::LayoutDirection direction ,
        const QRect & boundingRectangle , const QPoint & logicalPosition )**

        Returns the given **logicalPosition** converted to screen coordinates
        based on the specified **direction**. The **boundingRectangle** is used
        when performing the translation.

        **See also** **QWidget::layoutDirection** .
        """
        ...

    @staticmethod
    def visualRect(
        direction: QtCore.Qt.LayoutDirection,
        boundingRect: QtCore.QRect,
        logicalRect: QtCore.QRect,
    ) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qstyle.html#visualRect

        **[static] QRect QStyle::visualRect(Qt::LayoutDirection direction ,
        const QRect & boundingRectangle , const QRect & logicalRectangle )**

        Returns the given **logicalRectangle** converted to screen coordinates
        based on the specified **direction**. The **boundingRectangle** is used
        when performing the translation.

        This function is provided to support right-to-left desktops, and is
        typically used in implementations of the **subControlRect** () function.

        **See also** **QWidget::layoutDirection** .
        """
        ...

    def generatedIconPixmap(
        self, iconMode: QtGui.QIcon.Mode, pixmap: QtGui.QPixmap, opt: "QStyleOption"
    ) -> QtGui.QPixmap:
        """
        https://doc.qt.io/qt-5/qstyle.html#generatedIconPixmap

        **[pure virtual] QPixmap QStyle::generatedIconPixmap(QIcon::Mode
        iconMode , const QPixmap & pixmap , const QStyleOption * option )
        const**

        Returns a copy of the given **pixmap** , styled to conform to the
        specified **iconMode** and taking into account the palette specified by
        **option**.

        The **option** parameter can pass extra information, but it must contain
        a palette.

        Note that not all pixmaps will conform, in which case the returned
        pixmap is a plain copy.

        **See also** **QIcon** .
        """
        ...

    def standardIcon(
        self,
        standardIcon: "QStyle.StandardPixmap",
        option: typing.Optional["QStyleOption"] = ...,
        widget: typing.Optional[QWidget] = ...,
    ) -> QtGui.QIcon:
        """
        https://doc.qt.io/qt-5/qstyle.html#standardIcon

        **[pure virtual] QIcon QStyle::standardIcon(QStyle::StandardPixmap
        standardIcon , const QStyleOption * option = 0, const QWidget * widget =
        0) const**

        Returns an icon for the given **standardIcon**.

        The **standardIcon** is a standard pixmap which can follow some existing
        GUI style or guideline. The **option** argument can be used to pass
        extra information required when defining the appropriate icon. The
        **widget** argument is optional and can also be used to aid the
        determination of the icon.

        This function was introduced in Qt 4.1.
        """
        ...

    def standardPixmap(
        self,
        standardPixmap: "QStyle.StandardPixmap",
        option: typing.Optional["QStyleOption"] = ...,
        widget: typing.Optional[QWidget] = ...,
    ) -> QtGui.QPixmap:
        ...

    def styleHint(
        self,
        stylehint: "QStyle.StyleHint",
        option: typing.Optional["QStyleOption"] = ...,
        widget: typing.Optional[QWidget] = ...,
        returnData: typing.Optional["QStyleHintReturn"] = ...,
    ) -> int:
        """
        https://doc.qt.io/qt-5/qstyle.html#styleHint

        **[pure virtual] int QStyle::styleHint(QStyle::StyleHint hint , const
        QStyleOption * option = nullptr, const QWidget * widget = nullptr,
        QStyleHintReturn * returnData = nullptr) const**

        Returns an integer representing the specified style **hint** for the
        given **widget** described by the provided style **option**.

        **returnData** is used when the querying widget needs more detailed data
        than the integer that styleHint() returns. See the **QStyleHintReturn**
        class description for details.
        """
        ...

    def sizeFromContents(
        self,
        ct: "QStyle.ContentsType",
        opt: "QStyleOption",
        contentsSize: QtCore.QSize,
        widget: typing.Optional[QWidget] = ...,
    ) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qstyle.html#sizeFromContents

        **[pure virtual] QSize QStyle::sizeFromContents(QStyle::ContentsType
        type , const QStyleOption * option , const QSize & contentsSize , const
        QWidget * widget = nullptr) const**

        Returns the size of the element described by the specified **option**
        and **type** , based on the provided **contentsSize**.

        The **option** argument is a pointer to a **QStyleOption**  or one of
        its subclasses. The **option** can be cast to the appropriate type using
        the **qstyleoption_cast** () function. The **widget** is an optional
        argument and can contain extra information used for calculating the
        size.

        See the table below for the appropriate **option** casts:

        Contents Type**QStyleOption**  Subclass
        **CT_CheckBox**
        **QStyleOptionButton**
        **CT_ComboBox** **QStyleOptionComboBox**
        **CT_GroupBox** **QStyleOptionGroupBox**
        **CT_HeaderSection**
        **QStyleOptionHeader**
        **CT_ItemViewItem** **QStyleOptionViewItem**
        **CT_LineEdit** **QStyleOptionFrame**
        **CT_MdiControls**
        **QStyleOptionComplex**
        **CT_Menu** **QStyleOption**
        **CT_MenuItem**
        **QStyleOptionMenuItem**
        **CT_MenuBar** **QStyleOptionMenuItem**
        **CT_MenuBarItem** **QStyleOptionMenuItem**
        **CT_ProgressBar**
        **QStyleOptionProgressBar**
        **CT_PushButton** **QStyleOptionButton**
        **CT_RadioButton** **QStyleOptionButton**
        **CT_ScrollBar**
        **QStyleOptionSlider**
        **CT_SizeGrip** **QStyleOption**
        **CT_Slider** **QStyleOptionSlider**
        **CT_SpinBox**
        **QStyleOptionSpinBox**
        **CT_Splitter** **QStyleOption**
        **CT_TabBarTab** **QStyleOptionTab**
        **CT_TabWidget**
        **QStyleOptionTabWidgetFrame**
        **CT_ToolButton**
        **QStyleOptionToolButton**

        **See also** **ContentsType**  and **QStyleOption** .
        """
        ...

    def pixelMetric(
        self,
        metric: "QStyle.PixelMetric",
        option: typing.Optional["QStyleOption"] = ...,
        widget: typing.Optional[QWidget] = ...,
    ) -> int:
        """
        https://doc.qt.io/qt-5/qstyle.html#pixelMetric

        **[pure virtual] int QStyle::pixelMetric(QStyle::PixelMetric metric ,
        const QStyleOption * option = nullptr, const QWidget * widget = nullptr)
        const**

        Returns the value of the given pixel **metric**.

        The specified **option** and **widget** can be used for calculating the
        metric. In general, the **widget** argument is not used. The **option**
        can be cast to the appropriate type using the **qstyleoption_cast** ()
        function. Note that the **option** may be zero even for PixelMetrics
        that can make use of it. See the table below for the appropriate
        **option** casts:

        Pixel Metric**QStyleOption**  Subclass
        **PM_SliderControlThickness**
        **QStyleOptionSlider**
        **PM_SliderLength** **QStyleOptionSlider**
        **PM_SliderTickmarkOffset** **QStyleOptionSlider**
        **PM_SliderSpaceAvailable** **QStyleOptionSlider**
        **PM_ScrollBarExtent** **QStyleOptionSlider**
        **PM_TabBarTabOverlap**
        **QStyleOptionTab**
        **PM_TabBarTabHSpace** **QStyleOptionTab**
        **PM_TabBarTabVSpace** **QStyleOptionTab**
        **PM_TabBarBaseHeight**
        **QStyleOptionTab**
        **PM_TabBarBaseOverlap** **QStyleOptionTab**

        Some pixel metrics are called from widgets and some are only called
        internally by the style. If the metric is not called by a widget, it is
        the discretion of the style author to make use of it. For some styles,
        this may not be appropriate.
        """
        ...

    def subControlRect(
        self,
        cc: "QStyle.ComplexControl",
        opt: "QStyleOptionComplex",
        sc: "QStyle.SubControl",
        widget: typing.Optional[QWidget] = ...,
    ) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qstyle.html#subControlRect

        **[pure virtual] QRect QStyle::subControlRect(QStyle::ComplexControl
        control , const QStyleOptionComplex * option , QStyle::SubControl
        subControl , const QWidget * widget = nullptr) const**

        Returns the rectangle containing the specified **subControl** of the
        given complex **control** (with the style specified by **option** ). The
        rectangle is defined in screen coordinates.

        The **option** argument is a pointer to **QStyleOptionComplex**  or one
        of its subclasses, and can be cast to the appropriate type using the
        **qstyleoption_cast** () function. See **drawComplexControl** () for
        details. The **widget** is optional and can contain additional
        information for the function.

        **See also** **drawComplexControl** ().
        """
        ...

    def hitTestComplexControl(
        self,
        cc: "QStyle.ComplexControl",
        opt: "QStyleOptionComplex",
        pt: QtCore.QPoint,
        widget: typing.Optional[QWidget] = ...,
    ) -> "QStyle.SubControl":
        """
        https://doc.qt.io/qt-5/qstyle.html#hitTestComplexControl

        **[pure virtual] QStyle::SubControl
        QStyle::hitTestComplexControl(QStyle::ComplexControl control , const
        QStyleOptionComplex * option , const QPoint & position , const QWidget *
        widget = nullptr) const**

        Returns the sub control at the given **position** in the given complex
        **control** (with the style options specified by **option** ).

        Note that the **position** is expressed in screen coordinates.

        The **option** argument is a pointer to a **QStyleOptionComplex**
        object (or one of its subclasses). The object can be cast to the
        appropriate type using the **qstyleoption_cast** () function. See
        **drawComplexControl** () for details. The **widget** argument is
        optional and can contain additional information for the function.

        **See also** **drawComplexControl** () and **subControlRect** ().
        """
        ...

    def drawComplexControl(
        self,
        cc: "QStyle.ComplexControl",
        opt: "QStyleOptionComplex",
        p: QtGui.QPainter,
        widget: typing.Optional[QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qstyle.html#drawComplexControl

        **[pure virtual] void QStyle::drawComplexControl(QStyle::ComplexControl
        control , const QStyleOptionComplex * option , QPainter * painter ,
        const QWidget * widget = nullptr) const**

        Draws the given **control** using the provided **painter** with the
        style options specified by **option**.

        The **widget** argument is optional and can be used as aid in drawing
        the control.

        The **option** parameter is a pointer to a **QStyleOptionComplex**
        object that can be cast to the correct subclass using the
        **qstyleoption_cast** () function. Note that the `rect` member of the
        specified **option** must be in logical coordinates. Reimplementations
        of this function should use **visualRect** () to change the logical
        coordinates into screen coordinates before calling the **drawPrimitive**
        () or **drawControl** () function.

        The table below is listing the complex control elements and their
        associated style option subclass. The style options contain all the
        parameters required to draw the controls, including
        **QStyleOption::state**  which holds the **style flags**  that are used
        when drawing. The table also describes which flags that are set when
        casting the given **option** to the appropriate subclass.

        Complex Control**QStyleOptionComplex**  SubclassStyle FlagRemark
        **CC_SpinBox** **QStyleOptionSpinBox** **State_Enabled** Set if the spin
        box is enabled.
        **State_HasFocus** Set if the spin box has input
        focus.
        **CC_ComboBox** **QStyleOptionComboBox** **State_Enabled** Set
        if the combobox is enabled.
        **State_HasFocus** Set if the combobox has
        input focus.
        **CC_ScrollBar** **QStyleOptionSlider** **State_Enabled**
        Set if the scroll bar is enabled.
        **State_HasFocus** Set if the scroll
        bar has input focus.
        **CC_Slider** **QStyleOptionSlider**
        **State_Enabled** Set if the slider is enabled.
        **State_HasFocus** Set
        if the slider has input focus.
        **CC_Dial** **QStyleOptionSlider**
        **State_Enabled** Set if the dial is enabled.
        **State_HasFocus** Set
        if the dial has input focus.
        **CC_ToolButton**
        **QStyleOptionToolButton** **State_Enabled** Set if the tool button is
        enabled.
        **State_HasFocus** Set if the tool button has input focus.
        **State_DownArrow** Set if the tool button is down (i.e., a mouse button
        or the space bar is pressed).
        **State_On** Set if the tool button is a
        toggle button and is toggled on.
        **State_AutoRaise** Set if the tool
        button has auto-raise enabled.
        **State_Raised** Set if the button is
        not down, not on, and doesn't contain the mouse when auto-raise is
        enabled.
        **CC_TitleBar** **QStyleOptionTitleBar** **State_Enabled**
        Set if the title bar is enabled.

        **See also** **drawPrimitive** () and **drawControl** ().
        """
        ...

    def subElementRect(
        self,
        subElement: "QStyle.SubElement",
        option: "QStyleOption",
        widget: typing.Optional[QWidget] = ...,
    ) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qstyle.html#subElementRect

        **[pure virtual] QRect QStyle::subElementRect(QStyle::SubElement element
        , const QStyleOption * option , const QWidget * widget = nullptr)
        const**

        Returns the sub-area for the given **element** as described in the
        provided style **option**. The returned rectangle is defined in screen
        coordinates.

        The **widget** argument is optional and can be used to aid determining
        the area. The **QStyleOption**  object can be cast to the appropriate
        type using the **qstyleoption_cast** () function. See the table below
        for the appropriate **option** casts:

        Sub Element**QStyleOption**  Subclass
        **SE_PushButtonContents**
        **QStyleOptionButton**
        **SE_PushButtonFocusRect**
        **QStyleOptionButton**
        **SE_PushButtonBevel** **QStyleOptionButton**
        **SE_CheckBoxIndicator** **QStyleOptionButton**
        **SE_CheckBoxContents** **QStyleOptionButton**
        **SE_CheckBoxFocusRect** **QStyleOptionButton**
        **SE_RadioButtonIndicator** **QStyleOptionButton**
        **SE_RadioButtonContents** **QStyleOptionButton**
        **SE_RadioButtonFocusRect** **QStyleOptionButton**
        **SE_ComboBoxFocusRect** **QStyleOptionComboBox**
        **SE_ProgressBarGroove** **QStyleOptionProgressBar**
        **SE_ProgressBarContents** **QStyleOptionProgressBar**
        **SE_ProgressBarLabel** **QStyleOptionProgressBar**
        """
        ...

    def drawControl(
        self,
        element: "QStyle.ControlElement",
        opt: "QStyleOption",
        p: QtGui.QPainter,
        widget: typing.Optional[QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qstyle.html#drawControl

        **[pure virtual] void QStyle::drawControl(QStyle::ControlElement element
        , const QStyleOption * option , QPainter * painter , const QWidget *
        widget = nullptr) const**

        Draws the given **element** with the provided **painter** with the style
        options specified by **option**.

        The **widget** argument is optional and can be used as aid in drawing
        the control. The **option** parameter is a pointer to a **QStyleOption**
        object that can be cast to the correct subclass using the
        **qstyleoption_cast** () function.

        The table below is listing the control elements and their associated
        style option subclass. The style options contain all the parameters
        required to draw the controls, including **QStyleOption::state**  which
        holds the style flags that are used when drawing. The table also
        describes which flags that are set when casting the given option to the
        appropriate subclass.

        Note that if a control element is not listed here, it is because it uses
        a plain **QStyleOption**  object.

        Control Element**QStyleOption**  SubclassStyle FlagRemark
        **CE_MenuItem** , **CE_MenuBarItem** **QStyleOptionMenuItem**
        **State_Selected** The menu item is currently selected item.
        **State_Enabled** The item is enabled.
        **State_DownArrow** Indicates
        that a scroll down arrow should be drawn.
        **State_UpArrow** Indicates
        that a scroll up arrow should be drawn
        **State_HasFocus** Set if the
        menu bar has input focus.
        **CE_PushButton** , **CE_PushButtonBevel** ,
        **CE_PushButtonLabel** **QStyleOptionButton** **State_Enabled** Set if
        the button is enabled.
        **State_HasFocus** Set if the button has input
        focus.
        **State_Raised** Set if the button is not down, not on and not
        flat.
        **State_On** Set if the button is a toggle button and is toggled
        on.
        **State_Sunken** Set if the button is down (i.e., the mouse button
        or the space bar is pressed on the button).
        **CE_RadioButton** ,
        **CE_RadioButtonLabel** , **CE_CheckBox** , **CE_CheckBoxLabel**
        **QStyleOptionButton** **State_Enabled** Set if the button is enabled.
        **State_HasFocus** Set if the button has input focus.
        **State_On** Set
        if the button is checked.
        **State_Off** Set if the button is not
        checked.
        **State_NoChange** Set if the button is in the NoChange
        state.
        **State_Sunken** Set if the button is down (i.e., the mouse
        button or the space bar is pressed on the button).
        **CE_ProgressBarContents** , **CE_ProgressBarLabel** ,
        **CE_ProgressBarGroove** **QStyleOptionProgressBar** **State_Enabled**
        Set if the progress bar is enabled.
        **State_HasFocus** Set if the
        progress bar has input focus.
        **CE_Header** , **CE_HeaderSection** ,
        **CE_HeaderLabel** **QStyleOptionHeader**
        **CE_TabBarTab** ,
        **CE_TabBarTabShape** , **CE_TabBarTabLabel** **QStyleOptionTab**
        **State_Enabled** Set if the tab bar is enabled.
        **State_Selected**
        The tab bar is the currently selected tab bar.
        **State_HasFocus** Set
        if the tab bar tab has input focus.
        **CE_ToolButtonLabel**
        **QStyleOptionToolButton** **State_Enabled** Set if the tool button is
        enabled.
        **State_HasFocus** Set if the tool button has input focus.
        **State_Sunken** Set if the tool button is down (i.e., a mouse button or
        the space bar is pressed).
        **State_On** Set if the tool button is a
        toggle button and is toggled on.
        **State_AutoRaise** Set if the tool
        button has auto-raise enabled.
        **State_MouseOver** Set if the mouse
        pointer is over the tool button.
        **State_Raised** Set if the button is
        not down and is not on.
        **CE_ToolBoxTab** **QStyleOptionToolBox**
        **State_Selected** The tab is the currently selected tab.
        **CE_HeaderSection** **QStyleOptionHeader** **State_Sunken** Indicates
        that the section is pressed.
        **State_UpArrow** Indicates that the sort
        indicator should be pointing up.
        **State_DownArrow** Indicates that
        the sort indicator should be pointing down.

        **See also** **drawPrimitive** () and **drawComplexControl** ().
        """
        ...

    def drawPrimitive(
        self,
        pe: "QStyle.PrimitiveElement",
        opt: "QStyleOption",
        p: QtGui.QPainter,
        widget: typing.Optional[QWidget] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qstyle.html#drawPrimitive

        **[pure virtual] void QStyle::drawPrimitive(QStyle::PrimitiveElement
        element , const QStyleOption * option , QPainter * painter , const
        QWidget * widget = nullptr) const**

        Draws the given primitive **element** with the provided **painter**
        using the style options specified by **option**.

        The **widget** argument is optional and may contain a widget that may
        aid in drawing the primitive element.

        The table below is listing the primitive elements and their associated
        style option subclasses. The style options contain all the parameters
        required to draw the elements, including **QStyleOption::state**  which
        holds the style flags that are used when drawing. The table also
        describes which flags that are set when casting the given option to the
        appropriate subclass.

        Note that if a primitive element is not listed here, it is because it
        uses a plain **QStyleOption**  object.

        Primitive Element**QStyleOption**  SubclassStyle FlagRemark
        **PE_FrameFocusRect** **QStyleOptionFocusRect** **State_FocusAtBorder**
        Whether the focus is is at the border or inside the widget.
        **PE_IndicatorCheckBox** **QStyleOptionButton** **State_NoChange**
        Indicates a "tri-state" checkbox.
        **State_On** Indicates the indicator
        is checked.
        **PE_IndicatorRadioButton** **QStyleOptionButton**
        **State_On** Indicates that a radio button is selected.
        **State_NoChange** Indicates a "tri-state" controller.
        **State_Enabled** Indicates the controller is enabled.
        **PE_IndicatorBranch** **QStyleOption** **State_Children** Indicates
        that the control for expanding the tree to show child items, should be
        drawn.
        **State_Item** Indicates that a horizontal branch (to show a
        child item), should be drawn.
        **State_Open** Indicates that the tree
        branch is expanded.
        **State_Sibling** Indicates that a vertical line
        (to show a sibling item), should be drawn.
        **PE_IndicatorHeaderArrow**
        **QStyleOptionHeader** **State_UpArrow** Indicates that the arrow should
        be drawn up; otherwise it should be down.
        **PE_FrameGroupBox** ,
        **PE_Frame** , **PE_FrameLineEdit** , **PE_FrameMenu** ,
        **PE_FrameDockWidget** , **PE_FrameWindow** **QStyleOptionFrame**
        **State_Sunken** Indicates that the Frame should be sunken.
        **PE_IndicatorToolBarHandle** **QStyleOption** **State_Horizontal**
        Indicates that the window handle is horizontal instead of vertical.
        **PE_IndicatorSpinPlus** , **PE_IndicatorSpinMinus** ,
        **PE_IndicatorSpinUp** , **PE_IndicatorSpinDown**
        ,**QStyleOptionSpinBox** **State_Sunken** Indicates that the button is
        pressed.
        **PE_PanelButtonCommand** **QStyleOptionButton**
        **State_Enabled** Set if the button is enabled.
        **State_HasFocus** Set
        if the button has input focus.
        **State_Raised** Set if the button is
        not down, not on and not flat.
        **State_On** Set if the button is a
        toggle button and is toggled on.
        **State_Sunken** Set if the button is
        down (i.e., the mouse button or the space bar is pressed on the button).

        **See also** **drawComplexControl** () and **drawControl** ().
        """
        ...

    def standardPalette(self) -> QtGui.QPalette:
        """
        https://doc.qt.io/qt-5/qstyle.html#standardPalette

        **[virtual] QPalette QStyle::standardPalette() const**

        Returns the style's standard palette.

        Note that on systems that support system colors, the style's standard
        palette is not used. In particular, the Windows Vista and Mac styles do
        not use the standard palette, but make use of native theme engines. With
        these styles, you should not set the palette with
        **QApplication::setPalette** ().

        **See also** **QApplication::setPalette** ().
        """
        ...

    def drawItemPixmap(
        self,
        painter: QtGui.QPainter,
        rect: QtCore.QRect,
        alignment: int,
        pixmap: QtGui.QPixmap,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qstyle.html#drawItemPixmap

        **[virtual] void QStyle::drawItemPixmap(QPainter * painter , const QRect
        & rectangle , int alignment , const QPixmap & pixmap ) const**

        Draws the given **pixmap** in the specified **rectangle** , according to
        the specified **alignment** , using the provided **painter**.

        **See also** **drawItemText** ().
        """
        ...

    def drawItemText(
        self,
        painter: QtGui.QPainter,
        rectangle: QtCore.QRect,
        alignment: int,
        palette: QtGui.QPalette,
        enabled: bool,
        text: str,
        textRole: QtGui.QPalette.ColorRole = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qstyle.html#drawItemText

        **[virtual] void QStyle::drawItemText(QPainter * painter , const QRect &
        rectangle , int alignment , const QPalette & palette , bool enabled ,
        const QString & text , QPalette::ColorRole textRole = QPalette::NoRole)
        const**

        Draws the given **text** in the specified **rectangle** using the
        provided **painter** and **palette**.

        The text is drawn using the painter's pen, and aligned and wrapped
        according to the specified **alignment**. If an explicit **textRole** is
        specified, the text is drawn using the **palette** 's color for the
        given role. The **enabled** parameter indicates whether or not the item
        is enabled; when reimplementing this function, the **enabled** parameter
        should influence how the item is drawn.

        **See also** **Qt::Alignment**  and **drawItemPixmap** ().
        """
        ...

    def itemPixmapRect(
        self, r: QtCore.QRect, flags: int, pixmap: QtGui.QPixmap
    ) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qstyle.html#itemPixmapRect

        **[virtual] QRect QStyle::itemPixmapRect(const QRect & rectangle , int
        alignment , const QPixmap & pixmap ) const**

        Returns the area within the given **rectangle** in which to draw the
        specified **pixmap** according to the defined **alignment**.
        """
        ...

    def itemTextRect(
        self,
        fm: QtGui.QFontMetrics,
        r: QtCore.QRect,
        flags: int,
        enabled: bool,
        text: str,
    ) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qstyle.html#itemTextRect

        **[virtual] QRect QStyle::itemTextRect(const QFontMetrics & metrics ,
        const QRect & rectangle , int alignment , bool enabled , const QString &
        text ) const**

        Returns the area within the given **rectangle** in which to draw the
        provided **text** according to the specified font **metrics** and
        **alignment**. The **enabled** parameter indicates whether or not the
        associated item is enabled.

        If the given **rectangle** is larger than the area needed to render the
        **text** , the rectangle that is returned will be offset within
        **rectangle** according to the specified **alignment**. For example, if
        **alignment** is **Qt::AlignCenter** , the returned rectangle will be
        centered within **rectangle**. If the given **rectangle** is smaller
        than the area needed, the returned rectangle will be the smallest
        rectangle large enough to render the **text**.

        **See also** **Qt::Alignment** .
        """
        ...

    @typing.overload
    def unpolish(self, a0: QWidget) -> None:
        """
        https://doc.qt.io/qt-5/qstyle.html#unpolish

        **[virtual] void QStyle::unpolish(QWidget * widget )**

        Uninitialize the given **widget** 's appearance.

        This function is the counterpart to **polish** (). It is called for
        every polished widget whenever the style is dynamically changed; the
        former style has to unpolish its settings before the new style can
        polish them again.

        Note that unpolish() will only be called if the widget is destroyed.
        This can cause problems in some cases, e.g, if you remove a widget from
        the UI, cache it, and then reinsert it after the style has changed; some
        of Qt's classes cache their widgets.

        **See also** **polish** ().
        """
        ...

    @typing.overload
    def unpolish(self, a0: QApplication) -> None:
        """
        https://doc.qt.io/qt-5/qstyle.html#unpolish-1

        **[virtual] void QStyle::unpolish(QApplication * application )**

        This is an overloaded function.

        Uninitialize the given **application**.
        """
        ...

    @typing.overload
    def polish(self, a0: QWidget) -> None:
        """
        https://doc.qt.io/qt-5/qstyle.html#polish

        **[virtual] void QStyle::polish(QWidget * widget )**

        Initializes the appearance of the given **widget**.

        This function is called for every widget at some point after it has been
        fully created but just **before** it is shown for the very first time.

        Note that the default implementation does nothing. Reasonable actions in
        this function might be to call the QWidget::setBackgroundMode() function
        for the widget. Do not use the function to set, for example, the
        geometry. Reimplementing this function provides a back-door through
        which the appearance of a widget can be changed, but with Qt's style
        engine it is rarely necessary to implement this function; reimplement
        **drawItemPixmap** (), **drawItemText** (), **drawPrimitive** (), etc.
        instead.

        The **QWidget::inherits** () function may provide enough information to
        allow class-specific customizations. But because new **QStyle**
        subclasses are expected to work reasonably with all current and
        **future** widgets, limited use of hard-coded customization is
        recommended.

        **See also** **unpolish** ().
        """
        ...

    @typing.overload
    def polish(self, a0: QApplication) -> None:
        """
        https://doc.qt.io/qt-5/qstyle.html#polish-1

        **[virtual] void QStyle::polish(QApplication * application )**

        This is an overloaded function.

        Late initialization of the given **application** object.
        """
        ...

    @typing.overload
    def polish(self, a0: QtGui.QPalette) -> QtGui.QPalette:
        """
        https://doc.qt.io/qt-5/qstyle.html#polish-2

        **[virtual] void QStyle::polish(QPalette & palette )**

        This is an overloaded function.

        Changes the **palette** according to style specific requirements for
        color palettes (if any).

        **See also** **QPalette**  and **QApplication::setPalette** ().
        """
        ...
