"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QLayoutItem(PyQt5.sip.wrapper):
    """
    https://doc.qt.io/qt-5/qlayoutitem.html

    **Detailed Description**

    This is used by custom layouts.

    Pure virtual functions are provided to return information about the layout,
    including, **sizeHint** (), **minimumSize** (), **maximumSize** () and
    expanding().

    The layout's geometry can be set and retrieved with **setGeometry** () and
    **geometry** (), and its alignment with **setAlignment** () and
    **alignment** ().

    **isEmpty** () returns whether the layout item is empty. If the concrete
    item is a **QWidget** , it can be retrieved using **widget** (). Similarly
    for **layout** () and **spacerItem** ().

    Some layouts have width and height interdependencies. These can be expressed
    using **hasHeightForWidth** (), **heightForWidth** (), and
    **minimumHeightForWidth** (). For more explanation see the **Qt Quarterly**
    article **Trading Height for Width** .

    **See also** **QLayout** .
    """

    @typing.overload
    def __init__(
        self,
        alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qlayoutitem.html#QLayoutItem

        **QLayoutItem::QLayoutItem(Qt::Alignment alignment = Qt::Alignment())**

        Constructs a layout item with an **alignment**. Not all subclasses
        support alignment.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QLayoutItem") -> None:
        """
        https://doc.qt.io/qt-5/qlayoutitem.html#QLayoutItem

        **QLayoutItem::QLayoutItem(Qt::Alignment alignment = Qt::Alignment())**

        Constructs a layout item with an **alignment**. Not all subclasses
        support alignment.
        """
        ...

    def controlTypes(self) -> "QSizePolicy.ControlTypes":
        """
        https://doc.qt.io/qt-5/qlayoutitem.html#controlTypes

        **[virtual] QSizePolicy::ControlTypes QLayoutItem::controlTypes()
        const**

        Returns the control type(s) for the layout item. For a **QWidgetItem** ,
        the control type comes from the widget's size policy; for a
        **QLayoutItem** , the control types is derived from the layout's
        contents.

        **See also** **QSizePolicy::controlType** ().
        """
        ...

    def setAlignment(
        self, a: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qlayoutitem.html#setAlignment

        **void QLayoutItem::setAlignment(Qt::Alignment alignment )**

        Sets the alignment of this item to **alignment**.

        **Note:** Item alignment is only supported by **QLayoutItem**
        subclasses where it would have a visual effect. Except for
        **QSpacerItem** , which provides blank space for layouts, all public Qt
        classes that inherit **QLayoutItem**  support item alignment.

        **See also** **alignment** ().
        """
        ...

    def alignment(self) -> QtCore.Qt.Alignment:
        """
        https://doc.qt.io/qt-5/qlayoutitem.html#alignment

        **Qt::Alignment QLayoutItem::alignment() const**

        Returns the alignment of this item.

        **See also** **setAlignment** ().
        """
        ...

    def spacerItem(self) -> "QSpacerItem":
        """
        https://doc.qt.io/qt-5/qlayoutitem.html#spacerItem

        **[virtual] QSpacerItem *QLayoutItem::spacerItem()**

        If this item is a **QSpacerItem** , it is returned as a **QSpacerItem**
        ; otherwise `nullptr` is returned. This function provides type-safe
        casting.

        **See also** **layout** () and **widget** ().
        """
        ...

    def layout(self) -> "QLayout":
        """
        https://doc.qt.io/qt-5/qlayoutitem.html#layout

        **[virtual] QLayout *QLayoutItem::layout()**

        If this item is a **QLayout** , it is returned as a **QLayout** ;
        otherwise `nullptr` is returned. This function provides type-safe
        casting.

        **See also** **spacerItem** () and **widget** ().
        """
        ...

    def widget(self) -> QWidget:
        """
        https://doc.qt.io/qt-5/qlayoutitem.html#widget

        **[virtual] QWidget *QLayoutItem::widget()**

        If this item manages a **QWidget** , returns that widget. Otherwise,
        `nullptr` is returned.

        **Note:** While the functions **layout** () and **spacerItem** ()
        perform casts, this function returns another object: **QLayout**  and
        **QSpacerItem**  inherit **QLayoutItem** , while **QWidget**  does not.

        **See also** **layout** () and **spacerItem** ().
        """
        ...

    def invalidate(self) -> None:
        """
        https://doc.qt.io/qt-5/qlayoutitem.html#invalidate

        **[virtual] void QLayoutItem::invalidate()**

        Invalidates any cached information in this layout item.
        """
        ...

    def minimumHeightForWidth(self, a0: int) -> int:
        """
        https://doc.qt.io/qt-5/qlayoutitem.html#minimumHeightForWidth

        **[virtual] int QLayoutItem::minimumHeightForWidth(int w ) const**

        Returns the minimum height this widget needs for the given width, **w**.
        The default implementation simply returns **heightForWidth** ( **w** ).
        """
        ...

    def heightForWidth(self, a0: int) -> int:
        """
        https://doc.qt.io/qt-5/qlayoutitem.html#heightForWidth

        **[virtual] int QLayoutItem::heightForWidth( int ) const**

        Returns the preferred height for this layout item, given the width,
        which is not used in this default implementation.

        The default implementation returns -1, indicating that the preferred
        height is independent of the width of the item. Using the function
        **hasHeightForWidth** () will typically be much faster than calling this
        function and testing for -1.

        Reimplement this function in layout managers that support height for
        width. A typical implementation will look like this:

        int MyLayout::heightForWidth(int w) const
            {
                if (cache_dirty
        || cached_width != w) {
                    MyLayout *that = const_cast<MyLayout
        \\*>(this);
                    int h = calculateHeightForWidth(w);
        that->cached_hfw = h;
                    return h;
                }
                return
        cached_hfw;
            }

        Caching is strongly recommended; without it layout will take exponential
        time.

        **See also** **hasHeightForWidth** ().
        """
        ...

    def hasHeightForWidth(self) -> bool:
        """
        https://doc.qt.io/qt-5/qlayoutitem.html#hasHeightForWidth

        **[virtual] bool QLayoutItem::hasHeightForWidth() const**

        Returns `true` if this layout's preferred height depends on its width;
        otherwise returns `false`. The default implementation returns false.

        Reimplement this function in layout managers that support height for
        width.

        **See also** **heightForWidth** () and **QWidget::heightForWidth** ().
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-5/qlayoutitem.html#isEmpty

        **[pure virtual] bool QLayoutItem::isEmpty() const**

        Implemented in subclasses to return whether this item is empty, i.e.
        whether it contains any widgets.
        """
        ...

    def geometry(self) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qlayoutitem.html#geometry

        **[pure virtual] QRect QLayoutItem::geometry() const**

        Returns the rectangle covered by this layout item.

        **See also** **setGeometry** ().
        """
        ...

    def setGeometry(self, a0: QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-5/qlayoutitem.html#setGeometry

        **[pure virtual] void QLayoutItem::setGeometry(const QRect & r )**

        Implemented in subclasses to set this item's geometry to **r**.

        **See also** **geometry** ().
        """
        ...

    def expandingDirections(self) -> QtCore.Qt.Orientations:
        """
        https://doc.qt.io/qt-5/qlayoutitem.html#expandingDirections

        **[pure virtual] Qt::Orientations QLayoutItem::expandingDirections()
        const**

        Returns whether this layout item can make use of more space than
        **sizeHint** (). A value of **Qt::Vertical**  or **Qt::Horizontal**
        means that it wants to grow in only one dimension, whereas
        **Qt::Vertical**  | **Qt::Horizontal**  means that it wants to grow in
        both dimensions.
        """
        ...

    def maximumSize(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qlayoutitem.html#maximumSize

        **[pure virtual] QSize QLayoutItem::maximumSize() const**

        Implemented in subclasses to return the maximum size of this item.
        """
        ...

    def minimumSize(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qlayoutitem.html#minimumSize

        **[pure virtual] QSize QLayoutItem::minimumSize() const**

        Implemented in subclasses to return the minimum size of this item.
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qlayoutitem.html#sizeHint

        **[pure virtual] QSize QLayoutItem::sizeHint() const**

        Implemented in subclasses to return the preferred size of this item.
        """
        ...
