"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QLayout(QtCore.QObject, QLayoutItem):
    """
    https://doc.qt.io/qt-5/qlayout.html

    **Detailed Description**

    This is an abstract base class inherited by the concrete classes
    **QBoxLayout** , **QGridLayout** , **QFormLayout** , and **QStackedLayout**
    .

    For users of QLayout subclasses or of **QMainWindow**  there is seldom any
    need to use the basic functions provided by QLayout, such as
    **setSizeConstraint** () or **setMenuBar** (). See **Layout Management**
    for more information.

    To make your own layout manager, implement the functions **addItem** (),
    **sizeHint** (), **setGeometry** (), **itemAt** () and **takeAt** (). You
    should also implement **minimumSize** () to ensure your layout isn't resized
    to zero size if there is too little space. To support children whose heights
    depend on their widths, implement **hasHeightForWidth** () and
    **heightForWidth** (). See the **Border Layout**  and **Flow Layout**
    examples for more information about implementing custom layout managers.

    Geometry management stops when the layout manager is deleted.

    **See also** **QLayoutItem** , **Layout Management** , **Basic Layouts
    Example** , **Border Layout Example** , and **Flow Layout Example** .
    """

    class SizeConstraint(int):
        SetDefaultConstraint: QLayout = ...
        SetNoConstraint: QLayout = ...
        SetMinimumSize: QLayout = ...
        SetFixedSize: QLayout = ...
        SetMaximumSize: QLayout = ...
        SetMinAndMaxSize: QLayout = ...

    @typing.overload
    def __init__(self, parent: QWidget) -> None:
        """
        https://doc.qt.io/qt-5/qlayout.html#QLayout

        **QLayout::QLayout(QWidget * parent )**

        Constructs a new top-level QLayout, with parent **parent**. **parent**
        may not be `nullptr`.

        The layout is set directly as the top-level layout for **parent**. There
        can be only one top-level layout for a widget. It is returned by
        **QWidget::layout** ().
        """
        ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qlayout.html#QLayout-1

        **QLayout::QLayout()**

        Constructs a new child QLayout.

        This layout has to be inserted into another layout before geometry
        management will work.
        """
        ...

    def replaceWidget(
        self,
        from_: QWidget,
        to: QWidget,
        options: typing.Union[
            QtCore.Qt.FindChildOptions, QtCore.Qt.FindChildOption
        ] = ...,
    ) -> QLayoutItem:
        """
        https://doc.qt.io/qt-5/qlayout.html#replaceWidget

        **QLayoutItem *QLayout::replaceWidget(QWidget * from , QWidget * to ,
        Qt::FindChildOptions options = Qt::FindChildrenRecursively)**

        Searches for widget **from** and replaces it with widget **to** if
        found. Returns the layout item that contains the widget **from** on
        success. Otherwise `nullptr` is returned. If **options** contains
        `Qt::FindChildrenRecursively` (the default), sub-layouts are searched
        for doing the replacement. Any other flag in **options** is ignored.

        Notice that the returned item therefore might not belong to this layout,
        but to a sub-layout.

        The returned layout item is no longer owned by the layout and should be
        either deleted or inserted to another layout. The widget **from** is no
        longer managed by the layout and may need to be deleted or hidden. The
        parent of widget **from** is left unchanged.

        This function works for the built-in Qt layouts, but might not work for
        custom layouts.

        This function was introduced in Qt 5.2.

        **See also** **indexOf** ().
        """
        ...

    def controlTypes(self) -> "QSizePolicy.ControlTypes":
        """
        https://doc.qt.io/qt-5/qlayout.html#controlTypes

        **[override virtual] QSizePolicy::ControlTypes QLayout::controlTypes()
        const**

        Reimplements: **QLayoutItem::controlTypes** () const.
        """
        ...

    def contentsMargins(self) -> QtCore.QMargins:
        """
        https://doc.qt.io/qt-5/qlayout.html#contentsMargins

        **QMargins QLayout::contentsMargins() const**

        Returns the margins used around the layout.

        By default, **QLayout**  uses the values provided by the style. On most
        platforms, the margin is 11 pixels in all directions.

        This function was introduced in Qt 4.6.

        **See also** **setContentsMargins** ().
        """
        ...

    def contentsRect(self) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qlayout.html#contentsRect

        **QRect QLayout::contentsRect() const**

        Returns the layout's **geometry** () rectangle, but taking into account
        the contents margins.

        This function was introduced in Qt 4.3.

        **See also** **setContentsMargins** () and **getContentsMargins** ().
        """
        ...

    def getContentsMargins(self) -> typing.Tuple[int, int, int, int]:
        """
        https://doc.qt.io/qt-5/qlayout.html#getContentsMargins

        **void QLayout::getContentsMargins(int * left , int * top , int * right
        , int * bottom ) const**

        For each of **left** , **top** , **right** and **bottom** that is not
        `nullptr`, stores the size of the margin named in the location the
        pointer refers to.

        By default, **QLayout**  uses the values provided by the style. On most
        platforms, the margin is 11 pixels in all directions.

        This function was introduced in Qt 4.3.

        **See also** **setContentsMargins** (), **QStyle::pixelMetric** (),
        **PM_LayoutLeftMargin** , **PM_LayoutTopMargin** ,
        **PM_LayoutRightMargin** , and **PM_LayoutBottomMargin** .
        """
        ...

    @typing.overload
    def setContentsMargins(self, left: int, top: int, right: int, bottom: int) -> None:
        """
        https://doc.qt.io/qt-5/qlayout.html#setContentsMargins

        **void QLayout::setContentsMargins(int left , int top , int right , int
        bottom )**

        Sets the **left** , **top** , **right** , and **bottom** margins to use
        around the layout.

        By default, **QLayout**  uses the values provided by the style. On most
        platforms, the margin is 11 pixels in all directions.

        This function was introduced in Qt 4.3.

        **See also** **contentsMargins** (), **getContentsMargins** (),
        **QStyle::pixelMetric** (), **PM_LayoutLeftMargin** ,
        **PM_LayoutTopMargin** , **PM_LayoutRightMargin** , and
        **PM_LayoutBottomMargin** .
        """
        ...

    @typing.overload
    def setContentsMargins(self, margins: QtCore.QMargins) -> None:
        """
        https://doc.qt.io/qt-5/qlayout.html#setContentsMargins-1

        **void QLayout::setContentsMargins(const QMargins & margins )**

        Sets the **margins** to use around the layout.

        By default, **QLayout**  uses the values provided by the style. On most
        platforms, the margin is 11 pixels in all directions.

        This function was introduced in Qt 4.6.

        **See also** **contentsMargins** ().
        """
        ...

    def alignmentRect(self, a0: QtCore.QRect) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qlayout.html#alignmentRect

        **[protected] QRect QLayout::alignmentRect(const QRect & r ) const**

        Returns the rectangle that should be covered when the geometry of this
        layout is set to **r** , provided that this layout supports
        **setAlignment** ().

        The result is derived from **sizeHint** () and expanding(). It is never
        larger than **r**.
        """
        ...

    def addChildWidget(self, w: QWidget) -> None:
        """
        https://doc.qt.io/qt-5/qlayout.html#addChildWidget

        **[protected] void QLayout::addChildWidget(QWidget * w )**

        This function is called from `addWidget()` functions in subclasses to
        add **w** as a managed widget of a layout.

        If **w** is already managed by a layout, this function will give a
        warning and remove **w** from that layout. This function must therefore
        be called before adding **w** to the layout's data structure.
        """
        ...

    def addChildLayout(self, l: "QLayout") -> None:
        """
        https://doc.qt.io/qt-5/qlayout.html#addChildLayout

        **[protected] void QLayout::addChildLayout(QLayout * l )**

        This function is called from `addLayout()` or `insertLayout()` functions
        in subclasses to add layout **l** as a sub-layout.

        The only scenario in which you need to call it directly is if you
        implement a custom layout that supports nested layouts.

        **See also** **QBoxLayout::addLayout** (), **QBoxLayout::insertLayout**
        (), and **QGridLayout::addLayout** ().
        """
        ...

    def childEvent(self, e: QtCore.QChildEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlayout.html#childEvent

        **[override virtual protected] void QLayout::childEvent(QChildEvent * e
        )**

        Reimplements: **QObject::childEvent** (QChildEvent *event).
        """
        ...

    def widgetEvent(self, a0: QtCore.QEvent) -> None:
        ...

    @staticmethod
    def closestAcceptableSize(w: QWidget, s: QtCore.QSize) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qlayout.html#closestAcceptableSize

        **[static] QSize QLayout::closestAcceptableSize(const QWidget * widget ,
        const QSize & size )**

        Returns a size that satisfies all size constraints on **widget** ,
        including **heightForWidth** () and that is as close as possible to
        **size**.
        """
        ...

    def isEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-5/qlayout.html#isEnabled

        **bool QLayout::isEnabled() const**

        Returns `true` if the layout is enabled; otherwise returns `false`.

        **See also** **setEnabled** ().
        """
        ...

    def setEnabled(self, a0: bool) -> None:
        """
        https://doc.qt.io/qt-5/qlayout.html#setEnabled

        **void QLayout::setEnabled(bool enable )**

        Enables this layout if **enable** is true, otherwise disables it.

        An enabled layout adjusts dynamically to changes; a disabled layout acts
        as if it did not exist.

        By default all layouts are enabled.

        **See also** **isEnabled** ().
        """
        ...

    def layout(self) -> "QLayout":
        """
        https://doc.qt.io/qt-5/qlayout.html#layout

        **[override virtual] QLayout *QLayout::layout()**

        Reimplements: **QLayoutItem::layout** ().
        """
        ...

    def totalSizeHint(self) -> QtCore.QSize:
        ...

    def totalMaximumSize(self) -> QtCore.QSize:
        ...

    def totalMinimumSize(self) -> QtCore.QSize:
        ...

    def totalHeightForWidth(self, w: int) -> int:
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-5/qlayout.html#isEmpty

        **[override virtual] bool QLayout::isEmpty() const**

        Reimplements: **QLayoutItem::isEmpty** () const.
        """
        ...

    def __len__(self) -> int:
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-5/qlayout.html#count

        **[pure virtual] int QLayout::count() const**

        Must be implemented in subclasses to return the number of items in the
        layout.

        **See also** **itemAt** ().
        """
        ...

    @typing.overload
    def indexOf(self, a0: QWidget) -> int:
        """
        https://doc.qt.io/qt-5/qlayout.html#indexOf

        **[virtual] int QLayout::indexOf(QWidget * widget ) const**

        Searches for widget **widget** in this layout (not including child
        layouts).

        Returns the index of **widget** , or -1 if **widget** is not found.

        The default implementation iterates over all items using **itemAt** ()
        """
        ...

    @typing.overload
    def indexOf(self, a0: QLayoutItem) -> int:
        """
        https://doc.qt.io/qt-5/qlayout.html#indexOf-1

        **int QLayout::indexOf(QLayoutItem * layoutItem ) const**

        Searches for layout item **layoutItem** in this layout (not including
        child layouts).

        Returns the index of **layoutItem** , or -1 if **layoutItem** is not
        found.

        This function was introduced in Qt 5.12.
        """
        ...

    def takeAt(self, index: int) -> QLayoutItem:
        """
        https://doc.qt.io/qt-5/qlayout.html#takeAt

        **[pure virtual] QLayoutItem *QLayout::takeAt(int index )**

        Must be implemented in subclasses to remove the layout item at **index**
        from the layout, and return the item. If there is no such item, the
        function must do nothing and return 0. Items are numbered consecutively
        from 0. If an item is removed, other items will be renumbered.

        The following code fragment shows a safe way to remove all items from a
        layout:

        **QLayoutItem**  *child;
            while ((child = layout->takeAt(0)) !=
        nullptr) {
                ...
                delete child->widget(); // delete the
        widget
                delete child;   // delete the layout item
            }

        **See also** **itemAt** () and **count** ().
        """
        ...

    def itemAt(self, index: int) -> QLayoutItem:
        """
        https://doc.qt.io/qt-5/qlayout.html#itemAt

        **[pure virtual] QLayoutItem *QLayout::itemAt(int index ) const**

        Must be implemented in subclasses to return the layout item at
        **index**. If there is no such item, the function must return 0. Items
        are numbered consecutively from 0. If an item is deleted, other items
        will be renumbered.

        This function can be used to iterate over a layout. The following code
        will draw a rectangle for each layout item in the layout structure of
        the widget.

        static void paintLayout(**QPainter**  *painter, **QLayoutItem**  *item)
        {
                **QLayout**  *layout = item->layout();
                if (layout) {
        for (int i = 0; i < layout->count(); ++i)
        paintLayout(painter, layout->itemAt(i));
                }
        painter->drawRect(item->geometry());
            }

            void
        MyWidget::paintEvent(**QPaintEvent**  *)
            {
                **QPainter**
        painter(this);
                if (layout())
                    paintLayout(&painter,
        layout());
            }

        **See also** **count** () and **takeAt** ().
        """
        ...

    def setGeometry(self, a0: QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-5/qlayout.html#setGeometry

        **[override virtual] void QLayout::setGeometry(const QRect & r )**

        Reimplements: **QLayoutItem::setGeometry** (const QRect &r).

        **See also** **geometry** ().
        """
        ...

    def maximumSize(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qlayout.html#maximumSize

        **[override virtual] QSize QLayout::maximumSize() const**

        Reimplements: **QLayoutItem::maximumSize** () const.

        Returns the maximum size of this layout. This is the largest size that
        the layout can have while still respecting the specifications.

        The returned value doesn't include the space required by
        **QWidget::setContentsMargins** () or **menuBar** ().

        The default implementation allows unlimited resizing.
        """
        ...

    def minimumSize(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qlayout.html#minimumSize

        **[override virtual] QSize QLayout::minimumSize() const**

        Reimplements: **QLayoutItem::minimumSize** () const.

        Returns the minimum size of this layout. This is the smallest size that
        the layout can have while still respecting the specifications.

        The returned value doesn't include the space required by
        **QWidget::setContentsMargins** () or **menuBar** ().

        The default implementation allows unlimited resizing.
        """
        ...

    def expandingDirections(self) -> QtCore.Qt.Orientations:
        """
        https://doc.qt.io/qt-5/qlayout.html#expandingDirections

        **[override virtual] Qt::Orientations QLayout::expandingDirections()
        const**

        Reimplements: **QLayoutItem::expandingDirections** () const.

        Returns whether this layout can make use of more space than **sizeHint**
        (). A value of **Qt::Vertical**  or **Qt::Horizontal**  means that it
        wants to grow in only one dimension, whereas **Qt::Vertical**  |
        **Qt::Horizontal**  means that it wants to grow in both dimensions.

        The default implementation returns **Qt::Horizontal**  |
        **Qt::Vertical** . Subclasses reimplement it to return a meaningful
        value based on their child widgets's **size policies** .

        **See also** **sizeHint** ().
        """
        ...

    def removeItem(self, a0: QLayoutItem) -> None:
        """
        https://doc.qt.io/qt-5/qlayout.html#removeItem

        **void QLayout::removeItem(QLayoutItem * item )**

        Removes the layout item **item** from the layout. It is the caller's
        responsibility to delete the item.

        Notice that **item** can be a layout (since **QLayout**  inherits
        **QLayoutItem** ).

        **See also** **removeWidget** () and **addItem** ().
        """
        ...

    def removeWidget(self, w: QWidget) -> None:
        """
        https://doc.qt.io/qt-5/qlayout.html#removeWidget

        **void QLayout::removeWidget(QWidget * widget )**

        Removes the widget **widget** from the layout. After this call, it is
        the caller's responsibility to give the widget a reasonable geometry or
        to put the widget back into a layout or to explicitly hide it if
        necessary.

        **Note:** The ownership of **widget** remains the same as when it was
        added.

        **See also** **removeItem** (), **QWidget::setGeometry** (), and
        **addWidget** ().
        """
        ...

    def addItem(self, a0: QLayoutItem) -> None:
        """
        https://doc.qt.io/qt-5/qlayout.html#addItem

        **[pure virtual] void QLayout::addItem(QLayoutItem * item )**

        Implemented in subclasses to add an **item**. How it is added is
        specific to each subclass.

        This function is not usually called in application code. To add a widget
        to a layout, use the **addWidget** () function; to add a child layout,
        use the addLayout() function provided by the relevant **QLayout**
        subclass.

        **Note:** The ownership of **item** is transferred to the layout, and
        it's the layout's responsibility to delete it.

        **See also** **addWidget** (), **QBoxLayout::addLayout** (), and
        **QGridLayout::addLayout** ().
        """
        ...

    def addWidget(self, w: QWidget) -> None:
        """
        https://doc.qt.io/qt-5/qlayout.html#addWidget

        **void QLayout::addWidget(QWidget * w )**

        Adds widget **w** to this layout in a manner specific to the layout.
        This function uses **addItem** ().
        """
        ...

    def update(self) -> None:
        """
        https://doc.qt.io/qt-5/qlayout.html#update

        **void QLayout::update()**

        Updates the layout for **parentWidget** ().

        You should generally not need to call this because it is automatically
        called at the most appropriate times.

        **See also** **activate** () and **invalidate** ().
        """
        ...

    def activate(self) -> bool:
        """
        https://doc.qt.io/qt-5/qlayout.html#activate

        **bool QLayout::activate()**

        Redoes the layout for **parentWidget** () if necessary.

        You should generally not need to call this because it is automatically
        called at the most appropriate times. It returns true if the layout was
        redone.

        **See also** **update** () and **QWidget::updateGeometry** ().
        """
        ...

    def geometry(self) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qlayout.html#geometry

        **[override virtual] QRect QLayout::geometry() const**

        Reimplements: **QLayoutItem::geometry** () const.

        **See also** **setGeometry** ().
        """
        ...

    def invalidate(self) -> None:
        """
        https://doc.qt.io/qt-5/qlayout.html#invalidate

        **[override virtual] void QLayout::invalidate()**

        Reimplements: **QLayoutItem::invalidate** ().
        """
        ...

    def parentWidget(self) -> QWidget:
        """
        https://doc.qt.io/qt-5/qlayout.html#parentWidget

        **QWidget *QLayout::parentWidget() const**

        Returns the parent widget of this layout, or `nullptr` if this layout is
        not installed on any widget.

        If the layout is a sub-layout, this function returns the parent widget
        of the parent layout.

        **See also** **parent** ().
        """
        ...

    def menuBar(self) -> QWidget:
        """
        https://doc.qt.io/qt-5/qlayout.html#menuBar

        **QWidget *QLayout::menuBar() const**

        Returns the menu bar set for this layout, or `nullptr` if no menu bar is
        set.

        **See also** **setMenuBar** ().
        """
        ...

    def setMenuBar(self, w: QWidget) -> None:
        """
        https://doc.qt.io/qt-5/qlayout.html#setMenuBar

        **void QLayout::setMenuBar(QWidget * widget )**

        Tells the geometry manager to place the menu bar **widget** at the top
        of **parentWidget** (), outside **QWidget::contentsMargins** (). All
        child widgets are placed below the bottom edge of the menu bar.

        **See also** **menuBar** ().
        """
        ...

    def sizeConstraint(self) -> "QLayout.SizeConstraint":
        """
        https://doc.qt.io/qt-5/qlayout.html#sizeConstraint-prop

        **sizeConstraint : SizeConstraint**

        This property holds the resize mode of the layout

        The default mode is **SetDefaultConstraint** .

        **Access functions:**

        QLayout::SizeConstraint **sizeConstraint** () const
        void
        **setSizeConstraint** ( **QLayout::SizeConstraint** )
        """
        ...

    def setSizeConstraint(self, a0: "QLayout.SizeConstraint") -> None:
        """
        https://doc.qt.io/qt-5/qlayout.html#sizeConstraint-prop

        **sizeConstraint : SizeConstraint**

        This property holds the resize mode of the layout

        The default mode is **SetDefaultConstraint** .

        **Access functions:**

        QLayout::SizeConstraint **sizeConstraint** () const
        void
        **setSizeConstraint** ( **QLayout::SizeConstraint** )
        """
        ...

    @typing.overload
    def setAlignment(
        self,
        w: QWidget,
        alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag],
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qlayout.html#setAlignment

        **bool QLayout::setAlignment(QWidget * w , Qt::Alignment alignment )**

        Sets the alignment for widget **w** to **alignment** and returns true if
        **w** is found in this layout (not including child layouts); otherwise
        returns `false`.
        """
        ...

    @typing.overload
    def setAlignment(
        self,
        l: "QLayout",
        alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag],
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qlayout.html#setAlignment-1

        **bool QLayout::setAlignment(QLayout * l , Qt::Alignment alignment )**

        This is an overloaded function.

        Sets the alignment for the layout **l** to **alignment** and returns
        `true` if **l** is found in this layout (not including child layouts);
        otherwise returns `false`.
        """
        ...

    @typing.overload
    def setAlignment(
        self, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qlayout.html#setAlignment

        **bool QLayout::setAlignment(QWidget * w , Qt::Alignment alignment )**

        Sets the alignment for widget **w** to **alignment** and returns true if
        **w** is found in this layout (not including child layouts); otherwise
        returns `false`.
        """
        ...

    def setSpacing(self, a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qlayout.html#spacing-prop

        **spacing : int**

        This property holds the spacing between widgets inside the layout

        If no value is explicitly set, the layout's spacing is inherited from
        the parent layout, or from the style settings for the parent widget.

        For **QGridLayout**  and **QFormLayout** , it is possible to set
        different horizontal and vertical spacings using
        **setHorizontalSpacing()**  and **setVerticalSpacing()** . In that case,
        spacing() returns -1.

        **Access functions:**

        int **spacing** () const
        void **setSpacing** ( **int** )

        **See also** **contentsRect** (), **getContentsMargins** (),
        **QStyle::layoutSpacing** (), and **QStyle::pixelMetric** ().

        **Member Function Documentation**
        """
        ...

    def spacing(self) -> int:
        """
        https://doc.qt.io/qt-5/qlayout.html#spacing-prop

        **spacing : int**

        This property holds the spacing between widgets inside the layout

        If no value is explicitly set, the layout's spacing is inherited from
        the parent layout, or from the style settings for the parent widget.

        For **QGridLayout**  and **QFormLayout** , it is possible to set
        different horizontal and vertical spacings using
        **setHorizontalSpacing()**  and **setVerticalSpacing()** . In that case,
        spacing() returns -1.

        **Access functions:**

        int **spacing** () const
        void **setSpacing** ( **int** )

        **See also** **contentsRect** (), **getContentsMargins** (),
        **QStyle::layoutSpacing** (), and **QStyle::pixelMetric** ().

        **Member Function Documentation**
        """
        ...
