"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QLabel(QFrame):
    """
    https://doc.qt.io/qt-5/qlabel.html

    **Detailed Description**

    ![](images/windows-label.png)

    QLabel is used for displaying text or an image. No user interaction
    functionality is provided. The visual appearance of the label can be
    configured in various ways, and it can be used for specifying a focus
    mnemonic key for another widget.

    A QLabel can contain any of the following content types:

    ContentSetting
    Plain textPass a **QString**  to **setText** ().
    Rich
    textPass a **QString**  that contains rich text to **setText** ().
    A
    pixmapPass a **QPixmap**  to **setPixmap** ().
    A moviePass a **QMovie**
    to **setMovie** ().
    A numberPass an **int** or a **double** to **setNum**
    (), which converts the number to plain text.
    NothingThe same as an empty
    plain text. This is the default. Set by **clear** ().

    **Warning:** When passing a **QString**  to the constructor or calling
    **setText** (), make sure to sanitize your input, as QLabel tries to guess
    whether it displays the text as plain text or as rich text, a subset of HTML
    4 markup. You may want to call **setTextFormat** () explicitly, e.g. in case
    you expect the text to be in plain format but cannot control the text source
    (for instance when displaying data loaded from the Web).

    When the content is changed using any of these functions, any previous
    content is cleared.

    By default, labels display **left-aligned, vertically-centered**  text and
    images, where any tabs in the text to be displayed are **automatically
    expanded** . However, the look of a QLabel can be adjusted and fine-tuned in
    several ways.

    The positioning of the content within the QLabel widget area can be tuned
    with **setAlignment** () and **setIndent** (). Text content can also wrap
    lines along word boundaries with **setWordWrap** (). For example, this code
    sets up a sunken panel with a two-line text in the bottom right corner (both
    lines being flush with the right side of the label):

    **QLabel**  *label = new **QLabel** (this);
    label->setFrameStyle(**QFrame** ::Panel | **QFrame** ::Sunken);
    label->setText("first line\\nsecond line");
    label->setAlignment(Qt::AlignBottom | Qt::AlignRight);

    The properties and functions QLabel inherits from **QFrame**  can also be
    used to specify the widget frame to be used for any given label.

    A QLabel is often used as a label for an interactive widget. For this use
    QLabel provides a useful mechanism for adding an mnemonic (see
    **QKeySequence** ) that will set the keyboard focus to the other widget
    (called the QLabel's "buddy"). For example:

    **QLineEdit**  *phoneEdit = new **QLineEdit** (this);
        **QLabel**
    *phoneLabel = new **QLabel** ("&Phone:", this);
    phoneLabel->setBuddy(phoneEdit);

    In this example, keyboard focus is transferred to the label's buddy (the
    **QLineEdit** ) when the user presses Alt+P. If the buddy was a button
    (inheriting from **QAbstractButton** ), triggering the mnemonic would
    emulate a button click.

    **See also** **QLineEdit** , **QTextEdit** , **QPixmap** , **QMovie** , and
    **GUI Design Handbook: Label** .
    """

    @typing.overload
    def __init__(
        self,
        parent: typing.Optional[QWidget] = ...,
        flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qlabel.html#QLabel

        **QLabel::QLabel(QWidget * parent = nullptr, Qt::WindowFlags f =
        Qt::WindowFlags())**

        Constructs an empty label.

        The **parent** and widget flag **f** , arguments are passed to the
        **QFrame**  constructor.

        **See also** **setAlignment** (), **setFrameStyle** (), and
        **setIndent** ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        text: str,
        parent: typing.Optional[QWidget] = ...,
        flags: typing.Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qlabel.html#QLabel-1

        **QLabel::QLabel(const QString & text , QWidget * parent = nullptr,
        Qt::WindowFlags f = Qt::WindowFlags())**

        Constructs a label that displays the text, **text**.

        The **parent** and widget flag **f** , arguments are passed to the
        **QFrame**  constructor.

        **See also** **setText** (), **setAlignment** (), **setFrameStyle** (),
        and **setIndent** ().
        """
        ...

    def selectionStart(self) -> int:
        """
        https://doc.qt.io/qt-5/qlabel.html#selectionStart

        **int QLabel::selectionStart() const**

        selectionStart() returns the index of the first selected character in
        the label or -1 if no text is selected.

        **Note:** The **textInteractionFlags**  set on the label need to include
        either TextSelectableByMouse or TextSelectableByKeyboard.

        This function was introduced in Qt 4.7.

        **See also** **selectedText** ().
        """
        ...

    def selectedText(self) -> str:
        """
        https://doc.qt.io/qt-5/qlabel.html#selectedText-prop

        **selectedText : const QString**

        This property holds the selected text

        If there is no selected text this property's value is an empty string.

        By default, this property contains an empty string.

        **Note:** The **textInteractionFlags**  set on the label need to include
        either TextSelectableByMouse or TextSelectableByKeyboard.

        This property was introduced in Qt 4.7.

        **Access functions:**

        QString **selectedText** () const

        **See also** **hasSelectedText** ().
        """
        ...

    def hasSelectedText(self) -> bool:
        """
        https://doc.qt.io/qt-5/qlabel.html#hasSelectedText-prop

        **hasSelectedText : const bool**

        This property holds whether there is any text selected

        hasSelectedText() returns `true` if some or all of the text has been
        selected by the user; otherwise returns `false`.

        By default, this property is `false`.

        **Note:** The **textInteractionFlags**  set on the label need to include
        either TextSelectableByMouse or TextSelectableByKeyboard.

        This property was introduced in Qt 4.7.

        **Access functions:**

        bool **hasSelectedText** () const

        **See also** **selectedText** ().
        """
        ...

    def setSelection(self, a0: int, a1: int) -> None:
        """
        https://doc.qt.io/qt-5/qlabel.html#setSelection

        **void QLabel::setSelection(int start , int length )**

        Selects text from position **start** and for **length** characters.

        **Note:** The **textInteractionFlags**  set on the label need to include
        either TextSelectableByMouse or TextSelectableByKeyboard.

        This function was introduced in Qt 4.7.

        **See also** **selectedText** ().
        """
        ...

    def focusNextPrevChild(self, next: bool) -> bool:
        """
        https://doc.qt.io/qt-5/qlabel.html#focusNextPrevChild

        **[override virtual protected] bool QLabel::focusNextPrevChild(bool next
        )**

        Reimplements: **QWidget::focusNextPrevChild** (bool next).
        """
        ...

    def focusOutEvent(self, ev: QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlabel.html#focusOutEvent

        **[override virtual protected] void QLabel::focusOutEvent(QFocusEvent *
        ev )**

        Reimplements: **QWidget::focusOutEvent** (QFocusEvent *event).
        """
        ...

    def focusInEvent(self, ev: QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlabel.html#focusInEvent

        **[override virtual protected] void QLabel::focusInEvent(QFocusEvent *
        ev )**

        Reimplements: **QWidget::focusInEvent** (QFocusEvent *event).
        """
        ...

    def contextMenuEvent(self, ev: QtGui.QContextMenuEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlabel.html#contextMenuEvent

        **[override virtual protected] void
        QLabel::contextMenuEvent(QContextMenuEvent * ev )**

        Reimplements: **QWidget::contextMenuEvent** (QContextMenuEvent *event).
        """
        ...

    def mouseReleaseEvent(self, ev: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlabel.html#mouseReleaseEvent

        **[override virtual protected] void
        QLabel::mouseReleaseEvent(QMouseEvent * ev )**

        Reimplements: **QWidget::mouseReleaseEvent** (QMouseEvent *event).
        """
        ...

    def mouseMoveEvent(self, ev: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlabel.html#mouseMoveEvent

        **[override virtual protected] void QLabel::mouseMoveEvent(QMouseEvent *
        ev )**

        Reimplements: **QWidget::mouseMoveEvent** (QMouseEvent *event).
        """
        ...

    def mousePressEvent(self, ev: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlabel.html#mousePressEvent

        **[override virtual protected] void QLabel::mousePressEvent(QMouseEvent
        * ev )**

        Reimplements: **QWidget::mousePressEvent** (QMouseEvent *event).
        """
        ...

    def keyPressEvent(self, ev: QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlabel.html#keyPressEvent

        **[override virtual protected] void QLabel::keyPressEvent(QKeyEvent * ev
        )**

        Reimplements: **QWidget::keyPressEvent** (QKeyEvent *event).
        """
        ...

    def changeEvent(self, a0: QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlabel.html#changeEvent

        **[override virtual protected] void QLabel::changeEvent(QEvent * ev )**

        Reimplements: **QFrame::changeEvent** (QEvent *ev).
        """
        ...

    def paintEvent(self, a0: QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-5/qlabel.html#paintEvent

        **[override virtual protected] void QLabel::paintEvent( QPaintEvent *
        )**

        Reimplements: **QFrame::paintEvent** (QPaintEvent *).
        """
        ...

    def event(self, e: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qlabel.html#event

        **[override virtual protected] bool QLabel::event(QEvent * e )**

        Reimplements: **QFrame::event** (QEvent *e).
        """
        ...

    def setText(self, a0: str) -> None:
        """
        https://doc.qt.io/qt-5/qlabel.html#text-prop

        **text : QString**

        This property holds the label's text

        If no text has been set this will return an empty string. Setting the
        text clears any previous content.

        The text will be interpreted either as plain text or as rich text,
        depending on the text format setting; see **setTextFormat** (). The
        default setting is **Qt::AutoText** ; i.e. **QLabel**  will try to auto-
        detect the format of the text set. See **Supported HTML Subset**  for
        the definition of rich text.

        If a buddy has been set, the buddy mnemonic key is updated from the new
        text.

        Note that **QLabel**  is well-suited to display small rich text
        documents, such as small documents that get their document specific
        settings (font, text color, link color) from the label's palette and
        font properties. For large documents, use **QTextEdit**  in read-only
        mode instead. **QTextEdit**  can also provide a scroll bar when
        necessary.

        **Note:** This function enables mouse tracking if **text** contains rich
        text.

        **Access functions:**

        QString **text** () const
        void **setText** ( **const QString &**)

        **See also** **setTextFormat** (), **setBuddy** (), and **alignment** .
        """
        ...

    def setPixmap(self, a0: QtGui.QPixmap) -> None:
        """
        https://doc.qt.io/qt-5/qlabel.html#pixmap-prop

        **pixmap : QPixmap**

        This property holds the label's pixmap.

        Previously, Qt provided a version of `pixmap()` which returned the
        pixmap by-pointer. That version is now deprecated. To maintain
        compatibility with old code, you can explicitly differentiate between
        the by-pointer function and the by-value function:

        const **QPixmap**  *pixmapPtr = label->pixmap();
            **QPixmap**
        pixmapVal = label->pixmap(Qt::ReturnByValue);

        If you disable the deprecated version using the
        **QT_DISABLE_DEPRECATED_BEFORE**  macro, then you can omit
        `Qt::ReturnByValue` as shown below:

        **QPixmap**  pixmapVal = label->pixmap();

        If no pixmap has been set, the deprecated getter function will return
        `nullptr`.

        Setting the pixmap clears any previous content. The buddy shortcut, if
        any, is disabled.

        **Access functions:**

        QPixmap ****pixmap** ** ( **Qt::ReturnByValueConstant** ) const
        void
        **setPixmap** ( **const QPixmap &**)
        """
        ...

    def setPicture(self, a0: QtGui.QPicture) -> None:
        """
        https://doc.qt.io/qt-5/qlabel.html#setPicture

        **[slot] void QLabel::setPicture(const QPicture & picture )**

        Sets the label contents to **picture**. Any previous content is cleared.

        The buddy shortcut, if any, is disabled.

        **See also** **picture** () and **setBuddy** ().
        """
        ...

    @typing.overload
    def setNum(self, a0: float) -> None:
        """
        https://doc.qt.io/qt-5/qlabel.html#setNum

        **[slot] void QLabel::setNum(int num )**

        Sets the label contents to plain text containing the textual
        representation of integer **num**. Any previous content is cleared. Does
        nothing if the integer's string representation is the same as the
        current contents of the label.

        The buddy shortcut, if any, is disabled.

        **See also** **setText** (), **QString::setNum** (), and **setBuddy**
        ().
        """
        ...

    @typing.overload
    def setNum(self, a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qlabel.html#setNum-1

        **[slot] void QLabel::setNum(double num )**

        This is an overloaded function.

        Sets the label contents to plain text containing the textual
        representation of double **num**. Any previous content is cleared. Does
        nothing if the double's string representation is the same as the current
        contents of the label.

        The buddy shortcut, if any, is disabled.

        **See also** **setText** (), **QString::setNum** (), and **setBuddy**
        ().
        """
        ...

    def setMovie(self, movie: QtGui.QMovie) -> None:
        """
        https://doc.qt.io/qt-5/qlabel.html#setMovie

        **[slot] void QLabel::setMovie(QMovie * movie )**

        Sets the label contents to **movie**. Any previous content is cleared.
        The label does NOT take ownership of the movie.

        The buddy shortcut, if any, is disabled.

        **See also** **movie** () and **setBuddy** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qlabel.html#clear

        **[slot] void QLabel::clear()**

        Clears any label contents.
        """
        ...

    def setOpenExternalLinks(self, open: bool) -> None:
        """
        https://doc.qt.io/qt-5/qlabel.html#openExternalLinks-prop

        **openExternalLinks : bool**

        Specifies whether **QLabel**  should automatically open links using
        **QDesktopServices::openUrl** () instead of emitting the
        **linkActivated** () signal.

        **Note:** The **textInteractionFlags**  set on the label need to include
        either LinksAccessibleByMouse or LinksAccessibleByKeyboard.

        The default value is false.

        This property was introduced in Qt 4.2.

        **Access functions:**

        bool **openExternalLinks** () const
        void **setOpenExternalLinks**
        (bool **open** )

        **See also** **textInteractionFlags** ().
        """
        ...

    def textInteractionFlags(self) -> QtCore.Qt.TextInteractionFlags:
        """
        https://doc.qt.io/qt-5/qlabel.html#textInteractionFlags-prop

        **textInteractionFlags : Qt::TextInteractionFlags**

        Specifies how the label should interact with user input if it displays
        text.

        If the flags contain **Qt::LinksAccessibleByKeyboard**  the focus policy
        is also automatically set to **Qt::StrongFocus** . If
        **Qt::TextSelectableByKeyboard**  is set then the focus policy is set to
        **Qt::ClickFocus** .

        The default value is **Qt::LinksAccessibleByMouse** .

        This property was introduced in Qt 4.2.

        **Access functions:**

        Qt::TextInteractionFlags **textInteractionFlags** () const
        void
        **setTextInteractionFlags** (Qt::TextInteractionFlags **flags** )
        """
        ...

    def setTextInteractionFlags(
        self,
        flags: typing.Union[
            QtCore.Qt.TextInteractionFlags, QtCore.Qt.TextInteractionFlag
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qlabel.html#textInteractionFlags-prop

        **textInteractionFlags : Qt::TextInteractionFlags**

        Specifies how the label should interact with user input if it displays
        text.

        If the flags contain **Qt::LinksAccessibleByKeyboard**  the focus policy
        is also automatically set to **Qt::StrongFocus** . If
        **Qt::TextSelectableByKeyboard**  is set then the focus policy is set to
        **Qt::ClickFocus** .

        The default value is **Qt::LinksAccessibleByMouse** .

        This property was introduced in Qt 4.2.

        **Access functions:**

        Qt::TextInteractionFlags **textInteractionFlags** () const
        void
        **setTextInteractionFlags** (Qt::TextInteractionFlags **flags** )
        """
        ...

    def openExternalLinks(self) -> bool:
        """
        https://doc.qt.io/qt-5/qlabel.html#openExternalLinks-prop

        **openExternalLinks : bool**

        Specifies whether **QLabel**  should automatically open links using
        **QDesktopServices::openUrl** () instead of emitting the
        **linkActivated** () signal.

        **Note:** The **textInteractionFlags**  set on the label need to include
        either LinksAccessibleByMouse or LinksAccessibleByKeyboard.

        The default value is false.

        This property was introduced in Qt 4.2.

        **Access functions:**

        bool **openExternalLinks** () const
        void **setOpenExternalLinks**
        (bool **open** )

        **See also** **textInteractionFlags** ().
        """
        ...

    def heightForWidth(self, a0: int) -> int:
        """
        https://doc.qt.io/qt-5/qlabel.html#heightForWidth

        **[override virtual] int QLabel::heightForWidth(int w ) const**

        Reimplements: **QWidget::heightForWidth** (int w) const.
        """
        ...

    def buddy(self) -> QWidget:
        """
        https://doc.qt.io/qt-5/qlabel.html#buddy

        **QWidget *QLabel::buddy() const**

        Returns this label's buddy, or nullptr if no buddy is currently set.

        **See also** **setBuddy** ().
        """
        ...

    def setBuddy(self, a0: QWidget) -> None:
        """
        https://doc.qt.io/qt-5/qlabel.html#setBuddy

        **void QLabel::setBuddy(QWidget * buddy )**

        Sets this label's buddy to **buddy**.

        When the user presses the shortcut key indicated by this label, the
        keyboard focus is transferred to the label's buddy widget.

        The buddy mechanism is only available for QLabels that contain text in
        which one character is prefixed with an ampersand, '&'. This character
        is set as the shortcut key. See the **QKeySequence::mnemonic** ()
        documentation for details (to display an actual ampersand, use '&&').

        In a dialog, you might create two data entry widgets and a label for
        each, and set up the geometry layout so each label is just to the left
        of its data entry widget (its "buddy"), for example:

        **QLineEdit**  *nameEdit  = new **QLineEdit** (this);
            **QLabel**
        *nameLabel = new **QLabel** ("&Name:", this);
        nameLabel->setBuddy(nameEdit);
            **QLineEdit**  *phoneEdit  = new
        **QLineEdit** (this);
            **QLabel**     *phoneLabel = new **QLabel**
        ("&Phone:", this);
            phoneLabel->setBuddy(phoneEdit);
            // (layout
        setup not shown)

        With the code above, the focus jumps to the Name field when the user
        presses Alt+N, and to the Phone field when the user presses Alt+P.

        To unset a previously set buddy, call this function with **buddy** set
        to nullptr.

        **See also** **buddy** (), **setText** (), **QShortcut** , and
        **setAlignment** ().
        """
        ...

    def minimumSizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qlabel.html#minimumSizeHint

        **[override virtual] QSize QLabel::minimumSizeHint() const**

        Reimplements an access function for property:
        **QWidget::minimumSizeHint** .
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qlabel.html#sizeHint

        **[override virtual] QSize QLabel::sizeHint() const**

        Reimplements: **QFrame::sizeHint** () const.
        """
        ...

    def setScaledContents(self, a0: bool) -> None:
        """
        https://doc.qt.io/qt-5/qlabel.html#scaledContents-prop

        **scaledContents : bool**

        This property holds whether the label will scale its contents to fill
        all available space.

        When enabled and the label shows a pixmap, it will scale the pixmap to
        fill the available space.

        This property's default is false.

        **Access functions:**

        bool **hasScaledContents** () const
        void **setScaledContents** (
        **bool** )
        """
        ...

    def hasScaledContents(self) -> bool:
        ...

    def setMargin(self, a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qlabel.html#margin-prop

        **margin : int**

        This property holds the width of the margin

        The margin is the distance between the innermost pixel of the frame and
        the outermost pixel of contents.

        The default margin is 0.

        **Access functions:**

        int **margin** () const
        void **setMargin** ( **int** )

        **See also** **indent** .
        """
        ...

    def margin(self) -> int:
        """
        https://doc.qt.io/qt-5/qlabel.html#margin-prop

        **margin : int**

        This property holds the width of the margin

        The margin is the distance between the innermost pixel of the frame and
        the outermost pixel of contents.

        The default margin is 0.

        **Access functions:**

        int **margin** () const
        void **setMargin** ( **int** )

        **See also** **indent** .
        """
        ...

    def setIndent(self, a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qlabel.html#indent-prop

        **indent : int**

        This property holds the label's text indent in pixels

        If a label displays text, the indent applies to the left edge if
        **alignment** () is **Qt::AlignLeft** , to the right edge if
        **alignment** () is **Qt::AlignRight** , to the top edge if
        **alignment** () is **Qt::AlignTop** , and to the bottom edge if
        **alignment** () is **Qt::AlignBottom** .

        If indent is negative, or if no indent has been set, the label computes
        the effective indent as follows: If **frameWidth** () is 0, the
        effective indent becomes 0. If **frameWidth** () is greater than 0, the
        effective indent becomes half the width of the "x" character of the
        widget's current **font** ().

        By default, the indent is -1, meaning that an effective indent is
        calculating in the manner described above.

        **Access functions:**

        int **indent** () const
        void **setIndent** ( **int** )

        **See also** **alignment** , **margin** , **frameWidth** (), and
        **font** ().
        """
        ...

    def indent(self) -> int:
        """
        https://doc.qt.io/qt-5/qlabel.html#indent-prop

        **indent : int**

        This property holds the label's text indent in pixels

        If a label displays text, the indent applies to the left edge if
        **alignment** () is **Qt::AlignLeft** , to the right edge if
        **alignment** () is **Qt::AlignRight** , to the top edge if
        **alignment** () is **Qt::AlignTop** , and to the bottom edge if
        **alignment** () is **Qt::AlignBottom** .

        If indent is negative, or if no indent has been set, the label computes
        the effective indent as follows: If **frameWidth** () is 0, the
        effective indent becomes 0. If **frameWidth** () is greater than 0, the
        effective indent becomes half the width of the "x" character of the
        widget's current **font** ().

        By default, the indent is -1, meaning that an effective indent is
        calculating in the manner described above.

        **Access functions:**

        int **indent** () const
        void **setIndent** ( **int** )

        **See also** **alignment** , **margin** , **frameWidth** (), and
        **font** ().
        """
        ...

    def wordWrap(self) -> bool:
        """
        https://doc.qt.io/qt-5/qlabel.html#wordWrap-prop

        **wordWrap : bool**

        This property holds the label's word-wrapping policy

        If this property is `true` then label text is wrapped where necessary at
        word-breaks; otherwise it is not wrapped at all.

        By default, word wrap is disabled.

        **Access functions:**

        bool **wordWrap** () const
        void **setWordWrap** (bool **on** )

        **See also** **text** .

        **Member Function Documentation**
        """
        ...

    def setWordWrap(self, on: bool) -> None:
        """
        https://doc.qt.io/qt-5/qlabel.html#wordWrap-prop

        **wordWrap : bool**

        This property holds the label's word-wrapping policy

        If this property is `true` then label text is wrapped where necessary at
        word-breaks; otherwise it is not wrapped at all.

        By default, word wrap is disabled.

        **Access functions:**

        bool **wordWrap** () const
        void **setWordWrap** (bool **on** )

        **See also** **text** .

        **Member Function Documentation**
        """
        ...

    def setAlignment(
        self, a0: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qlabel.html#alignment-prop

        **alignment : Qt::Alignment**

        This property holds the alignment of the label's contents

        By default, the contents of the label are left-aligned and vertically-
        centered.

        **Access functions:**

        Qt::Alignment **alignment** () const
        void **setAlignment** (
        **Qt::Alignment** )

        **See also** **text** .
        """
        ...

    def alignment(self) -> QtCore.Qt.Alignment:
        """
        https://doc.qt.io/qt-5/qlabel.html#alignment-prop

        **alignment : Qt::Alignment**

        This property holds the alignment of the label's contents

        By default, the contents of the label are left-aligned and vertically-
        centered.

        **Access functions:**

        Qt::Alignment **alignment** () const
        void **setAlignment** (
        **Qt::Alignment** )

        **See also** **text** .
        """
        ...

    def setTextFormat(self, a0: QtCore.Qt.TextFormat) -> None:
        """
        https://doc.qt.io/qt-5/qlabel.html#textFormat-prop

        **textFormat : Qt::TextFormat**

        This property holds the label's text format

        See the **Qt::TextFormat**  enum for an explanation of the possible
        options.

        The default format is **Qt::AutoText** .

        **Access functions:**

        Qt::TextFormat **textFormat** () const
        void **setTextFormat** (
        **Qt::TextFormat** )

        **See also** **text** ().
        """
        ...

    def textFormat(self) -> QtCore.Qt.TextFormat:
        """
        https://doc.qt.io/qt-5/qlabel.html#textFormat-prop

        **textFormat : Qt::TextFormat**

        This property holds the label's text format

        See the **Qt::TextFormat**  enum for an explanation of the possible
        options.

        The default format is **Qt::AutoText** .

        **Access functions:**

        Qt::TextFormat **textFormat** () const
        void **setTextFormat** (
        **Qt::TextFormat** )

        **See also** **text** ().
        """
        ...

    def movie(self) -> QtGui.QMovie:
        """
        https://doc.qt.io/qt-5/qlabel.html#movie

        **QMovie *QLabel::movie() const**

        Returns a pointer to the label's movie, or nullptr if no movie has been
        set.

        **See also** **setMovie** ().
        """
        ...

    def picture(self) -> QtGui.QPicture:
        """
        https://doc.qt.io/qt-5/qlabel.html#picture-1

        **QPicture QLabel::picture( Qt::ReturnByValueConstant ) const**

        Returns the label's picture.

        Previously, Qt provided a version of `picture()` which returned the
        picture by-pointer. That version is now deprecated. To maintain
        compatibility with old code, you can explicitly differentiate between
        the by-pointer function and the by-value function:

        const **QPicture**  *picPtr = label->picture();
            **QPicture**  picVal
        = label->picture(Qt::ReturnByValue);

        If you disable the deprecated version using the
        **QT_DISABLE_DEPRECATED_BEFORE**  macro, then you can omit
        `Qt::ReturnByValue` as shown below:

        **QPicture**  picVal = label->picture();

        This function was introduced in Qt 5.15.
        """
        ...

    def pixmap(self) -> QtGui.QPixmap:
        """
        https://doc.qt.io/qt-5/qlabel.html#pixmap-1

        **QPixmap QLabel::pixmap( Qt::ReturnByValueConstant ) const**

        **Note:** Getter function for property **pixmap** .

        This function was introduced in Qt 5.15.
        """
        ...

    def text(self) -> str:
        """
        https://doc.qt.io/qt-5/qlabel.html#text-prop

        **text : QString**

        This property holds the label's text

        If no text has been set this will return an empty string. Setting the
        text clears any previous content.

        The text will be interpreted either as plain text or as rich text,
        depending on the text format setting; see **setTextFormat** (). The
        default setting is **Qt::AutoText** ; i.e. **QLabel**  will try to auto-
        detect the format of the text set. See **Supported HTML Subset**  for
        the definition of rich text.

        If a buddy has been set, the buddy mnemonic key is updated from the new
        text.

        Note that **QLabel**  is well-suited to display small rich text
        documents, such as small documents that get their document specific
        settings (font, text color, link color) from the label's palette and
        font properties. For large documents, use **QTextEdit**  in read-only
        mode instead. **QTextEdit**  can also provide a scroll bar when
        necessary.

        **Note:** This function enables mouse tracking if **text** contains rich
        text.

        **Access functions:**

        QString **text** () const
        void **setText** ( **const QString &**)

        **See also** **setTextFormat** (), **setBuddy** (), and **alignment** .
        """
        ...

    @property
    def linkActivated(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qlabel.html#linkActivated

        **[signal] void QLabel::linkActivated(const QString & link )**

        This signal is emitted when the user clicks a link. The URL referred to
        by the anchor is passed in **link**.

        This function was introduced in Qt 4.2.

        **See also** **linkHovered** ().
        """
        ...

    @property
    def linkHovered(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qlabel.html#linkHovered

        **[signal] void QLabel::linkHovered(const QString & link )**

        This signal is emitted when the user hovers over a link. The URL
        referred to by the anchor is passed in **link**.

        This function was introduced in Qt 4.2.

        **See also** **linkActivated** ().
        """
        ...
