"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QGroupBox(QWidget):
    """
    https://doc.qt.io/qt-5/qgroupbox.html

    **Detailed Description**

    ![](images/windows-groupbox.png)

    A group box provides a frame, a title on top, a keyboard shortcut, and
    displays various other widgets inside itself. The keyboard shortcut moves
    keyboard focus to one of the group box's child widgets.

    QGroupBox also lets you set the **title**  (normally set in the constructor)
    and the title's **alignment** . Group boxes can be **checkable** . Child
    widgets in checkable group boxes are enabled or disabled depending on
    whether or not the group box is **checked** .

    You can minimize the space consumption of a group box by enabling the
    **flat**  property. In most **styles** , enabling this property results in
    the removal of the left, right and bottom edges of the frame.

    QGroupBox doesn't automatically lay out the child widgets (which are often
    **QCheckBox** es or **QRadioButton** s but can be any widgets). The
    following example shows how we can set up a QGroupBox with a layout:

    **QGroupBox**  *groupBox = new **QGroupBox** (tr("Exclusive Radio
    Buttons"));

            **QRadioButton**  *radio1 = new **QRadioButton**
    (tr("&Radio button 1"));
            **QRadioButton**  *radio2 = new
    **QRadioButton** (tr("R&adio button 2"));
            **QRadioButton**  *radio3
    = new **QRadioButton** (tr("Ra&dio button 3"));
    radio1->setChecked(true);

            **QVBoxLayout**  *vbox = new
    **QVBoxLayout** ;
            vbox->addWidget(radio1);
    vbox->addWidget(radio2);
            vbox->addWidget(radio3);
    vbox->addStretch(1);
            groupBox->setLayout(vbox);

    **See also** **QButtonGroup**  and **Group Box Example** .
    """

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qgroupbox.html#QGroupBox

        **QGroupBox::QGroupBox(QWidget * parent = nullptr)**

        Constructs a group box widget with the given **parent** but with no
        title.
        """
        ...

    @typing.overload
    def __init__(self, title: str, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qgroupbox.html#QGroupBox-1

        **QGroupBox::QGroupBox(const QString & title , QWidget * parent =
        nullptr)**

        Constructs a group box with the given **title** and **parent**.
        """
        ...

    def mouseReleaseEvent(self, event: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qgroupbox.html#mouseReleaseEvent

        **[override virtual protected] void
        QGroupBox::mouseReleaseEvent(QMouseEvent * event )**

        Reimplements: **QWidget::mouseReleaseEvent** (QMouseEvent *event).
        """
        ...

    def mouseMoveEvent(self, event: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qgroupbox.html#mouseMoveEvent

        **[override virtual protected] void
        QGroupBox::mouseMoveEvent(QMouseEvent * event )**

        Reimplements: **QWidget::mouseMoveEvent** (QMouseEvent *event).
        """
        ...

    def mousePressEvent(self, event: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qgroupbox.html#mousePressEvent

        **[override virtual protected] void
        QGroupBox::mousePressEvent(QMouseEvent * event )**

        Reimplements: **QWidget::mousePressEvent** (QMouseEvent *event).
        """
        ...

    def changeEvent(self, a0: QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-5/qgroupbox.html#changeEvent

        **[override virtual protected] void QGroupBox::changeEvent(QEvent * ev
        )**

        Reimplements: **QWidget::changeEvent** (QEvent *event).
        """
        ...

    def focusInEvent(self, a0: QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-5/qgroupbox.html#focusInEvent

        **[override virtual protected] void QGroupBox::focusInEvent(QFocusEvent
        * fe )**

        Reimplements: **QWidget::focusInEvent** (QFocusEvent *event).
        """
        ...

    def paintEvent(self, a0: QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-5/qgroupbox.html#paintEvent

        **[override virtual protected] void QGroupBox::paintEvent(QPaintEvent *
        event )**

        Reimplements: **QWidget::paintEvent** (QPaintEvent *event).
        """
        ...

    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-5/qgroupbox.html#resizeEvent

        **[override virtual protected] void QGroupBox::resizeEvent(QResizeEvent
        * e )**

        Reimplements: **QWidget::resizeEvent** (QResizeEvent *event).
        """
        ...

    def childEvent(self, a0: QtCore.QChildEvent) -> None:
        """
        https://doc.qt.io/qt-5/qgroupbox.html#childEvent

        **[override virtual protected] void QGroupBox::childEvent(QChildEvent *
        c )**

        Reimplements: **QObject::childEvent** (QChildEvent *event).
        """
        ...

    def event(self, a0: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qgroupbox.html#event

        **[override virtual protected] bool QGroupBox::event(QEvent * e )**

        Reimplements: **QWidget::event** (QEvent *event).
        """
        ...

    def initStyleOption(self, option: "QStyleOptionGroupBox") -> None:
        """
        https://doc.qt.io/qt-5/qgroupbox.html#initStyleOption

        **[protected] void QGroupBox::initStyleOption(QStyleOptionGroupBox *
        option ) const**

        Initialize **option** with the values from this **QGroupBox** . This
        method is useful for subclasses when they need a
        **QStyleOptionGroupBox** , but don't want to fill in all the information
        themselves.

        **See also** **QStyleOption::initFrom** ().
        """
        ...

    def setChecked(self, b: bool) -> None:
        """
        https://doc.qt.io/qt-5/qgroupbox.html#checked-prop

        **checked : bool**

        This property holds whether the group box is checked

        If the group box is checkable, it is displayed with a check box. If the
        check box is checked, the group box's children are enabled; otherwise,
        the children are disabled and are inaccessible to the user.

        By default, checkable group boxes are also checked.

        **Access functions:**

        bool **isChecked** () const
        void **setChecked** (bool **checked** )

        **Notifier signal:**

        void ****toggled** ** (bool **on** )

        **See also** **checkable** .
        """
        ...

    def isChecked(self) -> bool:
        ...

    def setCheckable(self, b: bool) -> None:
        """
        https://doc.qt.io/qt-5/qgroupbox.html#checkable-prop

        **checkable : bool**

        This property holds whether the group box has a checkbox in its title

        If this property is `true`, the group box displays its title using a
        checkbox in place of an ordinary label. If the checkbox is checked, the
        group box's children are enabled; otherwise, they are disabled and
        inaccessible.

        By default, group boxes are not checkable.

        If this property is enabled for a group box, it will also be initially
        checked to ensure that its contents are enabled.

        **Access functions:**

        bool **isCheckable** () const
        void **setCheckable** (bool
        **checkable** )

        **See also** **checked** .
        """
        ...

    def isCheckable(self) -> bool:
        ...

    def setFlat(self, b: bool) -> None:
        """
        https://doc.qt.io/qt-5/qgroupbox.html#flat-prop

        **flat : bool**

        This property holds whether the group box is painted flat or has a frame

        A group box usually consists of a surrounding frame with a title at the
        top. If this property is enabled, only the top part of the frame is
        drawn in most styles; otherwise, the whole frame is drawn.

        By default, this property is disabled, i.e., group boxes are not flat
        unless explicitly specified.

        **Note:** In some styles, flat and non-flat group boxes have similar
        representations and may not be as distinguishable as they are in other
        styles.

        **Access functions:**

        bool **isFlat** () const
        void **setFlat** (bool **flat** )

        **See also** **title** .
        """
        ...

    def isFlat(self) -> bool:
        ...

    def minimumSizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qgroupbox.html#minimumSizeHint

        **[override virtual] QSize QGroupBox::minimumSizeHint() const**

        Reimplements an access function for property:
        **QWidget::minimumSizeHint** .
        """
        ...

    def setAlignment(self, a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qgroupbox.html#alignment-prop

        **alignment : Qt::Alignment**

        This property holds the alignment of the group box title.

        Most styles place the title at the top of the frame. The horizontal
        alignment of the title can be specified using single values from the
        following list:

        * **Qt::AlignLeft**  aligns the title text with the left-hand side of
        the group box.
          * **Qt::AlignRight**  aligns the title text with the
        right-hand side of the group box.
          * **Qt::AlignHCenter**  aligns the
        title text with the horizontal center of the group box.

        The default alignment is **Qt::AlignLeft** .

        **Access functions:**

        Qt::Alignment **alignment** () const
        void **setAlignment** (int
        **alignment** )

        **See also** **Qt::Alignment** .
        """
        ...

    def alignment(self) -> QtCore.Qt.Alignment:
        """
        https://doc.qt.io/qt-5/qgroupbox.html#alignment-prop

        **alignment : Qt::Alignment**

        This property holds the alignment of the group box title.

        Most styles place the title at the top of the frame. The horizontal
        alignment of the title can be specified using single values from the
        following list:

        * **Qt::AlignLeft**  aligns the title text with the left-hand side of
        the group box.
          * **Qt::AlignRight**  aligns the title text with the
        right-hand side of the group box.
          * **Qt::AlignHCenter**  aligns the
        title text with the horizontal center of the group box.

        The default alignment is **Qt::AlignLeft** .

        **Access functions:**

        Qt::Alignment **alignment** () const
        void **setAlignment** (int
        **alignment** )

        **See also** **Qt::Alignment** .
        """
        ...

    def setTitle(self, a0: str) -> None:
        """
        https://doc.qt.io/qt-5/qgroupbox.html#title-prop

        **title : QString**

        This property holds the group box title text

        The group box title text will have a keyboard shortcut if the title
        contains an ampersand ('&') followed by a letter.

        g->setTitle("&User information");

        In the example above, **Alt+U** moves the keyboard focus to the group
        box. See the **QShortcut**  documentation for details (to display an
        actual ampersand, use '&&').

        There is no default title text.

        **Access functions:**

        QString **title** () const
        void **setTitle** (const QString &
        **title** )

        **See also** **alignment** .

        **Member Function Documentation**
        """
        ...

    def title(self) -> str:
        """
        https://doc.qt.io/qt-5/qgroupbox.html#title-prop

        **title : QString**

        This property holds the group box title text

        The group box title text will have a keyboard shortcut if the title
        contains an ampersand ('&') followed by a letter.

        g->setTitle("&User information");

        In the example above, **Alt+U** moves the keyboard focus to the group
        box. See the **QShortcut**  documentation for details (to display an
        actual ampersand, use '&&').

        There is no default title text.

        **Access functions:**

        QString **title** () const
        void **setTitle** (const QString &
        **title** )

        **See also** **alignment** .

        **Member Function Documentation**
        """
        ...

    @property
    def clicked(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgroupbox.html#clicked

        **[signal] void QGroupBox::clicked(bool checked = false)**

        This signal is emitted when the check box is activated (i.e., pressed
        down then released while the mouse cursor is inside the button), or when
        the shortcut key is typed. Notably, this signal is **not** emitted if
        you call **setChecked** ().

        If the check box is checked, **checked** is true; it is false if the
        check box is unchecked.

        This function was introduced in Qt 4.2.

        **See also** **checkable** , **toggled** (), and **checked** .
        """
        ...

    @property
    def toggled(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgroupbox.html#toggled

        **[signal] void QGroupBox::toggled(bool on )**

        If the group box is checkable, this signal is emitted when the check box
        is toggled. **on** is true if the check box is checked; otherwise, it is
        false.

        **Note:** Notifier signal for property **checked** .

        **See also** **checkable** .
        """
        ...
