"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QGraphicsSceneMouseEvent(QGraphicsSceneEvent):
    """
    https://doc.qt.io/qt-5/qgraphicsscenemouseevent.html

    **Detailed Description**

    When a **QGraphicsView**  receives a **QMouseEvent** , it translates it to a
    QGraphicsSceneMouseEvent. The event is then forwarded to the
    **QGraphicsScene**  associated with the view. If the event is not handled by
    the scene, the view may use it, e.g., for the **DragMode** .

    In addition to containing the item, scene, and screen coordinates of the
    event (as **pos** (), **scenePos** (), and **screenPos** ()), mouse events
    also contain the coordinates of the previous mouse event received by the
    view. These can be retrieved with **lastPos** (), **lastScreenPos** (), and
    **lastScenePos** ().

    **See also** **QGraphicsSceneContextMenuEvent** ,
    **QGraphicsSceneHoverEvent** , **QGraphicsSceneWheelEvent** , and
    **QMouseEvent** .
    """

    def flags(self) -> QtCore.Qt.MouseEventFlags:
        """
        https://doc.qt.io/qt-5/qgraphicsscenemouseevent.html#flags

        **Qt::MouseEventFlags QGraphicsSceneMouseEvent::flags() const**

        Returns the mouse event flags.

        The mouse event flags provide additional information about a mouse
        event.

        This function was introduced in Qt 5.4.

        **See also** **Qt::MouseEventFlag**  and **QMouseEvent::flags** ().
        """
        ...

    def source(self) -> QtCore.Qt.MouseEventSource:
        """
        https://doc.qt.io/qt-5/qgraphicsscenemouseevent.html#source

        **Qt::MouseEventSource QGraphicsSceneMouseEvent::source() const**

        Returns information about the mouse event source.

        The mouse event source can be used to distinguish between genuine and
        artificial mouse events. The latter are events that are synthesized from
        touch events by the operating system or Qt itself.

        This function was introduced in Qt 5.4.

        **See also** **Qt::MouseEventSource**  and **QMouseEvent::source** ().
        """
        ...

    def modifiers(self) -> QtCore.Qt.KeyboardModifiers:
        """
        https://doc.qt.io/qt-5/qgraphicsscenemouseevent.html#modifiers

        **Qt::KeyboardModifiers QGraphicsSceneMouseEvent::modifiers() const**

        Returns the keyboard modifiers in use at the time the event was sent.

        **See also** **buttons** () and **button** ().
        """
        ...

    def button(self) -> QtCore.Qt.MouseButton:
        """
        https://doc.qt.io/qt-5/qgraphicsscenemouseevent.html#button

        **Qt::MouseButton QGraphicsSceneMouseEvent::button() const**

        Returns the mouse button (if any) that caused the event.

        **See also** **buttons** () and **modifiers** ().
        """
        ...

    def buttons(self) -> QtCore.Qt.MouseButtons:
        """
        https://doc.qt.io/qt-5/qgraphicsscenemouseevent.html#buttons

        **Qt::MouseButtons QGraphicsSceneMouseEvent::buttons() const**

        Returns the combination of mouse buttons that were pressed at the time
        the event was sent.

        **See also** **button** () and **modifiers** ().
        """
        ...

    def lastScreenPos(self) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-5/qgraphicsscenemouseevent.html#lastScreenPos

        **QPoint QGraphicsSceneMouseEvent::lastScreenPos() const**

        Returns the last recorded mouse cursor position in screen coordinates.
        The last recorded position is the position of the previous mouse event
        received by the view that created the event.

        **See also** **lastPos** (), **lastScenePos** (), and **screenPos** ().
        """
        ...

    def lastScenePos(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qgraphicsscenemouseevent.html#lastScenePos

        **QPointF QGraphicsSceneMouseEvent::lastScenePos() const**

        Returns the last recorded mouse cursor position in scene coordinates.
        The last recorded position is the position of the previous mouse event
        received by the view that created the event.

        **See also** **lastPos** (), **lastScreenPos** (), and **scenePos** ().
        """
        ...

    def lastPos(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qgraphicsscenemouseevent.html#lastPos

        **QPointF QGraphicsSceneMouseEvent::lastPos() const**

        Returns the last recorded mouse cursor position in item coordinates.

        **See also** **lastScenePos** (), **lastScreenPos** (), and **pos** ().
        """
        ...

    def buttonDownScreenPos(self, button: QtCore.Qt.MouseButton) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-5/qgraphicsscenemouseevent.html#buttonDownScreenPos

        **QPoint QGraphicsSceneMouseEvent::buttonDownScreenPos(Qt::MouseButton
        button ) const**

        Returns the mouse cursor position in screen coordinates where the
        specified **button** was clicked.

        **See also** **screenPos** (), **buttonDownPos** (), and
        **buttonDownScenePos** ().
        """
        ...

    def buttonDownScenePos(self, button: QtCore.Qt.MouseButton) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qgraphicsscenemouseevent.html#buttonDownScenePos

        **QPointF QGraphicsSceneMouseEvent::buttonDownScenePos(Qt::MouseButton
        button ) const**

        Returns the mouse cursor position in scene coordinates where the
        specified **button** was clicked.

        **See also** **buttonDownPos** (), **buttonDownScreenPos** (), and
        **scenePos** ().
        """
        ...

    def buttonDownPos(self, button: QtCore.Qt.MouseButton) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qgraphicsscenemouseevent.html#buttonDownPos

        **QPointF QGraphicsSceneMouseEvent::buttonDownPos(Qt::MouseButton button
        ) const**

        Returns the mouse cursor position in item coordinates where the
        specified **button** was clicked.

        **See also** **buttonDownScenePos** (), **buttonDownScreenPos** (), and
        **pos** ().
        """
        ...

    def screenPos(self) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-5/qgraphicsscenemouseevent.html#screenPos

        **QPoint QGraphicsSceneMouseEvent::screenPos() const**

        Returns the mouse cursor position in screen coordinates.

        **See also** **pos** (), **scenePos** (), and **lastScreenPos** ().
        """
        ...

    def scenePos(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qgraphicsscenemouseevent.html#scenePos

        **QPointF QGraphicsSceneMouseEvent::scenePos() const**

        Returns the mouse cursor position in scene coordinates.

        **See also** **pos** (), **screenPos** (), and **lastScenePos** ().
        """
        ...

    def pos(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qgraphicsscenemouseevent.html#pos

        **QPointF QGraphicsSceneMouseEvent::pos() const**

        Returns the mouse cursor position in item coordinates.

        **See also** **scenePos** (), **screenPos** (), and **lastPos** ().
        """
        ...
