"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *
from PyQt5 import sip


class QGraphicsBlurEffect(QGraphicsEffect):
    """
    https://doc.qt.io/qt-5/qgraphicsblureffect.html

    **Detailed Description**

    A blur effect blurs the source. This effect is useful for reducing details,
    such as when the source loses focus and you want to draw attention to other
    elements. The level of detail can be modified using the **setBlurRadius** ()
    function. Use **setBlurHints** () to choose the blur hints.

    By default, the blur radius is 5 pixels. The blur radius is specified in
    device coordinates.

    ![](images/graphicseffect-blur.png)

    **See also** **QGraphicsDropShadowEffect** , **QGraphicsColorizeEffect** ,
    and **QGraphicsOpacityEffect** .
    """

    class BlurHint(int):
        PerformanceHint: QGraphicsBlurEffect = ...
        QualityHint: QGraphicsBlurEffect = ...
        AnimationHint: QGraphicsBlurEffect = ...

    class BlurHints(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QGraphicsBlurEffect.BlurHints", "QGraphicsBlurEffect.BlurHint"
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QGraphicsBlurEffect.BlurHints") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QGraphicsBlurEffect.BlurHints":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsblureffect.html#QGraphicsBlurEffect

        **QGraphicsBlurEffect::QGraphicsBlurEffect(QObject * parent = nullptr)**

        Constructs a new QGraphicsBlurEffect instance. The **parent** parameter
        is passed to **QGraphicsEffect** 's constructor.
        """
        ...

    def draw(self, painter: QtGui.QPainter) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsblureffect.html#draw

        **[override virtual protected] void QGraphicsBlurEffect::draw(QPainter *
        painter )**

        Reimplements: **QGraphicsEffect::draw** (QPainter *painter).
        """
        ...

    def setBlurHints(
        self,
        hints: typing.Union[
            "QGraphicsBlurEffect.BlurHints", "QGraphicsBlurEffect.BlurHint"
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsblureffect.html#blurHints-prop

        **blurHints : BlurHints**

        This property holds the blur hint of the effect.

        Use the **PerformanceHint**  hint to say that you want a faster blur,
        the **QualityHint**  hint to say that you prefer a higher quality blur,
        or the **AnimationHint**  when you want to animate the blur radius.

        By default, the blur hint is **PerformanceHint** .

        **Access functions:**

        QGraphicsBlurEffect::BlurHints **blurHints** () const
        void
        **setBlurHints** (QGraphicsBlurEffect::BlurHints **hints** )

        **Notifier signal:**

        void ****blurHintsChanged** ** (QGraphicsBlurEffect::BlurHints **hints**
        )
        """
        ...

    def setBlurRadius(self, blurRadius: float) -> None:
        """
        https://doc.qt.io/qt-5/qgraphicsblureffect.html#blurRadius-prop

        **blurRadius : qreal**

        This property holds the blur radius of the effect.

        Using a smaller radius results in a sharper appearance, whereas a bigger
        radius results in a more blurred appearance.

        By default, the blur radius is 5 pixels.

        The radius is given in device coordinates, meaning it is unaffected by
        scale.

        **Access functions:**

        qreal **blurRadius** () const
        void **setBlurRadius** (qreal
        **blurRadius** )

        **Notifier signal:**

        void ****blurRadiusChanged** ** (qreal **radius** )

        **Member Function Documentation**
        """
        ...

    def blurHints(self) -> "QGraphicsBlurEffect.BlurHints":
        """
        https://doc.qt.io/qt-5/qgraphicsblureffect.html#blurHints-prop

        **blurHints : BlurHints**

        This property holds the blur hint of the effect.

        Use the **PerformanceHint**  hint to say that you want a faster blur,
        the **QualityHint**  hint to say that you prefer a higher quality blur,
        or the **AnimationHint**  when you want to animate the blur radius.

        By default, the blur hint is **PerformanceHint** .

        **Access functions:**

        QGraphicsBlurEffect::BlurHints **blurHints** () const
        void
        **setBlurHints** (QGraphicsBlurEffect::BlurHints **hints** )

        **Notifier signal:**

        void ****blurHintsChanged** ** (QGraphicsBlurEffect::BlurHints **hints**
        )
        """
        ...

    def blurRadius(self) -> float:
        """
        https://doc.qt.io/qt-5/qgraphicsblureffect.html#blurRadius-prop

        **blurRadius : qreal**

        This property holds the blur radius of the effect.

        Using a smaller radius results in a sharper appearance, whereas a bigger
        radius results in a more blurred appearance.

        By default, the blur radius is 5 pixels.

        The radius is given in device coordinates, meaning it is unaffected by
        scale.

        **Access functions:**

        qreal **blurRadius** () const
        void **setBlurRadius** (qreal
        **blurRadius** )

        **Notifier signal:**

        void ****blurRadiusChanged** ** (qreal **radius** )

        **Member Function Documentation**
        """
        ...

    def boundingRectFor(self, rect: QtCore.QRectF) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qgraphicsblureffect.html#boundingRectFor

        **[override virtual] QRectF QGraphicsBlurEffect::boundingRectFor(const
        QRectF & rect ) const**

        Reimplements: **QGraphicsEffect::boundingRectFor** (const QRectF &rect)
        const.
        """
        ...

    @property
    def blurHintsChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgraphicsblureffect.html#blurHintsChanged

        **[signal] void
        QGraphicsBlurEffect::blurHintsChanged(QGraphicsBlurEffect::BlurHints
        hints )**

        This signal is emitted whenever the effect's blur hints changes. The
        **hints** parameter holds the effect's new blur hints.

        **Note:** Notifier signal for property **blurHints** .
        """
        ...

    @property
    def blurRadiusChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qgraphicsblureffect.html#blurRadiusChanged

        **[signal] void QGraphicsBlurEffect::blurRadiusChanged(qreal radius )**

        This signal is emitted whenever the effect's blur radius changes. The
        **radius** parameter holds the effect's new blur radius.

        **Note:** Notifier signal for property **blurRadius** .
        """
        ...
