"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtWidgets import *
from PyQt5 import sip


class QFormLayout(QLayout):
    """
    https://doc.qt.io/qt-5/qformlayout.html

    **Detailed Description**

    QFormLayout is a convenience layout class that lays out its children in a
    two-column form. The left column consists of labels and the right column
    consists of "field" widgets (line editors, spin boxes, etc.).

    Traditionally, such two-column form layouts were achieved using
    **QGridLayout** . QFormLayout is a higher-level alternative that provides
    the following advantages:

    * **Adherence to the different platform's look and feel guidelines.**

    For
    example, the **macOS Aqua**  and KDE guidelines specify that the labels
    should be right-aligned, whereas Windows and GNOME applications normally use
    left-alignment.

      * **Support for wrapping long rows.**

    For devices with
    small displays, QFormLayout can be set to **wrap long rows** , or even to
    **wrap all rows** .

      * **Convenient API for creating label--field pairs.**
    The **addRow** () overload that takes a **QString**  and a **QWidget**  *
    creates a **QLabel**  behind the scenes and automatically set up its buddy.
    We can then write code like this:


            **QFormLayout**  *formLayout
    = new **QFormLayout** ;
        formLayout->addRow(tr("&Name:"), nameLineEdit);
    formLayout->addRow(tr("&Email:"), emailLineEdit);
    formLayout->addRow(tr("&Age:"), ageSpinBox);
        setLayout(formLayout);
    Compare this with the following code, written using **QGridLayout** :
    nameLabel = new **QLabel** (tr("&Name:"));
    nameLabel->setBuddy(nameLineEdit);

        emailLabel = new **QLabel**
    (tr("&Name:"));
        emailLabel->setBuddy(emailLineEdit);

        ageLabel =
    new **QLabel** (tr("&Name:"));
        ageLabel->setBuddy(ageSpinBox);
    **QGridLayout**  *gridLayout = new **QGridLayout** ;
    gridLayout->addWidget(nameLabel, 0, 0);
    gridLayout->addWidget(nameLineEdit, 0, 1);
    gridLayout->addWidget(emailLabel, 1, 0);
    gridLayout->addWidget(emailLineEdit, 1, 1);
    gridLayout->addWidget(ageLabel, 2, 0);
        gridLayout->addWidget(ageSpinBox,
    2, 1);
        setLayout(gridLayout);

    The table below shows the default appearance in different styles.

    **QCommonStyle**  derived styles (except
    QPlastiqueStyle)QMacStyleQPlastiqueStyleQt Extended styles
    ![](images/qformlayout-win.png)![](images/qformlayout-
    mac.png)![](images/qformlayout-kde.png)![](images/qformlayout-qpe.png)
    Traditional style used for Windows, GNOME, and earlier versions of KDE.
    Labels are left aligned, and expanding fields grow to fill the available
    space. (This normally corresponds to what we would get using a two-column
    **QGridLayout** .)Style based on the **macOS Aqua**  guidelines. Labels are
    right-aligned, the fields don't grow beyond their size hint, and the form is
    horizontally centered.Recommended style for **KDE applications** . Similar
    to MacStyle, except that the form is left-aligned and all fields grow to
    fill the available space.Default style for Qt Extended styles. Labels are
    right-aligned, expanding fields grow to fill the available space, and row
    wrapping is enabled for long lines.

    The form styles can be also be overridden individually by calling
    **setLabelAlignment** (), **setFormAlignment** (), **setFieldGrowthPolicy**
    (), and **setRowWrapPolicy** (). For example, to simulate the form layout
    appearance of QMacStyle on all platforms, but with left-aligned labels, you
    could write:

    formLayout->setRowWrapPolicy(**QFormLayout** ::DontWrapRows);
    formLayout->setFieldGrowthPolicy(**QFormLayout** ::FieldsStayAtSizeHint);
    formLayout->setFormAlignment(Qt::AlignHCenter | Qt::AlignTop);
    formLayout->setLabelAlignment(Qt::AlignLeft);

    **See also** **QGridLayout** , **QBoxLayout** , and **QStackedLayout** .
    """

    class ItemRole(int):
        LabelRole: QFormLayout = ...
        FieldRole: QFormLayout = ...
        SpanningRole: QFormLayout = ...

    class RowWrapPolicy(int):
        DontWrapRows: QFormLayout = ...
        WrapLongRows: QFormLayout = ...
        WrapAllRows: QFormLayout = ...

    class FieldGrowthPolicy(int):
        FieldsStayAtSizeHint: QFormLayout = ...
        ExpandingFieldsGrow: QFormLayout = ...
        AllNonFixedFieldsGrow: QFormLayout = ...

    class TakeRowResult(sip.simplewrapper):
        fieldItem: QLayoutItem = ...
        labelItem: QLayoutItem = ...

        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QFormLayout.TakeRowResult") -> None:
            ...

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qformlayout.html#QFormLayout

        **QFormLayout::QFormLayout(QWidget * parent = nullptr)**

        Constructs a new form layout with the given **parent** widget.

        **See also** **QWidget::setLayout** ().
        """
        ...

    @typing.overload
    def takeRow(self, row: int) -> "QFormLayout.TakeRowResult":
        """
        https://doc.qt.io/qt-5/qformlayout.html#takeRow

        **QFormLayout::TakeRowResult QFormLayout::takeRow(int row )**

        Removes the specified **row** from this form layout.

        **row** must be non-negative and less than **rowCount** ().

        **Note:** This function doesn't delete anything.

        After this call, **rowCount** () is decremented by one. All following
        rows are shifted up one row and the freed vertical space is
        redistributed amongst the remaining rows.

        You can use this function to undo a previous **addRow** () or
        **insertRow** ():

        **QFormLayout**  *flay = ...;
            **QPointer** <**QLineEdit** > le = new
        **QLineEdit** ;
            flay->insertRow(2, "User:", le);
            // later:
        **QFormLayout** ::TakeRowResult result = flay->takeRow(2);

        If you want to remove the row from the layout and delete the widgets,
        use **removeRow** () instead.

        Returns A structure containing both the widget and corresponding label
        layout items

        This function was introduced in Qt 5.8.

        **See also** **removeRow** ().
        """
        ...

    @typing.overload
    def takeRow(self, widget: QWidget) -> "QFormLayout.TakeRowResult":
        """
        https://doc.qt.io/qt-5/qformlayout.html#takeRow-1

        **QFormLayout::TakeRowResult QFormLayout::takeRow(QWidget * widget )**

        This is an overloaded function.

        Removes the specified **widget** from this form layout.

        **Note:** This function doesn't delete anything.

        After this call, **rowCount** () is decremented by one. All following
        rows are shifted up one row and the freed vertical space is
        redistributed amongst the remaining rows.

        **QFormLayout**  *flay = ...;
            **QPointer** <**QLineEdit** > le = new
        **QLineEdit** ;
            flay->insertRow(2, "User:", le);
            // later:
        **QFormLayout** ::TakeRowResult result = flay->takeRow(widget);

        If you want to remove the row from the layout and delete the widgets,
        use **removeRow** () instead.

        Returns A structure containing both the widget and corresponding label
        layout items

        This function was introduced in Qt 5.8.

        **See also** **removeRow** ().
        """
        ...

    @typing.overload
    def takeRow(self, layout: QLayout) -> "QFormLayout.TakeRowResult":
        """
        https://doc.qt.io/qt-5/qformlayout.html#takeRow-2

        **QFormLayout::TakeRowResult QFormLayout::takeRow(QLayout * layout )**

        This is an overloaded function.

        Removes the specified **layout** from this form layout.

        **Note:** This function doesn't delete anything.

        After this call, **rowCount** () is decremented by one. All following
        rows are shifted up one row and the freed vertical space is
        redistributed amongst the remaining rows.

        **QFormLayout**  *flay = ...;
            **QPointer** <**QVBoxLayout** > vbl =
        new **QVBoxLayout** ;
            flay->insertRow(2, "User:", vbl);
            //
        later:
            **QFormLayout** ::TakeRowResult result =
        flay->takeRow(widget);

        If you want to remove the row from the form layout and delete the
        inserted layout, use **removeRow** () instead.

        Returns A structure containing both the widget and corresponding label
        layout items

        This function was introduced in Qt 5.8.

        **See also** **removeRow** ().
        """
        ...

    @typing.overload
    def removeRow(self, row: int) -> None:
        """
        https://doc.qt.io/qt-5/qformlayout.html#removeRow

        **void QFormLayout::removeRow(int row )**

        Deletes row **row** from this form layout.

        **row** must be non-negative and less than **rowCount** ().

        After this call, **rowCount** () is decremented by one. All widgets and
        nested layouts that occupied this row are deleted. That includes both
        the field widget(s) and the label, if any. All following rows are
        shifted up one row and the freed vertical space is redistributed amongst
        the remaining rows.

        You can use this function to undo a previous **addRow** () or
        **insertRow** ():

        **QFormLayout**  *flay = ...;
            **QPointer** <**QLineEdit** > le = new
        **QLineEdit** ;
            flay->insertRow(2, "User:", le);
            // later:
        flay->removeRow(2); // le == nullptr at this point

        If you want to remove the row from the layout without deleting the
        widgets, use **takeRow** () instead.

        This function was introduced in Qt 5.8.

        **See also** **takeRow** ().
        """
        ...

    @typing.overload
    def removeRow(self, widget: QWidget) -> None:
        """
        https://doc.qt.io/qt-5/qformlayout.html#removeRow-1

        **void QFormLayout::removeRow(QWidget * widget )**

        This is an overloaded function.

        Deletes the row corresponding to **widget** from this form layout.

        After this call, **rowCount** () is decremented by one. All widgets and
        nested layouts that occupied this row are deleted. That includes both
        the field widget(s) and the label, if any. All following rows are
        shifted up one row and the freed vertical space is redistributed amongst
        the remaining rows.

        You can use this function to undo a previous **addRow** () or
        **insertRow** ():

        **QFormLayout**  *flay = ...;
            **QPointer** <**QLineEdit** > le = new
        **QLineEdit** ;
            flay->insertRow(2, "User:", le);
            // later:
        flay->removeRow(le); // le == nullptr at this point

        If you want to remove the row from the layout without deleting the
        widgets, use **takeRow** () instead.

        This function was introduced in Qt 5.8.

        **See also** **takeRow** ().
        """
        ...

    @typing.overload
    def removeRow(self, layout: QLayout) -> None:
        """
        https://doc.qt.io/qt-5/qformlayout.html#removeRow-2

        **void QFormLayout::removeRow(QLayout * layout )**

        This is an overloaded function.

        Deletes the row corresponding to **layout** from this form layout.

        After this call, **rowCount** () is decremented by one. All widgets and
        nested layouts that occupied this row are deleted. That includes both
        the field widget(s) and the label, if any. All following rows are
        shifted up one row and the freed vertical space is redistributed amongst
        the remaining rows.

        You can use this function to undo a previous **addRow** () or
        **insertRow** ():

        **QFormLayout**  *flay = ...;
            **QPointer** <**QVBoxLayout** > vbl =
        new **QVBoxLayout** ;
            flay->insertRow(2, "User:", vbl);
            //
        later:
            flay->removeRow(layout); // vbl == nullptr at this point

        If you want to remove the row from the form layout without deleting the
        inserted layout, use **takeRow** () instead.

        This function was introduced in Qt 5.8.

        **See also** **takeRow** ().
        """
        ...

    def rowCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qformlayout.html#rowCount

        **int QFormLayout::rowCount() const**

        Returns the number of rows in the form.

        **See also** **QLayout::count** ().
        """
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-5/qformlayout.html#count

        **[override virtual] int QFormLayout::count() const**

        Reimplements: **QLayout::count** () const.
        """
        ...

    def expandingDirections(self) -> QtCore.Qt.Orientations:
        """
        https://doc.qt.io/qt-5/qformlayout.html#expandingDirections

        **[override virtual] Qt::Orientations QFormLayout::expandingDirections()
        const**

        Reimplements: **QLayout::expandingDirections** () const.
        """
        ...

    def heightForWidth(self, width: int) -> int:
        """
        https://doc.qt.io/qt-5/qformlayout.html#heightForWidth

        **[override virtual] int QFormLayout::heightForWidth(int width ) const**

        Reimplements: **QLayoutItem::heightForWidth** (int ) const.
        """
        ...

    def hasHeightForWidth(self) -> bool:
        """
        https://doc.qt.io/qt-5/qformlayout.html#hasHeightForWidth

        **[override virtual] bool QFormLayout::hasHeightForWidth() const**

        Reimplements: **QLayoutItem::hasHeightForWidth** () const.
        """
        ...

    def invalidate(self) -> None:
        """
        https://doc.qt.io/qt-5/qformlayout.html#invalidate

        **[override virtual] void QFormLayout::invalidate()**

        Reimplements: **QLayout::invalidate** ().
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qformlayout.html#sizeHint

        **[override virtual] QSize QFormLayout::sizeHint() const**

        Reimplements: **QLayoutItem::sizeHint** () const.
        """
        ...

    def minimumSize(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qformlayout.html#minimumSize

        **[override virtual] QSize QFormLayout::minimumSize() const**

        Reimplements: **QLayout::minimumSize** () const.
        """
        ...

    def setGeometry(self, rect: QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-5/qformlayout.html#setGeometry

        **[override virtual] void QFormLayout::setGeometry(const QRect & rect
        )**

        Reimplements: **QLayout::setGeometry** (const QRect &r).
        """
        ...

    def takeAt(self, index: int) -> QLayoutItem:
        """
        https://doc.qt.io/qt-5/qformlayout.html#takeAt

        **[override virtual] QLayoutItem *QFormLayout::takeAt(int index )**

        Reimplements: **QLayout::takeAt** (int index).
        """
        ...

    def addItem(self, item: QLayoutItem) -> None:
        """
        https://doc.qt.io/qt-5/qformlayout.html#addItem

        **[override virtual] void QFormLayout::addItem(QLayoutItem * item )**

        Reimplements: **QLayout::addItem** (QLayoutItem *item).
        """
        ...

    @typing.overload
    def labelForField(self, field: QWidget) -> QWidget:
        """
        https://doc.qt.io/qt-5/qformlayout.html#labelForField

        **QWidget *QFormLayout::labelForField(QWidget * field ) const**

        Returns the label associated with the given **field**.

        **See also** **itemAt** ().
        """
        ...

    @typing.overload
    def labelForField(self, field: QLayout) -> QWidget:
        """
        https://doc.qt.io/qt-5/qformlayout.html#labelForField-1

        **QWidget *QFormLayout::labelForField(QLayout * field ) const**

        This is an overloaded function.
        """
        ...

    def getLayoutPosition(
        self, layout: QLayout
    ) -> typing.Tuple[int, "QFormLayout.ItemRole"]:
        """
        https://doc.qt.io/qt-5/qformlayout.html#getLayoutPosition

        **void QFormLayout::getLayoutPosition(QLayout * layout , int * rowPtr ,
        QFormLayout::ItemRole * rolePtr ) const**

        Retrieves the row and role (column) of the specified child **layout**.
        If **layout** is not in the form layout, * **rowPtr** is set to -1;
        otherwise the row is stored in * **rowPtr** and the role is stored in *
        **rolePtr**.
        """
        ...

    def getWidgetPosition(
        self, widget: QWidget
    ) -> typing.Tuple[int, "QFormLayout.ItemRole"]:
        """
        https://doc.qt.io/qt-5/qformlayout.html#getWidgetPosition

        **void QFormLayout::getWidgetPosition(QWidget * widget , int * rowPtr ,
        QFormLayout::ItemRole * rolePtr ) const**

        Retrieves the row and role (column) of the specified **widget** in the
        layout. If **widget** is not in the layout, * **rowPtr** is set to -1;
        otherwise the row is stored in * **rowPtr** and the role is stored in *
        **rolePtr**.

        **See also** **getItemPosition** () and **itemAt** ().
        """
        ...

    def getItemPosition(self, index: int) -> typing.Tuple[int, "QFormLayout.ItemRole"]:
        """
        https://doc.qt.io/qt-5/qformlayout.html#getItemPosition

        **void QFormLayout::getItemPosition(int index , int * rowPtr ,
        QFormLayout::ItemRole * rolePtr ) const**

        Retrieves the row and role (column) of the item at the specified
        **index**. If **index** is out of bounds, * **rowPtr** is set to -1;
        otherwise the row is stored in * **rowPtr** and the role is stored in *
        **rolePtr**.

        **See also** **itemAt** (), **count** (), **getLayoutPosition** (), and
        **getWidgetPosition** ().
        """
        ...

    @typing.overload
    def itemAt(self, row: int, role: "QFormLayout.ItemRole") -> QLayoutItem:
        """
        https://doc.qt.io/qt-5/qformlayout.html#itemAt

        **QLayoutItem *QFormLayout::itemAt(int row , QFormLayout::ItemRole role
        ) const**

        Returns the layout item in the given **row** with the specified **role**
        (column). Returns `nullptr` if there is no such item.

        **See also** **QLayout::itemAt** () and **setItem** ().
        """
        ...

    @typing.overload
    def itemAt(self, index: int) -> QLayoutItem:
        """
        https://doc.qt.io/qt-5/qformlayout.html#itemAt-1

        **[override virtual] QLayoutItem *QFormLayout::itemAt(int index )
        const**

        Reimplements: **QLayout::itemAt** (int index) const.
        """
        ...

    def setLayout(
        self, row: int, role: "QFormLayout.ItemRole", layout: QLayout
    ) -> None:
        """
        https://doc.qt.io/qt-5/qformlayout.html#setLayout

        **void QFormLayout::setLayout(int row , QFormLayout::ItemRole role ,
        QLayout * layout )**

        Sets the sub-layout in the given **row** for the given **role** to
        **layout** , extending the form layout with empty rows if necessary.

        If the cell is already occupied, the **layout** is not inserted and an
        error message is sent to the console.

        **Note:** For most applications, **addRow** () or **insertRow** ()
        should be used instead of setLayout().

        **See also** **setWidget** ().
        """
        ...

    def setWidget(
        self, row: int, role: "QFormLayout.ItemRole", widget: QWidget
    ) -> None:
        """
        https://doc.qt.io/qt-5/qformlayout.html#setWidget

        **void QFormLayout::setWidget(int row , QFormLayout::ItemRole role ,
        QWidget * widget )**

        Sets the widget in the given **row** for the given **role** to
        **widget** , extending the layout with empty rows if necessary.

        If the cell is already occupied, the **widget** is not inserted and an
        error message is sent to the console.

        **Note:** For most applications, **addRow** () or **insertRow** ()
        should be used instead of setWidget().

        **See also** **setLayout** ().
        """
        ...

    def setItem(
        self, row: int, role: "QFormLayout.ItemRole", item: QLayoutItem
    ) -> None:
        """
        https://doc.qt.io/qt-5/qformlayout.html#setItem

        **void QFormLayout::setItem(int row , QFormLayout::ItemRole role ,
        QLayoutItem * item )**

        Sets the item in the given **row** for the given **role** to **item** ,
        extending the layout with empty rows if necessary.

        If the cell is already occupied, the **item** is not inserted and an
        error message is sent to the console. The **item** spans both columns.

        **Warning:** Do not use this function to add child layouts or child
        widget items. Use **setLayout** () or **setWidget** () instead.

        **See also** **setLayout** ().
        """
        ...

    @typing.overload
    def insertRow(self, row: int, label: QWidget, field: QWidget) -> None:
        """
        https://doc.qt.io/qt-5/qformlayout.html#insertRow

        **void QFormLayout::insertRow(int row , QWidget * label , QWidget *
        field )**

        Inserts a new row at position **row** in this form layout, with the
        given **label** and **field**. If **row** is out of bounds, the new row
        is added at the end.

        **See also** **addRow** ().
        """
        ...

    @typing.overload
    def insertRow(self, row: int, label: QWidget, field: QLayout) -> None:
        """
        https://doc.qt.io/qt-5/qformlayout.html#insertRow-1

        **void QFormLayout::insertRow(int row , QWidget * label , QLayout *
        field )**

        This is an overloaded function.
        """
        ...

    @typing.overload
    def insertRow(self, row: int, labelText: str, field: QWidget) -> None:
        """
        https://doc.qt.io/qt-5/qformlayout.html#insertRow-2

        **void QFormLayout::insertRow(int row , const QString & labelText ,
        QWidget * field )**

        This is an overloaded function.

        This overload automatically creates a **QLabel**  behind the scenes with
        **labelText** as its text. The **field** is set as the new **QLabel** 's
        **buddy** .
        """
        ...

    @typing.overload
    def insertRow(self, row: int, labelText: str, field: QLayout) -> None:
        """
        https://doc.qt.io/qt-5/qformlayout.html#insertRow-3

        **void QFormLayout::insertRow(int row , const QString & labelText ,
        QLayout * field )**

        This is an overloaded function.

        This overload automatically creates a **QLabel**  behind the scenes with
        **labelText** as its text.
        """
        ...

    @typing.overload
    def insertRow(self, row: int, widget: QWidget) -> None:
        """
        https://doc.qt.io/qt-5/qformlayout.html#insertRow-4

        **void QFormLayout::insertRow(int row , QWidget * widget )**

        This is an overloaded function.

        Inserts the specified **widget** at position **row** in this form
        layout. The **widget** spans both columns. If **row** is out of bounds,
        the widget is added at the end.
        """
        ...

    @typing.overload
    def insertRow(self, row: int, layout: QLayout) -> None:
        """
        https://doc.qt.io/qt-5/qformlayout.html#insertRow-5

        **void QFormLayout::insertRow(int row , QLayout * layout )**

        This is an overloaded function.

        Inserts the specified **layout** at position **row** in this form
        layout. The **layout** spans both columns. If **row** is out of bounds,
        the widget is added at the end.
        """
        ...

    @typing.overload
    def addRow(self, label: QWidget, field: QWidget) -> None:
        """
        https://doc.qt.io/qt-5/qformlayout.html#addRow

        **void QFormLayout::addRow(QWidget * label , QWidget * field )**

        Adds a new row to the bottom of this form layout, with the given
        **label** and **field**.

        **See also** **insertRow** ().
        """
        ...

    @typing.overload
    def addRow(self, label: QWidget, field: QLayout) -> None:
        """
        https://doc.qt.io/qt-5/qformlayout.html#addRow-1

        **void QFormLayout::addRow(QWidget * label , QLayout * field )**

        This is an overloaded function.
        """
        ...

    @typing.overload
    def addRow(self, labelText: str, field: QWidget) -> None:
        """
        https://doc.qt.io/qt-5/qformlayout.html#addRow-2

        **void QFormLayout::addRow(const QString & labelText , QWidget * field
        )**

        This is an overloaded function.

        This overload automatically creates a **QLabel**  behind the scenes with
        **labelText** as its text. The **field** is set as the new **QLabel** 's
        **buddy** .
        """
        ...

    @typing.overload
    def addRow(self, labelText: str, field: QLayout) -> None:
        """
        https://doc.qt.io/qt-5/qformlayout.html#addRow-3

        **void QFormLayout::addRow(const QString & labelText , QLayout * field
        )**

        This is an overloaded function.

        This overload automatically creates a **QLabel**  behind the scenes with
        **labelText** as its text.
        """
        ...

    @typing.overload
    def addRow(self, widget: QWidget) -> None:
        """
        https://doc.qt.io/qt-5/qformlayout.html#addRow-4

        **void QFormLayout::addRow(QWidget * widget )**

        This is an overloaded function.

        Adds the specified **widget** at the end of this form layout. The
        **widget** spans both columns.
        """
        ...

    @typing.overload
    def addRow(self, layout: QLayout) -> None:
        """
        https://doc.qt.io/qt-5/qformlayout.html#addRow-5

        **void QFormLayout::addRow(QLayout * layout )**

        This is an overloaded function.

        Adds the specified **layout** at the end of this form layout. The
        **layout** spans both columns.
        """
        ...

    def setSpacing(self, a0: int) -> None:
        """
        https://doc.qt.io/qt-5/qformlayout.html#setSpacing

        **void QFormLayout::setSpacing(int spacing )**

        This function sets both the vertical and horizontal spacing to
        **spacing**.

        **See also** **spacing** (), **setVerticalSpacing** (), and
        **setHorizontalSpacing** ().
        """
        ...

    def spacing(self) -> int:
        """
        https://doc.qt.io/qt-5/qformlayout.html#spacing

        **int QFormLayout::spacing() const**

        If the vertical spacing is equal to the horizontal spacing, this
        function returns that value; otherwise it returns -1.

        **See also** **setSpacing** (), **verticalSpacing** (), and
        **horizontalSpacing** ().
        """
        ...

    def verticalSpacing(self) -> int:
        """
        https://doc.qt.io/qt-5/qformlayout.html#verticalSpacing-prop

        **verticalSpacing : int**

        This property holds the spacing between widgets that are laid out
        vertically

        By default, if no value is explicitly set, the layout's vertical spacing
        is inherited from the parent layout, or from the style settings for the
        parent widget.

        **Access functions:**

        int **verticalSpacing** () const
        void **setVerticalSpacing** (int
        **spacing** )

        **See also** **horizontalSpacing** , **QStyle::pixelMetric** (), and
        **PM_LayoutHorizontalSpacing** .

        **Member Function Documentation**
        """
        ...

    def setVerticalSpacing(self, spacing: int) -> None:
        """
        https://doc.qt.io/qt-5/qformlayout.html#verticalSpacing-prop

        **verticalSpacing : int**

        This property holds the spacing between widgets that are laid out
        vertically

        By default, if no value is explicitly set, the layout's vertical spacing
        is inherited from the parent layout, or from the style settings for the
        parent widget.

        **Access functions:**

        int **verticalSpacing** () const
        void **setVerticalSpacing** (int
        **spacing** )

        **See also** **horizontalSpacing** , **QStyle::pixelMetric** (), and
        **PM_LayoutHorizontalSpacing** .

        **Member Function Documentation**
        """
        ...

    def horizontalSpacing(self) -> int:
        """
        https://doc.qt.io/qt-5/qformlayout.html#horizontalSpacing-prop

        **horizontalSpacing : int**

        This property holds the spacing between widgets that are laid out side
        by side

        By default, if no value is explicitly set, the layout's horizontal
        spacing is inherited from the parent layout, or from the style settings
        for the parent widget.

        **Access functions:**

        int **horizontalSpacing** () const
        void **setHorizontalSpacing** (int
        **spacing** )

        **See also** **verticalSpacing** , **QStyle::pixelMetric** (), and
        **PM_LayoutHorizontalSpacing** .
        """
        ...

    def setHorizontalSpacing(self, spacing: int) -> None:
        """
        https://doc.qt.io/qt-5/qformlayout.html#horizontalSpacing-prop

        **horizontalSpacing : int**

        This property holds the spacing between widgets that are laid out side
        by side

        By default, if no value is explicitly set, the layout's horizontal
        spacing is inherited from the parent layout, or from the style settings
        for the parent widget.

        **Access functions:**

        int **horizontalSpacing** () const
        void **setHorizontalSpacing** (int
        **spacing** )

        **See also** **verticalSpacing** , **QStyle::pixelMetric** (), and
        **PM_LayoutHorizontalSpacing** .
        """
        ...

    def formAlignment(self) -> QtCore.Qt.Alignment:
        """
        https://doc.qt.io/qt-5/qformlayout.html#formAlignment-prop

        **formAlignment : Qt::Alignment**

        This property holds the alignment of the form layout's contents within
        the layout's geometry

        The default value depends on the widget or application style. For
        QMacStyle, the default is **Qt::AlignHCenter**  | **Qt::AlignTop** ; for
        the other styles, the default is **Qt::AlignLeft**  | **Qt::AlignTop** .

        **Access functions:**

        Qt::Alignment **formAlignment** () const
        void **setFormAlignment**
        (Qt::Alignment **alignment** )

        **See also** **labelAlignment**  and **rowWrapPolicy** .
        """
        ...

    def setFormAlignment(
        self, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qformlayout.html#formAlignment-prop

        **formAlignment : Qt::Alignment**

        This property holds the alignment of the form layout's contents within
        the layout's geometry

        The default value depends on the widget or application style. For
        QMacStyle, the default is **Qt::AlignHCenter**  | **Qt::AlignTop** ; for
        the other styles, the default is **Qt::AlignLeft**  | **Qt::AlignTop** .

        **Access functions:**

        Qt::Alignment **formAlignment** () const
        void **setFormAlignment**
        (Qt::Alignment **alignment** )

        **See also** **labelAlignment**  and **rowWrapPolicy** .
        """
        ...

    def labelAlignment(self) -> QtCore.Qt.Alignment:
        """
        https://doc.qt.io/qt-5/qformlayout.html#labelAlignment-prop

        **labelAlignment : Qt::Alignment**

        This property holds the horizontal alignment of the labels

        The default value depends on the widget or application style. For
        **QCommonStyle**  derived styles, except for QPlastiqueStyle, the
        default is **Qt::AlignLeft** ; for the other styles, the default is
        **Qt::AlignRight** .

        **Access functions:**

        Qt::Alignment **labelAlignment** () const
        void **setLabelAlignment**
        (Qt::Alignment **alignment** )

        **See also** **formAlignment** .
        """
        ...

    def setLabelAlignment(
        self, alignment: typing.Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qformlayout.html#labelAlignment-prop

        **labelAlignment : Qt::Alignment**

        This property holds the horizontal alignment of the labels

        The default value depends on the widget or application style. For
        **QCommonStyle**  derived styles, except for QPlastiqueStyle, the
        default is **Qt::AlignLeft** ; for the other styles, the default is
        **Qt::AlignRight** .

        **Access functions:**

        Qt::Alignment **labelAlignment** () const
        void **setLabelAlignment**
        (Qt::Alignment **alignment** )

        **See also** **formAlignment** .
        """
        ...

    def rowWrapPolicy(self) -> "QFormLayout.RowWrapPolicy":
        """
        https://doc.qt.io/qt-5/qformlayout.html#rowWrapPolicy-prop

        **rowWrapPolicy : RowWrapPolicy**

        This property holds the way in which the form's rows wrap

        The default value depends on the widget or application style. For Qt
        Extended styles, the default is **WrapLongRows** ; for the other styles,
        the default is **DontWrapRows** .

        If you want to display each label above its associated field (instead of
        next to it), set this property to **WrapAllRows** .

        **Access functions:**

        QFormLayout::RowWrapPolicy **rowWrapPolicy** () const
        void
        **setRowWrapPolicy** (QFormLayout::RowWrapPolicy **policy** )

        **See also** **fieldGrowthPolicy** .
        """
        ...

    def setRowWrapPolicy(self, policy: "QFormLayout.RowWrapPolicy") -> None:
        """
        https://doc.qt.io/qt-5/qformlayout.html#rowWrapPolicy-prop

        **rowWrapPolicy : RowWrapPolicy**

        This property holds the way in which the form's rows wrap

        The default value depends on the widget or application style. For Qt
        Extended styles, the default is **WrapLongRows** ; for the other styles,
        the default is **DontWrapRows** .

        If you want to display each label above its associated field (instead of
        next to it), set this property to **WrapAllRows** .

        **Access functions:**

        QFormLayout::RowWrapPolicy **rowWrapPolicy** () const
        void
        **setRowWrapPolicy** (QFormLayout::RowWrapPolicy **policy** )

        **See also** **fieldGrowthPolicy** .
        """
        ...

    def fieldGrowthPolicy(self) -> "QFormLayout.FieldGrowthPolicy":
        """
        https://doc.qt.io/qt-5/qformlayout.html#fieldGrowthPolicy-prop

        **fieldGrowthPolicy : FieldGrowthPolicy**

        This property holds the way in which the form's fields grow

        The default value depends on the widget or application style. For
        QMacStyle, the default is **FieldsStayAtSizeHint** ; for
        **QCommonStyle**  derived styles (like Plastique and Windows), the
        default is **ExpandingFieldsGrow** ; for Qt Extended styles, the default
        is **AllNonFixedFieldsGrow** .

        If none of the fields can grow and the form is resized, extra space is
        distributed according to the current **form alignment** .

        **Access functions:**

        QFormLayout::FieldGrowthPolicy **fieldGrowthPolicy** () const
        void
        **setFieldGrowthPolicy** (QFormLayout::FieldGrowthPolicy **policy** )

        **See also** **formAlignment**  and **rowWrapPolicy** .
        """
        ...

    def setFieldGrowthPolicy(self, policy: "QFormLayout.FieldGrowthPolicy") -> None:
        """
        https://doc.qt.io/qt-5/qformlayout.html#fieldGrowthPolicy-prop

        **fieldGrowthPolicy : FieldGrowthPolicy**

        This property holds the way in which the form's fields grow

        The default value depends on the widget or application style. For
        QMacStyle, the default is **FieldsStayAtSizeHint** ; for
        **QCommonStyle**  derived styles (like Plastique and Windows), the
        default is **ExpandingFieldsGrow** ; for Qt Extended styles, the default
        is **AllNonFixedFieldsGrow** .

        If none of the fields can grow and the form is resized, extra space is
        distributed according to the current **form alignment** .

        **Access functions:**

        QFormLayout::FieldGrowthPolicy **fieldGrowthPolicy** () const
        void
        **setFieldGrowthPolicy** (QFormLayout::FieldGrowthPolicy **policy** )

        **See also** **formAlignment**  and **rowWrapPolicy** .
        """
        ...
