"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QComboBox(QWidget):
    """
    https://doc.qt.io/qt-5/qcombobox.html

    **Detailed Description**

    ![](images/windows-combobox.png)

    A QComboBox provides a means of presenting a list of options to the user in
    a way that takes up the minimum amount of screen space.

    A combobox is a selection widget that displays the current item, and can pop
    up a list of selectable items. A combobox may be editable, allowing the user
    to modify each item in the list.

    Comboboxes can contain pixmaps as well as strings; the **insertItem** () and
    **setItemText** () functions are suitably overloaded. For editable
    comboboxes, the function **clearEditText** () is provided, to clear the
    displayed string without changing the combobox's contents.

    There are three signals emitted if the current item of a combobox changes,
    **currentIndexChanged** (), **currentTextChanged** () and **activated** ().
    **currentIndexChanged** () and **currentTextChanged** () are always emitted
    regardless if the change was done programmatically or by user interaction,
    while **activated** () is only emitted when the change is caused by user
    interaction. The **highlighted** () signal is emitted when the user
    highlights an item in the combobox popup list. All three signals exist in
    two versions, one with a **QString**  argument and one with an `int`
    argument. If the user selects or highlights a pixmap, only the `int` signals
    are emitted. Whenever the text of an editable combobox is changed the
    **editTextChanged** () signal is emitted.

    When the user enters a new string in an editable combobox, the widget may or
    may not insert it, and it can insert it in several locations. The default
    policy is **InsertAtBottom**  but you can change this using
    **setInsertPolicy** ().

    It is possible to constrain the input to an editable combobox using
    **QValidator** ; see **setValidator** (). By default, any input is accepted.

    A combobox can be populated using the insert functions, **insertItem** ()
    and **insertItems** () for example. Items can be changed with
    **setItemText** (). An item can be removed with **removeItem** () and all
    items can be removed with **clear** (). The text of the current item is
    returned by **currentText** (), and the text of a numbered item is returned
    with text(). The current item can be set with **setCurrentIndex** (). The
    number of items in the combobox is returned by **count** (); the maximum
    number of items can be set with **setMaxCount** (). You can allow editing
    using **setEditable** (). For editable comboboxes you can set auto-
    completion using **setCompleter** () and whether or not the user can add
    duplicates is set with **setDuplicatesEnabled** ().

    QComboBox uses the **model/view framework**  for its popup list and to store
    its items. By default a **QStandardItemModel**  stores the items and a
    **QListView**  subclass displays the popuplist. You can access the model and
    view directly (with **model** () and **view** ()), but QComboBox also
    provides functions to set and get item data (e.g., **setItemData** () and
    **itemText** ()). You can also set a new model and view (with **setModel**
    () and **setView** ()). For the text and icon in the combobox label, the
    data in the model that has the **Qt::DisplayRole**  and
    **Qt::DecorationRole**  is used. Note that you cannot alter the
    **SelectionMode**  of the **view** (), e.g., by using **setSelectionMode()**
    .

    **See also** **QLineEdit** , **QSpinBox** , **QRadioButton** ,
    **QButtonGroup** , and **GUI Design Handbook: Combo Box, Drop-Down List
    Box** .
    """

    class SizeAdjustPolicy(int):
        AdjustToContents: QComboBox = ...
        AdjustToContentsOnFirstShow: QComboBox = ...
        AdjustToMinimumContentsLength: QComboBox = ...
        AdjustToMinimumContentsLengthWithIcon: QComboBox = ...

    class InsertPolicy(int):
        NoInsert: QComboBox = ...
        InsertAtTop: QComboBox = ...
        InsertAtCurrent: QComboBox = ...
        InsertAtBottom: QComboBox = ...
        InsertAfterCurrent: QComboBox = ...
        InsertBeforeCurrent: QComboBox = ...
        InsertAlphabetically: QComboBox = ...

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#QComboBox

        **QComboBox::QComboBox(QWidget * parent = nullptr)**

        Constructs a combobox with the given **parent** , using the default
        model **QStandardItemModel** .
        """
        ...

    def placeholderText(self) -> str:
        """
        https://doc.qt.io/qt-5/qcombobox.html#placeholderText-prop

        **placeholderText : QString**

        Sets a **placeholderText** text shown when no valid index is set

        The **placeholderText** will be shown when an invalid index is set. The
        text is not accessible in the dropdown list. When this function is
        called before items are added the placeholder text will be shown,
        otherwise you have to call **setCurrentIndex** (-1) programmatically if
        you want to show the placeholder text. Set an empty placeholder text to
        reset the setting.

        When the **QComboBox**  is editable, use
        **QLineEdit::setPlaceholderText** () instead.

        This property was introduced in Qt 5.15.

        **Access functions:**

        QString **placeholderText** () const
        void **setPlaceholderText**
        (const QString & **placeholderText** )
        """
        ...

    def setPlaceholderText(self, placeholderText: str) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#placeholderText-prop

        **placeholderText : QString**

        Sets a **placeholderText** text shown when no valid index is set

        The **placeholderText** will be shown when an invalid index is set. The
        text is not accessible in the dropdown list. When this function is
        called before items are added the placeholder text will be shown,
        otherwise you have to call **setCurrentIndex** (-1) programmatically if
        you want to show the placeholder text. Set an empty placeholder text to
        reset the setting.

        When the **QComboBox**  is editable, use
        **QLineEdit::setPlaceholderText** () instead.

        This property was introduced in Qt 5.15.

        **Access functions:**

        QString **placeholderText** () const
        void **setPlaceholderText**
        (const QString & **placeholderText** )
        """
        ...

    def currentData(self, role: int = ...) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qcombobox.html#currentData-prop

        **currentData : const QVariant**

        This property holds the data for the current item

        By default, for an empty combo box or a combo box in which no current
        item is set, this property contains an invalid **QVariant** .

        This property was introduced in Qt 5.2.

        **Access functions:**

        QVariant **currentData** (int **role** = Qt::UserRole) const
        """
        ...

    @typing.overload
    def inputMethodQuery(self, a0: QtCore.Qt.InputMethodQuery) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qcombobox.html#inputMethodQuery

        **[override virtual] QVariant
        QComboBox::inputMethodQuery(Qt::InputMethodQuery query ) const**

        Reimplements: **QWidget::inputMethodQuery** (Qt::InputMethodQuery query)
        const.
        """
        ...

    @typing.overload
    def inputMethodQuery(
        self, query: QtCore.Qt.InputMethodQuery, argument: typing.Any
    ) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qcombobox.html#inputMethodQuery

        **[override virtual] QVariant
        QComboBox::inputMethodQuery(Qt::InputMethodQuery query ) const**

        Reimplements: **QWidget::inputMethodQuery** (Qt::InputMethodQuery query)
        const.
        """
        ...

    def inputMethodEvent(self, a0: QtGui.QInputMethodEvent) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#inputMethodEvent

        **[override virtual protected] void
        QComboBox::inputMethodEvent(QInputMethodEvent * e )**

        Reimplements: **QWidget::inputMethodEvent** (QInputMethodEvent *event).
        """
        ...

    def contextMenuEvent(self, e: QtGui.QContextMenuEvent) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#contextMenuEvent

        **[override virtual protected] void
        QComboBox::contextMenuEvent(QContextMenuEvent * e )**

        Reimplements: **QWidget::contextMenuEvent** (QContextMenuEvent *event).
        """
        ...

    def wheelEvent(self, e: QtGui.QWheelEvent) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#wheelEvent

        **[override virtual protected] void QComboBox::wheelEvent(QWheelEvent *
        e )**

        Reimplements: **QWidget::wheelEvent** (QWheelEvent *event).
        """
        ...

    def keyReleaseEvent(self, e: QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#keyReleaseEvent

        **[override virtual protected] void QComboBox::keyReleaseEvent(QKeyEvent
        * e )**

        Reimplements: **QWidget::keyReleaseEvent** (QKeyEvent *event).
        """
        ...

    def keyPressEvent(self, e: QtGui.QKeyEvent) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#keyPressEvent

        **[override virtual protected] void QComboBox::keyPressEvent(QKeyEvent *
        e )**

        Reimplements: **QWidget::keyPressEvent** (QKeyEvent *event).
        """
        ...

    def mouseReleaseEvent(self, e: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#mouseReleaseEvent

        **[override virtual protected] void
        QComboBox::mouseReleaseEvent(QMouseEvent * e )**

        Reimplements: **QWidget::mouseReleaseEvent** (QMouseEvent *event).
        """
        ...

    def mousePressEvent(self, e: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#mousePressEvent

        **[override virtual protected] void
        QComboBox::mousePressEvent(QMouseEvent * e )**

        Reimplements: **QWidget::mousePressEvent** (QMouseEvent *event).
        """
        ...

    def hideEvent(self, e: QtGui.QHideEvent) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#hideEvent

        **[override virtual protected] void QComboBox::hideEvent(QHideEvent * e
        )**

        Reimplements: **QWidget::hideEvent** (QHideEvent *event).
        """
        ...

    def showEvent(self, e: QtGui.QShowEvent) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#showEvent

        **[override virtual protected] void QComboBox::showEvent(QShowEvent * e
        )**

        Reimplements: **QWidget::showEvent** (QShowEvent *event).
        """
        ...

    def paintEvent(self, e: QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#paintEvent

        **[override virtual protected] void QComboBox::paintEvent(QPaintEvent *
        e )**

        Reimplements: **QWidget::paintEvent** (QPaintEvent *event).
        """
        ...

    def resizeEvent(self, e: QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#resizeEvent

        **[override virtual protected] void QComboBox::resizeEvent(QResizeEvent
        * e )**

        Reimplements: **QWidget::resizeEvent** (QResizeEvent *event).
        """
        ...

    def changeEvent(self, e: QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#changeEvent

        **[override virtual protected] void QComboBox::changeEvent(QEvent * e
        )**

        Reimplements: **QWidget::changeEvent** (QEvent *event).
        """
        ...

    def focusOutEvent(self, e: QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#focusOutEvent

        **[override virtual protected] void QComboBox::focusOutEvent(QFocusEvent
        * e )**

        Reimplements: **QWidget::focusOutEvent** (QFocusEvent *event).
        """
        ...

    def focusInEvent(self, e: QtGui.QFocusEvent) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#focusInEvent

        **[override virtual protected] void QComboBox::focusInEvent(QFocusEvent
        * e )**

        Reimplements: **QWidget::focusInEvent** (QFocusEvent *event).
        """
        ...

    def initStyleOption(self, option: "QStyleOptionComboBox") -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#initStyleOption

        **[protected] void QComboBox::initStyleOption(QStyleOptionComboBox *
        option ) const**

        Initialize **option** with the values from this **QComboBox** . This
        method is useful for subclasses when they need a
        **QStyleOptionComboBox** , but don't want to fill in all the information
        themselves.

        **See also** **QStyleOption::initFrom** ().
        """
        ...

    def setCurrentText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#currentText-prop

        **currentText : QString**

        This property holds the current text

        If the combo box is editable, the current text is the value displayed by
        the line edit. Otherwise, it is the value of the current item or an
        empty string if the combo box is empty or no current item is set.

        The setter setCurrentText() simply calls **setEditText** () if the combo
        box is editable. Otherwise, if there is a matching text in the list,
        **currentIndex**  is set to the corresponding index.

        **Access functions:**

        QString **currentText** () const
        void **setCurrentText** (const
        QString & **text** )

        **Notifier signal:**

        void ****currentTextChanged** ** (const QString & **text** )

        **See also** **editable**  and **setEditText** ().
        """
        ...

    def setEditText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#setEditText

        **[slot] void QComboBox::setEditText(const QString & text )**

        Sets the **text** in the combobox's text edit.
        """
        ...

    def clearEditText(self) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#clearEditText

        **[slot] void QComboBox::clearEditText()**

        Clears the contents of the line edit used for editing in the combobox.
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#clear

        **[slot] void QComboBox::clear()**

        Clears the combobox, removing all items.

        Note: If you have set an external model on the combobox this model will
        still be cleared when calling this function.
        """
        ...

    def insertSeparator(self, index: int) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#insertSeparator

        **void QComboBox::insertSeparator(int index )**

        Inserts a separator item into the combobox at the given **index**.

        If the index is equal to or higher than the total number of items, the
        new item is appended to the list of existing items. If the index is zero
        or negative, the new item is prepended to the list of existing items.

        This function was introduced in Qt 4.4.

        **See also** **insertItem** ().
        """
        ...

    def completer(self) -> "QCompleter":
        """
        https://doc.qt.io/qt-5/qcombobox.html#completer

        **QCompleter *QComboBox::completer() const**

        Returns the completer that is used to auto complete text input for the
        combobox.

        This function was introduced in Qt 4.2.

        **See also** **setCompleter** () and **editable** .
        """
        ...

    def setCompleter(self, c: "QCompleter") -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#setCompleter

        **void QComboBox::setCompleter(QCompleter * completer )**

        Sets the **completer** to use instead of the current completer. If
        **completer** is `nullptr`, auto completion is disabled.

        By default, for an editable combo box, a **QCompleter**  that performs
        case insensitive inline completion is automatically created.

        **Note:** The completer is removed when the **editable**  property
        becomes `false`. Setting a completer on a **QComboBox**  that is not
        editable will be ignored.

        This function was introduced in Qt 4.2.

        **See also** **completer** ().
        """
        ...

    def event(self, event: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qcombobox.html#event

        **[override virtual] bool QComboBox::event(QEvent * event )**

        Reimplements: **QWidget::event** (QEvent *event).
        """
        ...

    def hidePopup(self) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#hidePopup

        **[virtual] void QComboBox::hidePopup()**

        Hides the list of items in the combobox if it is currently visible and
        resets the internal state, so that if the custom pop-up was shown inside
        the reimplemented **showPopup** (), then you also need to reimplement
        the hidePopup() function to hide your custom pop-up and call the base
        class implementation to reset the internal state whenever your custom
        pop-up widget is hidden.

        **See also** **showPopup** ().
        """
        ...

    def showPopup(self) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#showPopup

        **[virtual] void QComboBox::showPopup()**

        Displays the list of items in the combobox. If the list is empty then no
        items will be shown.

        If you reimplement this function to show a custom pop-up, make sure you
        call **hidePopup** () to reset the internal state.

        **See also** **hidePopup** ().
        """
        ...

    def minimumSizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qcombobox.html#minimumSizeHint

        **[override virtual] QSize QComboBox::minimumSizeHint() const**

        Reimplements an access function for property:
        **QWidget::minimumSizeHint** .
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qcombobox.html#sizeHint

        **[override virtual] QSize QComboBox::sizeHint() const**

        Reimplements an access function for property: **QWidget::sizeHint** .

        This implementation caches the size hint to avoid resizing when the
        contents change dynamically. To invalidate the cached value change the
        **sizeAdjustPolicy** .
        """
        ...

    def setView(self, itemView: QAbstractItemView) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#setView

        **void QComboBox::setView(QAbstractItemView * itemView )**

        Sets the view to be used in the combobox popup to the given
        **itemView**. The combobox takes ownership of the view.

        Note: If you want to use the convenience views (like **QListWidget** ,
        **QTableWidget**  or **QTreeWidget** ), make sure to call **setModel**
        () on the combobox with the convenience widgets model before calling
        this function.

        **See also** **view** ().
        """
        ...

    def view(self) -> QAbstractItemView:
        """
        https://doc.qt.io/qt-5/qcombobox.html#view

        **QAbstractItemView *QComboBox::view() const**

        Returns the list view used for the combobox popup.

        **See also** **setView** ().
        """
        ...

    def setItemData(self, index: int, value: typing.Any, role: int = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#setItemData

        **void QComboBox::setItemData(int index , const QVariant & value , int
        role = Qt::UserRole)**

        Sets the data **role** for the item on the given **index** in the
        combobox to the specified **value**.

        **See also** **itemData** ().
        """
        ...

    def setItemIcon(self, index: int, icon: QtGui.QIcon) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#setItemIcon

        **void QComboBox::setItemIcon(int index , const QIcon & icon )**

        Sets the **icon** for the item on the given **index** in the combobox.

        **See also** **itemIcon** ().
        """
        ...

    def setItemText(self, index: int, text: str) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#setItemText

        **void QComboBox::setItemText(int index , const QString & text )**

        Sets the **text** for the item on the given **index** in the combobox.

        **See also** **itemText** ().
        """
        ...

    def removeItem(self, index: int) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#removeItem

        **void QComboBox::removeItem(int index )**

        Removes the item at the given **index** from the combobox. This will
        update the current index if the index is removed.

        This function does nothing if **index** is out of range.
        """
        ...

    def insertItems(self, index: int, texts: typing.Iterable[str]) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#insertItems

        **void QComboBox::insertItems(int index , const QStringList & list )**

        Inserts the strings from the **list** into the combobox as separate
        items, starting at the **index** specified.

        If the index is equal to or higher than the total number of items, the
        new items are appended to the list of existing items. If the index is
        zero or negative, the new items are prepended to the list of existing
        items.

        **See also** **insertItem** ().
        """
        ...

    @typing.overload
    def insertItem(self, index: int, text: str, userData: typing.Any = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#insertItem

        **void QComboBox::insertItem(int index , const QString & text , const
        QVariant & userData = QVariant())**

        Inserts the **text** and **userData** (stored in the **Qt::UserRole** )
        into the combobox at the given **index**.

        If the index is equal to or higher than the total number of items, the
        new item is appended to the list of existing items. If the index is zero
        or negative, the new item is prepended to the list of existing items.

        **See also** **insertItems** ().
        """
        ...

    @typing.overload
    def insertItem(
        self, index: int, icon: QtGui.QIcon, text: str, userData: typing.Any = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#insertItem-1

        **void QComboBox::insertItem(int index , const QIcon & icon , const
        QString & text , const QVariant & userData = QVariant())**

        Inserts the **icon** , **text** and **userData** (stored in the
        **Qt::UserRole** ) into the combobox at the given **index**.

        If the index is equal to or higher than the total number of items, the
        new item is appended to the list of existing items. If the index is zero
        or negative, the new item is prepended to the list of existing items.

        **See also** **insertItems** ().
        """
        ...

    @typing.overload
    def addItem(self, text: str, userData: typing.Any = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#addItem

        **void QComboBox::addItem(const QString & text , const QVariant &
        userData = QVariant())**

        Adds an item to the combobox with the given **text** , and containing
        the specified **userData** (stored in the **Qt::UserRole** ). The item
        is appended to the list of existing items.
        """
        ...

    @typing.overload
    def addItem(self, icon: QtGui.QIcon, text: str, userData: typing.Any = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#addItem-1

        **void QComboBox::addItem(const QIcon & icon , const QString & text ,
        const QVariant & userData = QVariant())**

        Adds an item to the combobox with the given **icon** and **text** , and
        containing the specified **userData** (stored in the **Qt::UserRole** ).
        The item is appended to the list of existing items.
        """
        ...

    def addItems(self, texts: typing.Iterable[str]) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#addItems

        **void QComboBox::addItems(const QStringList & texts )**

        Adds each of the strings in the given **texts** to the combobox. Each
        item is appended to the list of existing items in turn.
        """
        ...

    def itemData(self, index: int, role: int = ...) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qcombobox.html#itemData

        **QVariant QComboBox::itemData(int index , int role = Qt::UserRole)
        const**

        Returns the data for the given **role** in the given **index** in the
        combobox, or QVariant::Invalid if there is no data for this role.

        **See also** **setItemData** ().
        """
        ...

    def itemIcon(self, index: int) -> QtGui.QIcon:
        """
        https://doc.qt.io/qt-5/qcombobox.html#itemIcon

        **QIcon QComboBox::itemIcon(int index ) const**

        Returns the icon for the given **index** in the combobox.

        **See also** **setItemIcon** ().
        """
        ...

    def itemText(self, index: int) -> str:
        """
        https://doc.qt.io/qt-5/qcombobox.html#itemText

        **QString QComboBox::itemText(int index ) const**

        Returns the text for the given **index** in the combobox.

        **See also** **setItemText** ().
        """
        ...

    def currentText(self) -> str:
        """
        https://doc.qt.io/qt-5/qcombobox.html#currentText-prop

        **currentText : QString**

        This property holds the current text

        If the combo box is editable, the current text is the value displayed by
        the line edit. Otherwise, it is the value of the current item or an
        empty string if the combo box is empty or no current item is set.

        The setter setCurrentText() simply calls **setEditText** () if the combo
        box is editable. Otherwise, if there is a matching text in the list,
        **currentIndex**  is set to the corresponding index.

        **Access functions:**

        QString **currentText** () const
        void **setCurrentText** (const
        QString & **text** )

        **Notifier signal:**

        void ****currentTextChanged** ** (const QString & **text** )

        **See also** **editable**  and **setEditText** ().
        """
        ...

    def setCurrentIndex(self, index: int) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#currentIndex-prop

        **currentIndex : int**

        This property holds the index of the current item in the combobox.

        The current index can change when inserting or removing items.

        By default, for an empty combo box or a combo box in which no current
        item is set, this property has a value of -1.

        **Access functions:**

        int **currentIndex** () const
        void **setCurrentIndex** (int **index**
        )

        **Notifier signal:**

        void ****currentIndexChanged** ** (int **index** )
        """
        ...

    def currentIndex(self) -> int:
        """
        https://doc.qt.io/qt-5/qcombobox.html#currentIndex-prop

        **currentIndex : int**

        This property holds the index of the current item in the combobox.

        The current index can change when inserting or removing items.

        By default, for an empty combo box or a combo box in which no current
        item is set, this property has a value of -1.

        **Access functions:**

        int **currentIndex** () const
        void **setCurrentIndex** (int **index**
        )

        **Notifier signal:**

        void ****currentIndexChanged** ** (int **index** )
        """
        ...

    def setModelColumn(self, visibleColumn: int) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#modelColumn-prop

        **modelColumn : int**

        This property holds the column in the model that is visible.

        If set prior to populating the combo box, the pop-up view will not be
        affected and will show the first column (using this property's default
        value).

        By default, this property has a value of 0.

        **Access functions:**

        int **modelColumn** () const
        void **setModelColumn** (int
        **visibleColumn** )
        """
        ...

    def modelColumn(self) -> int:
        """
        https://doc.qt.io/qt-5/qcombobox.html#modelColumn-prop

        **modelColumn : int**

        This property holds the column in the model that is visible.

        If set prior to populating the combo box, the pop-up view will not be
        affected and will show the first column (using this property's default
        value).

        By default, this property has a value of 0.

        **Access functions:**

        int **modelColumn** () const
        void **setModelColumn** (int
        **visibleColumn** )
        """
        ...

    def setRootModelIndex(self, index: QtCore.QModelIndex) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#setRootModelIndex

        **void QComboBox::setRootModelIndex(const QModelIndex & index )**

        Sets the root model item **index** for the items in the combobox.

        **See also** **rootModelIndex** ().
        """
        ...

    def rootModelIndex(self) -> QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-5/qcombobox.html#rootModelIndex

        **QModelIndex QComboBox::rootModelIndex() const**

        Returns the root model item index for the items in the combobox.

        **See also** **setRootModelIndex** ().
        """
        ...

    def setModel(self, model: QtCore.QAbstractItemModel) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#setModel

        **void QComboBox::setModel(QAbstractItemModel * model )**

        Sets the model to be **model**. **model** must not be `nullptr`. If you
        want to clear the contents of a model, call **clear** ().

        **See also** **model** () and **clear** ().
        """
        ...

    def model(self) -> QtCore.QAbstractItemModel:
        """
        https://doc.qt.io/qt-5/qcombobox.html#model

        **QAbstractItemModel *QComboBox::model() const**

        Returns the model used by the combobox.

        **See also** **setModel** ().
        """
        ...

    def setItemDelegate(self, delegate: QAbstractItemDelegate) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#setItemDelegate

        **void QComboBox::setItemDelegate(QAbstractItemDelegate * delegate )**

        Sets the item **delegate** for the popup list view. The combobox takes
        ownership of the delegate.

        **Warning:** You should not share the same instance of a delegate
        between comboboxes, widget mappers or views. Doing so can cause
        incorrect or unintuitive editing behavior since each view connected to a
        given delegate may receive the **closeEditor()**  signal, and attempt to
        access, modify or close an editor that has already been closed.

        **See also** **itemDelegate** ().
        """
        ...

    def itemDelegate(self) -> QAbstractItemDelegate:
        """
        https://doc.qt.io/qt-5/qcombobox.html#itemDelegate

        **QAbstractItemDelegate *QComboBox::itemDelegate() const**

        Returns the item delegate used by the popup list view.

        **See also** **setItemDelegate** ().
        """
        ...

    def validator(self) -> QtGui.QValidator:
        """
        https://doc.qt.io/qt-5/qcombobox.html#validator

        **const QValidator *QComboBox::validator() const**

        Returns the validator that is used to constrain text input for the
        combobox.

        **See also** **setValidator** () and **editable** .
        """
        ...

    def setValidator(self, v: QtGui.QValidator) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#setValidator

        **void QComboBox::setValidator(const QValidator * validator )**

        Sets the **validator** to use instead of the current validator.

        **Note:** The validator is removed when the **editable**  property
        becomes `false`.

        **See also** **validator** ().
        """
        ...

    def lineEdit(self) -> "QLineEdit":
        """
        https://doc.qt.io/qt-5/qcombobox.html#lineEdit

        **QLineEdit *QComboBox::lineEdit() const**

        Returns the line edit used to edit items in the combobox, or `nullptr`
        if there is no line edit.

        Only editable combo boxes have a line edit.

        **See also** **setLineEdit** ().
        """
        ...

    def setLineEdit(self, edit: "QLineEdit") -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#setLineEdit

        **void QComboBox::setLineEdit(QLineEdit * edit )**

        Sets the line **edit** to use instead of the current line edit widget.

        The combo box takes ownership of the line edit.

        **See also** **lineEdit** ().
        """
        ...

    def setEditable(self, editable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#editable-prop

        **editable : bool**

        This property holds whether the combo box can be edited by the user

        By default, this property is `false`. The effect of editing depends on
        the insert policy.

        **Note:** When disabling the **editable** state, the validator and
        completer are removed.

        **Access functions:**

        bool **isEditable** () const
        void **setEditable** (bool **editable** )

        **See also** **InsertPolicy** .
        """
        ...

    def isEditable(self) -> bool:
        ...

    def setIconSize(self, size: QtCore.QSize) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#iconSize-prop

        **iconSize : QSize**

        This property holds the size of the icons shown in the combobox.

        Unless explicitly set this returns the default value of the current
        style. This size is the maximum size that icons can have; icons of
        smaller size are not scaled up.

        **Access functions:**

        QSize **iconSize** () const
        void **setIconSize** (const QSize &
        **size** )
        """
        ...

    def iconSize(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qcombobox.html#iconSize-prop

        **iconSize : QSize**

        This property holds the size of the icons shown in the combobox.

        Unless explicitly set this returns the default value of the current
        style. This size is the maximum size that icons can have; icons of
        smaller size are not scaled up.

        **Access functions:**

        QSize **iconSize** () const
        void **setIconSize** (const QSize &
        **size** )
        """
        ...

    def setMinimumContentsLength(self, characters: int) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#minimumContentsLength-prop

        **minimumContentsLength : int**

        This property holds the minimum number of characters that should fit
        into the combobox.

        The default value is 0.

        If this property is set to a positive value, the **minimumSizeHint** ()
        and **sizeHint** () take it into account.

        **Access functions:**

        int **minimumContentsLength** () const
        void
        **setMinimumContentsLength** (int **characters** )

        **See also** **sizeAdjustPolicy** .
        """
        ...

    def minimumContentsLength(self) -> int:
        """
        https://doc.qt.io/qt-5/qcombobox.html#minimumContentsLength-prop

        **minimumContentsLength : int**

        This property holds the minimum number of characters that should fit
        into the combobox.

        The default value is 0.

        If this property is set to a positive value, the **minimumSizeHint** ()
        and **sizeHint** () take it into account.

        **Access functions:**

        int **minimumContentsLength** () const
        void
        **setMinimumContentsLength** (int **characters** )

        **See also** **sizeAdjustPolicy** .
        """
        ...

    def setSizeAdjustPolicy(self, policy: "QComboBox.SizeAdjustPolicy") -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#sizeAdjustPolicy-prop

        **sizeAdjustPolicy : SizeAdjustPolicy**

        This property holds the policy describing how the size of the combobox
        changes when the content changes

        The default value is **AdjustToContentsOnFirstShow** .

        **Access functions:**

        QComboBox::SizeAdjustPolicy **sizeAdjustPolicy** () const
        void
        **setSizeAdjustPolicy** (QComboBox::SizeAdjustPolicy **policy** )

        **See also** **SizeAdjustPolicy** .

        **Member Function Documentation**
        """
        ...

    def sizeAdjustPolicy(self) -> "QComboBox.SizeAdjustPolicy":
        """
        https://doc.qt.io/qt-5/qcombobox.html#sizeAdjustPolicy-prop

        **sizeAdjustPolicy : SizeAdjustPolicy**

        This property holds the policy describing how the size of the combobox
        changes when the content changes

        The default value is **AdjustToContentsOnFirstShow** .

        **Access functions:**

        QComboBox::SizeAdjustPolicy **sizeAdjustPolicy** () const
        void
        **setSizeAdjustPolicy** (QComboBox::SizeAdjustPolicy **policy** )

        **See also** **SizeAdjustPolicy** .

        **Member Function Documentation**
        """
        ...

    def setInsertPolicy(self, policy: "QComboBox.InsertPolicy") -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#insertPolicy-prop

        **insertPolicy : InsertPolicy**

        This property holds the policy used to determine where user-inserted
        items should appear in the combobox

        The default value is **InsertAtBottom** , indicating that new items will
        appear at the bottom of the list of items.

        **Access functions:**

        QComboBox::InsertPolicy **insertPolicy** () const
        void
        **setInsertPolicy** (QComboBox::InsertPolicy **policy** )

        **See also** **InsertPolicy** .
        """
        ...

    def insertPolicy(self) -> "QComboBox.InsertPolicy":
        """
        https://doc.qt.io/qt-5/qcombobox.html#insertPolicy-prop

        **insertPolicy : InsertPolicy**

        This property holds the policy used to determine where user-inserted
        items should appear in the combobox

        The default value is **InsertAtBottom** , indicating that new items will
        appear at the bottom of the list of items.

        **Access functions:**

        QComboBox::InsertPolicy **insertPolicy** () const
        void
        **setInsertPolicy** (QComboBox::InsertPolicy **policy** )

        **See also** **InsertPolicy** .
        """
        ...

    def findData(
        self,
        data: typing.Any,
        role: int = ...,
        flags: typing.Union[QtCore.Qt.MatchFlags, QtCore.Qt.MatchFlag] = ...,
    ) -> int:
        """
        https://doc.qt.io/qt-5/qcombobox.html#findData

        **int QComboBox::findData(const QVariant & data , int role =
        Qt::UserRole, Qt::MatchFlags flags =
        static_cast<Qt::MatchFlags>(Qt::MatchExactly|Qt::MatchCaseSensitive))
        const**

        Returns the index of the item containing the given **data** for the
        given **role** ; otherwise returns -1.

        The **flags** specify how the items in the combobox are searched.
        """
        ...

    def findText(
        self,
        text: str,
        flags: typing.Union[QtCore.Qt.MatchFlags, QtCore.Qt.MatchFlag] = ...,
    ) -> int:
        """
        https://doc.qt.io/qt-5/qcombobox.html#findText

        **int QComboBox::findText(const QString & text , Qt::MatchFlags flags =
        Qt::MatchExactly|Qt::MatchCaseSensitive) const**

        Returns the index of the item containing the given **text** ; otherwise
        returns -1.

        The **flags** specify how the items in the combobox are searched.
        """
        ...

    def hasFrame(self) -> bool:
        ...

    def setFrame(self, a0: bool) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#frame-prop

        **frame : bool**

        This property holds whether the combo box draws itself with a frame

        If enabled (the default) the combo box draws itself inside a frame,
        otherwise the combo box draws itself without any frame.

        **Access functions:**

        bool **hasFrame** () const
        void **setFrame** ( **bool** )
        """
        ...

    def setDuplicatesEnabled(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#duplicatesEnabled-prop

        **duplicatesEnabled : bool**

        This property holds whether the user can enter duplicate items into the
        combobox

        Note that it is always possible to programmatically insert duplicate
        items into the combobox.

        By default, this property is `false` (duplicates are not allowed).

        **Access functions:**

        bool **duplicatesEnabled** () const
        void **setDuplicatesEnabled**
        (bool **enable** )
        """
        ...

    def duplicatesEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-5/qcombobox.html#duplicatesEnabled-prop

        **duplicatesEnabled : bool**

        This property holds whether the user can enter duplicate items into the
        combobox

        Note that it is always possible to programmatically insert duplicate
        items into the combobox.

        By default, this property is `false` (duplicates are not allowed).

        **Access functions:**

        bool **duplicatesEnabled** () const
        void **setDuplicatesEnabled**
        (bool **enable** )
        """
        ...

    def maxCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qcombobox.html#maxCount-prop

        **maxCount : int**

        This property holds the maximum number of items allowed in the combobox

        **Note:** If you set the maximum number to be less then the current
        amount of items in the combobox, the extra items will be truncated. This
        also applies if you have set an external model on the combobox.

        By default, this property's value is derived from the highest signed
        integer available (typically 2147483647).

        **Access functions:**

        int **maxCount** () const
        void **setMaxCount** (int **max** )
        """
        ...

    def setMaxCount(self, max: int) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#maxCount-prop

        **maxCount : int**

        This property holds the maximum number of items allowed in the combobox

        **Note:** If you set the maximum number to be less then the current
        amount of items in the combobox, the extra items will be truncated. This
        also applies if you have set an external model on the combobox.

        By default, this property's value is derived from the highest signed
        integer available (typically 2147483647).

        **Access functions:**

        int **maxCount** () const
        void **setMaxCount** (int **max** )
        """
        ...

    def __len__(self) -> int:
        ...

    def count(self) -> int:
        """
        https://doc.qt.io/qt-5/qcombobox.html#count-prop

        **count : const int**

        This property holds the number of items in the combobox

        By default, for an empty combo box, this property has a value of 0.

        **Access functions:**

        int **count** () const
        """
        ...

    def setMaxVisibleItems(self, maxItems: int) -> None:
        """
        https://doc.qt.io/qt-5/qcombobox.html#maxVisibleItems-prop

        **maxVisibleItems : int**

        This property holds the maximum allowed size on screen of the combo box,
        measured in items

        By default, this property has a value of 10.

        **Note:** This property is ignored for non-editable comboboxes in styles
        that returns true for **QStyle::SH_ComboBox_Popup**  such as the Mac
        style or the Gtk+ Style.

        **Access functions:**

        int **maxVisibleItems** () const
        void **setMaxVisibleItems** (int
        **maxItems** )
        """
        ...

    def maxVisibleItems(self) -> int:
        """
        https://doc.qt.io/qt-5/qcombobox.html#maxVisibleItems-prop

        **maxVisibleItems : int**

        This property holds the maximum allowed size on screen of the combo box,
        measured in items

        By default, this property has a value of 10.

        **Note:** This property is ignored for non-editable comboboxes in styles
        that returns true for **QStyle::SH_ComboBox_Popup**  such as the Mac
        style or the Gtk+ Style.

        **Access functions:**

        int **maxVisibleItems** () const
        void **setMaxVisibleItems** (int
        **maxItems** )
        """
        ...

    @property
    def activated(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcombobox.html#activated

        **[signal] void QComboBox::activated(int index )**

        This signal is sent when the user chooses an item in the combobox. The
        item's **index** is passed. Note that this signal is sent even when the
        choice is not changed. If you need to know when the choice actually
        changes, use signal **currentIndexChanged** () or **currentTextChanged**
        ().

        **Note:** Signal **activated** is overloaded in this class. To connect
        to this signal by using the function pointer syntax, Qt provides a
        convenient helper for obtaining the function pointer as shown in this
        example:

        connect(comboBox, QOverload<int>::of(&**QComboBox** ::activated),
        [=](int index){ /* ... */ });
        """
        ...

    @property
    def currentIndexChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcombobox.html#currentIndexChanged

        **[signal] void QComboBox::currentIndexChanged(int index )**

        This signal is sent whenever the **currentIndex**  in the combobox
        changes either through user interaction or programmatically. The item's
        **index** is passed or -1 if the combobox becomes empty or the
        **currentIndex**  was reset.

        **Note:** Notifier signal for property **currentIndex** .

        **Note:** Signal **currentIndexChanged** is overloaded in this class. To
        connect to this signal by using the function pointer syntax, Qt provides
        a convenient helper for obtaining the function pointer as shown in this
        example:

        connect(comboBox, QOverload<int>::of(&**QComboBox**
        ::currentIndexChanged),
                [=](int index){ /* ... */ });

        This function was introduced in Qt 4.1.
        """
        ...

    @property
    def currentTextChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcombobox.html#currentTextChanged

        **[signal] void QComboBox::currentTextChanged(const QString & text )**

        This signal is sent whenever **currentText**  changes. The new value is
        passed as **text**.

        **Note:** Notifier signal for property **currentText** .

        This function was introduced in Qt 5.0.
        """
        ...

    @property
    def editTextChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcombobox.html#editTextChanged

        **[signal] void QComboBox::editTextChanged(const QString & text )**

        This signal is emitted when the text in the combobox's line edit widget
        is changed. The new text is specified by **text**.
        """
        ...

    @property
    def highlighted(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcombobox.html#highlighted

        **[signal] void QComboBox::highlighted(int index )**

        This signal is sent when an item in the combobox popup list is
        highlighted by the user. The item's **index** is passed.

        **Note:** Signal **highlighted** is overloaded in this class. To connect
        to this signal by using the function pointer syntax, Qt provides a
        convenient helper for obtaining the function pointer as shown in this
        example:

        connect(comboBox, QOverload<int>::of(&**QComboBox** ::highlighted),
        [=](int index){ /* ... */ });
        """
        ...

    @property
    def textActivated(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcombobox.html#textActivated

        **[signal] void QComboBox::textActivated(const QString & text )**

        This signal is sent when the user chooses an item in the combobox. The
        item's **text** is passed. Note that this signal is sent even when the
        choice is not changed. If you need to know when the choice actually
        changes, use signal **currentIndexChanged** () or **currentTextChanged**
        ().

        This function was introduced in Qt 5.14.
        """
        ...

    @property
    def textHighlighted(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcombobox.html#textHighlighted

        **[signal] void QComboBox::textHighlighted(const QString & text )**

        This signal is sent when an item in the combobox popup list is
        highlighted by the user. The item's **text** is passed.

        This function was introduced in Qt 5.14.
        """
        ...
