"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QColumnView(QAbstractItemView):
    """
    https://doc.qt.io/qt-5/qcolumnview.html

    **Detailed Description**

    QColumnView displays a model in a number of QListViews, one for each
    hierarchy in the tree. This is sometimes referred to as a cascading list.

    The QColumnView class is one of the **Model/View Classes**  and is part of
    Qt's **model/view framework** .

    QColumnView implements the interfaces defined by the **QAbstractItemView**
    class to allow it to display data provided by models derived from the
    **QAbstractItemModel**  class.

    ![](images/qcolumnview.png)

    **See also** **Model/View Programming** .
    """

    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcolumnview.html#QColumnView

        **QColumnView::QColumnView(QWidget * parent = nullptr)**

        Constructs a column view with a **parent** to represent a model's data.
        Use **setModel** () to set the model.

        **See also** **QAbstractItemModel** .
        """
        ...

    def currentChanged(
        self, current: QtCore.QModelIndex, previous: QtCore.QModelIndex
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcolumnview.html#currentChanged

        **[override virtual protected] void QColumnView::currentChanged(const
        QModelIndex & current , const QModelIndex & previous )**

        Reimplements: **QAbstractItemView::currentChanged** (const QModelIndex
        &current, const QModelIndex &previous).
        """
        ...

    def rowsInserted(self, parent: QtCore.QModelIndex, start: int, end: int) -> None:
        """
        https://doc.qt.io/qt-5/qcolumnview.html#rowsInserted

        **[override virtual protected] void QColumnView::rowsInserted(const
        QModelIndex & parent , int start , int end )**

        Reimplements: **QAbstractItemView::rowsInserted** (const QModelIndex
        &parent, int start, int end).
        """
        ...

    def scrollContentsBy(self, dx: int, dy: int) -> None:
        """
        https://doc.qt.io/qt-5/qcolumnview.html#scrollContentsBy

        **[override virtual protected] void QColumnView::scrollContentsBy(int dx
        , int dy )**

        Reimplements: **QAbstractScrollArea::scrollContentsBy** (int dx, int
        dy).
        """
        ...

    def verticalOffset(self) -> int:
        """
        https://doc.qt.io/qt-5/qcolumnview.html#verticalOffset

        **[override virtual protected] int QColumnView::verticalOffset() const**

        Reimplements: **QAbstractItemView::verticalOffset** () const.
        """
        ...

    def horizontalOffset(self) -> int:
        """
        https://doc.qt.io/qt-5/qcolumnview.html#horizontalOffset

        **[override virtual protected] int QColumnView::horizontalOffset()
        const**

        Reimplements: **QAbstractItemView::horizontalOffset** () const.
        """
        ...

    def visualRegionForSelection(
        self, selection: QtCore.QItemSelection
    ) -> QtGui.QRegion:
        """
        https://doc.qt.io/qt-5/qcolumnview.html#visualRegionForSelection

        **[override virtual protected] QRegion
        QColumnView::visualRegionForSelection(const QItemSelection & selection )
        const**

        Reimplements: **QAbstractItemView::visualRegionForSelection** (const
        QItemSelection &selection) const.
        """
        ...

    def setSelection(
        self,
        rect: QtCore.QRect,
        command: typing.Union[
            QtCore.QItemSelectionModel.SelectionFlags,
            QtCore.QItemSelectionModel.SelectionFlag,
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcolumnview.html#setSelection

        **[override virtual protected] void QColumnView::setSelection(const
        QRect & rect , QItemSelectionModel::SelectionFlags command )**

        Reimplements: **QAbstractItemView::setSelection** (const QRect &rect,
        QItemSelectionModel::SelectionFlags flags).
        """
        ...

    def resizeEvent(self, event: QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-5/qcolumnview.html#resizeEvent

        **[override virtual protected] void
        QColumnView::resizeEvent(QResizeEvent * event )**

        Reimplements: **QAbstractItemView::resizeEvent** (QResizeEvent *event).
        """
        ...

    def moveCursor(
        self,
        cursorAction: QAbstractItemView.CursorAction,
        modifiers: typing.Union[
            QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier
        ],
    ) -> QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-5/qcolumnview.html#moveCursor

        **[override virtual protected] QModelIndex
        QColumnView::moveCursor(QAbstractItemView::CursorAction cursorAction ,
        Qt::KeyboardModifiers modifiers )**

        Reimplements: **QAbstractItemView::moveCursor**
        (QAbstractItemView::CursorAction cursorAction, Qt::KeyboardModifiers
        modifiers).

        Move left should go to the parent index Move right should go to the
        child index or down if there is no child
        """
        ...

    def isIndexHidden(self, index: QtCore.QModelIndex) -> bool:
        """
        https://doc.qt.io/qt-5/qcolumnview.html#isIndexHidden

        **[override virtual protected] bool QColumnView::isIndexHidden(const
        QModelIndex & index ) const**

        Reimplements: **QAbstractItemView::isIndexHidden** (const QModelIndex
        &index) const.
        """
        ...

    def initializeColumn(self, column: QAbstractItemView) -> None:
        """
        https://doc.qt.io/qt-5/qcolumnview.html#initializeColumn

        **[protected] void QColumnView::initializeColumn(QAbstractItemView *
        column ) const**

        Copies the behavior and options of the column view and applies them to
        the **column** such as the **iconSize** (), **textElideMode** () and
        **alternatingRowColors** (). This can be useful when reimplementing
        **createColumn** ().

        This function was introduced in Qt 4.4.

        **See also** **createColumn** ().
        """
        ...

    def createColumn(self, rootIndex: QtCore.QModelIndex) -> QAbstractItemView:
        """
        https://doc.qt.io/qt-5/qcolumnview.html#createColumn

        **[virtual protected] QAbstractItemView *QColumnView::createColumn(const
        QModelIndex & index )**

        To use a custom widget for the final column when you select an item
        overload this function and return a widget. **index** is the root index
        that will be assigned to the view.

        Return the new view. **QColumnView**  will automatically take ownership
        of the widget.

        **See also** **setPreviewWidget** ().
        """
        ...

    def selectAll(self) -> None:
        """
        https://doc.qt.io/qt-5/qcolumnview.html#selectAll

        **[override virtual] void QColumnView::selectAll()**

        Reimplements: **QAbstractItemView::selectAll** ().
        """
        ...

    def setRootIndex(self, index: QtCore.QModelIndex) -> None:
        """
        https://doc.qt.io/qt-5/qcolumnview.html#setRootIndex

        **[override virtual] void QColumnView::setRootIndex(const QModelIndex &
        index )**

        Reimplements: **QAbstractItemView::setRootIndex** (const QModelIndex
        &index).
        """
        ...

    def setSelectionModel(self, selectionModel: QtCore.QItemSelectionModel) -> None:
        """
        https://doc.qt.io/qt-5/qcolumnview.html#setSelectionModel

        **[override virtual] void
        QColumnView::setSelectionModel(QItemSelectionModel * newSelectionModel
        )**

        Reimplements: **QAbstractItemView::setSelectionModel**
        (QItemSelectionModel *selectionModel).
        """
        ...

    def setModel(self, model: QtCore.QAbstractItemModel) -> None:
        """
        https://doc.qt.io/qt-5/qcolumnview.html#setModel

        **[override virtual] void QColumnView::setModel(QAbstractItemModel *
        model )**

        Reimplements: **QAbstractItemView::setModel** (QAbstractItemModel
        *model).
        """
        ...

    def visualRect(self, index: QtCore.QModelIndex) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qcolumnview.html#visualRect

        **[override virtual] QRect QColumnView::visualRect(const QModelIndex &
        index ) const**

        Reimplements: **QAbstractItemView::visualRect** (const QModelIndex
        &index) const.
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qcolumnview.html#sizeHint

        **[override virtual] QSize QColumnView::sizeHint() const**

        Reimplements: **QAbstractScrollArea::sizeHint** () const.
        """
        ...

    def scrollTo(
        self, index: QtCore.QModelIndex, hint: QAbstractItemView.ScrollHint = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcolumnview.html#scrollTo

        **[override virtual] void QColumnView::scrollTo(const QModelIndex &
        index , QAbstractItemView::ScrollHint hint = EnsureVisible)**

        Reimplements: **QAbstractItemView::scrollTo** (const QModelIndex &index,
        QAbstractItemView::ScrollHint hint).
        """
        ...

    def indexAt(self, point: QtCore.QPoint) -> QtCore.QModelIndex:
        """
        https://doc.qt.io/qt-5/qcolumnview.html#indexAt

        **[override virtual] QModelIndex QColumnView::indexAt(const QPoint &
        point ) const**

        Reimplements: **QAbstractItemView::indexAt** (const QPoint &point)
        const.
        """
        ...

    def setResizeGripsVisible(self, visible: bool) -> None:
        """
        https://doc.qt.io/qt-5/qcolumnview.html#resizeGripsVisible-prop

        **resizeGripsVisible : bool**

        This property holds the way to specify if the list views gets resize
        grips or not

        By default, `visible` is set to true

        **Access functions:**

        bool **resizeGripsVisible** () const
        void **setResizeGripsVisible**
        (bool **visible** )

        **See also** **setRootIndex** ().

        **Member Function Documentation**
        """
        ...

    def setPreviewWidget(self, widget: QWidget) -> None:
        """
        https://doc.qt.io/qt-5/qcolumnview.html#setPreviewWidget

        **void QColumnView::setPreviewWidget(QWidget * widget )**

        Sets the preview **widget**.

        The **widget** becomes a child of the column view, and will be destroyed
        when the column area is deleted or when a new widget is set.

        **See also** **previewWidget** () and **updatePreviewWidget** ().
        """
        ...

    def setColumnWidths(self, list: typing.Iterable[int]) -> None:
        """
        https://doc.qt.io/qt-5/qcolumnview.html#setColumnWidths

        **void QColumnView::setColumnWidths(const QList<int> & list )**

        Sets the column widths to the values given in the **list**. Extra values
        in the list are kept and used when the columns are created.

        If list contains too few values, only width of the rest of the columns
        will not be modified.

        **See also** **columnWidths** () and **createColumn** ().
        """
        ...

    def resizeGripsVisible(self) -> bool:
        """
        https://doc.qt.io/qt-5/qcolumnview.html#resizeGripsVisible-prop

        **resizeGripsVisible : bool**

        This property holds the way to specify if the list views gets resize
        grips or not

        By default, `visible` is set to true

        **Access functions:**

        bool **resizeGripsVisible** () const
        void **setResizeGripsVisible**
        (bool **visible** )

        **See also** **setRootIndex** ().

        **Member Function Documentation**
        """
        ...

    def previewWidget(self) -> QWidget:
        """
        https://doc.qt.io/qt-5/qcolumnview.html#previewWidget

        **QWidget *QColumnView::previewWidget() const**

        Returns the preview widget, or `nullptr` if there is none.

        **See also** **setPreviewWidget** () and **updatePreviewWidget** ().
        """
        ...

    def columnWidths(self) -> typing.List[int]:
        """
        https://doc.qt.io/qt-5/qcolumnview.html#columnWidths

        **QList<int> QColumnView::columnWidths() const**

        Returns a list of the width of all the columns in this view.

        **See also** **setColumnWidths** ().
        """
        ...

    @property
    def updatePreviewWidget(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcolumnview.html#updatePreviewWidget

        **[signal] void QColumnView::updatePreviewWidget(const QModelIndex &
        index )**

        This signal is emitted when the preview widget should be updated to
        provide rich information about **index**

        **See also** **previewWidget** ().
        """
        ...
