"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtWidgets import *


class QCheckBox(QAbstractButton):
    """
    https://doc.qt.io/qt-5/qcheckbox.html

    **Detailed Description**

    ![](images/windows-checkbox.png)

    A QCheckBox is an option button that can be switched on (checked) or off
    (unchecked). Checkboxes are typically used to represent features in an
    application that can be enabled or disabled without affecting others.
    Different types of behavior can be implemented. For example, a
    **QButtonGroup**  can be used to group check buttons logically, allowing
    exclusive checkboxes. However, **QButtonGroup**  does not provide any visual
    representation.

    The image below further illustrates the differences between exclusive and
    non-exclusive checkboxes.

    ![](images/checkboxes-exclusive.png)![](images/checkboxes-non-exclusive.png)

    Whenever a checkbox is checked or cleared, it emits the signal
    **stateChanged** (). Connect to this signal if you want to trigger an action
    each time the checkbox changes state. You can use **isChecked** () to query
    whether or not a checkbox is checked.

    In addition to the usual checked and unchecked states, QCheckBox optionally
    provides a third state to indicate "no change". This is useful whenever you
    need to give the user the option of neither checking nor unchecking a
    checkbox. If you need this third state, enable it with **setTristate** (),
    and use **checkState** () to query the current toggle state.

    Just like **QPushButton** , a checkbox displays text, and optionally a small
    icon. The icon is set with **setIcon** (). The text can be set in the
    constructor or with **setText** (). A shortcut key can be specified by
    preceding the preferred character with an ampersand. For example:

    **QCheckBox**  *checkbox = new **QCheckBox** ("C&ase sensitive", this);

    In this example, the shortcut is **Alt+A**. See the **QShortcut**
    documentation for details. To display an actual ampersand, use '&&'.

    Important inherited functions: **text** (), **setText** (), **text** (),
    pixmap(), setPixmap(), accel(), setAccel(), isToggleButton(), **setDown**
    (), **isDown** (), isOn(), **checkState** (), **autoRepeat** (),
    isExclusiveToggle(), **group** (), **setAutoRepeat** (), **toggle** (),
    **pressed** (), **released** (), **clicked** (), **toggled** (),
    **checkState** (), and **stateChanged** ().

    **See also** **QAbstractButton** , **QRadioButton** , and **GUI Design
    Handbook: Check Box** .
    """

    @typing.overload
    def __init__(self, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcheckbox.html#QCheckBox

        **QCheckBox::QCheckBox(QWidget * parent = nullptr)**

        Constructs a checkbox with the given **parent** , but with no text.

        **parent** is passed on to the **QAbstractButton**  constructor.
        """
        ...

    @typing.overload
    def __init__(self, text: str, parent: typing.Optional[QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcheckbox.html#QCheckBox-1

        **QCheckBox::QCheckBox(const QString & text , QWidget * parent =
        nullptr)**

        Constructs a checkbox with the given **parent** and **text**.

        **parent** is passed on to the **QAbstractButton**  constructor.
        """
        ...

    def initStyleOption(self, option: "QStyleOptionButton") -> None:
        """
        https://doc.qt.io/qt-5/qcheckbox.html#initStyleOption

        **[protected] void QCheckBox::initStyleOption(QStyleOptionButton *
        option ) const**

        Initializes **option** with the values from this **QCheckBox** . This
        method is useful for subclasses that require a **QStyleOptionButton** ,
        but do not want to fill in all the information themselves.

        **See also** **QStyleOption::initFrom** ().
        """
        ...

    def mouseMoveEvent(self, a0: QtGui.QMouseEvent) -> None:
        """
        https://doc.qt.io/qt-5/qcheckbox.html#mouseMoveEvent

        **[override virtual protected] void
        QCheckBox::mouseMoveEvent(QMouseEvent * e )**

        Reimplements: **QAbstractButton::mouseMoveEvent** (QMouseEvent *e).
        """
        ...

    def paintEvent(self, a0: QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-5/qcheckbox.html#paintEvent

        **[override virtual protected] void QCheckBox::paintEvent( QPaintEvent *
        )**

        Reimplements: **QAbstractButton::paintEvent** (QPaintEvent *e).
        """
        ...

    def event(self, e: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qcheckbox.html#event

        **[override virtual protected] bool QCheckBox::event(QEvent * e )**

        Reimplements: **QAbstractButton::event** (QEvent *e).
        """
        ...

    def nextCheckState(self) -> None:
        """
        https://doc.qt.io/qt-5/qcheckbox.html#nextCheckState

        **[override virtual protected] void QCheckBox::nextCheckState()**

        Reimplements: **QAbstractButton::nextCheckState** ().
        """
        ...

    def checkStateSet(self) -> None:
        """
        https://doc.qt.io/qt-5/qcheckbox.html#checkStateSet

        **[override virtual protected] void QCheckBox::checkStateSet()**

        Reimplements: **QAbstractButton::checkStateSet** ().
        """
        ...

    def hitButton(self, pos: QtCore.QPoint) -> bool:
        """
        https://doc.qt.io/qt-5/qcheckbox.html#hitButton

        **[override virtual protected] bool QCheckBox::hitButton(const QPoint &
        pos ) const**

        Reimplements: **QAbstractButton::hitButton** (const QPoint &pos) const.
        """
        ...

    def minimumSizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qcheckbox.html#minimumSizeHint

        **[override virtual] QSize QCheckBox::minimumSizeHint() const**

        Reimplements an access function for property:
        **QWidget::minimumSizeHint** .
        """
        ...

    def setCheckState(self, state: QtCore.Qt.CheckState) -> None:
        """
        https://doc.qt.io/qt-5/qcheckbox.html#setCheckState

        **void QCheckBox::setCheckState(Qt::CheckState state )**

        Sets the checkbox's check state to **state**. If you do not need
        tristate support, you can also use **QAbstractButton::setChecked** (),
        which takes a boolean.

        **See also** **checkState** () and **Qt::CheckState** .
        """
        ...

    def checkState(self) -> QtCore.Qt.CheckState:
        """
        https://doc.qt.io/qt-5/qcheckbox.html#checkState

        **Qt::CheckState QCheckBox::checkState() const**

        Returns the checkbox's check state. If you do not need tristate support,
        you can also use **QAbstractButton::isChecked** (), which returns a
        boolean.

        **See also** **setCheckState** () and **Qt::CheckState** .
        """
        ...

    def isTristate(self) -> bool:
        ...

    def setTristate(self, on: bool = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcheckbox.html#tristate-prop

        **tristate : bool**

        This property holds whether the checkbox is a tri-state checkbox

        The default is false, i.e., the checkbox has only two states.

        **Access functions:**

        bool **isTristate** () const
        void **setTristate** (bool **y** = true)

        **Member Function Documentation**
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qcheckbox.html#sizeHint

        **[override virtual] QSize QCheckBox::sizeHint() const**

        Reimplements an access function for property: **QWidget::sizeHint** .
        """
        ...

    @property
    def stateChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcheckbox.html#stateChanged

        **[signal] void QCheckBox::stateChanged(int state )**

        This signal is emitted whenever the checkbox's state changes, i.e.,
        whenever the user checks or unchecks it.

        **state** contains the checkbox's new **Qt::CheckState** .
        """
        ...
