"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import sip


class QWebSocketCorsAuthenticator(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qwebsocketcorsauthenticator.html

    **Detailed Description**

    The QWebSocketCorsAuthenticator class is used in the
    **originAuthenticationRequired()**  signal. The class provides a way to pass
    back the required information to the **QWebSocketServer** . It provides
    applications with fine-grained control over which origin URLs are allowed
    and which aren't. By default, every origin is accepted. To get fine-grained
    control, an application connects the **originAuthenticationRequired()**
    signal to a slot. When the origin (**QWebSocketCorsAuthenticator::origin**
    ()) is accepted, it calls **QWebSocketCorsAuthenticator::setAllowed** (true)

    **Note:** Checking on the origin does not make much sense when the server is
    accessed via a non-browser client, as that client can set whatever origin
    header it likes. In case of a browser client, the server SHOULD check the
    validity of the origin.

    **See also** **WebSocket Security Considerations**  and **QWebSocketServer**
    .
    """

    @typing.overload
    def __init__(self, origin: str) -> None:
        """
        https://doc.qt.io/qt-5/qwebsocketcorsauthenticator.html#QWebSocketCorsAu
        thenticator

        **QWebSocketCorsAuthenticator::QWebSocketCorsAuthenticator(const QString
        & origin )**

        Constructs a new QCorsAuthencator object with the given **origin**.

        **Note:** By default, **allowed** () returns true. This means that per
        default every origin is accepted.
        """
        ...

    @typing.overload
    def __init__(self, other: "QWebSocketCorsAuthenticator") -> None:
        """
        https://doc.qt.io/qt-5/qwebsocketcorsauthenticator.html#QWebSocketCorsAu
        thenticator-1

        **QWebSocketCorsAuthenticator::QWebSocketCorsAuthenticator(const
        QWebSocketCorsAuthenticator & other )**

        Constructs a copy of **other**.
        """
        ...

    def allowed(self) -> bool:
        """
        https://doc.qt.io/qt-5/qwebsocketcorsauthenticator.html#allowed

        **bool QWebSocketCorsAuthenticator::allowed() const**

        Returns true if the origin is allowed, otherwise returns false.

        **Note:** By default, all origins are accepted.

        **See also** **setAllowed** ().
        """
        ...

    def setAllowed(self, allowed: bool) -> None:
        """
        https://doc.qt.io/qt-5/qwebsocketcorsauthenticator.html#setAllowed

        **void QWebSocketCorsAuthenticator::setAllowed(bool allowed )**

        Allows or disallows the origin. Setting **allowed** to true, will accept
        the connection request for the given origin.

        Setting **allowed** to false, will reject the connection request.

        **Note:** By default, all origins are accepted.

        **See also** **allowed** ().
        """
        ...

    def origin(self) -> str:
        """
        https://doc.qt.io/qt-5/qwebsocketcorsauthenticator.html#origin

        **QString QWebSocketCorsAuthenticator::origin() const**

        Returns the origin this autenticator is handling about.
        """
        ...

    def swap(self, other: "QWebSocketCorsAuthenticator") -> None:
        """
        https://doc.qt.io/qt-5/qwebsocketcorsauthenticator.html#swap

        **void QWebSocketCorsAuthenticator::swap(QWebSocketCorsAuthenticator &
        other )**

        Swaps **other** with this authenticator.

        This operation is very fast and never fails.
        """
        ...
