"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore


class QWebChannelAbstractTransport(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qwebchannelabstracttransport.html

    **Detailed Description**

    Users of the **QWebChannel**  must implement this interface and connect
    instances of it to the **QWebChannel**  server for every client that should
    be connected to the **QWebChannel** . The **Qt WebChannel Standalone
    Example**  shows how this can be done using **Qt WebSockets** .

    **Note:** The JSON message protocol is considered internal and might change
    over time.

    **See also** **Qt WebChannel Standalone Example** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qwebchannelabstracttransport.html#QWebChannelAbst
        ractTransport

        **QWebChannelAbstractTransport::QWebChannelAbstractTransport(QObject *
        parent = Q_NULLPTR)**

        Constructs a transport object with the given **parent**.
        """
        ...

    def sendMessage(
        self,
        message: typing.Dict[
            str,
            typing.Union[
                QtCore.QJsonValue,
                QtCore.QJsonValue.Type,
                typing.Iterable[QtCore.QJsonValue],
                bool,
                int,
                float,
                None,
                str,
            ],
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qwebchannelabstracttransport.html#sendMessage

        **[pure virtual slot] void
        QWebChannelAbstractTransport::sendMessage(const QJsonObject & message
        )**

        Sends a JSON **message** to the remote client. An implementation would
        serialize the message and transmit it to the remote JavaScript client.
        """
        ...

    @property
    def messageReceived(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qwebchannelabstracttransport.html#messageReceived

        **[signal] void QWebChannelAbstractTransport::messageReceived(const
        QJsonObject & message , QWebChannelAbstractTransport * transport )**

        This signal must be emitted when a new JSON **message** was received
        from the remote client. The **transport** argument should be set to this
        transport object.
        """
        ...
