"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore


class QSvgRenderer(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qsvgrenderer.html

    **Detailed Description**

    Using QSvgRenderer, Scalable Vector Graphics (SVG) can be rendered onto any
    **QPaintDevice**  subclass, including **QWidget** , **QImage** , and
    QGLWidget.

    QSvgRenderer provides an API that supports basic features of SVG rendering,
    such as loading and rendering of static drawings, and more interactive
    features like animation. Since the rendering is performed using **QPainter**
    , SVG drawings can be rendered on any subclass of **QPaintDevice** .

    SVG drawings are either loaded when an QSvgRenderer is constructed, or
    loaded later using the **load** () functions. Data is either supplied
    directly as serialized XML, or indirectly using a file name. If a valid file
    has been loaded, either when the renderer is constructed or at some later
    time, **isValid** () returns true; otherwise it returns false. QSvgRenderer
    provides the **render** () slot to render the current document, or the
    current frame of an animated document, using a given painter.

    The **defaultSize** () function provides information about the amount of
    space that is required to render the currently loaded SVG file. This is
    useful for paint devices, such as **QWidget** , that often need to supply a
    size hint to their parent layout. The default size of a drawing may differ
    from its visible area, found using the **viewBox**  property.

    Animated SVG drawings are supported, and can be controlled with a simple
    collection of functions and properties:

    * The **animated** () function indicates whether a drawing contains
    animation information.
      * The **framesPerSecond**  property contains the
    rate at which the animation plays.

    Finally, the QSvgRenderer class provides the **repaintNeeded** () signal
    which is emitted whenever the rendering of the document needs to be updated.

    **See also** **QSvgWidget** , **Qt SVG C++ Classes** , **SVG Viewer
    Example** , and **QPicture** .
    """

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qsvgrenderer.html#QSvgRenderer

        **QSvgRenderer::QSvgRenderer(QObject * parent = nullptr)**

        Constructs a new renderer with the given **parent**.
        """
        ...

    @typing.overload
    def __init__(
        self, filename: str, parent: typing.Optional[QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsvgrenderer.html#QSvgRenderer-1

        **QSvgRenderer::QSvgRenderer(const QString & filename , QObject * parent
        = nullptr)**

        Constructs a new renderer with the given **parent** and loads the
        contents of the SVG file with the specified **filename**.
        """
        ...

    @typing.overload
    def __init__(
        self,
        contents: typing.Union[QtCore.QByteArray, bytes, bytearray],
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsvgrenderer.html#QSvgRenderer-2

        **QSvgRenderer::QSvgRenderer(const QByteArray & contents , QObject *
        parent = nullptr)**

        Constructs a new renderer with the given **parent** and loads the SVG
        data from the byte array specified by **contents**.
        """
        ...

    @typing.overload
    def __init__(
        self,
        contents: QtCore.QXmlStreamReader,
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsvgrenderer.html#QSvgRenderer-3

        **QSvgRenderer::QSvgRenderer(QXmlStreamReader * contents , QObject *
        parent = nullptr)**

        Constructs a new renderer with the given **parent** and loads the SVG
        data using the stream reader specified by **contents**.

        This function was introduced in Qt 4.5.
        """
        ...

    def transformForElement(self, id: str) -> QtGui.QTransform:
        """
        https://doc.qt.io/qt-5/qsvgrenderer.html#transformForElement

        **QTransform QSvgRenderer::transformForElement(const QString & id )
        const**

        Returns the transformation matrix for the element with the given **id**.
        The matrix is a product of the transformation of the element's parents.
        The transformation of the element itself is not included.

        To find the bounding rectangle of the element in logical coordinates,
        you can apply the matrix on the rectangle returned from
        **boundsOnElement** ().

        This function was introduced in Qt 5.15.

        **See also** **boundsOnElement** ().
        """
        ...

    def setAspectRatioMode(self, mode: QtCore.Qt.AspectRatioMode) -> None:
        """
        https://doc.qt.io/qt-5/qsvgrenderer.html#aspectRatioMode-prop

        **aspectRatioMode : Qt::AspectRatioMode**

        how rendering adheres to the SVG view box aspect ratio

        The accepted modes are:

        * **Qt::IgnoreAspectRatio**  (the default): the aspect ratio is ignored
        and the rendering is stretched to the target bounds.
          *
        **Qt::KeepAspectRatio** : rendering is centered and scaled as large as
        possible within the target bounds while preserving aspect ratio.

        This property was introduced in Qt 5.15.

        **Access functions:**

        Qt::AspectRatioMode **aspectRatioMode** () const
        void
        **setAspectRatioMode** (Qt::AspectRatioMode **mode** )
        """
        ...

    def aspectRatioMode(self) -> QtCore.Qt.AspectRatioMode:
        """
        https://doc.qt.io/qt-5/qsvgrenderer.html#aspectRatioMode-prop

        **aspectRatioMode : Qt::AspectRatioMode**

        how rendering adheres to the SVG view box aspect ratio

        The accepted modes are:

        * **Qt::IgnoreAspectRatio**  (the default): the aspect ratio is ignored
        and the rendering is stretched to the target bounds.
          *
        **Qt::KeepAspectRatio** : rendering is centered and scaled as large as
        possible within the target bounds while preserving aspect ratio.

        This property was introduced in Qt 5.15.

        **Access functions:**

        Qt::AspectRatioMode **aspectRatioMode** () const
        void
        **setAspectRatioMode** (Qt::AspectRatioMode **mode** )
        """
        ...

    @typing.overload
    def render(self, p: QtGui.QPainter) -> None:
        """
        https://doc.qt.io/qt-5/qsvgrenderer.html#render

        **[slot] void QSvgRenderer::render(QPainter * painter )**

        Renders the current document, or the current frame of an animated
        document, using the given **painter**.
        """
        ...

    @typing.overload
    def render(self, p: QtGui.QPainter, bounds: QtCore.QRectF) -> None:
        """
        https://doc.qt.io/qt-5/qsvgrenderer.html#render-1

        **[slot] void QSvgRenderer::render(QPainter * painter , const QRectF &
        bounds )**

        Renders the current document, or the current frame of an animated
        document, using the given **painter** on the specified **bounds** within
        the painter. If **bounds** is not empty, the output will be scaled to
        fill it, ignoring any aspect ratio implied by the SVG.
        """
        ...

    @typing.overload
    def render(
        self, painter: QtGui.QPainter, elementId: str, bounds: QtCore.QRectF = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsvgrenderer.html#render-2

        **[slot] void QSvgRenderer::render(QPainter * painter , const QString &
        elementId , const QRectF & bounds = QRectF())**

        Renders the given element with **elementId** using the given **painter**
        on the specified **bounds**. If the bounding rectangle is not specified
        the SVG element is mapped to the whole paint device.
        """
        ...

    @typing.overload
    def load(self, filename: str) -> bool:
        """
        https://doc.qt.io/qt-5/qsvgrenderer.html#load

        **[slot] bool QSvgRenderer::load(const QString & filename )**

        Loads the SVG file specified by **filename** , returning true if the
        content was successfully parsed; otherwise returns false.
        """
        ...

    @typing.overload
    def load(self, contents: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> bool:
        """
        https://doc.qt.io/qt-5/qsvgrenderer.html#load-1

        **[slot] bool QSvgRenderer::load(const QByteArray & contents )**

        Loads the specified SVG format **contents** , returning true if the
        content was successfully parsed; otherwise returns false.
        """
        ...

    @typing.overload
    def load(self, contents: QtCore.QXmlStreamReader) -> bool:
        """
        https://doc.qt.io/qt-5/qsvgrenderer.html#load-2

        **[slot] bool QSvgRenderer::load(QXmlStreamReader * contents )**

        Loads the specified SVG in **contents** , returning true if the content
        was successfully parsed; otherwise returns false.

        The reader will be used from where it currently is positioned. If
        **contents** is `null`, behavior is undefined.

        This function was introduced in Qt 4.5.
        """
        ...

    def animationDuration(self) -> int:
        ...

    def setCurrentFrame(self, a0: int) -> None:
        ...

    def currentFrame(self) -> int:
        ...

    def setFramesPerSecond(self, num: int) -> None:
        """
        https://doc.qt.io/qt-5/qsvgrenderer.html#framesPerSecond-prop

        **framesPerSecond : int**

        This property holds the number of frames per second to be shown

        The number of frames per second is 0 if the current document is not
        animated.

        **Access functions:**

        int **framesPerSecond** () const
        void **setFramesPerSecond** (int
        **num** )

        **See also** **animated** ().
        """
        ...

    def framesPerSecond(self) -> int:
        """
        https://doc.qt.io/qt-5/qsvgrenderer.html#framesPerSecond-prop

        **framesPerSecond : int**

        This property holds the number of frames per second to be shown

        The number of frames per second is 0 if the current document is not
        animated.

        **Access functions:**

        int **framesPerSecond** () const
        void **setFramesPerSecond** (int
        **num** )

        **See also** **animated** ().
        """
        ...

    def boundsOnElement(self, id: str) -> QtCore.QRectF:
        """
        https://doc.qt.io/qt-5/qsvgrenderer.html#boundsOnElement

        **QRectF QSvgRenderer::boundsOnElement(const QString & id ) const**

        Returns bounding rectangle of the item with the given **id**. The
        transformation matrix of parent elements is not affecting the bounds of
        the element.

        This function was introduced in Qt 4.2.

        **See also** **transformForElement** ().
        """
        ...

    def animated(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsvgrenderer.html#animated

        **bool QSvgRenderer::animated() const**

        Returns true if the current document contains animated elements;
        otherwise returns false.

        **See also** **framesPerSecond** ().
        """
        ...

    @typing.overload
    def setViewBox(self, viewbox: QtCore.QRect) -> None:
        """
        https://doc.qt.io/qt-5/qsvgrenderer.html#viewBox

        **QRect QSvgRenderer::viewBox() const**

        Returns **viewBoxF** ().toRect().

        **See also** **setViewBox** () and **viewBoxF** ().
        """
        ...

    @typing.overload
    def setViewBox(self, viewbox: QtCore.QRectF) -> None:
        """
        https://doc.qt.io/qt-5/qsvgrenderer.html#viewBox-prop

        **viewBox : QRectF**

        This property holds the rectangle specifying the visible area of the
        document in logical coordinates

        This property was introduced in Qt 4.2.

        **Access functions:**

        QRectF **viewBoxF** () const
        void **setViewBox** (const QRect &
        **viewbox** )
        void **setViewBox** (const QRectF & **viewbox** )

        **Member Function Documentation**
        """
        ...

    def viewBoxF(self) -> QtCore.QRectF:
        ...

    def viewBox(self) -> QtCore.QRect:
        """
        https://doc.qt.io/qt-5/qsvgrenderer.html#viewBox

        **QRect QSvgRenderer::viewBox() const**

        Returns **viewBoxF** ().toRect().

        **See also** **setViewBox** () and **viewBoxF** ().
        """
        ...

    def elementExists(self, id: str) -> bool:
        """
        https://doc.qt.io/qt-5/qsvgrenderer.html#elementExists

        **bool QSvgRenderer::elementExists(const QString & id ) const**

        Returns true if the element with the given **id** exists in the
        currently parsed SVG file and is a renderable element.

        Note: this method returns true only for elements that can be rendered.
        Which implies that elements that are considered part of the fill/stroke
        style properties, e.g. radialGradients even tough marked with "id"
        attributes will not be found by this method.

        This function was introduced in Qt 4.2.
        """
        ...

    def defaultSize(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qsvgrenderer.html#defaultSize

        **QSize QSvgRenderer::defaultSize() const**

        Returns the default size of the document contents.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsvgrenderer.html#isValid

        **bool QSvgRenderer::isValid() const**

        Returns true if there is a valid current document; otherwise returns
        false.
        """
        ...

    @property
    def repaintNeeded(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qsvgrenderer.html#repaintNeeded

        **[signal] void QSvgRenderer::repaintNeeded()**

        This signal is emitted whenever the rendering of the document needs to
        be updated, usually for the purposes of animation.
        """
        ...
