"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5.QtSql import *
from PyQt5 import sip


class QSqlError(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qsqlerror.html

    **Detailed Description**

    A QSqlError object can provide database-specific error data, including the
    **driverText** () and **databaseText** () messages (or both concatenated
    together as **text** ()), and the **nativeErrorCode** () and **type** ().

    **See also** **QSqlDatabase::lastError** () and **QSqlQuery::lastError** ().
    """

    class ErrorType(int):
        NoError: QSqlError = ...
        ConnectionError: QSqlError = ...
        StatementError: QSqlError = ...
        TransactionError: QSqlError = ...
        UnknownError: QSqlError = ...

    @typing.overload
    def __init__(
        self,
        driverText: str = ...,
        databaseText: str = ...,
        type: "QSqlError.ErrorType" = ...,
        errorCode: str = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsqlerror.html#QSqlError-1

        **QSqlError::QSqlError(const QString & driverText = QString(), const
        QString & databaseText = QString(), QSqlError::ErrorType type = NoError,
        const QString & code = QString())**

        Constructs an error containing the driver error text **driverText** ,
        the database-specific error text **databaseText** , the type **type**
        and the error code **code**.

        **Note:** DB2: It is possible for DB2 to report more than one error
        code. When this happens, `;` is used as separator between the error
        codes.
        """
        ...

    @typing.overload
    def __init__(
        self,
        driverText: str,
        databaseText: str,
        type: "QSqlError.ErrorType",
        number: int,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qsqlerror.html#QSqlError-2

        **QSqlError::QSqlError(const QSqlError & other )**

        Creates a copy of **other**.
        """
        ...

    @typing.overload
    def __init__(self, other: "QSqlError") -> None:
        """
        https://doc.qt.io/qt-5/qsqlerror.html#QSqlError-3

        **QSqlError::QSqlError(QSqlError && other )**

        Move-constructs a QSqlError instance, making it point at the same object
        that **other** was pointing to.

        **Note:** The moved-from object **other** is placed in a partially-
        formed state, in which the only valid operations are destruction and
        assignment of a new value.

        This function was introduced in Qt 5.10.
        """
        ...

    def swap(self, other: "QSqlError") -> None:
        """
        https://doc.qt.io/qt-5/qsqlerror.html#swap

        **void QSqlError::swap(QSqlError & other )**

        Swaps error **other** with this error. This operation is very fast and
        never fails.

        This function was introduced in Qt 5.10.
        """
        ...

    def nativeErrorCode(self) -> str:
        """
        https://doc.qt.io/qt-5/qsqlerror.html#nativeErrorCode

        **QString QSqlError::nativeErrorCode() const**

        Returns the database-specific error code, or an empty string if it
        cannot be determined.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qsqlerror.html#isValid

        **bool QSqlError::isValid() const**

        Returns `true` if an error is set, otherwise false.

        Example:

        **QSqlQueryModel**  model;
            model.setQuery("select * from myTable");
        if (model.lastError().isValid())
                **qDebug** () <<
        model.lastError();

        **See also** **type** ().
        """
        ...

    def text(self) -> str:
        """
        https://doc.qt.io/qt-5/qsqlerror.html#text

        **QString QSqlError::text() const**

        This is a convenience function that returns **databaseText** () and
        **driverText** () concatenated into a single string.

        **See also** **driverText** () and **databaseText** ().
        """
        ...

    def setNumber(self, number: int) -> None:
        ...

    def number(self) -> int:
        ...

    def setType(self, type: "QSqlError.ErrorType") -> None:
        """
        https://doc.qt.io/qt-5/qsqlerror.html#type

        **QSqlError::ErrorType QSqlError::type() const**

        Returns the error type, or -1 if the type cannot be determined.

        **See also** **setType** ().
        """
        ...

    def type(self) -> "QSqlError.ErrorType":
        """
        https://doc.qt.io/qt-5/qsqlerror.html#type

        **QSqlError::ErrorType QSqlError::type() const**

        Returns the error type, or -1 if the type cannot be determined.

        **See also** **setType** ().
        """
        ...

    def setDatabaseText(self, databaseText: str) -> None:
        """
        https://doc.qt.io/qt-5/qsqlerror.html#databaseText

        **QString QSqlError::databaseText() const**

        Returns the text of the error as reported by the database. This may
        contain database-specific descriptions; it may be empty.

        **See also** **setDatabaseText** (), **driverText** (), and **text** ().
        """
        ...

    def databaseText(self) -> str:
        """
        https://doc.qt.io/qt-5/qsqlerror.html#databaseText

        **QString QSqlError::databaseText() const**

        Returns the text of the error as reported by the database. This may
        contain database-specific descriptions; it may be empty.

        **See also** **setDatabaseText** (), **driverText** (), and **text** ().
        """
        ...

    def setDriverText(self, driverText: str) -> None:
        """
        https://doc.qt.io/qt-5/qsqlerror.html#driverText

        **QString QSqlError::driverText() const**

        Returns the text of the error as reported by the driver. This may
        contain database-specific descriptions. It may also be empty.

        **See also** **setDriverText** (), **databaseText** (), and **text** ().
        """
        ...

    def driverText(self) -> str:
        """
        https://doc.qt.io/qt-5/qsqlerror.html#driverText

        **QString QSqlError::driverText() const**

        Returns the text of the error as reported by the driver. This may
        contain database-specific descriptions. It may also be empty.

        **See also** **setDriverText** (), **databaseText** (), and **text** ().
        """
        ...
