"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
from PyQt5.QtSensors import *


class QAmbientTemperatureReading(QSensorReading):
    """
    https://doc.qt.io/qt-5/qambienttemperaturereading.html

    **Detailed Description**

    The ambient (room) temperature is the temperature in degree Celsius.
    """

    def setTemperature(self, temperature: float) -> None:
        """
        https://doc.qt.io/qt-5/qambienttemperaturereading.html#setTemperature

        **void QAmbientTemperatureReading::setTemperature(qreal temperature )**

        Sets ambient temperature to **temperature**.

        **See also** **temperature** ().
        """
        ...

    def temperature(self) -> float:
        """
        https://doc.qt.io/qt-5/qambienttemperaturereading.html#temperature-prop

        **temperature : const qreal**

        This property holds the ambient temperature

        Measured in degree Celsius.

        **Access functions:**

        qreal **temperature** () const

        **Member Function Documentation**
        """
        ...
