"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtGui
from PyQt5 import QtCore
from PyQt5.QtQuick import *


class QQuickFramebufferObject(QQuickItem):
    """
    https://doc.qt.io/qt-5/qquickframebufferobject.html

    **Detailed Description**

    On most platforms, the rendering will occur on a **dedicated thread** . For
    this reason, the QQuickFramebufferObject class enforces a strict separation
    between the item implementation and the FBO rendering. All item logic, such
    as properties and UI-related helper functions needed by QML should be
    located in a QQuickFramebufferObject class subclass. Everything that relates
    to rendering must be located in the **QQuickFramebufferObject::Renderer**
    class.

    **Warning:** This class is only functional when Qt Quick is rendering via
    OpenGL, either directly or through the **RHI-based rendering path** . It is
    not compatible with other RHI backends, such as, Vulkan or Metal.

    To avoid race conditions and read/write issues from two threads it is
    important that the renderer and the item never read or write shared
    variables. Communication between the item and the renderer should primarily
    happen via the **QQuickFramebufferObject::Renderer::synchronize** ()
    function. This function will be called on the render thread while the GUI
    thread is blocked.

    Using queued connections or events for communication between item and
    renderer is also possible.

    Both the Renderer and the FBO are memory managed internally.

    To render into the FBO, the user should subclass the Renderer class and
    reimplement its **Renderer::render** () function. The Renderer subclass is
    returned from **createRenderer** ().

    The size of the FBO will by default adapt to the size of the item. If a
    fixed size is preferred, set **textureFollowsItemSize**  to `false` and
    return a texture of your choosing from
    **QQuickFramebufferObject::Renderer::createFramebufferObject** ().

    Starting Qt 5.4, the QQuickFramebufferObject class is a **texture provider**
    and can be used directly in **ShaderEffects**  and other classes that
    consume texture providers.

    **See also** **Scene Graph - Rendering FBOs**  and **Scene Graph and
    Rendering** .
    """

    class Renderer(PyQt5.sip.wrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QQuickFramebufferObject.Renderer") -> None:
            ...

        def invalidateFramebufferObject(self) -> None:
            ...

        def update(self) -> None:
            ...

        def framebufferObject(self) -> QtGui.QOpenGLFramebufferObject:
            ...

        def synchronize(self, a0: "QQuickFramebufferObject") -> None:
            ...

        def createFramebufferObject(
            self, size: QtCore.QSize
        ) -> QtGui.QOpenGLFramebufferObject:
            ...

        def render(self) -> None:
            ...

    def __init__(self, parent: typing.Optional[QQuickItem] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qquickframebufferobject.html#QQuickFramebufferObj
        ect

        **QQuickFramebufferObject::QQuickFramebufferObject(QQuickItem * parent =
        nullptr)**

        Constructs a new QQuickFramebufferObject with parent **parent**.
        """
        ...

    def setMirrorVertically(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qquickframebufferobject.html#mirrorVertically-
        prop

        **mirrorVertically : bool**

        This property controls if the size of the FBO's contents should be
        mirrored vertically when drawing. This allows easy integration of third-
        party rendering code that does not follow the standard expectations.

        The default value is `false`.

        This property was introduced in Qt 5.6.

        **Access functions:**

        bool **mirrorVertically** () const
        void **setMirrorVertically** (bool
        **enable** )

        **Notifier signal:**

        void **mirrorVerticallyChanged** ( **bool** )
        """
        ...

    def mirrorVertically(self) -> bool:
        """
        https://doc.qt.io/qt-5/qquickframebufferobject.html#mirrorVertically-
        prop

        **mirrorVertically : bool**

        This property controls if the size of the FBO's contents should be
        mirrored vertically when drawing. This allows easy integration of third-
        party rendering code that does not follow the standard expectations.

        The default value is `false`.

        This property was introduced in Qt 5.6.

        **Access functions:**

        bool **mirrorVertically** () const
        void **setMirrorVertically** (bool
        **enable** )

        **Notifier signal:**

        void **mirrorVerticallyChanged** ( **bool** )
        """
        ...

    def releaseResources(self) -> None:
        """
        https://doc.qt.io/qt-5/qquickframebufferobject.html#releaseResources

        **[override virtual] void QQuickFramebufferObject::releaseResources()**

        Reimplements: **QQuickItem::releaseResources** ().
        """
        ...

    def textureProvider(self) -> "QSGTextureProvider":
        """
        https://doc.qt.io/qt-5/qquickframebufferobject.html#textureProvider

        **[override virtual] QSGTextureProvider
        *QQuickFramebufferObject::textureProvider() const**

        Reimplements: **QQuickItem::textureProvider** () const.
        """
        ...

    def isTextureProvider(self) -> bool:
        """
        https://doc.qt.io/qt-5/qquickframebufferobject.html#isTextureProvider

        **[override virtual] bool QQuickFramebufferObject::isTextureProvider()
        const**

        Reimplements: **QQuickItem::isTextureProvider** () const.
        """
        ...

    def updatePaintNode(
        self, a0: "QSGNode", a1: QQuickItem.UpdatePaintNodeData
    ) -> "QSGNode":
        ...

    def geometryChanged(
        self, newGeometry: QtCore.QRectF, oldGeometry: QtCore.QRectF
    ) -> None:
        ...

    def createRenderer(self) -> "QQuickFramebufferObject.Renderer":
        """
        https://doc.qt.io/qt-5/qquickframebufferobject.html#createRenderer

        **[pure virtual] QQuickFramebufferObject::Renderer
        *QQuickFramebufferObject::createRenderer() const**

        Reimplement this function to create a renderer used to render into the
        FBO.

        This function will be called on the rendering thread while the GUI
        thread is blocked.
        """
        ...

    def setTextureFollowsItemSize(self, follows: bool) -> None:
        """
        https://doc.qt.io/qt-5/qquickframebufferobject.html#textureFollowsItemSi
        ze-prop

        **textureFollowsItemSize : bool**

        This property controls if the size of the FBO's texture should follow
        the dimensions of the **QQuickFramebufferObject**  item. When this
        property is false, the FBO will be created once the first time it is
        displayed. If it is set to true, the FBO will be recreated every time
        the dimensions of the item change.

        The default value is `true`.

        **Access functions:**

        bool **textureFollowsItemSize** () const
        void
        **setTextureFollowsItemSize** (bool **follows** )

        **Notifier signal:**

        void **textureFollowsItemSizeChanged** ( **bool** )

        **Member Function Documentation**
        """
        ...

    def textureFollowsItemSize(self) -> bool:
        """
        https://doc.qt.io/qt-5/qquickframebufferobject.html#textureFollowsItemSi
        ze-prop

        **textureFollowsItemSize : bool**

        This property controls if the size of the FBO's texture should follow
        the dimensions of the **QQuickFramebufferObject**  item. When this
        property is false, the FBO will be created once the first time it is
        displayed. If it is set to true, the FBO will be recreated every time
        the dimensions of the item change.

        The default value is `true`.

        **Access functions:**

        bool **textureFollowsItemSize** () const
        void
        **setTextureFollowsItemSize** (bool **follows** )

        **Notifier signal:**

        void **textureFollowsItemSizeChanged** ( **bool** )

        **Member Function Documentation**
        """
        ...

    @property
    def mirrorVerticallyChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...

    @property
    def textureFollowsItemSizeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        ...
