"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtWidgets
from PyQt5.QtPrintSupport import *
from PyQt5 import sip


class QAbstractPrintDialog(QtWidgets.QDialog):
    """
    https://doc.qt.io/qt-5/qabstractprintdialog.html

    **Detailed Description**

    This class implements getter and setter functions that are used to customize
    settings shown in print dialogs, but it is not used directly. Use
    **QPrintDialog**  to display a print dialog in your application.

    **See also** **QPrintDialog**  and **QPrinter** .
    """

    class PrintDialogOption(int):
        None_: QAbstractPrintDialog = ...
        PrintToFile: QAbstractPrintDialog = ...
        PrintSelection: QAbstractPrintDialog = ...
        PrintPageRange: QAbstractPrintDialog = ...
        PrintCollateCopies: QAbstractPrintDialog = ...
        PrintShowPageSize: QAbstractPrintDialog = ...
        PrintCurrentPage: QAbstractPrintDialog = ...

    class PrintRange(int):
        AllPages: QAbstractPrintDialog = ...
        Selection: QAbstractPrintDialog = ...
        PageRange: QAbstractPrintDialog = ...
        CurrentPage: QAbstractPrintDialog = ...

    class PrintDialogOptions(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QAbstractPrintDialog.PrintDialogOptions",
                "QAbstractPrintDialog.PrintDialogOption",
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QAbstractPrintDialog.PrintDialogOptions") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QAbstractPrintDialog.PrintDialogOptions":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def __init__(
        self, printer: "QPrinter", parent: typing.Optional[QtWidgets.QWidget] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-5/qabstractprintdialog.html#QAbstractPrintDialog

        **QAbstractPrintDialog::QAbstractPrintDialog(QPrinter * printer ,
        QWidget * parent = nullptr)**

        Constructs an abstract print dialog for **printer** with **parent** as
        parent widget.
        """
        ...

    def enabledOptions(self) -> "QAbstractPrintDialog.PrintDialogOptions":
        ...

    def setEnabledOptions(
        self,
        options: typing.Union[
            "QAbstractPrintDialog.PrintDialogOptions",
            "QAbstractPrintDialog.PrintDialogOption",
        ],
    ) -> None:
        ...

    def setOptionTabs(self, tabs: typing.Iterable[QtWidgets.QWidget]) -> None:
        """
        https://doc.qt.io/qt-5/qabstractprintdialog.html#setOptionTabs

        **void QAbstractPrintDialog::setOptionTabs(const QList<QWidget *> & tabs
        )**

        Set a list of widgets as **tabs** to be shown on the print dialog, if
        supported.

        Currently this option is only supported on X11.

        Setting the option tabs will transfer their ownership to the print
        dialog.

        This function was introduced in Qt 4.4.
        """
        ...

    def printer(self) -> "QPrinter":
        """
        https://doc.qt.io/qt-5/qabstractprintdialog.html#printer

        **QPrinter *QAbstractPrintDialog::printer() const**

        Returns the printer that this printer dialog operates on.
        """
        ...

    def toPage(self) -> int:
        """
        https://doc.qt.io/qt-5/qabstractprintdialog.html#toPage

        **int QAbstractPrintDialog::toPage() const**

        Returns the last page to be printed. By default, this value is set to 0.
        """
        ...

    def fromPage(self) -> int:
        """
        https://doc.qt.io/qt-5/qabstractprintdialog.html#fromPage

        **int QAbstractPrintDialog::fromPage() const**

        Returns the first page to be printed By default, this value is set to 0.
        """
        ...

    def setFromTo(self, fromPage: int, toPage: int) -> None:
        """
        https://doc.qt.io/qt-5/qabstractprintdialog.html#setFromTo

        **void QAbstractPrintDialog::setFromTo(int from , int to )**

        Sets the range in the print dialog to be from **from** to **to**.
        """
        ...

    def maxPage(self) -> int:
        """
        https://doc.qt.io/qt-5/qabstractprintdialog.html#maxPage

        **int QAbstractPrintDialog::maxPage() const**

        Returns the maximum page in the page range. As of Qt 4.4, this function
        returns INT_MAX by default. Previous versions returned 1 by default.
        """
        ...

    def minPage(self) -> int:
        """
        https://doc.qt.io/qt-5/qabstractprintdialog.html#minPage

        **int QAbstractPrintDialog::minPage() const**

        Returns the minimum page in the page range. By default, this value is
        set to 1.
        """
        ...

    def setMinMax(self, min: int, max: int) -> None:
        """
        https://doc.qt.io/qt-5/qabstractprintdialog.html#setMinMax

        **void QAbstractPrintDialog::setMinMax(int min , int max )**

        Sets the page range in this dialog to be from **min** to **max**. This
        also enables the **PrintPageRange**  option.
        """
        ...

    def printRange(self) -> "QAbstractPrintDialog.PrintRange":
        """
        https://doc.qt.io/qt-5/qabstractprintdialog.html#printRange

        **QAbstractPrintDialog::PrintRange QAbstractPrintDialog::printRange()
        const**

        Returns the print range.

        **See also** **setPrintRange** ().
        """
        ...

    def setPrintRange(self, range: "QAbstractPrintDialog.PrintRange") -> None:
        """
        https://doc.qt.io/qt-5/qabstractprintdialog.html#setPrintRange

        **void
        QAbstractPrintDialog::setPrintRange(QAbstractPrintDialog::PrintRange
        range )**

        Sets the print range option in to be **range**.

        **See also** **printRange** ().
        """
        ...

    def exec(self) -> int:
        ...

    def exec_(self) -> int:
        ...
