"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5.QtPositioning import *


class QGeoShape(PyQt5.sip.wrapper):
    """
    https://doc.qt.io/qt-5/qgeoshape.html

    **Detailed Description**

    This class is the base class for classes which specify a geographic area.

    For the sake of consistency, subclasses should describe the specific details
    of the associated areas in terms of **QGeoCoordinate**  instances and
    distances in meters.

    This class is a **Q_GADGET**  since Qt 5.5. It can be **directly used from
    C++ and QML** .
    """

    class ShapeType(int):
        UnknownType: QGeoShape = ...
        RectangleType: QGeoShape = ...
        CircleType: QGeoShape = ...
        PathType: QGeoShape = ...
        PolygonType: QGeoShape = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qgeoshape.html#QGeoShape

        **QGeoShape::QGeoShape()**

        Constructs a new invalid geo shape of **UnknownType** .
        """
        ...

    @typing.overload
    def __init__(self, other: "QGeoShape") -> None:
        """
        https://doc.qt.io/qt-5/qgeoshape.html#QGeoShape-1

        **QGeoShape::QGeoShape(const QGeoShape & other )**

        Constructs a new geo shape which is a copy of **other**.
        """
        ...

    def boundingGeoRectangle(self) -> "QGeoRectangle":
        """
        https://doc.qt.io/qt-5/qgeoshape.html#boundingGeoRectangle

        **QGeoRectangle QGeoShape::boundingGeoRectangle() const**

        Returns a **QGeoRectangle**  representing the geographical bounding
        rectangle of the geo shape, that defines the latitudinal/longitudinal
        bounds of the geo shape.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        This function was introduced in Qt 5.9.
        """
        ...

    def toString(self) -> str:
        """
        https://doc.qt.io/qt-5/qgeoshape.html#toString

        **QString QGeoShape::toString() const**

        Returns a string representation of this geo shape.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        This function was introduced in Qt 5.5.
        """
        ...

    def center(self) -> "QGeoCoordinate":
        """
        https://doc.qt.io/qt-5/qgeoshape.html#center

        **QGeoCoordinate QGeoShape::center() const**

        Returns the coordinate located at the geometric center of the geo shape.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .

        This function was introduced in Qt 5.5.
        """
        ...

    def extendShape(self, coordinate: "QGeoCoordinate") -> None:
        ...

    def contains(self, coordinate: "QGeoCoordinate") -> bool:
        """
        https://doc.qt.io/qt-5/qgeoshape.html#contains

        **bool QGeoShape::contains(const QGeoCoordinate & coordinate ) const**

        Returns whether the coordinate **coordinate** is contained within this
        geo shape.

        **Note:** This function can be invoked via the meta-object system and
        from QML. See **Q_INVOKABLE** .
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-5/qgeoshape.html#isEmpty

        **bool QGeoShape::isEmpty() const**

        Returns whether this geo shape is empty.

        An empty geo shape is a region which has a geometrical area of 0.

        **Note:** Getter function for property **isEmpty** .
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qgeoshape.html#isValid

        **bool QGeoShape::isValid() const**

        Returns whether this geo shape is valid.

        **Note:** Getter function for property **isValid** .
        """
        ...

    def type(self) -> "QGeoShape.ShapeType":
        """
        https://doc.qt.io/qt-5/qgeoshape.html#type

        **QGeoShape::ShapeType QGeoShape::type() const**

        Returns the type of this geo shape.

        **Note:** Getter function for property **type** .
        """
        ...
