"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtNfc import *
from PyQt5 import sip


class QNdefFilter(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qndeffilter.html

    **Detailed Description**

    The QNdefFilter encapsulates the structure of an NDEF message and is used by
    **QNearFieldManager::registerNdefMessageHandler** () to match NDEF message
    that have a particular structure.

    The following filter matches NDEF messages that contain a single smart
    poster record:

    **QNdefFilter**  filter;
        filter.append(**QNdefRecord** ::NfcRtd, "Sp");

    The following filter matches NDEF messages that contain a URI, a localized
    piece of text and an optional JPEG image. The order of the records must be
    in the order specified:

    **QNdefFilter**  filter;
        filter.setOrderMatch(true);
    filter.appendRecord(**QNdefRecord** ::NfcRtd, "U");
    filter.appendRecord<**QNdefNfcTextRecord** >();
    filter.appendRecord(**QNdefRecord** ::Mime, "image/jpeg", 0, 1);
    """

    class Record(sip.simplewrapper):
        maximum: int = ...
        minimum: int = ...
        type: typing = ...
        typeNameFormat = ...

        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QNdefFilter.Record") -> None:
            ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qndeffilter.html#QNdefFilter

        **QNdefFilter::QNdefFilter()**

        Constructs a new NDEF filter.
        """
        ...

    @typing.overload
    def __init__(self, other: "QNdefFilter") -> None:
        """
        https://doc.qt.io/qt-5/qndeffilter.html#QNdefFilter-1

        **QNdefFilter::QNdefFilter(const QNdefFilter & other )**

        constructs a new NDEF filter that is a copy of **other**.
        """
        ...

    def recordAt(self, i: int) -> "QNdefFilter.Record":
        """
        https://doc.qt.io/qt-5/qndeffilter.html#recordAt

        **QNdefFilter::Record QNdefFilter::recordAt(int i ) const**

        Returns the NDEF record at index **i**.
        """
        ...

    def __len__(self) -> int:
        ...

    def recordCount(self) -> int:
        """
        https://doc.qt.io/qt-5/qndeffilter.html#recordCount

        **int QNdefFilter::recordCount() const**

        Returns the number of NDEF records in the filter.
        """
        ...

    @typing.overload
    def appendRecord(
        self,
        typeNameFormat: "QNdefRecord.TypeNameFormat",
        type: typing.Union[QtCore.QByteArray, bytes, bytearray],
        min: int = ...,
        max: int = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qndeffilter.html#appendRecord

        **template <typename T> void QNdefFilter::appendRecord(unsigned int min
        = 1, unsigned int max = 1)**

        Appends a record matching the template parameter to the NDEF filter. The
        record must occur between **min** and **max** times in the NDEF message.
        """
        ...

    @typing.overload
    def appendRecord(self, record: "QNdefFilter.Record") -> None:
        """
        https://doc.qt.io/qt-5/qndeffilter.html#appendRecord-1

        **void QNdefFilter::appendRecord(QNdefRecord::TypeNameFormat
        typeNameFormat , const QByteArray & type , unsigned int min = 1,
        unsigned int max = 1)**

        Appends a record with type name format **typeNameFormat** and type
        **type** to the NDEF filter. The record must occur between **min** and
        **max** times in the NDEF message.
        """
        ...

    def orderMatch(self) -> bool:
        """
        https://doc.qt.io/qt-5/qndeffilter.html#orderMatch

        **bool QNdefFilter::orderMatch() const**

        Returns true if the filter takes NDEF record order into account when
        matching; otherwise returns false.

        **See also** **setOrderMatch** ().
        """
        ...

    def setOrderMatch(self, on: bool) -> None:
        """
        https://doc.qt.io/qt-5/qndeffilter.html#setOrderMatch

        **void QNdefFilter::setOrderMatch(bool on )**

        Sets the ording requirements of the filter. If **on** is true the filter
        will only match if the order of records in the filter matches the order
        of the records in the NDEF message. If **on** is false the order of the
        records is not taken into account when matching.

        By default record order is not taken into account.

        **See also** **orderMatch** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qndeffilter.html#clear

        **void QNdefFilter::clear()**

        Clears the filter.
        """
        ...
