"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5.QtNetwork import *


class QNetworkProxyFactory(PyQt5.sip.wrapper):
    """
    https://doc.qt.io/qt-5/qnetworkproxyfactory.html

    **Detailed Description**

    QNetworkProxyFactory is an extension to **QNetworkProxy** , allowing
    applications to have a more fine-grained control over which proxy servers
    are used, depending on the socket requesting the proxy. This allows an
    application to apply different settings, according to the protocol or
    destination hostname, for instance.

    QNetworkProxyFactory can be set globally for an application, in which case
    it will override any global proxies set with
    **QNetworkProxy::setApplicationProxy** (). If set globally, any sockets
    created with Qt will query the factory to determine the proxy to be used.

    A factory can also be set in certain frameworks that support multiple
    connections, such as **QNetworkAccessManager** . When set on such object,
    the factory will be queried for sockets created by that framework only.

    **System Proxies**

    You can configure a factory to use the system proxy's settings. Call the
    **setUseSystemConfiguration** () function with true to enable this behavior,
    or false to disable it.

    Similarly, you can use a factory to make queries directly to the system
    proxy by calling its **systemProxyForQuery** () function.

    **Warning:** Depending on the configuration of the user's system, the use of
    system proxy features on certain platforms may be subject to limitations.
    The **systemProxyForQuery** () documentation contains a list of these
    limitations for those platforms that are affected.
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkproxyfactory.html#QNetworkProxyFactory

        **QNetworkProxyFactory::QNetworkProxyFactory()**

        Creates a QNetworkProxyFactory object.

        Since QNetworkProxyFactory is an abstract class, you cannot create
        objects of type QNetworkProxyFactory directly.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QNetworkProxyFactory") -> None:
        """
        https://doc.qt.io/qt-5/qnetworkproxyfactory.html#QNetworkProxyFactory

        **QNetworkProxyFactory::QNetworkProxyFactory()**

        Creates a QNetworkProxyFactory object.

        Since QNetworkProxyFactory is an abstract class, you cannot create
        objects of type QNetworkProxyFactory directly.
        """
        ...

    @staticmethod
    def usesSystemConfiguration() -> bool:
        """
        https://doc.qt.io/qt-5/qnetworkproxyfactory.html#usesSystemConfiguration

        **[static] bool QNetworkProxyFactory::usesSystemConfiguration()**

        Returns whether the use of platform-specific proxy settings are enabled.

        This function was introduced in Qt 5.8.
        """
        ...

    @staticmethod
    def setUseSystemConfiguration(enable: bool) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkproxyfactory.html#setUseSystemConfigurati
        on

        **[static] void QNetworkProxyFactory::setUseSystemConfiguration(bool
        enable )**

        Enables the use of the platform-specific proxy settings, and only those.
        See **systemProxyForQuery** () for more information.

        Calling this function with **enable** set to `true` resets any proxy or
        **QNetworkProxyFactory**  that is already set.

        **Note:** See the **systemProxyForQuery** () documentation for a list of
        limitations related to the use of system proxies.

        This function was introduced in Qt 4.6.
        """
        ...

    @staticmethod
    def systemProxyForQuery(
        query: QNetworkProxyQuery = ...,
    ) -> typing.List[QNetworkProxy]:
        """
        https://doc.qt.io/qt-5/qnetworkproxyfactory.html#systemProxyForQuery

        **[static] QList<QNetworkProxy>
        QNetworkProxyFactory::systemProxyForQuery(const QNetworkProxyQuery &
        query = QNetworkProxyQuery())**

        This function takes the query request, **query** , examines the details
        of the type of socket or request and returns a list of **QNetworkProxy**
        objects that indicate the proxy servers to be used, in order of
        preference.

        This function can be used to determine the platform-specific proxy
        settings. This function will use the libraries provided by the operating
        system to determine the proxy for a given connection, if such libraries
        exist. If they don't, this function will just return a **QNetworkProxy**
        of type **QNetworkProxy::NoProxy** .

        On Windows, this function will use the WinHTTP DLL functions. Despite
        its name, Microsoft suggests using it for all applications that require
        network connections, not just HTTP. This will respect the proxy settings
        set on the registry with the proxycfg.exe tool. If those settings are
        not found, this function will attempt to obtain Internet Explorer's
        settings and use them.

        On macOS, this function will obtain the proxy settings using the
        SystemConfiguration framework from Apple. It will apply the FTP, HTTP
        and HTTPS proxy configurations for queries that contain the protocol tag
        "ftp", "http" and "https", respectively. If the SOCKS proxy is enabled
        in that configuration, this function will use the SOCKS server for all
        queries. If SOCKS isn't enabled, it will use the HTTPS proxy for all
        TcpSocket and UrlRequest queries.

        On other systems, this function will pick up proxy settings from the
        "http_proxy" environment variable. This variable must be a URL using one
        of the following schemes: "http", "socks5" or "socks5h".

        **Limitations**

        These are the limitations for the current version of this function.
        Future versions of Qt may lift some of the limitations listed here.

        * On macOS, this function will ignore the Proxy Auto Configuration
        settings, since it cannot execute the associated ECMAScript code.
          * On
        Windows platforms, this function may take several seconds to execute
        depending on the configuration of the user's system.
        """
        ...

    @staticmethod
    def proxyForQuery(query: QNetworkProxyQuery) -> typing.List[QNetworkProxy]:
        """
        https://doc.qt.io/qt-5/qnetworkproxyfactory.html#proxyForQuery

        **[static] QList<QNetworkProxy>
        QNetworkProxyFactory::proxyForQuery(const QNetworkProxyQuery & query )**

        This function takes the query request, **query** , examines the details
        of the type of socket or request and returns a list of **QNetworkProxy**
        objects that indicate the proxy servers to be used, in order of
        preference.
        """
        ...

    @staticmethod
    def setApplicationProxyFactory(factory: "QNetworkProxyFactory") -> None:
        """
        https://doc.qt.io/qt-5/qnetworkproxyfactory.html#setApplicationProxyFact
        ory

        **[static] void
        QNetworkProxyFactory::setApplicationProxyFactory(QNetworkProxyFactory *
        factory )**

        Sets the application-wide proxy factory to be **factory**. This function
        will take ownership of that object and will delete it when necessary.

        The application-wide proxy is used as a last-resort when all other proxy
        selection requests returned **QNetworkProxy::DefaultProxy** . For
        example, **QTcpSocket**  objects can have a proxy set with
        **QTcpSocket::setProxy** , but if none is set, the proxy factory class
        set with this function will be queried.

        If you set a proxy factory with this function, any application level
        proxies set with **QNetworkProxy::setApplicationProxy**  will be
        overridden, and **usesSystemConfiguration** () will return `false`.

        **See also** **QNetworkProxy::setApplicationProxy** (),
        **QAbstractSocket::proxy** (), and **QAbstractSocket::setProxy** ().
        """
        ...

    def queryProxy(self, query: QNetworkProxyQuery = ...) -> typing.List[QNetworkProxy]:
        """
        https://doc.qt.io/qt-5/qnetworkproxyfactory.html#queryProxy

        **[pure virtual] QList<QNetworkProxy>
        QNetworkProxyFactory::queryProxy(const QNetworkProxyQuery & query =
        QNetworkProxyQuery())**

        This function takes the query request, **query** , examines the details
        of the type of socket or request and returns a list of **QNetworkProxy**
        objects that indicate the proxy servers to be used, in order of
        preference.

        When reimplementing this class, take care to return at least one
        element.

        If you cannot determine a better proxy alternative, use
        **QNetworkProxy::DefaultProxy** , which tells the code querying for a
        proxy to use a higher alternative. For example, if this factory is set
        to a **QNetworkAccessManager**  object, DefaultProxy will tell it to
        query the application-level proxy settings.

        If this factory is set as the application proxy factory, DefaultProxy
        and NoProxy will have the same meaning.
        """
        ...
