"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtCore
import datetime
from PyQt5.QtNetwork import *
from PyQt5 import sip


class QNetworkCacheMetaData(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qnetworkcachemetadata.html

    **Detailed Description**

    QNetworkCacheMetaData provides information about a cache file including the
    url, when it was last modified, when the cache file was created, headers for
    file and if the file should be saved onto a disk.

    **See also** **QAbstractNetworkCache** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkcachemetadata.html#QNetworkCacheMetaData

        **QNetworkCacheMetaData::QNetworkCacheMetaData()**

        Constructs an invalid network cache meta data.

        **See also** **isValid** ().
        """
        ...

    @typing.overload
    def __init__(self, other: "QNetworkCacheMetaData") -> None:
        """
        https://doc.qt.io/qt-5/qnetworkcachemetadata.html#QNetworkCacheMetaData-
        1

        **QNetworkCacheMetaData::QNetworkCacheMetaData(const
        QNetworkCacheMetaData & other )**

        Constructs a copy of the **other** QNetworkCacheMetaData.
        """
        ...

    def swap(self, other: "QNetworkCacheMetaData") -> None:
        """
        https://doc.qt.io/qt-5/qnetworkcachemetadata.html#swap

        **void QNetworkCacheMetaData::swap(QNetworkCacheMetaData & other )**

        Swaps this metadata instance with **other**. This function is very fast
        and never fails.

        This function was introduced in Qt 5.0.
        """
        ...

    def setAttributes(
        self, attributes: typing.Dict["QNetworkRequest.Attribute", typing.Any]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkcachemetadata.html#setAttributes

        **void QNetworkCacheMetaData::setAttributes(const
        QNetworkCacheMetaData::AttributesMap & attributes )**

        Sets all attributes of this cache item to be the map **attributes**.

        This function was introduced in Qt 4.6.

        **See also** **attributes** () and **QNetworkRequest::setAttribute** ().
        """
        ...

    def attributes(self) -> typing.Dict["QNetworkRequest.Attribute", typing.Any]:
        """
        https://doc.qt.io/qt-5/qnetworkcachemetadata.html#attributes

        **QNetworkCacheMetaData::AttributesMap
        QNetworkCacheMetaData::attributes() const**

        Returns all the attributes stored with this cache item.

        This function was introduced in Qt 4.6.

        **See also** **setAttributes** () and **QNetworkRequest::Attribute** .
        """
        ...

    def setSaveToDisk(self, allow: bool) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkcachemetadata.html#setSaveToDisk

        **void QNetworkCacheMetaData::setSaveToDisk(bool allow )**

        Sets whether this network cache meta data and associated content should
        be allowed to be stored on disk to **allow**.

        **See also** **saveToDisk** ().
        """
        ...

    def saveToDisk(self) -> bool:
        """
        https://doc.qt.io/qt-5/qnetworkcachemetadata.html#saveToDisk

        **bool QNetworkCacheMetaData::saveToDisk() const**

        Returns is this cache should be allowed to be stored on disk.

        Some cache implementations can keep these cache items in memory for
        performance reasons, but for security reasons they should not be written
        to disk.

        Specifically with http, documents with Cache-control set to no-store or
        any https document that doesn't have "Cache-control: public" set will
        set the saveToDisk to false.

        **See also** **setSaveToDisk** ().
        """
        ...

    def setExpirationDate(
        self, dateTime: typing.Union[QtCore.QDateTime, datetime.datetime]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkcachemetadata.html#setExpirationDate

        **void QNetworkCacheMetaData::setExpirationDate(const QDateTime &
        dateTime )**

        Sets the date and time when the meta data expires to **dateTime**.

        **See also** **expirationDate** ().
        """
        ...

    def expirationDate(self) -> QtCore.QDateTime:
        """
        https://doc.qt.io/qt-5/qnetworkcachemetadata.html#expirationDate

        **QDateTime QNetworkCacheMetaData::expirationDate() const**

        Returns the date and time when the meta data expires.

        **See also** **setExpirationDate** ().
        """
        ...

    def setLastModified(
        self, dateTime: typing.Union[QtCore.QDateTime, datetime.datetime]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkcachemetadata.html#setLastModified

        **void QNetworkCacheMetaData::setLastModified(const QDateTime & dateTime
        )**

        Sets the date and time when the meta data was last modified to
        **dateTime**.

        **See also** **lastModified** ().
        """
        ...

    def lastModified(self) -> QtCore.QDateTime:
        """
        https://doc.qt.io/qt-5/qnetworkcachemetadata.html#lastModified

        **QDateTime QNetworkCacheMetaData::lastModified() const**

        Returns the date and time when the meta data was last modified.

        **See also** **setLastModified** ().
        """
        ...

    def setRawHeaders(
        self,
        headers: typing.Iterable[
            typing.Tuple[
                typing.Union[QtCore.QByteArray, bytes, bytearray],
                typing.Union[QtCore.QByteArray, bytes, bytearray],
            ]
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkcachemetadata.html#setRawHeaders

        **void QNetworkCacheMetaData::setRawHeaders(const
        QNetworkCacheMetaData::RawHeaderList & list )**

        Sets the raw headers to **list**.

        **See also** **rawHeaders** ().
        """
        ...

    def rawHeaders(
        self,
    ) -> typing.List[typing.Tuple[QtCore.QByteArray, QtCore.QByteArray]]:
        """
        https://doc.qt.io/qt-5/qnetworkcachemetadata.html#rawHeaders

        **QNetworkCacheMetaData::RawHeaderList
        QNetworkCacheMetaData::rawHeaders() const**

        Returns a list of all raw headers that are set in this meta data. The
        list is in the same order that the headers were set.

        **See also** **setRawHeaders** ().
        """
        ...

    def setUrl(self, url: QtCore.QUrl) -> None:
        """
        https://doc.qt.io/qt-5/qnetworkcachemetadata.html#setUrl

        **void QNetworkCacheMetaData::setUrl(const QUrl & url )**

        Sets the URL this network cache meta data to be **url**.

        The password and fragment are removed from the url.

        **See also** **url** ().
        """
        ...

    def url(self) -> QtCore.QUrl:
        """
        https://doc.qt.io/qt-5/qnetworkcachemetadata.html#url

        **QUrl QNetworkCacheMetaData::url() const**

        Returns the URL this network cache meta data is referring to.

        **See also** **setUrl** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-5/qnetworkcachemetadata.html#isValid

        **bool QNetworkCacheMetaData::isValid() const**

        Returns `true` if this network cache meta data has attributes that have
        been set otherwise false.
        """
        ...
