"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtWidgets
from PyQt5 import QtMultimedia
from PyQt5 import QtCore
from PyQt5.QtMultimediaWidgets import *


class QVideoWidget(QtWidgets.QWidget, QtMultimedia.QMediaBindableInterface):
    """
    https://doc.qt.io/qt-5/qvideowidget.html

    **Detailed Description**

    Attaching a QVideoWidget to a **QMediaObject**  allows it to display the
    video or image output of that media object. A QVideoWidget is attached to
    media object by passing a pointer to the **QMediaObject**  in its
    constructor, and detached by destroying the QVideoWidget.

    player = new **QMediaPlayer** ;

        playlist = new **QMediaPlaylist**
    (player);
        playlist->addMedia(**QUrl**
    ("http://example.com/myclip1.mp4"));
        playlist->addMedia(**QUrl**
    ("http://example.com/myclip2.mp4"));

        videoWidget = new
    **QVideoWidget** ;
        player->setVideoOutput(videoWidget);
    videoWidget->show();
        playlist->setCurrentIndex(1);
        player->play();

    **Note** : Only a single display output can be attached to a media object at
    one time.

    **See also** **QMediaObject** , **QMediaPlayer** , and
    **QGraphicsVideoItem** .
    """

    def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qvideowidget.html#QVideoWidget

        **QVideoWidget::QVideoWidget(QWidget * parent = nullptr)**

        Constructs a new video widget.

        The **parent** is passed to **QWidget** .
        """
        ...

    def videoSurface(self) -> QtMultimedia.QAbstractVideoSurface:
        """
        https://doc.qt.io/qt-5/qvideowidget.html#videoSurface-prop

        **videoSurface : QAbstractVideoSurface* const**

        Returns the underlaying video surface that can render video frames to
        the current widget. This property is never `nullptr`. Example of how to
        render video frames to **QVideoWidget** :

        **QImage**  img = **QImage** ("images/qt-
        logo.png").convertToFormat(**QImage** ::Format_ARGB32);
        **QVideoSurfaceFormat**  format(img.size(), **QVideoFrame**
        ::Format_ARGB32);
            videoWidget = new **QVideoWidget** ;
        videoWidget->videoSurface()->start(format);
        videoWidget->videoSurface()->present(img);
            videoWidget->show();

        This property was introduced in Qt 5.15.

        **Access functions:**

        QAbstractVideoSurface * **videoSurface** () const

        **See also** **QMediaPlayer::setVideoOutput** .

        **Member Function Documentation**
        """
        ...

    def setMediaObject(self, object: QtMultimedia.QMediaObject) -> bool:
        """
        https://doc.qt.io/qt-5/qvideowidget.html#mediaObject-prop

        **mediaObject : QMediaObject* const**

        This property holds the media object which provides the video displayed
        by a widget.

        **Access functions:**

        virtual QMediaObject * **mediaObject** () const override
        """
        ...

    def paintEvent(self, event: QtGui.QPaintEvent) -> None:
        """
        https://doc.qt.io/qt-5/qvideowidget.html#paintEvent

        **[override virtual protected] void QVideoWidget::paintEvent(QPaintEvent
        * event )**

        Reimplements: **QWidget::paintEvent** (QPaintEvent *event).

        Handles the paint **event**.
        """
        ...

    def moveEvent(self, event: QtGui.QMoveEvent) -> None:
        """
        https://doc.qt.io/qt-5/qvideowidget.html#moveEvent

        **[override virtual protected] void QVideoWidget::moveEvent(QMoveEvent *
        event )**

        Reimplements: **QWidget::moveEvent** (QMoveEvent *event).

        Handles the move **event**.
        """
        ...

    def resizeEvent(self, event: QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-5/qvideowidget.html#resizeEvent

        **[override virtual protected] void
        QVideoWidget::resizeEvent(QResizeEvent * event )**

        Reimplements: **QWidget::resizeEvent** (QResizeEvent *event).

        Handles the resize **event**.
        """
        ...

    def hideEvent(self, event: QtGui.QHideEvent) -> None:
        """
        https://doc.qt.io/qt-5/qvideowidget.html#hideEvent

        **[override virtual protected] void QVideoWidget::hideEvent(QHideEvent *
        event )**

        Reimplements: **QWidget::hideEvent** (QHideEvent *event).

        Handles the hide **event**.
        """
        ...

    def showEvent(self, event: QtGui.QShowEvent) -> None:
        """
        https://doc.qt.io/qt-5/qvideowidget.html#showEvent

        **[override virtual protected] void QVideoWidget::showEvent(QShowEvent *
        event )**

        Reimplements: **QWidget::showEvent** (QShowEvent *event).

        Handles the show **event**.
        """
        ...

    def event(self, event: QtCore.QEvent) -> bool:
        """
        https://doc.qt.io/qt-5/qvideowidget.html#event

        **[override virtual protected] bool QVideoWidget::event(QEvent * event
        )**

        Reimplements: **QWidget::event** (QEvent *event).

        Current event **event**. Returns the value of the baseclass
        **QWidget::event** (**QEvent**  *event) function.
        """
        ...

    def setSaturation(self, saturation: int) -> None:
        """
        https://doc.qt.io/qt-5/qvideowidget.html#saturation-prop

        **saturation : int**

        This property holds an adjustment to the saturation of displayed video.

        Valid saturation values range between -100 and 100, the default is 0.

        **Access functions:**

        int **saturation** () const
        void **setSaturation** (int **saturation**
        )

        **Notifier signal:**

        void ****saturationChanged** ** (int **saturation** )
        """
        ...

    def setHue(self, hue: int) -> None:
        """
        https://doc.qt.io/qt-5/qvideowidget.html#hue-prop

        **hue : int**

        This property holds an adjustment to the hue of displayed video.

        Valid hue values range between -100 and 100, the default is 0.

        **Access functions:**

        int **hue** () const
        void **setHue** (int **hue** )

        **Notifier signal:**

        void ****hueChanged** ** (int **hue** )
        """
        ...

    def setContrast(self, contrast: int) -> None:
        """
        https://doc.qt.io/qt-5/qvideowidget.html#contrast-prop

        **contrast : int**

        This property holds an adjustment to the contrast of displayed video.

        Valid contrast values range between -100 and 100, the default is 0.

        **Access functions:**

        int **contrast** () const
        void **setContrast** (int **contrast** )

        **Notifier signal:**

        void ****contrastChanged** ** (int **contrast** )
        """
        ...

    def setBrightness(self, brightness: int) -> None:
        """
        https://doc.qt.io/qt-5/qvideowidget.html#brightness-prop

        **brightness : int**

        This property holds an adjustment to the brightness of displayed video.

        Valid brightness values range between -100 and 100, the default is 0.

        **Access functions:**

        int **brightness** () const
        void **setBrightness** (int **brightness**
        )

        **Notifier signal:**

        void ****brightnessChanged** ** (int **brightness** )
        """
        ...

    def setAspectRatioMode(self, mode: QtCore.Qt.AspectRatioMode) -> None:
        """
        https://doc.qt.io/qt-5/qvideowidget.html#aspectRatioMode-prop

        **aspectRatioMode : Qt::AspectRatioMode**

        how video is scaled with respect to its aspect ratio.

        **Access functions:**

        Qt::AspectRatioMode **aspectRatioMode** () const
        void
        **setAspectRatioMode** (Qt::AspectRatioMode **mode** )
        """
        ...

    def setFullScreen(self, fullScreen: bool) -> None:
        """
        https://doc.qt.io/qt-5/qvideowidget.html#fullScreen-prop

        **fullScreen : bool**

        This property holds whether video display is confined to a window or is
        fullScreen.

        **Access functions:**

        bool **isFullScreen** () const
        void **setFullScreen** (bool
        **fullScreen** )

        **Notifier signal:**

        void ****fullScreenChanged** ** (bool **fullScreen** )
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-5/qvideowidget.html#sizeHint

        **[override virtual] QSize QVideoWidget::sizeHint() const**

        Reimplements an access function for property: **QWidget::sizeHint** .

        Returns the size hint for the current back end, if there is one, or else
        the size hint from **QWidget** .
        """
        ...

    def saturation(self) -> int:
        """
        https://doc.qt.io/qt-5/qvideowidget.html#saturation-prop

        **saturation : int**

        This property holds an adjustment to the saturation of displayed video.

        Valid saturation values range between -100 and 100, the default is 0.

        **Access functions:**

        int **saturation** () const
        void **setSaturation** (int **saturation**
        )

        **Notifier signal:**

        void ****saturationChanged** ** (int **saturation** )
        """
        ...

    def hue(self) -> int:
        """
        https://doc.qt.io/qt-5/qvideowidget.html#hue-prop

        **hue : int**

        This property holds an adjustment to the hue of displayed video.

        Valid hue values range between -100 and 100, the default is 0.

        **Access functions:**

        int **hue** () const
        void **setHue** (int **hue** )

        **Notifier signal:**

        void ****hueChanged** ** (int **hue** )
        """
        ...

    def contrast(self) -> int:
        """
        https://doc.qt.io/qt-5/qvideowidget.html#contrast-prop

        **contrast : int**

        This property holds an adjustment to the contrast of displayed video.

        Valid contrast values range between -100 and 100, the default is 0.

        **Access functions:**

        int **contrast** () const
        void **setContrast** (int **contrast** )

        **Notifier signal:**

        void ****contrastChanged** ** (int **contrast** )
        """
        ...

    def brightness(self) -> int:
        """
        https://doc.qt.io/qt-5/qvideowidget.html#brightness-prop

        **brightness : int**

        This property holds an adjustment to the brightness of displayed video.

        Valid brightness values range between -100 and 100, the default is 0.

        **Access functions:**

        int **brightness** () const
        void **setBrightness** (int **brightness**
        )

        **Notifier signal:**

        void ****brightnessChanged** ** (int **brightness** )
        """
        ...

    def aspectRatioMode(self) -> QtCore.Qt.AspectRatioMode:
        """
        https://doc.qt.io/qt-5/qvideowidget.html#aspectRatioMode-prop

        **aspectRatioMode : Qt::AspectRatioMode**

        how video is scaled with respect to its aspect ratio.

        **Access functions:**

        Qt::AspectRatioMode **aspectRatioMode** () const
        void
        **setAspectRatioMode** (Qt::AspectRatioMode **mode** )
        """
        ...

    def mediaObject(self) -> QtMultimedia.QMediaObject:
        """
        https://doc.qt.io/qt-5/qvideowidget.html#mediaObject-prop

        **mediaObject : QMediaObject* const**

        This property holds the media object which provides the video displayed
        by a widget.

        **Access functions:**

        virtual QMediaObject * **mediaObject** () const override
        """
        ...

    @property
    def brightnessChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qvideowidget.html#brightnessChanged

        **[signal] void QVideoWidget::brightnessChanged(int brightness )**

        Signals that a video widgets's **brightness** adjustment has changed.

        **Note:** Notifier signal for property **brightness** .

        **See also** **brightness** ().
        """
        ...

    @property
    def contrastChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qvideowidget.html#contrastChanged

        **[signal] void QVideoWidget::contrastChanged(int contrast )**

        Signals that a video widgets's **contrast** adjustment has changed.

        **Note:** Notifier signal for property **contrast** .

        **See also** **contrast** ().
        """
        ...

    @property
    def fullScreenChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qvideowidget.html#fullScreenChanged

        **[signal] void QVideoWidget::fullScreenChanged(bool fullScreen )**

        Signals that the **fullScreen** mode of a video widget has changed.

        **Note:** Notifier signal for property **fullScreen** .

        **See also** **isFullScreen** ().
        """
        ...

    @property
    def hueChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qvideowidget.html#hueChanged

        **[signal] void QVideoWidget::hueChanged(int hue )**

        Signals that a video widgets's **hue** has changed.

        **Note:** Notifier signal for property **hue** .

        **See also** **hue** ().
        """
        ...

    @property
    def saturationChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qvideowidget.html#saturationChanged

        **[signal] void QVideoWidget::saturationChanged(int saturation )**

        Signals that a video widgets's **saturation** has changed.

        **Note:** Notifier signal for property **saturation** .

        **See also** **saturation** ().
        """
        ...
