"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QMediaGaplessPlaybackControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qmediagaplessplaybackcontrol.html

    **Detailed Description**

    If a **QMediaService**  supports gapless playback it will implement
    QMediaGaplessPlaybackControl. This control provides a means to set the
    **next media**  or **crossfade time**  for smooth transitions between
    tracks.

    The functionality provided by this control is exposed to application code
    through the **QMediaPlayer**  class.

    The interface name of QMediaGaplessPlaybackControl is `org.qt-
    project.qt.mediagaplessplaybackcontrol/5.0` as defined in
    **QMediaGaplessPlaybackControl_iid** .

    **See also** **QMediaService::requestControl** () and **QMediaPlayer** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qmediagaplessplaybackcontrol.html#QMediaGaplessPl
        aybackControl

        **[protected]
        QMediaGaplessPlaybackControl::QMediaGaplessPlaybackControl(QObject *
        parent = nullptr)**

        Constructs a new gapless playback control with the given **parent**.
        """
        ...

    def setCrossfadeTime(self, crossfadeTime: float) -> None:
        """
        https://doc.qt.io/qt-5/qmediagaplessplaybackcontrol.html#setCrossfadeTim
        e

        **[pure virtual] void
        QMediaGaplessPlaybackControl::setCrossfadeTime(qreal crossfadeTime )**

        Sets the **crossfadeTime** in seconds for smooth transition.

        Positive value means how much time it will take for the next media to
        transit from silent to full volume and vice versa for current one. So
        both current and the next one will be playing during this period of
        time.

        A crossfade time of zero or negative will result in gapless playback
        (suitable for some continuous media).

        **See also** **crossfadeTime** ().
        """
        ...

    def crossfadeTime(self) -> float:
        """
        https://doc.qt.io/qt-5/qmediagaplessplaybackcontrol.html#crossfadeTime

        **[pure virtual] qreal QMediaGaplessPlaybackControl::crossfadeTime()
        const**

        Returns current crossfade time in seconds.

        **See also** **setCrossfadeTime** ().
        """
        ...

    def isCrossfadeSupported(self) -> bool:
        """
        https://doc.qt.io/qt-5/qmediagaplessplaybackcontrol.html#isCrossfadeSupp
        orted

        **[pure virtual] bool
        QMediaGaplessPlaybackControl::isCrossfadeSupported() const**

        Indicates whether crossfading is supported or not. If crossfading is not
        supported, **setCrossfadeTime** () will be ignored and **crossfadeTime**
        () will always return 0.
        """
        ...

    def setNextMedia(self, media: QMediaContent) -> None:
        """
        https://doc.qt.io/qt-5/qmediagaplessplaybackcontrol.html#setNextMedia

        **[pure virtual] void QMediaGaplessPlaybackControl::setNextMedia(const
        QMediaContent & media )**

        Sets the next **media** for smooth transition.

        **See also** **nextMedia** ().
        """
        ...

    def nextMedia(self) -> QMediaContent:
        """
        https://doc.qt.io/qt-5/qmediagaplessplaybackcontrol.html#nextMedia

        **[pure virtual] QMediaContent QMediaGaplessPlaybackControl::nextMedia()
        const**

        Returns the content of the next media

        **See also** **setNextMedia** ().
        """
        ...

    @property
    def advancedToNextMedia(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediagaplessplaybackcontrol.html#advancedToNextM
        edia

        **[signal] void QMediaGaplessPlaybackControl::advancedToNextMedia()**

        Signals when the player advances to the next media (the content of next
        media will be cleared).

        **See also** **nextMedia** ().
        """
        ...

    @property
    def crossfadeTimeChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediagaplessplaybackcontrol.html#crossfadeTimeCh
        anged

        **[signal] void QMediaGaplessPlaybackControl::crossfadeTimeChanged(qreal
        crossfadeTime )**

        Signals that the **crossfadeTime** has changed.

        **See also** **crossfadeTime** ().
        """
        ...

    @property
    def nextMediaChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediagaplessplaybackcontrol.html#nextMediaChange
        d

        **[signal] void QMediaGaplessPlaybackControl::nextMediaChanged(const
        QMediaContent & media )**

        Signals that the next **media** has changed (either explicitly via
        **setNextMedia** () or when the player clears the next media while
        advancing to it).

        **See also** **nextMedia** ().
        """
        ...
