"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QMediaAudioProbeControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qmediaaudioprobecontrol.html

    **Detailed Description**

    **QAudioProbe**  is the client facing class for probing audio - this class
    is implemented by media backends to provide this functionality.

    The interface name of QMediaAudioProbeControl is `org.qt-
    project.qt.mediaaudioprobecontrol/5.0` as defined in
    **QMediaAudioProbeControl_iid** .

    **See also** **QAudioProbe** , **QMediaService::requestControl** (),
    **QMediaPlayer** , and **QCamera** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qmediaaudioprobecontrol.html#QMediaAudioProbeCont
        rol

        **[protected] QMediaAudioProbeControl::QMediaAudioProbeControl(QObject *
        parent = nullptr)**

        Create a new media audio probe control object with the given **parent**.
        """
        ...

    @property
    def audioBufferProbed(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaaudioprobecontrol.html#audioBufferProbed

        **[signal] void QMediaAudioProbeControl::audioBufferProbed(const
        QAudioBuffer & buffer )**

        This signal should be emitted when an audio **buffer** is processed in
        the media service.
        """
        ...

    @property
    def flush(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qmediaaudioprobecontrol.html#flush

        **[signal] void QMediaAudioProbeControl::flush()**

        This signal should be emitted when it is required to release all frames.
        """
        ...
