"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QCameraImageProcessing(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qcameraimageprocessing.html

    **Detailed Description**

    After capturing the data for a camera frame, the camera hardware and
    software performs various image processing tasks to produce a final image.
    This includes compensating for ambient light color, reducing noise, as well
    as making some other adjustments to the image.

    You can retrieve this class from an instance of a **QCamera**  object.

    For example, you can set the white balance (or color temperature) used for
    processing images:

    camera = new **QCamera** ;
        QCameraImageProcessing *imageProcessing =
    camera->imageProcessing();

        if (imageProcessing->isAvailable()) {
    imageProcessing->setWhiteBalanceMode(QCameraImageProcessing::WhiteBalanceFlu
    orescent);
        }

    Or adjust the amount of denoising performed:

    imageProcessing->setDenoisingLevel(-0.3); //reduce the amount of denoising
    applied

    In some cases changing these settings may result in a longer delay before an
    image is ready.

    For more information on image processing of camera frames, see **Camera
    Image Processing** .

    **See also** **QCameraImageProcessingControl** .
    """

    class ColorFilter(int):
        ColorFilterNone: QCameraImageProcessing = ...
        ColorFilterGrayscale: QCameraImageProcessing = ...
        ColorFilterNegative: QCameraImageProcessing = ...
        ColorFilterSolarize: QCameraImageProcessing = ...
        ColorFilterSepia: QCameraImageProcessing = ...
        ColorFilterPosterize: QCameraImageProcessing = ...
        ColorFilterWhiteboard: QCameraImageProcessing = ...
        ColorFilterBlackboard: QCameraImageProcessing = ...
        ColorFilterAqua: QCameraImageProcessing = ...
        ColorFilterVendor: QCameraImageProcessing = ...

    class WhiteBalanceMode(int):
        WhiteBalanceAuto: QCameraImageProcessing = ...
        WhiteBalanceManual: QCameraImageProcessing = ...
        WhiteBalanceSunlight: QCameraImageProcessing = ...
        WhiteBalanceCloudy: QCameraImageProcessing = ...
        WhiteBalanceShade: QCameraImageProcessing = ...
        WhiteBalanceTungsten: QCameraImageProcessing = ...
        WhiteBalanceFluorescent: QCameraImageProcessing = ...
        WhiteBalanceFlash: QCameraImageProcessing = ...
        WhiteBalanceSunset: QCameraImageProcessing = ...
        WhiteBalanceVendor: QCameraImageProcessing = ...

    def setBrightness(self, value: float) -> None:
        """
        https://doc.qt.io/qt-5/qcameraimageprocessing.html#setBrightness

        **void QCameraImageProcessing::setBrightness(qreal value )**

        Set the brightness adjustment to **value**.

        Valid brightness adjustment values range between -1.0 and 1.0, with a
        default of 0.

        **See also** **brightness** ().
        """
        ...

    def brightness(self) -> float:
        """
        https://doc.qt.io/qt-5/qcameraimageprocessing.html#brightness

        **qreal QCameraImageProcessing::brightness() const**

        Returns the brightness adjustment setting.

        **See also** **setBrightness** ().
        """
        ...

    def isColorFilterSupported(
        self, filter: "QCameraImageProcessing.ColorFilter"
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qcameraimageprocessing.html#isColorFilterSupporte
        d

        **bool QCameraImageProcessing::isColorFilterSupported(QCameraImageProces
        sing::ColorFilter filter ) const**

        Returns true if a color **filter** is supported.

        This function was introduced in Qt 5.5.
        """
        ...

    def setColorFilter(self, filter: "QCameraImageProcessing.ColorFilter") -> None:
        """
        https://doc.qt.io/qt-5/qcameraimageprocessing.html#setColorFilter

        **void QCameraImageProcessing::setColorFilter(QCameraImageProcessing::Co
        lorFilter filter )**

        Sets the color **filter** which will be applied to image data captured
        by the camera.

        This function was introduced in Qt 5.5.

        **See also** **colorFilter** ().
        """
        ...

    def colorFilter(self) -> "QCameraImageProcessing.ColorFilter":
        """
        https://doc.qt.io/qt-5/qcameraimageprocessing.html#colorFilter

        **QCameraImageProcessing::ColorFilter
        QCameraImageProcessing::colorFilter() const**

        Returns the color filter which will be applied to image data captured by
        the camera.

        This function was introduced in Qt 5.5.

        **See also** **setColorFilter** ().
        """
        ...

    def setDenoisingLevel(self, value: float) -> None:
        """
        https://doc.qt.io/qt-5/qcameraimageprocessing.html#setDenoisingLevel

        **void QCameraImageProcessing::setDenoisingLevel(qreal level )**

        Sets the denoising adjustment **level**.

        Valid denoising values range between -1.0 and 1.0, with a default of 0.

        If the parameter value is set to 0, the amount of denoising applied is
        selected by camera and depends on camera capabilities and settings.
        Changing value in -1.0..1.0 range adjusts the amount of denoising
        applied within the supported range.

        **See also** **denoisingLevel** ().
        """
        ...

    def denoisingLevel(self) -> float:
        """
        https://doc.qt.io/qt-5/qcameraimageprocessing.html#denoisingLevel

        **qreal QCameraImageProcessing::denoisingLevel() const**

        Returns the denoising adjustment level.

        **See also** **setDenoisingLevel** ().
        """
        ...

    def setSharpeningLevel(self, value: float) -> None:
        """
        https://doc.qt.io/qt-5/qcameraimageprocessing.html#setSharpeningLevel

        **void QCameraImageProcessing::setSharpeningLevel(qreal level )**

        Sets the sharpening adjustment **level**.

        Valid sharpening values range between -1.0 and 1.0, with a default of 0.

        **See also** **sharpeningLevel** ().
        """
        ...

    def sharpeningLevel(self) -> float:
        """
        https://doc.qt.io/qt-5/qcameraimageprocessing.html#sharpeningLevel

        **qreal QCameraImageProcessing::sharpeningLevel() const**

        Returns the sharpening adjustment level.

        **See also** **setSharpeningLevel** ().
        """
        ...

    def setSaturation(self, value: float) -> None:
        """
        https://doc.qt.io/qt-5/qcameraimageprocessing.html#setSaturation

        **void QCameraImageProcessing::setSaturation(qreal value )**

        Sets the saturation adjustment value to **value**.

        Valid saturation values range between -1.0 and 1.0, with a default of 0.

        **See also** **saturation** ().
        """
        ...

    def saturation(self) -> float:
        """
        https://doc.qt.io/qt-5/qcameraimageprocessing.html#saturation

        **qreal QCameraImageProcessing::saturation() const**

        Returns the saturation adjustment value.

        **See also** **setSaturation** ().
        """
        ...

    def setContrast(self, value: float) -> None:
        """
        https://doc.qt.io/qt-5/qcameraimageprocessing.html#setContrast

        **void QCameraImageProcessing::setContrast(qreal value )**

        Set the contrast adjustment to **value**.

        Valid contrast adjustment values range between -1.0 and 1.0, with a
        default of 0.

        **See also** **contrast** ().
        """
        ...

    def contrast(self) -> float:
        """
        https://doc.qt.io/qt-5/qcameraimageprocessing.html#contrast

        **qreal QCameraImageProcessing::contrast() const**

        Returns the contrast adjustment setting.

        **See also** **setContrast** ().
        """
        ...

    def setManualWhiteBalance(self, colorTemperature: float) -> None:
        """
        https://doc.qt.io/qt-5/qcameraimageprocessing.html#setManualWhiteBalance

        **void QCameraImageProcessing::setManualWhiteBalance(qreal
        colorTemperature )**

        Sets manual white balance to **colorTemperature**. This is used when
        **whiteBalanceMode** () is set to `WhiteBalanceManual`. The units are
        Kelvin.

        **See also** **manualWhiteBalance** ().
        """
        ...

    def manualWhiteBalance(self) -> float:
        """
        https://doc.qt.io/qt-5/qcameraimageprocessing.html#manualWhiteBalance

        **qreal QCameraImageProcessing::manualWhiteBalance() const**

        Returns the current color temperature if the current white balance mode
        is `WhiteBalanceManual`. For other modes the return value is undefined.

        **See also** **setManualWhiteBalance** ().
        """
        ...

    def isWhiteBalanceModeSupported(
        self, mode: "QCameraImageProcessing.WhiteBalanceMode"
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qcameraimageprocessing.html#isWhiteBalanceModeSup
        ported

        **bool QCameraImageProcessing::isWhiteBalanceModeSupported(QCameraImageP
        rocessing::WhiteBalanceMode mode ) const**

        Returns true if the white balance **mode** is supported.
        """
        ...

    def setWhiteBalanceMode(
        self, mode: "QCameraImageProcessing.WhiteBalanceMode"
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcameraimageprocessing.html#setWhiteBalanceMode

        **void QCameraImageProcessing::setWhiteBalanceMode(QCameraImageProcessin
        g::WhiteBalanceMode mode )**

        Sets the white balance to **mode**.

        **See also** **whiteBalanceMode** ().
        """
        ...

    def whiteBalanceMode(self) -> "QCameraImageProcessing.WhiteBalanceMode":
        """
        https://doc.qt.io/qt-5/qcameraimageprocessing.html#whiteBalanceMode

        **QCameraImageProcessing::WhiteBalanceMode
        QCameraImageProcessing::whiteBalanceMode() const**

        Returns the white balance mode being used.

        **See also** **setWhiteBalanceMode** ().
        """
        ...

    def isAvailable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qcameraimageprocessing.html#isAvailable

        **bool QCameraImageProcessing::isAvailable() const**

        Returns true if image processing related settings are supported by this
        camera.
        """
        ...
