"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *
from PyQt5 import sip


class QCameraFocus(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qcamerafocus.html

    **Detailed Description**

    On hardware that supports it, this class lets you adjust the focus or zoom
    (both optical and digital). This also includes things like "Macro" mode for
    close up work (e.g. reading barcodes, or recognising letters), or "touch to
    focus" - indicating an interesting area of the viewfinder for the hardware
    to attempt to focus on.

    QCameraFocus *focus = camera->focus();
    focus->setFocusPointMode(QCameraFocus::FocusPointCustom);
    focus->setCustomFocusPoint(**QPointF** (0.25f, 0.75f)); // A point near the
    bottom left, 25% away from the corner, near that shiny vase

    Zooming can be accomplished in a number of ways - usually the more expensive
    but higher quality approach is an optical zoom, which allows using the full
    extent of the camera sensor to gather image pixels. In addition it is
    possible to digitally zoom, which will generally just enlarge part of the
    sensor frame and throw away other parts. If the camera hardware supports
    optical zoom this should generally always be used first. The
    **maximumOpticalZoom** () method allows this to be checked. The **zoomTo**
    () method allows changing both optical and digital zoom at once.

    focus->zoomTo(3.0, 4.0); // Super zoom!

    **Some notes on autofocus**

    Some hardware supports a movable focus lens assembly, and typically this
    hardware also supports automatically focusing via some heuristic. You can
    influence this via the **FocusPointMode**  setting - typically the center of
    the frame is brought into focus, but some hardware also supports focusing on
    any faces detected in the frame, or on a specific point (usually provided by
    a user in a "touch to focus" scenario).

    This class (in combination with **QCameraFocusZone** ) can expose
    information on what parts of the camera sensor image are in focus or are
    being used for autofocusing via the **focusZones** () property:

    focus->setFocusPointMode(QCameraFocus::FocusPointAuto);
        const **QList**
    <**QCameraFocusZone** > zones = focus->focusZones();
        for (const
    **QCameraFocusZone**  &zone : zones) {
            if (zone.status() ==
    **QCameraFocusZone** ::Focused) {
                // Draw a green box at
    zone.area()
            } else if (zone.status() == **QCameraFocusZone**
    ::Selected) {
                // This area is selected for autofocusing, but is
    not in focus
                // Draw a yellow box at zone.area()
            }
        }

    **See also** **QCameraFocusZone** .
    """

    class FocusPointMode(int):
        FocusPointAuto: QCameraFocus = ...
        FocusPointCenter: QCameraFocus = ...
        FocusPointFaceDetection: QCameraFocus = ...
        FocusPointCustom: QCameraFocus = ...

    class FocusMode(int):
        ManualFocus: QCameraFocus = ...
        HyperfocalFocus: QCameraFocus = ...
        InfinityFocus: QCameraFocus = ...
        AutoFocus: QCameraFocus = ...
        ContinuousFocus: QCameraFocus = ...
        MacroFocus: QCameraFocus = ...

    class FocusModes(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self, f: typing.Union["QCameraFocus.FocusModes", "QCameraFocus.FocusMode"]
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QCameraFocus.FocusModes") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QCameraFocus.FocusModes":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def zoomTo(self, opticalZoom: float, digitalZoom: float) -> None:
        """
        https://doc.qt.io/qt-5/qcamerafocus.html#zoomTo

        **void QCameraFocus::zoomTo(qreal optical , qreal digital )**

        Set the camera **optical** and **digital** zoom values.

        Since there may be a physical component to move, the change in zoom
        value may not be instantaneous.
        """
        ...

    def digitalZoom(self) -> float:
        """
        https://doc.qt.io/qt-5/qcamerafocus.html#digitalZoom-prop

        **digitalZoom : const qreal**

        This property holds the current digital zoom value.

        **Access functions:**

        qreal **digitalZoom** () const

        **Notifier signal:**

        void ****digitalZoomChanged** ** (qreal **value** )

        **See also** **QCameraFocus::opticalZoom** .
        """
        ...

    def opticalZoom(self) -> float:
        """
        https://doc.qt.io/qt-5/qcamerafocus.html#opticalZoom-prop

        **opticalZoom : const qreal**

        This property holds the current optical zoom value.

        **Access functions:**

        qreal **opticalZoom** () const

        **Notifier signal:**

        void ****opticalZoomChanged** ** (qreal **value** )

        **See also** **QCameraFocus::digitalZoom** .

        **Member Function Documentation**
        """
        ...

    def maximumDigitalZoom(self) -> float:
        """
        https://doc.qt.io/qt-5/qcamerafocus.html#maximumDigitalZoom

        **qreal QCameraFocus::maximumDigitalZoom() const**

        Returns the maximum digital zoom

        This will be `1.0` on cameras that do not support digital zoom.
        """
        ...

    def maximumOpticalZoom(self) -> float:
        """
        https://doc.qt.io/qt-5/qcamerafocus.html#maximumOpticalZoom

        **qreal QCameraFocus::maximumOpticalZoom() const**

        Returns the maximum optical zoom.

        This will be `1.0` on cameras that do not support optical zoom.
        """
        ...

    def focusZones(self) -> typing.List[QCameraFocusZone]:
        """
        https://doc.qt.io/qt-5/qcamerafocus.html#focusZones-prop

        **focusZones : const QCameraFocusZoneList**

        Returns the list of active focus zones.

        If QCamera::FocusPointAuto or QCamera::FocusPointFaceDetection focus
        mode is selected this method returns the list of zones the camera is
        actually focused on.

        The coordinates system is the same as for custom focus points:
        **QPointF** (0,0) points to the left top frame point, **QPointF**
        (0.5,0.5) points to the frame center.

        **Access functions:**

        QCameraFocusZoneList **focusZones** () const

        **Notifier signal:**

        void ****focusZonesChanged** ** ()
        """
        ...

    def setCustomFocusPoint(
        self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcamerafocus.html#customFocusPoint-prop

        **customFocusPoint : QPointF**

        This property represents the position of the custom focus point, in
        relative frame coordinates: **QPointF** (0,0) points to the left top
        frame point, **QPointF** (0.5,0.5) points to the frame center.

        The custom focus point property is used only in `FocusPointCustom` focus
        mode.

        **Access functions:**

        QPointF **customFocusPoint** () const
        void **setCustomFocusPoint**
        (const QPointF & **point** )
        """
        ...

    def customFocusPoint(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qcamerafocus.html#customFocusPoint-prop

        **customFocusPoint : QPointF**

        This property represents the position of the custom focus point, in
        relative frame coordinates: **QPointF** (0,0) points to the left top
        frame point, **QPointF** (0.5,0.5) points to the frame center.

        The custom focus point property is used only in `FocusPointCustom` focus
        mode.

        **Access functions:**

        QPointF **customFocusPoint** () const
        void **setCustomFocusPoint**
        (const QPointF & **point** )
        """
        ...

    def isFocusPointModeSupported(self, a0: "QCameraFocus.FocusPointMode") -> bool:
        """
        https://doc.qt.io/qt-5/qcamerafocus.html#isFocusPointModeSupported

        **bool
        QCameraFocus::isFocusPointModeSupported(QCameraFocus::FocusPointMode
        mode ) const**

        Returns true if focus point **mode** is supported.
        """
        ...

    def setFocusPointMode(self, mode: "QCameraFocus.FocusPointMode") -> None:
        """
        https://doc.qt.io/qt-5/qcamerafocus.html#focusPointMode-prop

        **focusPointMode : FocusPointMode**

        This property holds the current camera focus point selection mode.

        If the camera focus mode is set to use an autofocusing mode, this
        property controls the way the camera will select areas of the frame to
        use for autofocusing.

        **Access functions:**

        QCameraFocus::FocusPointMode **focusPointMode** () const
        void
        **setFocusPointMode** (QCameraFocus::FocusPointMode **mode** )

        **See also** **QCameraFocus::isFocusPointModeSupported** ().
        """
        ...

    def focusPointMode(self) -> "QCameraFocus.FocusPointMode":
        """
        https://doc.qt.io/qt-5/qcamerafocus.html#focusPointMode-prop

        **focusPointMode : FocusPointMode**

        This property holds the current camera focus point selection mode.

        If the camera focus mode is set to use an autofocusing mode, this
        property controls the way the camera will select areas of the frame to
        use for autofocusing.

        **Access functions:**

        QCameraFocus::FocusPointMode **focusPointMode** () const
        void
        **setFocusPointMode** (QCameraFocus::FocusPointMode **mode** )

        **See also** **QCameraFocus::isFocusPointModeSupported** ().
        """
        ...

    def isFocusModeSupported(
        self, mode: typing.Union["QCameraFocus.FocusModes", "QCameraFocus.FocusMode"]
    ) -> bool:
        """
        https://doc.qt.io/qt-5/qcamerafocus.html#isFocusModeSupported

        **bool QCameraFocus::isFocusModeSupported(QCameraFocus::FocusModes mode
        ) const**

        Returns true if the focus **mode** is supported by camera.
        """
        ...

    def setFocusMode(
        self, mode: typing.Union["QCameraFocus.FocusModes", "QCameraFocus.FocusMode"]
    ) -> None:
        """
        https://doc.qt.io/qt-5/qcamerafocus.html#focusMode-prop

        **focusMode : FocusModes**

        This property holds the current camera focus mode.

        This controls the way the camera lens assembly is configured.

        **Access functions:**

        QCameraFocus::FocusModes **focusMode** () const
        void **setFocusMode**
        (QCameraFocus::FocusModes **mode** )

        **See also** **QCameraFocus::isFocusModeSupported** ().
        """
        ...

    def focusMode(self) -> "QCameraFocus.FocusModes":
        """
        https://doc.qt.io/qt-5/qcamerafocus.html#focusMode-prop

        **focusMode : FocusModes**

        This property holds the current camera focus mode.

        This controls the way the camera lens assembly is configured.

        **Access functions:**

        QCameraFocus::FocusModes **focusMode** () const
        void **setFocusMode**
        (QCameraFocus::FocusModes **mode** )

        **See also** **QCameraFocus::isFocusModeSupported** ().
        """
        ...

    def isAvailable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qcamerafocus.html#isAvailable

        **bool QCameraFocus::isAvailable() const**

        Returns true if focus related settings are supported by this camera.

        You may need to also check if any specific features are supported.
        """
        ...

    @property
    def digitalZoomChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcamerafocus.html#digitalZoomChanged

        **[signal] void QCameraFocus::digitalZoomChanged(qreal value )**

        Signal emitted when digital zoom value changes to new **value**.

        **Note:** Notifier signal for property **digitalZoom** .
        """
        ...

    @property
    def focusZonesChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcamerafocus.html#focusZonesChanged

        **[signal] void QCameraFocus::focusZonesChanged()**

        This signal is emitted when the set of zones used in autofocusing is
        changed.

        This can change when a zone is focused or loses focus, or new focus
        zones have been detected.

        **Note:** Notifier signal for property **focusZones** .
        """
        ...

    @property
    def maximumDigitalZoomChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcamerafocus.html#maximumDigitalZoomChanged

        **[signal] void QCameraFocus::maximumDigitalZoomChanged(qreal zoom )**

        Signal emitted when the maximum supported digital **zoom** value
        changed.

        The maximum supported zoom value can depend on other camera settings,
        like capture mode or resolution.
        """
        ...

    @property
    def maximumOpticalZoomChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcamerafocus.html#maximumOpticalZoomChanged

        **[signal] void QCameraFocus::maximumOpticalZoomChanged(qreal zoom )**

        Signal emitted when the maximum supported optical **zoom** value
        changed.
        """
        ...

    @property
    def opticalZoomChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcamerafocus.html#opticalZoomChanged

        **[signal] void QCameraFocus::opticalZoomChanged(qreal value )**

        Signal emitted when optical zoom value changes to new **value**.

        **Note:** Notifier signal for property **opticalZoom** .
        """
        ...
