"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QCameraCaptureBufferFormatControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qcameracapturebufferformatcontrol.html

    **Detailed Description**

    The format is of type **QVideoFrame::PixelFormat** .

    The interface name of QCameraCaptureBufferFormatControl is `org.qt-
    project.qt.cameracapturebufferformatcontrol/5.0` as defined in
    **QCameraCaptureBufferFormatControl_iid** .

    **See also** **QMediaService::requestControl** ().
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qcameracapturebufferformatcontrol.html#QCameraCap
        tureBufferFormatControl

        **[protected] QCameraCaptureBufferFormatControl::QCameraCaptureBufferFor
        matControl(QObject * parent = nullptr)**

        Constructs a new image buffer capture format control object with the
        given **parent**
        """
        ...

    def setBufferFormat(self, format: "QVideoFrame.PixelFormat") -> None:
        """
        https://doc.qt.io/qt-5/qcameracapturebufferformatcontrol.html#setBufferF
        ormat

        **[pure virtual] void QCameraCaptureBufferFormatControl::setBufferFormat
        (QVideoFrame::PixelFormat format )**

        Sets the buffer capture **format**.

        **See also** **bufferFormat** ().
        """
        ...

    def bufferFormat(self) -> "QVideoFrame.PixelFormat":
        """
        https://doc.qt.io/qt-5/qcameracapturebufferformatcontrol.html#bufferForm
        at

        **[pure virtual] QVideoFrame::PixelFormat
        QCameraCaptureBufferFormatControl::bufferFormat() const**

        Returns the current buffer capture format.

        **See also** **setBufferFormat** ().
        """
        ...

    def supportedBufferFormats(self) -> typing.List["QVideoFrame.PixelFormat"]:
        """
        https://doc.qt.io/qt-5/qcameracapturebufferformatcontrol.html#supportedB
        ufferFormats

        **[pure virtual] QList<QVideoFrame::PixelFormat>
        QCameraCaptureBufferFormatControl::supportedBufferFormats() const**

        Returns the list of the supported buffer capture formats.
        """
        ...

    @property
    def bufferFormatChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qcameracapturebufferformatcontrol.html#bufferForm
        atChanged

        **[signal] void QCameraCaptureBufferFormatControl::bufferFormatChanged(Q
        VideoFrame::PixelFormat format )**

        Signals the buffer image capture format changed to **format**.
        """
        ...
