"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QAudioEncoderSettingsControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qaudioencodersettingscontrol.html

    **Detailed Description**

    If a **QMediaService**  supports encoding audio data it will implement
    QAudioEncoderSettingsControl. This control provides information about the
    limits of restricted audio encoder options and allows the selection of a set
    of audio encoder settings as specified in a **QAudioEncoderSettings**
    object.

    The functionality provided by this control is exposed to application code
    through the **QMediaRecorder**  class.

    The interface name of QAudioEncoderSettingsControl is `org.qt-
    project.qt.audioencodersettingscontrol/5.0` as defined in
    **QAudioEncoderSettingsControl_iid** .

    **See also** **QMediaService::requestControl** () and **QMediaRecorder** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qaudioencodersettingscontrol.html#QAudioEncoderSe
        ttingsControl

        **[protected]
        QAudioEncoderSettingsControl::QAudioEncoderSettingsControl(QObject *
        parent = nullptr)**

        Create a new audio encoder settings control object with the given
        **parent**.
        """
        ...

    def setAudioSettings(self, settings: "QAudioEncoderSettings") -> None:
        """
        https://doc.qt.io/qt-5/qaudioencodersettingscontrol.html#setAudioSetting
        s

        **[pure virtual] void
        QAudioEncoderSettingsControl::setAudioSettings(const
        QAudioEncoderSettings & settings )**

        Sets the selected audio **settings**.

        **See also** **audioSettings** ().
        """
        ...

    def audioSettings(self) -> "QAudioEncoderSettings":
        """
        https://doc.qt.io/qt-5/qaudioencodersettingscontrol.html#audioSettings

        **[pure virtual] QAudioEncoderSettings
        QAudioEncoderSettingsControl::audioSettings() const**

        Returns the audio encoder settings.

        The returned value may be different tha passed to
        **QAudioEncoderSettingsControl::setAudioSettings** () if the settings
        contains the default or undefined parameters. In this case if the
        undefined parameters are already resolved, they should be returned.

        **See also** **setAudioSettings** ().
        """
        ...

    def supportedSampleRates(
        self, settings: "QAudioEncoderSettings"
    ) -> typing.Tuple[typing.List[int], bool]:
        """
        https://doc.qt.io/qt-5/qaudioencodersettingscontrol.html#supportedSample
        Rates

        **[pure virtual] QList<int>
        QAudioEncoderSettingsControl::supportedSampleRates(const
        QAudioEncoderSettings & settings , bool * continuous = nullptr) const**

        Returns the list of supported audio sample rates, if known.

        If non null audio **settings** parameter is passed, the returned list is
        reduced to sample rates supported with partial settings applied.

        It can be used for example to query the list of sample rates, supported
        by specific audio codec.

        If the encoder supports arbitrary sample rates within the supported
        rates range, * **continuous** is set to true, otherwise * **continuous**
        is set to false.
        """
        ...

    def codecDescription(self, codecName: str) -> str:
        """
        https://doc.qt.io/qt-5/qaudioencodersettingscontrol.html#codecDescriptio
        n

        **[pure virtual] QString
        QAudioEncoderSettingsControl::codecDescription(const QString & codecName
        ) const**

        Returns the description of audio codec **codecName**.
        """
        ...

    def supportedAudioCodecs(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qaudioencodersettingscontrol.html#supportedAudioC
        odecs

        **[pure virtual] QStringList
        QAudioEncoderSettingsControl::supportedAudioCodecs() const**

        Returns the list of supported audio codec names.
        """
        ...
