"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5.QtMultimedia import *
from PyQt5 import sip


class QAudioDeviceInfo(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qaudiodeviceinfo.html

    **Detailed Description**

    QAudioDeviceInfo lets you query for audio devices--such as sound cards and
    USB headsets--that are currently available on the system. The audio devices
    available are dependent on the platform or audio plugins installed.

    A QAudioDeviceInfo is used by Qt to construct classes that communicate with
    the device--such as **QAudioInput** , and **QAudioOutput** .

    You can also query each device for the formats it supports. A format in this
    context is a set consisting of a specific byte order, channel, codec,
    frequency, sample rate, and sample type. A format is represented by the
    **QAudioFormat**  class.

    The values supported by the device for each of these parameters can be
    fetched with **supportedByteOrders** (), **supportedChannelCounts** (),
    **supportedCodecs** (), **supportedSampleRates** (),
    **supportedSampleSizes** (), and **supportedSampleTypes** (). The
    combinations supported are dependent on the platform, audio plugins
    installed and the audio device capabilities. If you need a specific format,
    you can check if the device supports it with **isFormatSupported** (), or
    fetch a supported format that is as close as possible to the format with
    **nearestFormat** (). For instance:

    **QAudioFormat**  format;
        format.setSampleRate(44100);
        // ... other
    format parameters
        format.setSampleType(**QAudioFormat** ::SignedInt);
    **QAudioDeviceInfo**  info(**QAudioDeviceInfo** ::defaultOutputDevice());
    if (!info.isFormatSupported(format))
            format =
    info.nearestFormat(format);

    The static functions **defaultInputDevice** (), **defaultOutputDevice** (),
    and **availableDevices** () let you get a list of all available devices.
    Devices are fetched according to the value of mode this is specified by the
    **QAudio** ::Mode enum. The QAudioDeviceInfo returned are only valid for the
    **QAudio** ::Mode.

    For instance:

    const auto deviceInfos = **QAudioDeviceInfo**
    ::availableDevices(QAudio::AudioOutput);
        for (const **QAudioDeviceInfo**
    &deviceInfo : deviceInfos)
            **qDebug** () << "Device name: " <<
    deviceInfo.deviceName();

    In this code sample, we loop through all devices that are able to output
    sound, i.e., play an audio stream in a supported format. For each device we
    find, we simply print the **deviceName** ().

    **See also** **QAudioOutput**  and **QAudioInput** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qaudiodeviceinfo.html#QAudioDeviceInfo

        **QAudioDeviceInfo::QAudioDeviceInfo()**

        Constructs an empty QAudioDeviceInfo object.
        """
        ...

    @typing.overload
    def __init__(self, other: "QAudioDeviceInfo") -> None:
        """
        https://doc.qt.io/qt-5/qaudiodeviceinfo.html#QAudioDeviceInfo-1

        **QAudioDeviceInfo::QAudioDeviceInfo(const QAudioDeviceInfo & other )**

        Constructs a copy of **other**.
        """
        ...

    def realm(self) -> str:
        """
        https://doc.qt.io/qt-5/qaudiodeviceinfo.html#realm

        **QString QAudioDeviceInfo::realm() const**

        Returns the key that represents the audio plugin.

        This function was introduced in Qt 5.14.

        **See also** **QAudioSystemPlugin** .
        """
        ...

    def supportedChannelCounts(self) -> typing.List[int]:
        """
        https://doc.qt.io/qt-5/qaudiodeviceinfo.html#supportedChannelCounts

        **QList<int> QAudioDeviceInfo::supportedChannelCounts() const**

        Returns a list of supported channel counts.

        This is typically 1 for mono sound, or 2 for stereo sound.
        """
        ...

    def supportedSampleRates(self) -> typing.List[int]:
        """
        https://doc.qt.io/qt-5/qaudiodeviceinfo.html#supportedSampleRates

        **QList<int> QAudioDeviceInfo::supportedSampleRates() const**

        Returns a list of supported sample rates (in Hertz).
        """
        ...

    @staticmethod
    def availableDevices(mode: QAudio.Mode) -> typing.List["QAudioDeviceInfo"]:
        """
        https://doc.qt.io/qt-5/qaudiodeviceinfo.html#availableDevices

        **[static] QList<QAudioDeviceInfo>
        QAudioDeviceInfo::availableDevices(QAudio::Mode mode )**

        Returns a list of audio devices that support **mode**.
        """
        ...

    @staticmethod
    def defaultOutputDevice() -> "QAudioDeviceInfo":
        """
        https://doc.qt.io/qt-5/qaudiodeviceinfo.html#defaultOutputDevice

        **[static] QAudioDeviceInfo QAudioDeviceInfo::defaultOutputDevice()**

        Returns the information for the default output audio device. All
        platform and audio plugin implementations provide a default audio device
        to use.
        """
        ...

    @staticmethod
    def defaultInputDevice() -> "QAudioDeviceInfo":
        """
        https://doc.qt.io/qt-5/qaudiodeviceinfo.html#defaultInputDevice

        **[static] QAudioDeviceInfo QAudioDeviceInfo::defaultInputDevice()**

        Returns the information for the default input audio device. All platform
        and audio plugin implementations provide a default audio device to use.
        """
        ...

    def supportedSampleTypes(self) -> typing.List["QAudioFormat.SampleType"]:
        """
        https://doc.qt.io/qt-5/qaudiodeviceinfo.html#supportedSampleTypes

        **QList<QAudioFormat::SampleType>
        QAudioDeviceInfo::supportedSampleTypes() const**

        Returns a list of supported sample types.
        """
        ...

    def supportedByteOrders(self) -> typing.List["QAudioFormat.Endian"]:
        """
        https://doc.qt.io/qt-5/qaudiodeviceinfo.html#supportedByteOrders

        **QList<QAudioFormat::Endian> QAudioDeviceInfo::supportedByteOrders()
        const**

        Returns a list of supported byte orders.
        """
        ...

    def supportedSampleSizes(self) -> typing.List[int]:
        """
        https://doc.qt.io/qt-5/qaudiodeviceinfo.html#supportedSampleSizes

        **QList<int> QAudioDeviceInfo::supportedSampleSizes() const**

        Returns a list of supported sample sizes (in bits).

        Typically this will include 8 and 16 bit sample sizes.
        """
        ...

    def supportedCodecs(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qaudiodeviceinfo.html#supportedCodecs

        **QStringList QAudioDeviceInfo::supportedCodecs() const**

        Returns a list of supported codecs.

        All platform and plugin implementations should provide support for:

        "audio/pcm" - Linear PCM

        For writing plugins to support additional codecs refer to:

        http://www.iana.org/assignments/media-types/audio/
        """
        ...

    def nearestFormat(self, format: "QAudioFormat") -> "QAudioFormat":
        """
        https://doc.qt.io/qt-5/qaudiodeviceinfo.html#nearestFormat

        **QAudioFormat QAudioDeviceInfo::nearestFormat(const QAudioFormat &
        settings ) const**

        Returns the closest **QAudioFormat**  to the supplied **settings** that
        the system supports.

        These settings are provided by the platform/audio plugin being used.

        They are also dependent on the **QAudio** ::Mode being used.
        """
        ...

    def preferredFormat(self) -> "QAudioFormat":
        """
        https://doc.qt.io/qt-5/qaudiodeviceinfo.html#preferredFormat

        **QAudioFormat QAudioDeviceInfo::preferredFormat() const**

        Returns the default audio format settings for this device.

        These settings are provided by the platform/audio plugin being used.

        They are also dependent on the **QAudio** ::Mode being used.

        A typical audio system would provide something like:

        * Input settings: 8000Hz mono 8 bit.
          * Output settings: 44100Hz stereo
        16 bit little endian.
        """
        ...

    def isFormatSupported(self, format: "QAudioFormat") -> bool:
        """
        https://doc.qt.io/qt-5/qaudiodeviceinfo.html#isFormatSupported

        **bool QAudioDeviceInfo::isFormatSupported(const QAudioFormat & settings
        ) const**

        Returns true if the supplied **settings** are supported by the audio
        device described by this **QAudioDeviceInfo** .
        """
        ...

    def deviceName(self) -> str:
        """
        https://doc.qt.io/qt-5/qaudiodeviceinfo.html#deviceName

        **QString QAudioDeviceInfo::deviceName() const**

        Returns the human readable name of the audio device.

        Device names vary depending on the platform/audio plugin being used.

        They are a unique string identifier for the audio device.

        eg. default, Intel, U0x46d0x9a4
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-5/qaudiodeviceinfo.html#isNull

        **bool QAudioDeviceInfo::isNull() const**

        Returns whether this **QAudioDeviceInfo**  object holds a valid device
        definition.
        """
        ...
