"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtMultimedia import *


class QAudioDecoderControl(QMediaControl):
    """
    https://doc.qt.io/qt-5/qaudiodecodercontrol.html

    **Detailed Description**

    The functionality provided by this control is exposed to application code
    through the **QAudioDecoder**  class.

    The interface name of QAudioDecoderControl is `org.qt-
    project.qt.audiodecodercontrol/5.0` as defined in
    **QAudioDecoderControl_iid** .

    **See also** **QMediaService::requestControl** () and **QAudioDecoder** .
    """

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-5/qaudiodecodercontrol.html#QAudioDecoderControl

        **[protected] QAudioDecoderControl::QAudioDecoderControl(QObject *
        parent = nullptr)**

        Constructs a new audio decoder control with the given **parent**.
        """
        ...

    def duration(self) -> int:
        """
        https://doc.qt.io/qt-5/qaudiodecodercontrol.html#duration

        **[pure virtual] qint64 QAudioDecoderControl::duration() const**

        Returns total duration (in milliseconds) of the audio stream or -1 if
        not available.
        """
        ...

    def position(self) -> int:
        """
        https://doc.qt.io/qt-5/qaudiodecodercontrol.html#position

        **[pure virtual] qint64 QAudioDecoderControl::position() const**

        Returns position (in milliseconds) of the last buffer read from the
        decoder or -1 if no buffers have been read.
        """
        ...

    def bufferAvailable(self) -> bool:
        """
        https://doc.qt.io/qt-5/qaudiodecodercontrol.html#bufferAvailable

        **[pure virtual] bool QAudioDecoderControl::bufferAvailable() const**

        Returns true if a buffer is available to be read, and false otherwise.
        """
        ...

    def read(self) -> QAudioBuffer:
        """
        https://doc.qt.io/qt-5/qaudiodecodercontrol.html#read

        **[pure virtual] QAudioBuffer QAudioDecoderControl::read()**

        Attempts to read a buffer from the decoder, without blocking. Returns
        invalid buffer if there are no decoded buffers available, or on error.
        """
        ...

    def setAudioFormat(self, format: "QAudioFormat") -> None:
        """
        https://doc.qt.io/qt-5/qaudiodecodercontrol.html#setAudioFormat

        **[pure virtual] void QAudioDecoderControl::setAudioFormat(const
        QAudioFormat & format )**

        Set the desired audio format for decoded samples to **format**.

        If the decoder does not support this format, **error** () will be set to
        `FormatError`.

        If you do not specify a format, the format of the decoded audio itself
        will be used. Otherwise, some format conversion will be applied.

        If you wish to reset the decoded format to that of the original audio
        file, you can specify an invalid **format**.

        **See also** **audioFormat** ().
        """
        ...

    def audioFormat(self) -> "QAudioFormat":
        """
        https://doc.qt.io/qt-5/qaudiodecodercontrol.html#audioFormat

        **[pure virtual] QAudioFormat QAudioDecoderControl::audioFormat()
        const**

        Returns the current audio format of the decoded stream.

        Any buffers returned should have this format.

        **See also** **setAudioFormat** () and **formatChanged** ().
        """
        ...

    def stop(self) -> None:
        """
        https://doc.qt.io/qt-5/qaudiodecodercontrol.html#stop

        **[pure virtual] void QAudioDecoderControl::stop()**

        Stops playback of the current media and discards any buffers.

        If successful the player control will immediately enter the **stopped**
        state.
        """
        ...

    def start(self) -> None:
        """
        https://doc.qt.io/qt-5/qaudiodecodercontrol.html#start

        **[pure virtual] void QAudioDecoderControl::start()**

        Starts decoding the current media.

        If successful the player control will immediately enter the **decoding**
        state.

        **See also** **state** () and **read** ().
        """
        ...

    def setSourceDevice(self, device: QtCore.QIODevice) -> None:
        """
        https://doc.qt.io/qt-5/qaudiodecodercontrol.html#setSourceDevice

        **[pure virtual] void QAudioDecoderControl::setSourceDevice(QIODevice *
        device )**

        Sets the current source to **device**. Changing the source will stop any
        current decoding and discard any buffers.

        Sources are exclusive, so only one can be set.

        **See also** **sourceDevice** ().
        """
        ...

    def sourceDevice(self) -> QtCore.QIODevice:
        """
        https://doc.qt.io/qt-5/qaudiodecodercontrol.html#sourceDevice

        **[pure virtual] QIODevice *QAudioDecoderControl::sourceDevice() const**

        Returns the current media source **QIODevice** , or 0 if none (or a
        file).

        **See also** **setSourceDevice** ().
        """
        ...

    def setSourceFilename(self, fileName: str) -> None:
        """
        https://doc.qt.io/qt-5/qaudiodecodercontrol.html#setSourceFilename

        **[pure virtual] void QAudioDecoderControl::setSourceFilename(const
        QString & fileName )**

        Sets the current source to **fileName**. Changing the source will stop
        any current decoding and discard any buffers.

        Sources are exclusive, so only one can be set.

        **See also** **sourceFilename** ().
        """
        ...

    def sourceFilename(self) -> str:
        """
        https://doc.qt.io/qt-5/qaudiodecodercontrol.html#sourceFilename

        **[pure virtual] QString QAudioDecoderControl::sourceFilename() const**

        Returns the current media source filename, or a null **QString**  if
        none (or a device)

        **See also** **setSourceFilename** ().
        """
        ...

    def state(self) -> QAudioDecoder.State:
        """
        https://doc.qt.io/qt-5/qaudiodecodercontrol.html#state

        **[pure virtual] QAudioDecoder::State QAudioDecoderControl::state()
        const**

        Returns the state of a player control.
        """
        ...

    @property
    def bufferAvailableChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qaudiodecodercontrol.html#bufferAvailableChanged

        **[signal] void QAudioDecoderControl::bufferAvailableChanged(bool
        available )**

        Signals that the **bufferAvailable**  property has changed to
        **available**.
        """
        ...

    @property
    def bufferReady(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qaudiodecodercontrol.html#bufferReady

        **[signal] void QAudioDecoderControl::bufferReady()**

        Signals that a new buffer is ready for reading.
        """
        ...

    @property
    def durationChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qaudiodecodercontrol.html#durationChanged

        **[signal] void QAudioDecoderControl::durationChanged(qint64 duration
        )**

        Signals that the estimated **duration** of the decoded data has changed.

        **See also** **positionChanged** ().
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qaudiodecodercontrol.html#error

        **[signal] void QAudioDecoderControl::error(int error , const QString &
        errorString )**

        Signals that an **error** has occurred. The **errorString** provides a
        more detailed explanation.
        """
        ...

    @property
    def finished(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qaudiodecodercontrol.html#finished

        **[signal] void QAudioDecoderControl::finished()**

        Signals that the decoding has finished successfully. If decoding fails,
        error signal is emitted instead.

        **See also** **start** (), **stop** (), and **error** ().
        """
        ...

    @property
    def formatChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qaudiodecodercontrol.html#formatChanged

        **[signal] void QAudioDecoderControl::formatChanged(const QAudioFormat &
        format )**

        Signals that the current audio format of the decoder has changed to
        **format**.

        **See also** **audioFormat** () and **setAudioFormat** ().
        """
        ...

    @property
    def positionChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qaudiodecodercontrol.html#positionChanged

        **[signal] void QAudioDecoderControl::positionChanged(qint64 position
        )**

        Signals that the current **position** of the decoder has changed.

        **See also** **durationChanged** ().
        """
        ...

    @property
    def sourceChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qaudiodecodercontrol.html#sourceChanged

        **[signal] void QAudioDecoderControl::sourceChanged()**

        Signals that the current source of the decoder has changed.

        **See also** **sourceFilename** () and **sourceDevice** ().
        """
        ...

    @property
    def stateChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qaudiodecodercontrol.html#stateChanged

        **[signal] void QAudioDecoderControl::stateChanged(QAudioDecoder::State
        newState )**

        Signals that the state of a player control has changed to **newState**.

        **See also** **state** ().
        """
        ...
