"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5.QtLocation import *
from PyQt5 import sip


class QPlaceSearchResult(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qplacesearchresult.html

    **Detailed Description**

    A list of search results can be retrieved from the **QPlaceSearchReply**
    after it has successfully completed the request. Common to all search
    results are the **title**  and **icon** , which can be used to present the
    search result to the user.

    The intended usage is that depending on the **type** , the search result can
    be converted to a more detailed subclass like so:

    if (result.type() == **QPlaceSearchResult** ::PlaceResult) {
    **QPlaceResult**  placeResult = result;
            **qDebug** () <<
    placeResult.place().name();
            **qDebug** () <<
    placeResult.place().location().coordinate();
            **qDebug** () <<
    placeResult.distance();
        }

    The implementation is handled in such a way that object slicing is not an
    issue. It is not expected that client applications or backend plugins
    instantiate a QPlaceSearchResult directly, but rather client applications
    simply convert to search result subclasses and backend plugins only
    instantiate subclasses.

    **See also** **QPlaceResult** .
    """

    class SearchResultType(int):
        UnknownSearchResult: QPlaceSearchResult = ...
        PlaceResult: QPlaceSearchResult = ...
        ProposedSearchResult: QPlaceSearchResult = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qplacesearchresult.html#QPlaceSearchResult

        **QPlaceSearchResult::QPlaceSearchResult()**

        Constructs a new search result.
        """
        ...

    @typing.overload
    def __init__(self, other: "QPlaceSearchResult") -> None:
        """
        https://doc.qt.io/qt-5/qplacesearchresult.html#QPlaceSearchResult-1

        **QPlaceSearchResult::QPlaceSearchResult(const QPlaceSearchResult &
        other )**

        Constructs a copy of **other**
        """
        ...

    def setIcon(self, icon: QPlaceIcon) -> None:
        """
        https://doc.qt.io/qt-5/qplacesearchresult.html#setIcon

        **void QPlaceSearchResult::setIcon(const QPlaceIcon & icon )**

        Sets the icon of the search result to **icon**.

        **See also** **icon** ().
        """
        ...

    def icon(self) -> QPlaceIcon:
        """
        https://doc.qt.io/qt-5/qplacesearchresult.html#icon

        **QPlaceIcon QPlaceSearchResult::icon() const**

        Returns an icon that can be used to represent the search result.

        **See also** **setIcon** ().
        """
        ...

    def setTitle(self, title: str) -> None:
        """
        https://doc.qt.io/qt-5/qplacesearchresult.html#setTitle

        **void QPlaceSearchResult::setTitle(const QString & title )**

        Sets the title of the search result to **title**.

        **See also** **title** ().
        """
        ...

    def title(self) -> str:
        """
        https://doc.qt.io/qt-5/qplacesearchresult.html#title

        **QString QPlaceSearchResult::title() const**

        Returns the title of the search result. This string can be used to
        display the search result to the user.

        **See also** **setTitle** ().
        """
        ...

    def type(self) -> "QPlaceSearchResult.SearchResultType":
        """
        https://doc.qt.io/qt-5/qplacesearchresult.html#type

        **QPlaceSearchResult::SearchResultType QPlaceSearchResult::type()
        const**

        Returns the result type.
        """
        ...
