"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt5.sip
from PyQt5 import QtCore
from PyQt5.QtLocation import *


class QPlaceManagerEngine(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qplacemanagerengine.html

    **Detailed Description**

    Application developers need not concern themselves with the
    QPlaceManagerEngine. Backend implementers however will need to derive from
    QPlaceManagerEngine and provide implementations for the abstract virtual
    functions.

    For more information on writing a backend see the **Places Backend**
    documentation.

    **See also** **QPlaceManager** .
    """

    def __init__(
        self,
        parameters: typing.Dict[str, typing.Any],
        parent: typing.Optional[QtCore.QObject] = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#QPlaceManagerEngine

        **QPlaceManagerEngine::QPlaceManagerEngine(const QVariantMap &
        parameters , QObject * parent = nullptr)**

        Constructs a new engine with the specified **parent** , using
        **parameters** to pass any implementation specific data to the engine.
        """
        ...

    def manager(self) -> QPlaceManager:
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#manager

        **[protected] QPlaceManager *QPlaceManagerEngine::manager() const**

        Returns the manager instance used to create this engine.
        """
        ...

    def matchingPlaces(self, request: "QPlaceMatchRequest") -> "QPlaceMatchReply":
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#matchingPlaces

        **[virtual] QPlaceMatchReply *QPlaceManagerEngine::matchingPlaces(const
        QPlaceMatchRequest & request )**

        Returns a reply which contains a list of places which correspond/match
        those specified in **request**.
        """
        ...

    def compatiblePlace(self, original: QPlace) -> QPlace:
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#compatiblePlace

        **[virtual] QPlace QPlaceManagerEngine::compatiblePlace(const QPlace &
        original ) const**

        Returns a pruned or modified version of the **original** place which is
        suitable to be saved by the manager engine.

        Only place details that are supported by this manager is present in the
        modified version. Manager specific data such as the place id, is not
        copied over from the **original**.
        """
        ...

    def constructIconUrl(self, icon: QPlaceIcon, size: QtCore.QSize) -> QtCore.QUrl:
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#constructIconUrl

        **[virtual] QUrl QPlaceManagerEngine::constructIconUrl(const QPlaceIcon
        & icon , const QSize & size ) const**

        **QUrl**  QPlaceManagerEngine::constructIconUrl(const **QPlaceIcon**
        &icon, const **QSize**  &size)

        Constructs an icon url from a given **icon** , **size**. The URL of the
        icon image that most closely matches the given parameters is returned.
        """
        ...

    def setLocales(self, locales: typing.Iterable[QtCore.QLocale]) -> None:
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#setLocales

        **[virtual] void QPlaceManagerEngine::setLocales(const QList<QLocale> &
        locales )**

        Set the list of preferred **locales**.

        **See also** **locales** ().
        """
        ...

    def locales(self) -> typing.List[QtCore.QLocale]:
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#locales

        **[virtual] QList<QLocale> QPlaceManagerEngine::locales() const**

        Returns a list of preferred locales. The locales are used as a hint to
        the manager engine for what language place and category details should
        be returned in.

        If the first specified locale cannot be accommodated, the manager engine
        falls back to the next and so forth.

        Support for locales may vary from provider to provider. For those that
        do support it, by default, the **global default locale**  will be used.
        If the manager engine has no locales assigned to it, it implicitly uses
        the global default locale. For engines that do not support locales, the
        locale list is always empty.

        **See also** **setLocales** ().
        """
        ...

    def childCategories(self, parentId: str) -> typing.List[QPlaceCategory]:
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#childCategories

        **[virtual] QList<QPlaceCategory>
        QPlaceManagerEngine::childCategories(const QString & parentId ) const**

        Returns a list of categories that are children of the category
        corresponding to **parentId**. If **parentId** is empty, all the top
        level categories are returned.
        """
        ...

    def category(self, categoryId: str) -> QPlaceCategory:
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#category

        **[virtual] QPlaceCategory QPlaceManagerEngine::category(const QString &
        categoryId ) const**

        Returns the category corresponding to the given **categoryId**.
        """
        ...

    def childCategoryIds(self, categoryId: str) -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#childCategoryIds

        **[virtual] QStringList QPlaceManagerEngine::childCategoryIds(const
        QString & categoryId ) const**

        Returns the child category identifiers of the category corresponding to
        **categoryId**. If **categoryId** is empty then all top level category
        identifiers are returned.
        """
        ...

    def parentCategoryId(self, categoryId: str) -> str:
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#parentCategoryId

        **[virtual] QString QPlaceManagerEngine::parentCategoryId(const QString
        & categoryId ) const**

        Returns the parent category identifier of the category corresponding to
        **categoryId**.
        """
        ...

    def initializeCategories(self) -> QPlaceReply:
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#initializeCategories

        **[virtual] QPlaceReply *QPlaceManagerEngine::initializeCategories()**

        Initializes the categories of the manager engine.
        """
        ...

    def removeCategory(self, categoryId: str) -> QPlaceIdReply:
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#removeCategory

        **[virtual] QPlaceIdReply *QPlaceManagerEngine::removeCategory(const
        QString & categoryId )**

        Removes the category corresponding to **categoryId** from the manager
        engine's datastore.
        """
        ...

    def saveCategory(self, category: QPlaceCategory, parentId: str) -> QPlaceIdReply:
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#saveCategory

        **[virtual] QPlaceIdReply *QPlaceManagerEngine::saveCategory(const
        QPlaceCategory & category , const QString & parentId )**

        Saves a **category** that is a child of the category specified by
        **parentId**. An empty **parentId** means **category** is saved as a top
        level category.
        """
        ...

    def removePlace(self, placeId: str) -> QPlaceIdReply:
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#removePlace

        **[virtual] QPlaceIdReply *QPlaceManagerEngine::removePlace(const
        QString & placeId )**

        Removes the place corresponding to **placeId** from the manager engine's
        datastore.
        """
        ...

    def savePlace(self, place: QPlace) -> QPlaceIdReply:
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#savePlace

        **[virtual] QPlaceIdReply *QPlaceManagerEngine::savePlace(const QPlace &
        place )**

        Saves a specified **place** to the manager engine's datastore.
        """
        ...

    def searchSuggestions(
        self, request: "QPlaceSearchRequest"
    ) -> "QPlaceSearchSuggestionReply":
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#searchSuggestions

        **[virtual] QPlaceSearchSuggestionReply
        *QPlaceManagerEngine::searchSuggestions(const QPlaceSearchRequest &
        request )**

        Requests a set of search term suggestions according to the parameters
        specified in **request**.
        """
        ...

    def search(self, request: "QPlaceSearchRequest") -> "QPlaceSearchReply":
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#search

        **[virtual] QPlaceSearchReply *QPlaceManagerEngine::search(const
        QPlaceSearchRequest & request )**

        Searches for places according to the parameters specified in
        **request**.
        """
        ...

    def getPlaceContent(self, request: QPlaceContentRequest) -> QPlaceContentReply:
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#getPlaceContent

        **[virtual] QPlaceContentReply
        *QPlaceManagerEngine::getPlaceContent(const QPlaceContentRequest &
        request )**

        Retrieves content for a place according to the parameters specified in
        **request**.
        """
        ...

    def getPlaceDetails(self, placeId: str) -> QPlaceDetailsReply:
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#getPlaceDetails

        **[virtual] QPlaceDetailsReply
        *QPlaceManagerEngine::getPlaceDetails(const QString & placeId )**

        Retrieves details of place corresponding to the given **placeId**.
        """
        ...

    def managerVersion(self) -> int:
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#managerVersion

        **int QPlaceManagerEngine::managerVersion() const**

        Returns the version of this engine implementation.

        The manager version is automatically set to be the same as the
        QGeoServiceProviderFactory::providerVersion().
        """
        ...

    def managerName(self) -> str:
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#managerName

        **QString QPlaceManagerEngine::managerName() const**

        Returns the name which this engine implementation uses to distinguish
        itself from the implementations provided by other plugins.

        The manager name is automatically set to be the same as the
        QGeoServiceProviderFactory::providerName().
        """
        ...

    @property
    def categoryAdded(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#categoryAdded

        **[signal] void QPlaceManagerEngine::categoryAdded(const QPlaceCategory
        & category , const QString & parentId )**

        This signal is emitted if a **category** has been added to the manager
        engine's datastore. The parent of the **category** is specified by
        **parentId**.

        This signal is only emitted by manager engines that support the
        QPlaceManager::NotificationsFeature.

        **See also** **dataChanged** ().
        """
        ...

    @property
    def categoryRemoved(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#categoryRemoved

        **[signal] void QPlaceManagerEngine::categoryRemoved(const QString &
        categoryId , const QString & parentId )**

        This signal is emitted when the category corresponding to **categoryId**
        has been removed from the manager engine's datastore. The parent of the
        removed category is specified by **parentId**.

        This signal is only emitted by manager engines that support the
        QPlaceManager::NotificationsFeature.

        **See also** **dataChanged** ().
        """
        ...

    @property
    def categoryUpdated(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#categoryUpdated

        **[signal] void QPlaceManagerEngine::categoryUpdated(const
        QPlaceCategory & category , const QString & parentId )**

        This signal is emitted if a **category** has been modified in the
        manager engine's datastore. The parent of the modified category is
        specified by **parentId**.

        This signal is only emitted by manager engines that support the
        QPlaceManager::NotificationsFeature.

        **See also** **dataChanged** ().
        """
        ...

    @property
    def dataChanged(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#dataChanged

        **[signal] void QPlaceManagerEngine::dataChanged()**

        *

        This signal is emitted by the engine if there are large scale changes to
        its underlying datastore and the engine considers these changes radical
        enough to require clients to reload all data.

        If the signal is emitted, no other signals will be emitted for the
        associated changes.
        """
        ...

    @property
    def error(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#error

        **[signal] void QPlaceManagerEngine::error(QPlaceReply * reply ,
        QPlaceReply::Error error , const QString & errorString = QString())**

        This signal is emitted when an error has been detected in the processing
        of **reply**. The **QPlaceManager::finished** () signal will probably
        follow.

        The error will be described by the error code **error**. If
        **errorString** is not empty it will contain a textual description of
        the error meant for developers and not end users.

        This signal and **QPlaceReply::error** () will be emitted at the same
        time.

        **Note:** Do not delete the **reply** object in the slot connected to
        this signal. Use **deleteLater** () instead.
        """
        ...

    @property
    def finished(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#finished

        **[signal] void QPlaceManagerEngine::finished(QPlaceReply * reply )**

        This signal is emitted when **reply** has finished processing.

        If reply->**error** () equals **QPlaceReply::NoError**  then the
        processing finished successfully.

        This signal and **QPlaceReply::finished** () will be emitted at the same
        time.

        **Note:** Do not delete the **reply** object in the slot connected to
        this signal. Use **deleteLater** () instead.
        """
        ...

    @property
    def placeAdded(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#placeAdded

        **[signal] void QPlaceManagerEngine::placeAdded(const QString & placeId
        )**

        This signal is emitted if a place has been added to the manager engine's
        datastore. The particular added place is specified by **placeId**.

        This signal is only emitted by manager engines that support the
        QPlaceManager::NotificationsFeature.

        **See also** **dataChanged** ().
        """
        ...

    @property
    def placeRemoved(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#placeRemoved

        **[signal] void QPlaceManagerEngine::placeRemoved(const QString &
        placeId )**

        This signal is emitted if a place has been removed from the manager
        engine's datastore. The particular place that has been removed is
        specified by **placeId**.

        This signal is only emitted by manager engines that support the
        QPlaceManager::NotificationsFeature.

        **See also** **dataChanged** ().
        """
        ...

    @property
    def placeUpdated(self) -> PyQt5.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-5/qplacemanagerengine.html#placeUpdated

        **[signal] void QPlaceManagerEngine::placeUpdated(const QString &
        placeId )**

        This signal is emitted if a place has been modified in the manager
        engine's datastore. The particular modified place is specified by
        **placeId**.

        This signal is only emitted by manager engines that support the
        QPlaceManager::NotificationsFeature.

        **See also** **dataChanged** ().
        """
        ...
