"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5.QtLocation import *
from PyQt5 import sip


class QPlaceContentRequest(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qplacecontentrequest.html

    **Detailed Description**

    The QPlaceContentRequest class is used in conjunction with a
    **QPlaceManager**  to retrieve rich content like images and reviews in a
    paginated fashion. The following code would request a set of 5 images from
    the 10th index:

    **QPlaceContentRequest**  request;
    request.setContentType(**QPlaceContent** ::ImageType);
    request.setPlaceId(place.placeId());
        request.setLimit(5);
    **QPlaceContentReply**  *contentReply = manager->getPlaceContent(request);
    //..connect signals..//
            ...
            ...
        void contentHandler() {
    if (contentReply->error() == **QPlaceReply** ::NoError)  {
    place.insertContent(contentReply->request().contentType(),
    contentReply->content());
            }
        }

    **See also** **QPlaceContentReply** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qplacecontentrequest.html#QPlaceContentRequest

        **QPlaceContentRequest::QPlaceContentRequest()**

        Constructs a new request object.
        """
        ...

    @typing.overload
    def __init__(self, other: "QPlaceContentRequest") -> None:
        """
        https://doc.qt.io/qt-5/qplacecontentrequest.html#QPlaceContentRequest-1

        **QPlaceContentRequest::QPlaceContentRequest(const QPlaceContentRequest
        & other )**

        Constructs a copy of **other**.
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-5/qplacecontentrequest.html#clear

        **void QPlaceContentRequest::clear()**

        Clears the content request.
        """
        ...

    def setLimit(self, limit: int) -> None:
        """
        https://doc.qt.io/qt-5/qplacecontentrequest.html#setLimit

        **void QPlaceContentRequest::setLimit(int limit )**

        Set the maximum number of content items to retrieve to **limit**.

        **See also** **limit** ().
        """
        ...

    def limit(self) -> int:
        """
        https://doc.qt.io/qt-5/qplacecontentrequest.html#limit

        **int QPlaceContentRequest::limit() const**

        Returns the maximum number of content items to retrieve.

        A negative value for limit means that it is undefined. It is left up to
        the backend provider to choose an appropriate number of items to return.

        The default limit is -1.

        **See also** **setLimit** ().
        """
        ...

    def setContentContext(self, context: typing.Any) -> None:
        """
        https://doc.qt.io/qt-5/qplacecontentrequest.html#setContentContext

        **void QPlaceContentRequest::setContentContext(const QVariant & context
        )**

        Sets the content context to **context**.

        **Note:** This method is intended to be used by geo service plugins when
        returning place content results.

        The content context is used by backends to store additional content
        context related to the content request. Other relevant fields should
        also be filled in. For example, if the content request is for image
        content the content type should also be set with **setContentType** ().
        The content context allows additional context to be kept which is not
        directly accessible via the Qt Location API.

        The content context can be of any type storable in a **QVariant** . The
        value of the content context is not intended to be used directly by
        applications.

        **See also** **contentContext** ().
        """
        ...

    def contentContext(self) -> typing.Any:
        """
        https://doc.qt.io/qt-5/qplacecontentrequest.html#contentContext

        **QVariant QPlaceContentRequest::contentContext() const**

        Returns backend specific additional content context associated with this
        place content request.

        **See also** **setContentContext** ().
        """
        ...

    def setPlaceId(self, identifier: str) -> None:
        """
        https://doc.qt.io/qt-5/qplacecontentrequest.html#setPlaceId

        **void QPlaceContentRequest::setPlaceId(const QString & identifier )**

        Sets the identifier of the place to fetch content for to **identifier**.

        **See also** **placeId** ().
        """
        ...

    def placeId(self) -> str:
        """
        https://doc.qt.io/qt-5/qplacecontentrequest.html#placeId

        **QString QPlaceContentRequest::placeId() const**

        Returns the identifier of the place content is to be fetched for.

        **See also** **setPlaceId** ().
        """
        ...

    def setContentType(self, type: QPlaceContent.Type) -> None:
        """
        https://doc.qt.io/qt-5/qplacecontentrequest.html#setContentType

        **void QPlaceContentRequest::setContentType(QPlaceContent::Type type )**

        Sets the **type** of content to be requested.

        **See also** **contentType** ().
        """
        ...

    def contentType(self) -> QPlaceContent.Type:
        """
        https://doc.qt.io/qt-5/qplacecontentrequest.html#contentType

        **QPlaceContent::Type QPlaceContentRequest::contentType() const**

        Returns the type of content to be requested, for example reviews or
        images

        **See also** **setContentType** ().
        """
        ...
