"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5.QtLocation import *
from PyQt5 import sip


class QPlaceContent(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qplacecontent.html

    **Detailed Description**

    Rich content such as **images** , **reviews**  and **editorials**  inherit
    from the QPlaceContent class which contains common properties such as an
    attribution string and content contributor, which may take the form of a
    **user**  and/or **supplier** . It is possible that a user from a supplier
    is contributing content, hence both fields could be filled in
    simultaneously.

    **Note:** Some providers may **require** that the attribution string be
    displayed to the user whenever a piece of content is viewed.

    Conversion between QPlaceContent and it's subclasses can be easily performed
    without casting. Due to the way it has been implemented, object slicing is
    not an issue, the following code is valid:

    **QPlaceImage**  image;
        image.setUrl(**QUrl** ("www.example.com"));
    **QPlaceContent**  content = image;

        **QPlaceImage**  image2;
    image2 = content;
        **qDebug** () << image2.url(); //image2.url() ==
    "www.example.com"

    The rich content of a place is typically made available as paginated items.
    The ability to convert between QPlaceContent and it's subclasses means that
    code which handles the mechanics of paging can be easily shared for each of
    the sub types.

    At present the QPlaceContent class is not extensible by 3rd parties.

    Note: The Places API considers content objects to be 'retrieve-only'
    objects. Submission of content to a provider is not a supported use case.

    **See also** **QPlaceImage** , **QPlaceReview** , and **QPlaceEditorial** .
    """

    class Type(int):
        NoType: QPlaceContent = ...
        ImageType: QPlaceContent = ...
        ReviewType: QPlaceContent = ...
        EditorialType: QPlaceContent = ...
        CustomType: QPlaceContent = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qplacecontent.html#QPlaceContent

        **QPlaceContent::QPlaceContent()**

        Constructs an default content object which has no type.
        """
        ...

    @typing.overload
    def __init__(self, other: "QPlaceContent") -> None:
        """
        https://doc.qt.io/qt-5/qplacecontent.html#QPlaceContent-1

        **QPlaceContent::QPlaceContent(const QPlaceContent & other )**

        Constructs a new copy of **other**.
        """
        ...

    def setAttribution(self, attribution: str) -> None:
        """
        https://doc.qt.io/qt-5/qplacecontent.html#setAttribution

        **void QPlaceContent::setAttribution(const QString & attribution )**

        Sets a rich text **attribution** string for this content item.

        **See also** **attribution** ().
        """
        ...

    def attribution(self) -> str:
        """
        https://doc.qt.io/qt-5/qplacecontent.html#attribution

        **QString QPlaceContent::attribution() const**

        Returns a rich text attribution string.

        **Note** : Some providers may require that the attribution of a
        particular content item always be displayed when the content item is
        shown.

        **See also** **setAttribution** ().
        """
        ...

    def setUser(self, user: "QPlaceUser") -> None:
        """
        https://doc.qt.io/qt-5/qplacecontent.html#setUser

        **void QPlaceContent::setUser(const QPlaceUser & user )**

        Sets the **user** who contributed this content.

        **See also** **user** ().
        """
        ...

    def user(self) -> "QPlaceUser":
        """
        https://doc.qt.io/qt-5/qplacecontent.html#user

        **QPlaceUser QPlaceContent::user() const**

        Returns the user who contributed this content.

        **See also** **setUser** ().
        """
        ...

    def setSupplier(self, supplier: "QPlaceSupplier") -> None:
        """
        https://doc.qt.io/qt-5/qplacecontent.html#setSupplier

        **void QPlaceContent::setSupplier(const QPlaceSupplier & supplier )**

        Sets the **supplier** of the content.

        **See also** **supplier** ().
        """
        ...

    def supplier(self) -> "QPlaceSupplier":
        """
        https://doc.qt.io/qt-5/qplacecontent.html#supplier

        **QPlaceSupplier QPlaceContent::supplier() const**

        Returns the supplier who contributed this content.

        **See also** **setSupplier** ().
        """
        ...

    def type(self) -> "QPlaceContent.Type":
        """
        https://doc.qt.io/qt-5/qplacecontent.html#type

        **QPlaceContent::Type QPlaceContent::type() const**

        Returns the content type.
        """
        ...
