"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import sip


class QPlaceAttribute(sip.simplewrapper):
    """
    https://doc.qt.io/qt-5/qplaceattribute.html

    **Detailed Description**

    A QPlaceAttribute instance stores an additional piece of information about a
    place that is not otherwise exposed through the **QPlace**  class. A
    QPlaceAttribute encapsulates a localized label which describes the attribute
    and rich text string representing the attribute's value. Generally, both are
    intended to be displayed to the end-user as is.

    Some plugins may not support attributes at all, others may only support a
    certain set, others still may support a dynamically changing set of
    attributes over time or even allow attributes to be arbitrarily defined by
    the client application. The attributes could also vary on a place by place
    basis, for example one place may have opening hours while another does not.
    Consult the **plugin references**  for details.

    **Attribute Types**

    The QPlaceAttribute class defines some constant strings which characterize
    standard **attribute types**.

    * **QPlaceAttribute::OpeningHours**
      * **QPlaceAttribute::Payment**
      *
    **QPlaceAttribute::Provider**

    There is a class of attribute types of the format x_id_<provider> for
    example x_id_here. This class of attributes is a set of alternative
    identifiers of the place, from the specified provider's perspective.

    The above types are used to access and modify attributes in **QPlace**  via:

    * **QPlace::extendedAttribute** ()
      * **QPlace::setExtendedAttribute** ()
    * **QPlace::removeExtendedAttribute** ()
      *
    **QPlace::removeExtendedAttribute** ()

    The **attribute type** is a string type so that providers are able to
    introduce new attributes as necessary. Custom attribute types should always
    be prefixed by a qualifier in order to avoid conflicts.

    **User Readable and Non-User Readable Attributes**

    Some attributes may not be intended to be readable by end users, the label
    field of such attributes are empty to indicate this fact.
    """

    OpeningHours: str = ...
    Payment: str = ...
    Provider: str = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-5/qplaceattribute.html#QPlaceAttribute

        **QPlaceAttribute::QPlaceAttribute()**

        Constructs an attribute.
        """
        ...

    @typing.overload
    def __init__(self, other: "QPlaceAttribute") -> None:
        """
        https://doc.qt.io/qt-5/qplaceattribute.html#QPlaceAttribute-1

        **QPlaceAttribute::QPlaceAttribute(const QPlaceAttribute & other )**

        Creates a copy of **other**.
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-5/qplaceattribute.html#isEmpty

        **bool QPlaceAttribute::isEmpty() const**

        Returns a boolean indicating whether the all the fields of the place
        attribute are empty or not.
        """
        ...

    def setText(self, text: str) -> None:
        """
        https://doc.qt.io/qt-5/qplaceattribute.html#setText

        **void QPlaceAttribute::setText(const QString & text )**

        Sets the **text** of the attribute.

        **See also** **text** ().
        """
        ...

    def text(self) -> str:
        """
        https://doc.qt.io/qt-5/qplaceattribute.html#text

        **QString QPlaceAttribute::text() const**

        Returns a piece of rich text representing the attribute value.

        **See also** **setText** ().
        """
        ...

    def setLabel(self, label: str) -> None:
        """
        https://doc.qt.io/qt-5/qplaceattribute.html#setLabel

        **void QPlaceAttribute::setLabel(const QString & label )**

        Sets the **label** of the attribute.

        **See also** **label** ().
        """
        ...

    def label(self) -> str:
        """
        https://doc.qt.io/qt-5/qplaceattribute.html#label

        **QString QPlaceAttribute::label() const**

        Returns a localized label describing the attribute.

        **See also** **setLabel** ().
        """
        ...
