"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtLocation import *
from PyQt5 import sip


class QGeoServiceProvider(QtCore.QObject):
    """
    https://doc.qt.io/qt-5/qgeoserviceprovider.html

    **Detailed Description**

    The Maps and Navigation API allows people to access various kinds of
    geographical information, including functionality to perform geocoding,
    routing and the display of maps. The QGeoServiceProvider aggregates the
    access to a set of these services that are provided by a single vendor.

    It is possible to mix and match service providers for the various domains,
    so that a geocoding manager from one service provider can be used with a
    geographic routing manager from another service provider.

    This is not recommended unless the client is able to verify that the data
    provided by the different services are compatible, as differences in the
    underlying data sets could cause serious incongruences between the services.

    Subclasses of QGeoServiceProvider guarantee that the different services that
    they provide are interoperable.

    At this point there are two GeoServices plugins packaged with Qt. They are
    accessible using their provider names:

    * "mapbox" -> **Mapbox service**
      * "here" -> **HERE Services**
      * "osm"
    -> **OpenStreetMap Services**
      * "esri" -> **ESRI Services**

    Each service provider must follow a naming convention for their service
    specific parameter names/keys. They use the provider name as prefix for all
    their parameter names. For example, the **HERE**  service provider requires
    the `here.app_id` parameter. When a provider is loaded only those parameters
    are passed on whose parameter names start with the provider name. This
    avoids the sharing sensitive parameters such as confidential `token` or
    `app_id` parameters with other plugins.

    Please check the GeoServices plugin specific documentation to obtain a
    complete list of the available parameter names/keys and values.
    """

    class NavigationFeature(int):
        NoNavigationFeatures: QGeoServiceProvider = ...
        OnlineNavigationFeature: QGeoServiceProvider = ...
        OfflineNavigationFeature: QGeoServiceProvider = ...
        AnyNavigationFeatures: QGeoServiceProvider = ...

    class PlacesFeature(int):
        NoPlacesFeatures: QGeoServiceProvider = ...
        OnlinePlacesFeature: QGeoServiceProvider = ...
        OfflinePlacesFeature: QGeoServiceProvider = ...
        SavePlaceFeature: QGeoServiceProvider = ...
        RemovePlaceFeature: QGeoServiceProvider = ...
        SaveCategoryFeature: QGeoServiceProvider = ...
        RemoveCategoryFeature: QGeoServiceProvider = ...
        PlaceRecommendationsFeature: QGeoServiceProvider = ...
        SearchSuggestionsFeature: QGeoServiceProvider = ...
        LocalizedPlacesFeature: QGeoServiceProvider = ...
        NotificationsFeature: QGeoServiceProvider = ...
        PlaceMatchingFeature: QGeoServiceProvider = ...
        AnyPlacesFeatures: QGeoServiceProvider = ...

    class MappingFeature(int):
        NoMappingFeatures: QGeoServiceProvider = ...
        OnlineMappingFeature: QGeoServiceProvider = ...
        OfflineMappingFeature: QGeoServiceProvider = ...
        LocalizedMappingFeature: QGeoServiceProvider = ...
        AnyMappingFeatures: QGeoServiceProvider = ...

    class GeocodingFeature(int):
        NoGeocodingFeatures: QGeoServiceProvider = ...
        OnlineGeocodingFeature: QGeoServiceProvider = ...
        OfflineGeocodingFeature: QGeoServiceProvider = ...
        ReverseGeocodingFeature: QGeoServiceProvider = ...
        LocalizedGeocodingFeature: QGeoServiceProvider = ...
        AnyGeocodingFeatures: QGeoServiceProvider = ...

    class RoutingFeature(int):
        NoRoutingFeatures: QGeoServiceProvider = ...
        OnlineRoutingFeature: QGeoServiceProvider = ...
        OfflineRoutingFeature: QGeoServiceProvider = ...
        LocalizedRoutingFeature: QGeoServiceProvider = ...
        RouteUpdatesFeature: QGeoServiceProvider = ...
        AlternativeRoutesFeature: QGeoServiceProvider = ...
        ExcludeAreasRoutingFeature: QGeoServiceProvider = ...
        AnyRoutingFeatures: QGeoServiceProvider = ...

    class Error(int):
        NoError: QGeoServiceProvider = ...
        NotSupportedError: QGeoServiceProvider = ...
        UnknownParameterError: QGeoServiceProvider = ...
        MissingRequiredParameterError: QGeoServiceProvider = ...
        ConnectionError: QGeoServiceProvider = ...
        LoaderError: QGeoServiceProvider = ...

    class RoutingFeatures(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QGeoServiceProvider.RoutingFeatures",
                "QGeoServiceProvider.RoutingFeature",
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QGeoServiceProvider.RoutingFeatures") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QGeoServiceProvider.RoutingFeatures":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class GeocodingFeatures(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QGeoServiceProvider.GeocodingFeatures",
                "QGeoServiceProvider.GeocodingFeature",
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QGeoServiceProvider.GeocodingFeatures") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QGeoServiceProvider.GeocodingFeatures":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class MappingFeatures(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QGeoServiceProvider.MappingFeatures",
                "QGeoServiceProvider.MappingFeature",
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QGeoServiceProvider.MappingFeatures") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QGeoServiceProvider.MappingFeatures":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class PlacesFeatures(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QGeoServiceProvider.PlacesFeatures",
                "QGeoServiceProvider.PlacesFeature",
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QGeoServiceProvider.PlacesFeatures") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QGeoServiceProvider.PlacesFeatures":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    class NavigationFeatures(sip.simplewrapper):
        @typing.overload
        def __init__(self) -> None:
            ...

        @typing.overload
        def __init__(
            self,
            f: typing.Union[
                "QGeoServiceProvider.NavigationFeatures",
                "QGeoServiceProvider.NavigationFeature",
            ],
        ) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QGeoServiceProvider.NavigationFeatures") -> None:
            ...

        def __hash__(self) -> int:
            ...

        def __bool__(self) -> int:
            ...

        def __invert__(self) -> "QGeoServiceProvider.NavigationFeatures":
            ...

        def __index__(self) -> int:
            ...

        def __int__(self) -> int:
            ...

    def __init__(
        self,
        providerName: str,
        parameters: typing.Dict[str, typing.Any] = ...,
        allowExperimental: bool = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qgeoserviceprovider.html#QGeoServiceProvider

        **QGeoServiceProvider::QGeoServiceProvider(const QString & providerName
        , const QVariantMap & parameters = QVariantMap(), bool allowExperimental
        = false)**

        Constructs a QGeoServiceProvider whose backend has the name
        **providerName** , using the provided **parameters**.

        If multiple plugins have the same **providerName** , the plugin with the
        highest reported providerVersion() will be used.

        If **allowExperimental** is true then plugins marked as experimental may
        be used. By default experimental plugins are not considered.

        If no plugin matching **providerName** was able to be loaded then
        **error** () and **errorString** () will provide details about why this
        is the case.

        **Note:** Before the list of **parameters** is passed on to the to-be-
        loaded provider plugin, the list is filtered to avoid the sharing of
        plugin specific parameters with unrelated provider plugins. Plugin
        specific parameter keys must be prefixed with the provider name (e.g.
        `here.app_id`).
        """
        ...

    def navigationErrorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qgeoserviceprovider.html#navigationErrorString

        **QString QGeoServiceProvider::navigationErrorString() const**

        Returns a string describing the error which occurred during the last
        attempt to create a navigation manager.

        This function was introduced in Qt 5.13.
        """
        ...

    def navigationError(self) -> "QGeoServiceProvider.Error":
        """
        https://doc.qt.io/qt-5/qgeoserviceprovider.html#navigationError

        **QGeoServiceProvider::Error QGeoServiceProvider::navigationError()
        const**

        Returns an error code describing the error which occurred during the
        last attempt to create a navigation manager.

        This function was introduced in Qt 5.13.
        """
        ...

    def placesErrorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qgeoserviceprovider.html#placesErrorString

        **QString QGeoServiceProvider::placesErrorString() const**

        Returns a string describing the error which occurred during the last
        attempt to create a places manager.

        This function was introduced in Qt 5.13.
        """
        ...

    def placesError(self) -> "QGeoServiceProvider.Error":
        """
        https://doc.qt.io/qt-5/qgeoserviceprovider.html#placesError

        **QGeoServiceProvider::Error QGeoServiceProvider::placesError() const**

        Returns an error code describing the error which occurred during the
        last attempt to create a places manager.

        This function was introduced in Qt 5.13.
        """
        ...

    def routingErrorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qgeoserviceprovider.html#routingErrorString

        **QString QGeoServiceProvider::routingErrorString() const**

        Returns a string describing the error which occurred during the last
        attempt to create a routing manager.

        This function was introduced in Qt 5.13.
        """
        ...

    def routingError(self) -> "QGeoServiceProvider.Error":
        """
        https://doc.qt.io/qt-5/qgeoserviceprovider.html#routingError

        **QGeoServiceProvider::Error QGeoServiceProvider::routingError() const**

        Returns an error code describing the error which occurred during the
        last attempt to create a routing manager.

        This function was introduced in Qt 5.13.
        """
        ...

    def geocodingErrorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qgeoserviceprovider.html#geocodingErrorString

        **QString QGeoServiceProvider::geocodingErrorString() const**

        Returns a string describing the error which occurred during the last
        attempt to create a geocoding manager.

        This function was introduced in Qt 5.13.
        """
        ...

    def geocodingError(self) -> "QGeoServiceProvider.Error":
        """
        https://doc.qt.io/qt-5/qgeoserviceprovider.html#geocodingError

        **QGeoServiceProvider::Error QGeoServiceProvider::geocodingError()
        const**

        Returns an error code describing the error which occurred during the
        last attempt to create a geocoding manager.

        This function was introduced in Qt 5.13.
        """
        ...

    def mappingErrorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qgeoserviceprovider.html#mappingErrorString

        **QString QGeoServiceProvider::mappingErrorString() const**

        Returns a string describing the error which occurred during the last
        attempt to create a mapping manager.

        This function was introduced in Qt 5.13.
        """
        ...

    def mappingError(self) -> "QGeoServiceProvider.Error":
        """
        https://doc.qt.io/qt-5/qgeoserviceprovider.html#mappingError

        **QGeoServiceProvider::Error QGeoServiceProvider::mappingError() const**

        Returns an error code describing the error which occurred during the
        last attempt to create a mapping manager.

        This function was introduced in Qt 5.13.
        """
        ...

    def navigationManager(self) -> QNavigationManager:
        """
        https://doc.qt.io/qt-5/qgeoserviceprovider.html#navigationManager

        **QNavigationManager *QGeoServiceProvider::navigationManager() const**

        Returns a new QNavigationManager made available by the service provider.

        After this function has been called, **error** () and **errorString** ()
        will report any errors which occurred during the construction of the
        QNavigationManagerEngine.
        """
        ...

    def navigationFeatures(self) -> "QGeoServiceProvider.NavigationFeatures":
        """
        https://doc.qt.io/qt-5/qgeoserviceprovider.html#navigationFeatures

        **QGeoServiceProvider::NavigationFeatures
        QGeoServiceProvider::navigationFeatures() const**

        Returns the navigation features supported by the geo service provider.

        This function was introduced in QtLocation 5.11.
        """
        ...

    def setAllowExperimental(self, allow: bool) -> None:
        """
        https://doc.qt.io/qt-5/qgeoserviceprovider.html#setAllowExperimental

        **void QGeoServiceProvider::setAllowExperimental(bool allow )**

        Sets whether experimental plugins are considered when locating the
        correct plugin library for this service provider to **allow**.

        **Important:** this will destroy any existing managers held by this
        service provider instance. You should be sure not to attempt to use any
        pointers that you have previously retrieved after calling this method.
        """
        ...

    def setLocale(self, locale: QtCore.QLocale) -> None:
        """
        https://doc.qt.io/qt-5/qgeoserviceprovider.html#setLocale

        **void QGeoServiceProvider::setLocale(const QLocale & locale )**

        Sets the locale used by this service provider to **locale**. If the
        relevant features (see **LocalizedMappingFeature**  etc), this will
        change the languages, units and other locale-specific attributes of the
        provider's data.
        """
        ...

    def setParameters(self, parameters: typing.Dict[str, typing.Any]) -> None:
        """
        https://doc.qt.io/qt-5/qgeoserviceprovider.html#setParameters

        **void QGeoServiceProvider::setParameters(const QVariantMap & parameters
        )**

        Sets the parameters used to construct individual manager classes for
        this service provider to **parameters**.

        Before the list of **parameters** is passed on to the to-be-loaded
        service provider, the list is filtered to avoid the sharing of provider
        specific parameters with unrelated service providers. Provider specific
        parameter keys must be prefixed with the provider name (e.g.
        `here.app_id`).

        **Important:** this will destroy any existing managers held by this
        service provider instance. You should be sure not to attempt to use any
        pointers that you have previously retrieved after calling this method.
        """
        ...

    def errorString(self) -> str:
        """
        https://doc.qt.io/qt-5/qgeoserviceprovider.html#errorString

        **QString QGeoServiceProvider::errorString() const**

        Returns a string describing the error which occurred during the last
        operation that was performed by this class.
        """
        ...

    def error(self) -> "QGeoServiceProvider.Error":
        """
        https://doc.qt.io/qt-5/qgeoserviceprovider.html#error

        **QGeoServiceProvider::Error QGeoServiceProvider::error() const**

        Returns an error code describing the error which occurred during the
        last operation that was performed by this class.
        """
        ...

    def placeManager(self) -> "QPlaceManager":
        """
        https://doc.qt.io/qt-5/qgeoserviceprovider.html#placeManager

        **QPlaceManager *QGeoServiceProvider::placeManager() const**

        Returns the **QPlaceManager**  made available by the service provider.

        This function will attempt to construct a **QPlaceManager**  instance
        when it is called for the first time. If the attempt is successful the
        **QPlaceManager**  will be cached, otherwise each call of this function
        will attempt to construct a **QPlace**  instance until the construction
        is successful.

        The QGeoPlaceManager is owned by this **QGeoServiceProvider**  and
        should not be deleted separately. Users should assume that deleting the
        **QGeoServiceProvider**  renders the pointer returned by this method
        invalid.

        After this function has been called, **error** () and **errorString** ()
        will report any errors which occurred during the construction of the
        **QPlaceManager** .
        """
        ...

    def routingManager(self) -> QGeoRoutingManager:
        """
        https://doc.qt.io/qt-5/qgeoserviceprovider.html#routingManager

        **QGeoRoutingManager *QGeoServiceProvider::routingManager() const**

        Returns the **QGeoRoutingManager**  made available by the service
        provider.

        This function will return 0 if the service provider does not provide any
        geographic routing services.

        This function will attempt to construct a **QGeoRoutingManager**
        instance when it is called for the first time. If the attempt is
        successful the **QGeoRoutingManager**  will be cached, otherwise each
        call of this function will attempt to construct a **QGeoRoutingManager**
        instance until the construction is successful.

        The **QGeoRoutingManager**  is owned by this **QGeoServiceProvider**
        and should not be deleted separately. Users should assume that deleting
        the **QGeoServiceProvider**  renders the pointer returned by this method
        invalid.

        After this function has been called, **error** () and **errorString** ()
        will report any errors which occurred during the construction of the
        **QGeoRoutingManager** .
        """
        ...

    def geocodingManager(self) -> QGeoCodingManager:
        """
        https://doc.qt.io/qt-5/qgeoserviceprovider.html#geocodingManager

        **QGeoCodingManager *QGeoServiceProvider::geocodingManager() const**

        Returns the **QGeoCodingManager**  made available by the service
        provider.

        This function will return 0 if the service provider does not provide any
        geocoding services.

        This function will attempt to construct a **QGeoCodingManager**
        instance when it is called for the first time. If the attempt is
        successful the **QGeoCodingManager**  will be cached, otherwise each
        call of this function will attempt to construct a **QGeoCodingManager**
        instance until the construction is successful.

        The **QGeoCodingManager**  is owned by this **QGeoServiceProvider**  and
        should not be deleted separately. Users should assume that deleting the
        **QGeoServiceProvider**  renders the pointer returned by this method
        invalid.

        After this function has been called, **error** () and **errorString** ()
        will report any errors which occurred during the construction of the
        **QGeoCodingManager** .
        """
        ...

    def placesFeatures(self) -> "QGeoServiceProvider.PlacesFeatures":
        """
        https://doc.qt.io/qt-5/qgeoserviceprovider.html#placesFeatures

        **QGeoServiceProvider::PlacesFeatures
        QGeoServiceProvider::placesFeatures() const**

        Returns the places features supported by the geo service provider.
        """
        ...

    def mappingFeatures(self) -> "QGeoServiceProvider.MappingFeatures":
        """
        https://doc.qt.io/qt-5/qgeoserviceprovider.html#mappingFeatures

        **QGeoServiceProvider::MappingFeatures
        QGeoServiceProvider::mappingFeatures() const**

        Returns the mapping features supported by the geo service provider.
        """
        ...

    def geocodingFeatures(self) -> "QGeoServiceProvider.GeocodingFeatures":
        """
        https://doc.qt.io/qt-5/qgeoserviceprovider.html#geocodingFeatures

        **QGeoServiceProvider::GeocodingFeatures
        QGeoServiceProvider::geocodingFeatures() const**

        Returns the geocoding features supported by the geo service provider.
        """
        ...

    def routingFeatures(self) -> "QGeoServiceProvider.RoutingFeatures":
        """
        https://doc.qt.io/qt-5/qgeoserviceprovider.html#routingFeatures

        **QGeoServiceProvider::RoutingFeatures
        QGeoServiceProvider::routingFeatures() const**

        Returns the routing features supported by the geo service provider.
        """
        ...

    @staticmethod
    def availableServiceProviders() -> typing.List[str]:
        """
        https://doc.qt.io/qt-5/qgeoserviceprovider.html#availableServiceProvider
        s

        **[static] QStringList
        QGeoServiceProvider::availableServiceProviders()**

        Returns a list of names of the available service providers, for use with
        the **QGeoServiceProvider**  constructors.
        """
        ...
