"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt5 import QtCore
from PyQt5.QtGui import *


class QWheelEvent(QInputEvent):
    """
    https://doc.qt.io/qt-5/qwheelevent.html

    **Detailed Description**

    Wheel events are sent to the widget under the mouse cursor, but if that
    widget does not handle the event they are sent to the focus widget. Wheel
    events are generated for both mouse wheels and trackpad scroll gestures.
    There are two ways to read the wheel event delta: **angleDelta** () returns
    the deltas in wheel degrees. These values are always provided.
    **pixelDelta** () returns the deltas in screen pixels, and is available on
    platforms that have high-resolution trackpads, such as macOS. If that is the
    case, **source** () will return **Qt::MouseEventSynthesizedBySystem** .

    The functions pos() and globalPos() return the mouse cursor's location at
    the time of the event.

    A wheel event contains a special accept flag that indicates whether the
    receiver wants the event. You should call **ignore** () if you do not handle
    the wheel event; this ensures that it will be sent to the parent widget.

    The **QWidget::setEnabled** () function can be used to enable or disable
    mouse and keyboard events for a widget.

    The event handler **QWidget::wheelEvent** () receives wheel events.

    **See also** **QMouseEvent**  and **QWidget::grabMouse** ().
    """

    @typing.overload
    def __init__(
        self,
        pos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        globalPos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        pixelDelta: QtCore.QPoint,
        angleDelta: QtCore.QPoint,
        qt4Delta: int,
        qt4Orientation: QtCore.Qt.Orientation,
        buttons: typing.Union[QtCore.Qt.MouseButtons, QtCore.Qt.MouseButton],
        modifiers: typing.Union[
            QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier
        ],
    ) -> None:
        """
        https://doc.qt.io/qt-5/qwheelevent.html#QWheelEvent-6

        **QWheelEvent::QWheelEvent(QPointF pos , QPointF globalPos , QPoint
        pixelDelta , QPoint angleDelta , Qt::MouseButtons buttons ,
        Qt::KeyboardModifiers modifiers , Qt::ScrollPhase phase , bool inverted
        , Qt::MouseEventSource source = Qt::MouseEventNotSynthesized)**

        Constructs a wheel event object.

        The **pos** provides the location of the mouse cursor within the window.
        The position in global coordinates is specified by **globalPos**.

        **pixelDelta** contains the scrolling distance in pixels on screen,
        while **angleDelta** contains the wheel rotation angle. **pixelDelta**
        is optional and can be null.

        The mouse and keyboard states at the time of the event are specified by
        **buttons** and **modifiers**.

        The scrolling phase of the event is specified by **phase**.

        If the wheel event comes from a physical mouse wheel, **source** is set
        to **Qt::MouseEventNotSynthesized** . If it comes from a gesture
        detected by the operating system, or from a non-mouse hardware device,
        such that **pixelDelta** is directly related to finger movement,
        **source** is set to **Qt::MouseEventSynthesizedBySystem** . If it comes
        from Qt, source would be set to **Qt::MouseEventSynthesizedByQt** .

        If the system is configured to invert the delta values delivered with
        the event (such as natural scrolling of the touchpad on macOS),
        **inverted** should be `true`. Otherwise, **inverted** is `false`

        This function was introduced in Qt 5.12.

        **See also** **position** (), **globalPosition** (), **angleDelta** (),
        **pixelDelta** (), **phase** (), **inverted** (), and **source** ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        pos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        globalPos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        pixelDelta: QtCore.QPoint,
        angleDelta: QtCore.QPoint,
        qt4Delta: int,
        qt4Orientation: QtCore.Qt.Orientation,
        buttons: typing.Union[QtCore.Qt.MouseButtons, QtCore.Qt.MouseButton],
        modifiers: typing.Union[
            QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier
        ],
        phase: QtCore.Qt.ScrollPhase,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qwheelevent.html#QWheelEvent-6

        **QWheelEvent::QWheelEvent(QPointF pos , QPointF globalPos , QPoint
        pixelDelta , QPoint angleDelta , Qt::MouseButtons buttons ,
        Qt::KeyboardModifiers modifiers , Qt::ScrollPhase phase , bool inverted
        , Qt::MouseEventSource source = Qt::MouseEventNotSynthesized)**

        Constructs a wheel event object.

        The **pos** provides the location of the mouse cursor within the window.
        The position in global coordinates is specified by **globalPos**.

        **pixelDelta** contains the scrolling distance in pixels on screen,
        while **angleDelta** contains the wheel rotation angle. **pixelDelta**
        is optional and can be null.

        The mouse and keyboard states at the time of the event are specified by
        **buttons** and **modifiers**.

        The scrolling phase of the event is specified by **phase**.

        If the wheel event comes from a physical mouse wheel, **source** is set
        to **Qt::MouseEventNotSynthesized** . If it comes from a gesture
        detected by the operating system, or from a non-mouse hardware device,
        such that **pixelDelta** is directly related to finger movement,
        **source** is set to **Qt::MouseEventSynthesizedBySystem** . If it comes
        from Qt, source would be set to **Qt::MouseEventSynthesizedByQt** .

        If the system is configured to invert the delta values delivered with
        the event (such as natural scrolling of the touchpad on macOS),
        **inverted** should be `true`. Otherwise, **inverted** is `false`

        This function was introduced in Qt 5.12.

        **See also** **position** (), **globalPosition** (), **angleDelta** (),
        **pixelDelta** (), **phase** (), **inverted** (), and **source** ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        pos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        globalPos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        pixelDelta: QtCore.QPoint,
        angleDelta: QtCore.QPoint,
        qt4Delta: int,
        qt4Orientation: QtCore.Qt.Orientation,
        buttons: typing.Union[QtCore.Qt.MouseButtons, QtCore.Qt.MouseButton],
        modifiers: typing.Union[
            QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier
        ],
        phase: QtCore.Qt.ScrollPhase,
        source: QtCore.Qt.MouseEventSource,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qwheelevent.html#QWheelEvent-6

        **QWheelEvent::QWheelEvent(QPointF pos , QPointF globalPos , QPoint
        pixelDelta , QPoint angleDelta , Qt::MouseButtons buttons ,
        Qt::KeyboardModifiers modifiers , Qt::ScrollPhase phase , bool inverted
        , Qt::MouseEventSource source = Qt::MouseEventNotSynthesized)**

        Constructs a wheel event object.

        The **pos** provides the location of the mouse cursor within the window.
        The position in global coordinates is specified by **globalPos**.

        **pixelDelta** contains the scrolling distance in pixels on screen,
        while **angleDelta** contains the wheel rotation angle. **pixelDelta**
        is optional and can be null.

        The mouse and keyboard states at the time of the event are specified by
        **buttons** and **modifiers**.

        The scrolling phase of the event is specified by **phase**.

        If the wheel event comes from a physical mouse wheel, **source** is set
        to **Qt::MouseEventNotSynthesized** . If it comes from a gesture
        detected by the operating system, or from a non-mouse hardware device,
        such that **pixelDelta** is directly related to finger movement,
        **source** is set to **Qt::MouseEventSynthesizedBySystem** . If it comes
        from Qt, source would be set to **Qt::MouseEventSynthesizedByQt** .

        If the system is configured to invert the delta values delivered with
        the event (such as natural scrolling of the touchpad on macOS),
        **inverted** should be `true`. Otherwise, **inverted** is `false`

        This function was introduced in Qt 5.12.

        **See also** **position** (), **globalPosition** (), **angleDelta** (),
        **pixelDelta** (), **phase** (), **inverted** (), and **source** ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        pos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        globalPos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        pixelDelta: QtCore.QPoint,
        angleDelta: QtCore.QPoint,
        qt4Delta: int,
        qt4Orientation: QtCore.Qt.Orientation,
        buttons: typing.Union[QtCore.Qt.MouseButtons, QtCore.Qt.MouseButton],
        modifiers: typing.Union[
            QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier
        ],
        phase: QtCore.Qt.ScrollPhase,
        source: QtCore.Qt.MouseEventSource,
        inverted: bool,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qwheelevent.html#QWheelEvent-6

        **QWheelEvent::QWheelEvent(QPointF pos , QPointF globalPos , QPoint
        pixelDelta , QPoint angleDelta , Qt::MouseButtons buttons ,
        Qt::KeyboardModifiers modifiers , Qt::ScrollPhase phase , bool inverted
        , Qt::MouseEventSource source = Qt::MouseEventNotSynthesized)**

        Constructs a wheel event object.

        The **pos** provides the location of the mouse cursor within the window.
        The position in global coordinates is specified by **globalPos**.

        **pixelDelta** contains the scrolling distance in pixels on screen,
        while **angleDelta** contains the wheel rotation angle. **pixelDelta**
        is optional and can be null.

        The mouse and keyboard states at the time of the event are specified by
        **buttons** and **modifiers**.

        The scrolling phase of the event is specified by **phase**.

        If the wheel event comes from a physical mouse wheel, **source** is set
        to **Qt::MouseEventNotSynthesized** . If it comes from a gesture
        detected by the operating system, or from a non-mouse hardware device,
        such that **pixelDelta** is directly related to finger movement,
        **source** is set to **Qt::MouseEventSynthesizedBySystem** . If it comes
        from Qt, source would be set to **Qt::MouseEventSynthesizedByQt** .

        If the system is configured to invert the delta values delivered with
        the event (such as natural scrolling of the touchpad on macOS),
        **inverted** should be `true`. Otherwise, **inverted** is `false`

        This function was introduced in Qt 5.12.

        **See also** **position** (), **globalPosition** (), **angleDelta** (),
        **pixelDelta** (), **phase** (), **inverted** (), and **source** ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        pos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        globalPos: typing.Union[QtCore.QPointF, QtCore.QPoint],
        pixelDelta: QtCore.QPoint,
        angleDelta: QtCore.QPoint,
        buttons: typing.Union[QtCore.Qt.MouseButtons, QtCore.Qt.MouseButton],
        modifiers: typing.Union[
            QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier
        ],
        phase: QtCore.Qt.ScrollPhase,
        inverted: bool,
        source: QtCore.Qt.MouseEventSource = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-5/qwheelevent.html#QWheelEvent-6

        **QWheelEvent::QWheelEvent(QPointF pos , QPointF globalPos , QPoint
        pixelDelta , QPoint angleDelta , Qt::MouseButtons buttons ,
        Qt::KeyboardModifiers modifiers , Qt::ScrollPhase phase , bool inverted
        , Qt::MouseEventSource source = Qt::MouseEventNotSynthesized)**

        Constructs a wheel event object.

        The **pos** provides the location of the mouse cursor within the window.
        The position in global coordinates is specified by **globalPos**.

        **pixelDelta** contains the scrolling distance in pixels on screen,
        while **angleDelta** contains the wheel rotation angle. **pixelDelta**
        is optional and can be null.

        The mouse and keyboard states at the time of the event are specified by
        **buttons** and **modifiers**.

        The scrolling phase of the event is specified by **phase**.

        If the wheel event comes from a physical mouse wheel, **source** is set
        to **Qt::MouseEventNotSynthesized** . If it comes from a gesture
        detected by the operating system, or from a non-mouse hardware device,
        such that **pixelDelta** is directly related to finger movement,
        **source** is set to **Qt::MouseEventSynthesizedBySystem** . If it comes
        from Qt, source would be set to **Qt::MouseEventSynthesizedByQt** .

        If the system is configured to invert the delta values delivered with
        the event (such as natural scrolling of the touchpad on macOS),
        **inverted** should be `true`. Otherwise, **inverted** is `false`

        This function was introduced in Qt 5.12.

        **See also** **position** (), **globalPosition** (), **angleDelta** (),
        **pixelDelta** (), **phase** (), **inverted** (), and **source** ().
        """
        ...

    @typing.overload
    def __init__(self, a0: "QWheelEvent") -> None:
        """
        https://doc.qt.io/qt-5/qwheelevent.html#QWheelEvent-6

        **QWheelEvent::QWheelEvent(QPointF pos , QPointF globalPos , QPoint
        pixelDelta , QPoint angleDelta , Qt::MouseButtons buttons ,
        Qt::KeyboardModifiers modifiers , Qt::ScrollPhase phase , bool inverted
        , Qt::MouseEventSource source = Qt::MouseEventNotSynthesized)**

        Constructs a wheel event object.

        The **pos** provides the location of the mouse cursor within the window.
        The position in global coordinates is specified by **globalPos**.

        **pixelDelta** contains the scrolling distance in pixels on screen,
        while **angleDelta** contains the wheel rotation angle. **pixelDelta**
        is optional and can be null.

        The mouse and keyboard states at the time of the event are specified by
        **buttons** and **modifiers**.

        The scrolling phase of the event is specified by **phase**.

        If the wheel event comes from a physical mouse wheel, **source** is set
        to **Qt::MouseEventNotSynthesized** . If it comes from a gesture
        detected by the operating system, or from a non-mouse hardware device,
        such that **pixelDelta** is directly related to finger movement,
        **source** is set to **Qt::MouseEventSynthesizedBySystem** . If it comes
        from Qt, source would be set to **Qt::MouseEventSynthesizedByQt** .

        If the system is configured to invert the delta values delivered with
        the event (such as natural scrolling of the touchpad on macOS),
        **inverted** should be `true`. Otherwise, **inverted** is `false`

        This function was introduced in Qt 5.12.

        **See also** **position** (), **globalPosition** (), **angleDelta** (),
        **pixelDelta** (), **phase** (), **inverted** (), and **source** ().
        """
        ...

    def globalPosition(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qwheelevent.html#globalPosition

        **QPointF QWheelEvent::globalPosition() const**

        Returns the global position of the mouse pointer **at the time of the
        event**. This is important on asynchronous window systems such as X11;
        whenever you move your widgets around in response to mouse events,
        globalPosition() can differ a lot from the current cursor position
        returned by **QCursor::pos** ().

        **See also** **position** ().
        """
        ...

    def position(self) -> QtCore.QPointF:
        """
        https://doc.qt.io/qt-5/qwheelevent.html#position

        **QPointF QWheelEvent::position() const**

        Returns the position of the mouse cursor relative to the widget that
        received the event.

        If you move your widgets around in response to mouse events, use
        **globalPosition** () instead of this function.

        This function was introduced in Qt 5.14.

        **See also** **globalPosition** ().
        """
        ...

    def inverted(self) -> bool:
        """
        https://doc.qt.io/qt-5/qwheelevent.html#inverted

        **bool QWheelEvent::inverted() const**

        Returns whether the delta values delivered with the event are inverted.

        Normally, a vertical wheel will produce a **QWheelEvent**  with positive
        delta values if the top of the wheel is rotating away from the hand
        operating it. Similarly, a horizontal wheel movement will produce a
        **QWheelEvent**  with positive delta values if the top of the wheel is
        moved to the left.

        However, on some platforms this is configurable, so that the same
        operations described above will produce negative delta values (but with
        the same magnitude). With the inverted property a wheel event consumer
        can choose to always follow the direction of the wheel, regardless of
        the system settings, but only for specific widgets. (One such use case
        could be that the user is rotating the wheel in the same direction as a
        visual Tumbler rotates. Another usecase is to make a slider handle
        follow the direction of movement of fingers on a touchpad regardless of
        system configuration.)

        **Note:** Many platforms provide no such information. On such platforms
        inverted always returns false.

        This function was introduced in Qt 5.7.
        """
        ...

    def source(self) -> QtCore.Qt.MouseEventSource:
        """
        https://doc.qt.io/qt-5/qwheelevent.html#source

        **Qt::MouseEventSource QWheelEvent::source() const**

        Returns information about the wheel event source.

        The source can be used to distinguish between events that come from a
        mouse with a physical wheel and events that are generated by some other
        means, such as a flick gesture on a touchpad.

        **Note:** Many platforms provide no such information. On such platforms
        **Qt::MouseEventNotSynthesized**  is returned always.

        This function was introduced in Qt 5.5.

        **See also** **Qt::MouseEventSource** .
        """
        ...

    def phase(self) -> QtCore.Qt.ScrollPhase:
        """
        https://doc.qt.io/qt-5/qwheelevent.html#phase

        **Qt::ScrollPhase QWheelEvent::phase() const**

        Returns the scrolling phase of this wheel event.

        **Note:** The **Qt::ScrollBegin**  and **Qt::ScrollEnd**  phases are
        currently supported only on macOS.

        This function was introduced in Qt 5.2.
        """
        ...

    def globalPosF(self) -> QtCore.QPointF:
        ...

    def posF(self) -> QtCore.QPointF:
        ...

    def angleDelta(self) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-5/qwheelevent.html#angleDelta

        **QPoint QWheelEvent::angleDelta() const**

        Returns the relative amount that the wheel was rotated, in eighths of a
        degree. A positive value indicates that the wheel was rotated forwards
        away from the user; a negative value indicates that the wheel was
        rotated backwards toward the user. `angleDelta().y()` provides the angle
        through which the common vertical mouse wheel was rotated since the
        previous event. `angleDelta().x()` provides the angle through which the
        horizontal mouse wheel was rotated, if the mouse has a horizontal wheel;
        otherwise it stays at zero. Some mice allow the user to tilt the wheel
        to perform horizontal scrolling, and some touchpads support a horizontal
        scrolling gesture; that will also appear in `angleDelta().x()`.

        Most mouse types work in steps of 15 degrees, in which case the delta
        value is a multiple of 120; i.e., 120 units * 1/8 = 15 degrees.

        However, some mice have finer-resolution wheels and send delta values
        that are less than 120 units (less than 15 degrees). To support this
        possibility, you can either cumulatively add the delta values from
        events until the value of 120 is reached, then scroll the widget, or you
        can partially scroll the widget in response to each wheel event. But to
        provide a more native feel, you should prefer **pixelDelta** () on
        platforms where it's available.

        Example:

        void MyWidget::wheelEvent(**QWheelEvent**  *event)
            {
        **QPoint**  numPixels = event->pixelDelta();
                **QPoint**
        numDegrees = event->angleDelta() / 8;

                if
        (!numPixels.isNull()) {
                    scrollWithPixels(numPixels);
        } else if (!numDegrees.isNull()) {
                    **QPoint**  numSteps =
        numDegrees / 15;
                    scrollWithDegrees(numSteps);
                }
        event->accept();
            }

        **Note:** On platforms that support scrolling **phases** , the delta may
        be null when:

        * scrolling is about to begin, but the distance did not yet change
        (**Qt::ScrollBegin** ),
          * or scrolling has ended and the distance did
        not change anymore (**Qt::ScrollEnd** ).

        **See also** **pixelDelta** ().
        """
        ...

    def pixelDelta(self) -> QtCore.QPoint:
        """
        https://doc.qt.io/qt-5/qwheelevent.html#pixelDelta

        **QPoint QWheelEvent::pixelDelta() const**

        Returns the scrolling distance in pixels on screen. This value is
        provided on platforms that support high-resolution pixel-based delta
        values, such as macOS. The value should be used directly to scroll
        content on screen.

        Example:

        void MyWidget::wheelEvent(**QWheelEvent**  *event)
            {
        **QPoint**  numPixels = event->pixelDelta();
                **QPoint**
        numDegrees = event->angleDelta() / 8;

                if
        (!numPixels.isNull()) {
                    scrollWithPixels(numPixels);
        } else if (!numDegrees.isNull()) {
                    **QPoint**  numSteps =
        numDegrees / 15;
                    scrollWithDegrees(numSteps);
                }
        event->accept();
            }

        **Note:** On platforms that support scrolling **phases** , the delta may
        be null when:

        * scrolling is about to begin, but the distance did not yet change
        (**Qt::ScrollBegin** ),
          * or scrolling has ended and the distance did
        not change anymore (**Qt::ScrollEnd** ).

        **Note:** On X11 this value is driver specific and unreliable, use
        **angleDelta** () instead
        """
        ...

    def buttons(self) -> QtCore.Qt.MouseButtons:
        """
        https://doc.qt.io/qt-5/qwheelevent.html#buttons

        **Qt::MouseButtons QWheelEvent::buttons() const**

        Returns the mouse state when the event occurred.
        """
        ...

    def globalY(self) -> int:
        ...

    def globalX(self) -> int:
        ...

    def y(self) -> int:
        ...

    def x(self) -> int:
        ...

    def globalPos(self) -> QtCore.QPoint:
        ...

    def pos(self) -> QtCore.QPoint:
        ...
